/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client.util;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.maintain.WorkOrderPlanUserEntryInfo;
import com.kingdee.eas.eqm.maintain.client.util.WorkOrderPrecisionUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class WorkOrderLineCostCalUtil {
    protected static final String COL_CURRENCY = "currency";
    protected static final String COL_SELFCURRENCY = "selfCurrency";
    protected static final String COL_HOURS = "hours";
    protected static final String COL_AMOUNT = "amount";
    protected static final String COL_RATE = "rate";
    protected static final String COL_UNITPRICE = "unitPrice";
    protected static final String COL_PLANAMOUNT = "planAmount";
    protected static final String COL_REALCOSTAMOUNT = "realCostQty";
    protected static final String COL_LINECOST = "lineCost";
    private static Map tableLineCostFactor = new HashMap();
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";
    WorkOrderPrecisionUtil precisionUtil = new WorkOrderPrecisionUtil();

    public WorkOrderLineCostCalUtil() {
        this.initTableLineCostFactor();
    }

    public void setLineCost(KDTable table, int rowIndex) {
        BigDecimal lineCost = this.multiplyFactors(table, rowIndex);
        if (lineCost != null || !"realServiceEntry".equals(table.getName())) {
            table.getCell(rowIndex, COL_LINECOST).setValue((Object)lineCost);
        }
        this.precisionUtil.setLineCostByCurrencyPrecision(table, rowIndex);
    }

    private BigDecimal multiplyFactors(KDTable table, int rowIndex) {
        String[] colNames = (String[])tableLineCostFactor.get(table.getName());
        BigDecimal result = new BigDecimal("1");
        if (colNames != null) {
            for (int i = 0; i < colNames.length; ++i) {
                if (table.getCell(rowIndex, colNames[i]).getValue() == null) {
                    return null;
                }
                if (COL_AMOUNT.equals(colNames[i]) && table.getRow(rowIndex).getUserObject() instanceof WorkOrderPlanUserEntryInfo) {
                    int ammount = (Integer)table.getCell(rowIndex, colNames[i]).getValue();
                    result = result.multiply(new BigDecimal(ammount));
                    continue;
                }
                result = result.multiply((BigDecimal)table.getCell(rowIndex, colNames[i]).getValue());
            }
            if (result.longValue() > 999999999999L) {
                MsgBox.showWarning((String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"WARN_NUM_TOOLONG", null));
            }
        } else {
            result = (BigDecimal)table.getCell(rowIndex, COL_LINECOST).getValue();
        }
        return result;
    }

    private void initTableLineCostFactor() {
        String[] planUserFactor = new String[]{COL_AMOUNT, COL_HOURS, COL_RATE};
        String[] planMaterialFactor = new String[]{COL_UNITPRICE, COL_PLANAMOUNT};
        String[] planToolsFactor = new String[]{COL_AMOUNT, COL_HOURS, COL_RATE};
        String[] realUserFactor = new String[]{COL_HOURS, COL_RATE};
        String[] realMaterialFactor = new String[]{COL_UNITPRICE, COL_REALCOSTAMOUNT};
        String[] realToolsFactor = new String[]{COL_AMOUNT, COL_HOURS, COL_RATE};
        String[] realServiceFactor = new String[]{COL_HOURS, COL_RATE};
        tableLineCostFactor.put("planUserEntry", planUserFactor);
        tableLineCostFactor.put("planMaterialEntry", planMaterialFactor);
        tableLineCostFactor.put("planToolsEntry", planToolsFactor);
        tableLineCostFactor.put("realUserEntry", realUserFactor);
        tableLineCostFactor.put("realMaterialEntry", realMaterialFactor);
        tableLineCostFactor.put("realToolsEntry", realToolsFactor);
        tableLineCostFactor.put("realServiceEntry", realServiceFactor);
    }
}

