/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client.util;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.client.WorkOrderEditUI;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class WorkOrderPrecisionUtil {
    private static final Logger logger = CoreUIObject.getLogger(WorkOrderPrecisionUtil.class);
    protected static final String COL_CURRENCY = "currency";
    protected static final String COL_LINECOST = "lineCost";
    private static final String COL_UNITPRICE = "unitPrice";
    private static final String COL_RATE = "rate";
    private static final String COL_MATERIAL = "material";
    private static final int DEFAULT_PRECISSION = 2;
    private static final String COL_QTY = "amount";
    private static final String COL_HOURSE = "hours";

    public void setDefaultHourse(KDTable table, int rowIndex) {
        table.getCell(rowIndex, COL_HOURSE).setValue((Object)new BigDecimal("0.00"));
    }

    public void setDefaultPlanQty(KDTable table, int rowIndex) {
        if (table.getName().equals("realMaterialEntry")) {
            table.getCell(rowIndex, "planQty").setValue((Object)new BigDecimal("0.00"));
        } else {
            table.getCell(rowIndex, "planAmount").setValue((Object)new BigDecimal("0.00"));
        }
    }

    public void setDefaultAmount(KDTable table, int rowIndex) {
        table.getCell(rowIndex, COL_QTY).setValue((Object)new BigDecimal("0.00"));
    }

    public void setDefaultRate(KDTable table, int rowIndex) {
        table.getCell(rowIndex, COL_RATE).setValue((Object)new BigDecimal("0.00"));
    }

    public void setLineCostByCurrencyPrecision(KDTable table, int rowIndex) {
        int precission = this.getCurrencyPrecision(table, rowIndex);
        BigDecimal lineCostValue = this.getLineCostValueByPrecision(table, rowIndex, precission);
        this.setLineCostCellPrecision(table, rowIndex, precission);
        table.getCell(rowIndex, COL_LINECOST).setValue((Object)lineCostValue);
    }

    public void setLineCostByCurrencyPrecision(KDTable table, int rowIndex, int precission) {
        BigDecimal lineCostValue = this.getLineCostValueByPrecision(table, rowIndex, precission);
        this.setLineCostCellPrecision(table, rowIndex, precission);
        table.getCell(rowIndex, COL_LINECOST).setValue((Object)lineCostValue);
    }

    public void setLineCostCellPrecision(KDTable table, int rowIndex, int precision) {
        EQMPromptDialogFactory.createNumberic((KDTable)table, (int)table.getColumnIndex(COL_LINECOST), (int)rowIndex, (int)precision);
    }

    public void setUnitPriceCellPrecision(KDTable table, int rowIndex, int precision) {
        EQMPromptDialogFactory.createNumberic((KDTable)table, (int)table.getColumnIndex(COL_UNITPRICE), (int)rowIndex, (int)precision);
    }

    public void setToolsRateCellPrecision(KDTable table, int rowIndex, int precision) {
        EQMPromptDialogFactory.createNumberic((KDTable)table, (int)table.getColumnIndex(COL_RATE), (int)rowIndex, (int)precision);
    }

    public void setUnitPricePrecisionByMaterial(KDTable table, int rowIndex) {
        int precision = this.getUnitPriceOrRatePrecision(table, rowIndex);
        this.setUnitPriceCellPrecision(table, rowIndex, precision);
        table.getCell(rowIndex, COL_UNITPRICE).setValue((Object)this.getUnitPriceByPrecision(table, rowIndex, precision));
    }

    public void setRatePrecisionByMaterial(KDTable table, int rowIndex) {
        int precision = this.getUnitPriceOrRatePrecision(table, rowIndex);
        this.setToolsRateCellPrecision(table, rowIndex, precision);
        table.getCell(rowIndex, COL_RATE).setValue((Object)this.getRateByPrecision(table, rowIndex, precision));
    }

    public BigDecimal getRateByPrecision(KDTable table, int rowIndex, int precision) {
        if (table.getCell(rowIndex, COL_RATE).getValue() == null) {
            return new BigDecimal("0.00");
        }
        BigDecimal unitPrice = (BigDecimal)table.getCell(rowIndex, COL_RATE).getValue();
        return unitPrice.setScale(precision, 4);
    }

    public BigDecimal getUnitPriceByPrecision(KDTable table, int rowIndex, int precision) {
        if (table.getCell(rowIndex, COL_UNITPRICE).getValue() == null) {
            return new BigDecimal("0.00");
        }
        BigDecimal unitPrice = (BigDecimal)table.getCell(rowIndex, COL_UNITPRICE).getValue();
        return unitPrice.setScale(precision, 4);
    }

    public BigDecimal getLineCostValueByPrecision(KDTable table, int rowIndex, int precission) {
        if (table.getCell(rowIndex, COL_LINECOST).getValue() == null) {
            return new BigDecimal("0.00");
        }
        BigDecimal lineCost = (BigDecimal)table.getCell(rowIndex, COL_LINECOST).getValue();
        return lineCost.setScale(precission, 4);
    }

    public int getCurrencyPrecision(KDTable table, int rowIndex) {
        CurrencyInfo currency = (CurrencyInfo)table.getCell(rowIndex, COL_CURRENCY).getValue();
        if (currency == null) {
            return 2;
        }
        return currency.getPrecision();
    }

    public int getUnitPriceOrRatePrecision(KDTable table, int rowIndex) {
        MaterialInfo material = (MaterialInfo)table.getCell(rowIndex, COL_MATERIAL).getValue();
        if (material == null) {
            return 2;
        }
        return material.getPricePrecision();
    }

    private SelectorItemCollection getMaterialSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("pricePrecision"));
        return sic;
    }

    private SelectorItemCollection getcurrencySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("precision"));
        return sic;
    }

    public void updateAllCellLineCostPrecision(WorkOrderEditUI workOrderUI) {
        KDTable[] tables = workOrderUI.getCurrencyTables();
        for (int tableIndex = 0; tableIndex < tables.length; ++tableIndex) {
            KDTable table = tables[tableIndex];
            for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
                if (table.getCell(rowIndex, COL_CURRENCY).getValue() == null) {
                    table.getCell(rowIndex, COL_CURRENCY).setValue((Object)workOrderUI.getDefaultCurrency());
                }
                this.setLineCostCellPrecision(table, rowIndex, this.getCurrencyPrecision(table, rowIndex));
            }
        }
    }
}

