/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.eqmcore.EqmMaterialFacadeFactory;
import com.kingdee.eas.eqm.common.eqmcore.IEqmMaterialFacade;
import com.kingdee.eas.eqm.maintain.client.MultiMeasureUnitUtil;
import java.math.BigDecimal;

public class WorkOrderToolsEntryUtil {
    public static final String COL_TOOLS_ID = "id";
    public static final String COL_TOOLS_TASKNUMBER = "taskNumber";
    public static final String COL_TOOLS_TOOLS = "material";
    public static final String COL_TOOLS_TOOLS_NAME = "materialName";
    public static final String COL_TOOLS_AMOUNT = "amount";
    public static final String COL_TOOLS_MEASUREUNIT = "measureUnit";
    public static final String COL_TOOLS_STORAGEORGUNIT = "storageOrgUnit";
    public static final String COL_TOOLS_WAREHOUSE = "warehouse";
    public static final String COL_TOOLS_HOURS = "hours";
    public static final String COL_TOOLS_RATE = "rate";
    public static final String COL_TOOLS_LINECOST = "lineCost";
    public static final String COL_TOOLS_REMARK = "remark";
    public static final String COL_TOOLS_CURRENCY = "currency";
    public static final String COL_TOOLS_SELFCURRENCY = "selfCurrency";

    private IEqmMaterialFacade getMaterialFacade() throws BOSException {
        IEqmMaterialFacade materialFacade = null;
        materialFacade = EqmMaterialFacadeFactory.getRemoteInstance();
        return materialFacade;
    }

    public void setToolRate(KDTable table, int rowIndex, String storageOrgID) throws EASBizException, BOSException {
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)table.getCell(rowIndex, COL_TOOLS_MEASUREUNIT).getValue();
        MaterialInfo tool = (MaterialInfo)table.getCell(rowIndex, COL_TOOLS_TOOLS).getValue();
        table.getCell(rowIndex, COL_TOOLS_RATE).setValue((Object)this.getUnitpriceByMeasureUnit(this.getToolRate(table, rowIndex, storageOrgID), null, measureUnitInfo, tool));
    }

    public BigDecimal getToolRate(KDTable table, int rowIndex, String storageOrgID) throws BOSException, EASBizException {
        if (this.getMaterialFacade() == null) {
            return new BigDecimal("0.00");
        }
        if (table.getCell(rowIndex, COL_TOOLS_TOOLS).getValue() == null) {
            return new BigDecimal("0.00");
        }
        return this.getMaterialFacade().getToolRate(((MaterialInfo)table.getCell(rowIndex, COL_TOOLS_TOOLS).getValue()).getId().toString(), storageOrgID);
    }

    public BigDecimal getToolRate(String toolID, String storageOrgID) throws BOSException, EASBizException {
        if (this.getMaterialFacade() == null) {
            return new BigDecimal("0.00");
        }
        if (toolID == null) {
            return new BigDecimal("0.00");
        }
        return this.getMaterialFacade().getToolRate(toolID, storageOrgID);
    }

    public BigDecimal getUnitpriceByMeasureUnit(BigDecimal unitprice, MeasureUnitInfo oldMeasureUnitInfo, MeasureUnitInfo measureUnitInfo, MaterialInfo material) throws EASBizException, BOSException {
        if (unitprice == null) {
            return null;
        }
        MultiMeasureUnitUtil multiMeasureUnitUtil = new MultiMeasureUnitUtil();
        MultiMeasureUnitInfo oldMultiMeasureUnit = null;
        MultiMeasureUnitInfo newMultiMeasureUnit = null;
        if (oldMeasureUnitInfo != null) {
            oldMultiMeasureUnit = multiMeasureUnitUtil.getMutiMeasureUnitInfo(material, oldMeasureUnitInfo);
        }
        if (measureUnitInfo != null) {
            newMultiMeasureUnit = multiMeasureUnitUtil.getMutiMeasureUnitInfo(material, measureUnitInfo);
        }
        int precision = unitprice.scale();
        if (measureUnitInfo == null) {
            return unitprice.divide(this.getMultiUnitCovRate(oldMultiMeasureUnit), 5).setScale(precision, 5);
        }
        if (oldMeasureUnitInfo == null) {
            return unitprice.multiply(this.getMultiUnitCovRate(newMultiMeasureUnit)).setScale(precision, 5);
        }
        BigDecimal baseUnitprice = unitprice.divide(this.getMultiUnitCovRate(oldMultiMeasureUnit), 5).setScale(precision, 5);
        return baseUnitprice.multiply(this.getMultiUnitCovRate(newMultiMeasureUnit)).setScale(precision, 5);
    }

    private BigDecimal getMultiUnitCovRate(MultiMeasureUnitInfo multiUnitInfo) throws EASBizException, BOSException {
        if (multiUnitInfo == null) {
            return new BigDecimal("1");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("conversionRate"));
        MultiMeasureUnitInfo multiUnitWithCovRate = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitInfo((IObjectPK)new ObjectUuidPK(multiUnitInfo.getId().toString()));
        return multiUnitWithCovRate.getBaseConvsRate();
    }
}

