/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.AbstractEvaItemInfo;
import com.kingdee.eas.fi.fa.basedata.EvaItemDetailEnum;
import com.kingdee.eas.fi.fa.basedata.EvaItemEnum;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeCollection;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.IFaDepreciationMode;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class FaUtils {
    public static final String[] changeItemConstant = new String[]{"assetCat", "number", "assetName", "assetAmt", "measureUnit", "originMethod", "useStatus", "economicPurp", "storeCity", "specs", "pArea", "mfr", "levFrDate", "paperNo", "dept", "keeper", "originType", "originUnit", "remark", "currency", "exRate", "originAmt", "buyValue", "buyAccuDepr", "addons", "deliverDate", "useTermCount", "useYears", "accuDepr", "accuDeprTYear", "neatRemValue", "measureUnitWL", "deprMethod", "accountAsset", "accountAccuDepr", "accountDecValue", "accuDeprAll", "faCurFacility", "faCurCostCenter", "faCurDepartment", "treatmentIncome", "fairValue", "neatLeftRate", "addonFare", "fiAccountDate", "evalAssetValue", "evalUseTermCount", "evalTaxLeftPeriod", "evalDeprMode", "evalMonthRate", "evalAddDepr", "evalRemValue", "evalNeatLeftRate", "evalYearDepr", "evalDecValue", "evalMeasureUnitWL", "deprTermCount", "inputTax", "barCode", "startUseDate", "groupNumber", "taxOriginAmt", "inputTaxRate", "isDeduct"};
    private static final String[] changeItemSelector = new String[]{"assetCat.id", "number", "assetName", "measureUnit.id", "originMethod.id", "useStatus.id", "economicPurp.id", "storeCity.id", "specs", "pArea", "mfr", "levFrDate", "paperNo", "dept.id", "keeper.id", "originType", "originUnit", "remark", "currency.id", "exRate", "buyValue", "buyAccuDepr", "addons", "deliverDate", "useTermCount", "useYears", "neatRemValue", "measureUnitWL.id", "deprMethod.id", "accountAsset.id", "accountAccuDepr.id", "accountDecValue.id", "treatmentIncome", "fairValue", "neatLeftRate", "addonFare", "fiAccountDate", "evalAssetValue", "evalUseTermCount", "evalTaxLeftPeriod", "evalDeprMode.id", "evalMonthRate", "evalAddDepr", "evalRemValue", "evalNeatLeftRate", "evalYearDepr", "evalDecValue", "evalMeasureUnitWL.id", "deprTermCount", "inputTax", "barCode", "startUseDate", "groupNumber", "taxOriginAmt", "inputTaxRate", "isDeduct"};
    private static final String[] checkFlowItemBizConstant = new String[]{"FaCurCard", "FaChangeBill", "FaClearBill", "FaDecValue", "FaSplitBill", "FaCombinBill", "FaDispatchBill", "FaEvaluateBill", "FaStocktakingTaskBill", "FaStocktakingBill", "FALeaseContract", "FaLeaseInBill", "FaLeaseBill", "FaMaintain", "FaRequisitionedBill", "FaRefunding", "FaBorrowing", "FaReturn"};
    public static final String AVEUSINGAGEMETHODNUMBER = "001";
    public static final String WORKLOADMETHODNUMBER = "002";
    public static final String SELFUSEPROPERTYNUMBER = "005";
    public static final String TOTALYEARNUMBER = "003";
    public static final String DOUBLESUBTRACT = "004";
    public static final String WELLONLY = "006";
    public static final String STRAIGHTACCOUNT = "007";
    public static final String STRAIGHTTAX = "008";
    public static final String AVGUSINGAGETAX = "009";
    public static final String AVEUSINGORIGINAGEMETHODNUMBER = "010";
    public static final String DOUBLESUBTRACTDYN = "100";
    public static final String DOUBLESUBTRACTSTA = "101";
    public static final String TOTALYEARDYN = "102";
    public static final String TOTALYEARSTA = "103";

    public static boolean isAveUsingAgeMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(AVEUSINGAGEMETHODNUMBER);
    }

    public static boolean isAveUsingOriginAgeMethod(FaDepreciationModeInfo method) throws BOSException {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(AVEUSINGORIGINAGEMETHODNUMBER);
    }

    public static boolean isWorkLoadMethod(FaDepreciationModeInfo method) {
        if (method == null) {
            return false;
        }
        if (method.get("isWorkload") == null) {
            return false;
        }
        return method.isIsWorkload();
    }

    public static HashMap getUserDepreciationMode(Context ctx, boolean onlyWorkload) throws BOSException {
        FaDepreciationModeCollection modes;
        IFaDepreciationMode iDepr = null;
        iDepr = ctx == null ? FaDepreciationModeFactory.getRemoteInstance() : FaDepreciationModeFactory.getLocalInstance(ctx);
        HashMap<String, FaDepreciationModeInfo> result = new HashMap<String, FaDepreciationModeInfo>();
        try {
            EntityViewInfo v = onlyWorkload ? new EntityViewInfo("select *,scheme.* where isCustom=1 and isWorkload=1") : new EntityViewInfo("where isCustom=1");
            modes = iDepr.getFaDepreciationModeCollection(v);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < modes.size(); ++i) {
            FaDepreciationModeInfo mode = modes.get(i);
            result.put(mode.getNumber(), mode);
        }
        return result;
    }

    public static boolean isSelfUsePropertyMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(SELFUSEPROPERTYNUMBER);
    }

    public static boolean isTotalYearMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(TOTALYEARNUMBER);
    }

    public static boolean isDoubleSubtractMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(DOUBLESUBTRACT);
    }

    public static boolean isDoubleSubtractDynMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(DOUBLESUBTRACTDYN);
    }

    public static boolean isDoubleSubtractStaMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(DOUBLESUBTRACTSTA);
    }

    public static boolean isTotalYearDynMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(TOTALYEARDYN);
    }

    public static boolean isTotalYearStaitcMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(TOTALYEARSTA);
    }

    public static boolean isUserDefinedMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null) {
            return false;
        }
        if (method.get("isCustom") == null) {
            throw new IllegalArgumentException("Please load property [FaDepreciationMode.isCustom], the FaDepreciationMode is " + method);
        }
        return method.isIsCustom();
    }

    public static boolean isStraightAccountMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(STRAIGHTACCOUNT);
    }

    public static boolean isStraightTaxMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(STRAIGHTTAX);
    }

    public static boolean isAvgUsingAgeTaxMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(AVGUSINGAGETAX);
    }

    public static boolean isWellOnlyMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals(WELLONLY);
    }

    public static List getItemInfo(String code) {
        ArrayList<AbstractEvaItemInfo> list = new ArrayList<AbstractEvaItemInfo>();
        if (StringUtils.isEmpty((String)code)) {
            return list;
        }
        StringBuffer buffer = new StringBuffer(code.trim());
        code = buffer.reverse().toString();
        int length = code.length();
        for (int i = 0; i < length; ++i) {
            AbstractEvaItemInfo info;
            if (code.charAt(i) != '1' || (info = FaUtils.getEvaItemInfo(i + 1)) == null) continue;
            list.add(info);
        }
        return list;
    }

    public static String getItemInfoCode(List list) {
        String code = AbstractEvaItemInfo.getFullCode(false);
        if (list == null || list.size() == 0) {
            return code;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof AbstractEvaItemInfo)) continue;
            AbstractEvaItemInfo info = (AbstractEvaItemInfo)obj;
            int index = info.getEnum().getValue();
            code = code.substring(0, 8 - index) + "1" + code.substring(8 - index + 1);
        }
        return code;
    }

    public static AbstractEvaItemInfo getEvaItemInfo(int enumInt) {
        List evaItems = FaUtils.getEvaItems();
        int size = evaItems.size();
        for (int i = 0; i < size; ++i) {
            AbstractEvaItemInfo evaItemInfo = (AbstractEvaItemInfo)evaItems.get(i);
            if (evaItemInfo.getEnum().getValue() != enumInt) continue;
            return evaItemInfo;
        }
        return null;
    }

    public static EvaItemEnum getEvaItemEnum(int value) {
        return (EvaItemEnum)((Object)AbstractEvaItemInfo.EVAITEM_CODE_ENUM_MAP.get(new Integer(value)));
    }

    public static EvaItemDetailEnum getEvaItemDetailEnum(String value) {
        return (EvaItemDetailEnum)((Object)AbstractEvaItemInfo.EVADETAIL_CODE_ENUM_MAP.get(value));
    }

    public static List getEvaItems() {
        return new ArrayList(AbstractEvaItemInfo.ALL_EVA_ITEMS);
    }

    public static void adjustUIHeight(CoreUIObject uiObject) {
        if (uiObject == null || uiObject.getUIContext().get("Owner") == null || !(uiObject.getUIContext().get("Owner") instanceof IUIObject)) {
            return;
        }
        IUIObject o = (IUIObject)uiObject.getUIContext().get("Owner");
        if (o != null) {
            int height = o.getUIContentPane().getHeight();
            if (uiObject.getHeight() > height) {
                uiObject.setPreferredSize(new Dimension(uiObject.getWidth(), height));
            }
        }
    }

    public static void freezeTable(KDTable table, int count) {
        if (table == null) {
            return;
        }
        KDTViewManager viewmgr = table.getViewManager();
        if (viewmgr != null && !viewmgr.isFreeze()) {
            viewmgr.setFreezeView(0, count);
            table.reLayoutAndPaint();
        }
    }

    public static String buildChgListParam(String[] chgList) {
        String result = "-1;";
        String[] changeItemConstantClone = (String[])changeItemConstant.clone();
        List<String> list = Arrays.asList(changeItemConstantClone);
        int size = chgList.length;
        for (int i = 0; i < size; ++i) {
            if (!list.contains(chgList[i])) continue;
            result = result + (i == 0 ? "" : ";") + list.indexOf(chgList[i]);
            result = result + (i == size - 1 ? ";" : "");
        }
        return result;
    }

    public static String buildFlowListParam(String[] chgList) {
        String result = "-1;";
        String[] checkFlowItemBizConstantClone = (String[])checkFlowItemBizConstant.clone();
        List<String> list = Arrays.asList(checkFlowItemBizConstantClone);
        int size = chgList.length;
        for (int i = 0; i < size; ++i) {
            if (!list.contains(chgList[i])) continue;
            result = result + (i == 0 ? "" : ";") + list.indexOf(chgList[i]);
            result = result + (i == size - 1 ? ";" : "");
        }
        return result;
    }

    public static boolean isInFlow(Class cls, Map map) {
        if (map == null) {
            return false;
        }
        if (map.get("FA_011") == null) {
            return false;
        }
        if (map.get("FA_018") == null || !"true".equals(map.get("FA_018"))) {
            return false;
        }
        List<String> chgItemList = Arrays.asList(FaManageUtils.parseCheckFlowListParam((String)map.get("FA_102").toString()));
        return chgItemList.contains(cls.getName().replaceAll("ListUI", "").replaceAll("EditUI", ""));
    }

    public static String[] parseChgListParam(String chgList) {
        if (chgList == null || chgList.length() < 1) {
            return new String[]{"-1;"};
        }
        StringTokenizer st = new StringTokenizer(chgList, ";");
        String[] result = new String[st.countTokens()];
        int size = result.length;
        for (int i = 0; i < size; ++i) {
            String item = st.nextToken();
            if (item == null || Integer.parseInt(item) >= changeItemConstant.length || Integer.parseInt(item) <= -1) continue;
            result[i] = changeItemConstant[Integer.parseInt(item)];
        }
        return result;
    }

    public static String[] parseCheckFlowListParam(String chgList) {
        if (chgList == null || chgList.length() < 1) {
            return new String[]{"-1;"};
        }
        StringTokenizer st = new StringTokenizer(chgList, ";");
        String[] result = new String[st.countTokens()];
        int size = result.length;
        for (int i = 0; i < size; ++i) {
            String item = st.nextToken();
            if (item == null || Integer.parseInt(item) >= checkFlowItemBizConstant.length || Integer.parseInt(item) <= -1) continue;
            result[i] = checkFlowItemBizConstant[Integer.parseInt(item)];
        }
        return result;
    }

    public static void enableTextField(JComponent source, boolean enable) {
        if (source instanceof KDBizPromptBox) {
            return;
        }
        for (int i = 0; i < source.getComponentCount(); ++i) {
            Component c = source.getComponent(i);
            FaUtils.enableComponent(c, enable);
            if (!(c instanceof JComponent) || ((JComponent)c).getComponentCount() <= 0) continue;
            FaUtils.enableTextField((JComponent)c, enable);
        }
    }

    public static void enableTextField(JComponent[] source, boolean enable) {
        for (int i = 0; i < source.length; ++i) {
            if (source[i] instanceof KDBizPromptBox) continue;
            JComponent c = source[i];
            FaUtils.enableComponent(c, enable);
            if (!(c instanceof JComponent) || c.getComponentCount() <= 0) continue;
            FaUtils.enableTextField(c, enable);
        }
    }

    public static void enableComponent(Component c, boolean enable) {
        if (c instanceof KDTable) {
            ((KDTable)c).setEditable(enable);
        }
        if (c instanceof KDDatePicker) {
            ((KDDatePicker)c).setAccessAuthority(enable ? 0 : 1);
            ((KDDatePicker)c).setEnabled(enable);
            ((KDDatePicker)c).setEditable(enable);
        } else if (c instanceof KDBizPromptBox) {
            ((KDBizPromptBox)c).setAccessAuthority(enable ? 0 : 1);
        } else if (c instanceof IKDTextComponent) {
            ((IKDTextComponent)c).setAccessAuthority(enable ? 0 : 1);
        }
        if (c instanceof KDWorkButton) {
            ((KDWorkButton)c).setEnabled(enable);
        }
        if (c instanceof KDRadioButton) {
            ((KDRadioButton)c).setEnabled(enable);
        }
    }

    public static FilterInfo getAccountViewFilter(String CU, String accountTblID) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTblID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        return filterInfo;
    }

    public static String getMaxChar() {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.maxChar", (Locale)LocaleUtils.getLocale((String)"l2"));
    }

    public static String[] getChangeItemConstant() {
        return changeItemConstant;
    }

    public static String[] getChangeItemSelector() {
        return changeItemSelector;
    }

    public static String[] getCheckFlowItemBizConstant() {
        return checkFlowItemBizConstant;
    }

    public static boolean isContainAsstActGpDt(Context context, AccountViewInfo accoutViewInfo) throws BOSException, EASBizException {
        AccountViewInfo asstAccountInfoTmp = null;
        SelectorItemCollection accountSelector = new SelectorItemCollection();
        accountSelector.add(new SelectorItemInfo("id"));
        accountSelector.add(new SelectorItemInfo("CAA.asstActGpDt.id"));
        IAccountView iAccountView = context != null ? AccountViewFactory.getLocalInstance((Context)context) : AccountViewFactory.getRemoteInstance();
        ObjectUuidPK asstAccountPK = new ObjectUuidPK(accoutViewInfo.getId().toString());
        if (asstAccountPK != null) {
            asstAccountInfoTmp = iAccountView.getAccountViewInfo((IObjectPK)asstAccountPK, accountSelector);
        }
        if (asstAccountInfoTmp == null) {
            return true;
        }
        AsstAccountInfo asstActInfo = asstAccountInfoTmp.getCAA();
        if (asstActInfo == null) {
            return true;
        }
        AsstActGroupDetailCollection asstActGroupCollection = asstActInfo.getAsstActGpDt();
        return asstActGroupCollection == null || asstActGroupCollection.size() <= 0;
    }
}

