/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaBaseDataSouceEnum;
import com.kingdee.eas.fi.fa.basedata.FaCatCollection;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.IFaCat;
import com.kingdee.eas.fi.fa.basedata.client.AbstractFaCatEditUI;
import com.kingdee.eas.fi.fa.def.DefCompanyFilterUtil;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.client.FaSpinnerChangeListener;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;

public class FaCatEditUI
extends AbstractFaCatEditUI {
    private static final long serialVersionUID = 1396992061953440455L;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FaCatEditUI.this.changeUseLimitAndPureRate();
        }
    };
    private Map<String, String> params = null;

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"strFaCat");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.setGCUseLimitAndPureRateStatus();
        this.loadUseLimitAndPureRate();
        this.bizPromptMeasureUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        this.prmtDepreciationPolicy.setEditable(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        this.prmtDepreciationPolicy.setEntityViewInfo(viewInfo);
        this.bizPromptMeasureUnit.setRequired(false);
        EntityViewInfo classViewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        FilterItemInfo companyFilterItemInfo3 = new FilterItemInfo("currencyCompany.id", (Object)aCompanyOrgUnitInfo.getId().toString(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(companyFilterItemInfo3);
        filterInfo.getFilterItems().add(new FilterItemInfo("typelink.objectType.number", (Object)"5000", CompareType.EQUALS));
        classViewInfo.setFilter(filterInfo);
        this.bizPromptClassfication.setEntityViewInfo(classViewInfo);
        EntityViewInfo modeViewInfo = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        modeViewInfo.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("number", (Object)"008", CompareType.NOTEQUALS));
        f.getFilterItems().add(new FilterItemInfo("number", (Object)"009", CompareType.NOTEQUALS));
        this.bizPromptDepreciationMode.setEntityViewInfo(modeViewInfo);
        this.chkCalcuByEvaluate.setVisible(true);
        this.ksPGroupLevel.addChangeListener((ChangeListener)new FaSpinnerChangeListener(9999, 0));
        this.bizPromptdecValPolicy.setQueryInfo("com.kingdee.eas.fi.fa.basedata.app.FaDecValPolicyQuery");
        this.bizPromptdecValPolicy.setCommitFormat("$number$");
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = DefCompanyFilterUtil.createDefFilter((String)SysContext.getSysContext().getCurrentFIUnit().getLongNumber());
        v.setFilter(filter);
        this.prmtStyle.setEntityViewInfo(v);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setStatusByFaCat();
    }

    private void setStatusByFaCat() {
        if (this.editData == null) {
            return;
        }
        if (this.isParentNode() && this.editData != null && this.editData.getParent() == null) {
            return;
        }
        Map<String, String> faParams = null;
        try {
            faParams = this.getParamters();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (faParams != null && "false".equals(faParams.get("FA_054"))) {
            this.formatTxtUseLimit.setEnabled(false);
            this.formatTxtUseLimitFrom.setEnabled(false);
            this.formatTxtUseLimitTo.setEnabled(false);
            this.formatTxtPrePureRate.setEnabled(false);
            this.formatTxtPureRateFrom.setEnabled(false);
            this.formatTxtPureRateTo.setEnabled(false);
            this.bizPromptDepreciationMode.setEnabled(false);
        }
        if (this.editData != null && this.editData.getParent() != null) {
            FaCatInfo parentInfo = this.editData.getParent();
            if (parentInfo.getBigDecimal("uselimit") == null) {
                this.formatTxtUseLimit.setEnabled(true);
            }
            if (parentInfo.getBigDecimal("uselimitfrom") == null) {
                this.formatTxtUseLimitFrom.setEnabled(true);
            }
            if (parentInfo.getBigDecimal("uselimitto") == null) {
                this.formatTxtUseLimitTo.setEnabled(true);
            }
            if (parentInfo.getPrePureRate() == null || ZERO.compareTo(parentInfo.getPrePureRate()) == 0) {
                this.formatTxtPrePureRate.setEnabled(true);
            }
            if (parentInfo.getPrePureRateFrom() == null || ZERO.compareTo(parentInfo.getPrePureRateFrom()) == 0) {
                this.formatTxtPureRateFrom.setEnabled(true);
            }
            if (parentInfo.getPrePureRateTo() == null || ZERO.compareTo(parentInfo.getPrePureRateTo()) == 0) {
                this.formatTxtPureRateTo.setEnabled(true);
            }
            if (parentInfo.getDepreMode() == null) {
                this.bizPromptDepreciationMode.setEnabled(true);
            }
        }
    }

    private Map<String, String> getParamters() {
        if (this.params != null) {
            return this.params;
        }
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        HashMap<String, ObjectUuidPK> paramKeys = new HashMap<String, ObjectUuidPK>();
        paramKeys.put("FA_054", new ObjectUuidPK(company.getId()));
        paramKeys.put(AccountConstant.GovermentAccountingSystem, null);
        Context ctx = null;
        try {
            this.params = ParamManager.getParamHashMap(ctx, paramKeys);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return this.params;
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    @Override
    public void loadFields() {
        String newGovermentAccountingSystem;
        this.removeListener();
        super.loadFields();
        this.registerListener();
        this.setGCUseLimitAndPureRateStatus();
        this.loadUseLimitAndPureRate();
        if (this.editData.getPrePureRate() != null) {
            this.formatTxtPrePureRate.setValue((Object)this.editData.getPrePureRate().setScale(2, 4));
        }
        this.setUIStatus();
        this.setStatusByFaCat();
        Map<String, String> faParams = this.getParamters();
        String string = newGovermentAccountingSystem = faParams.get(AccountConstant.GovermentAccountingSystem) != null ? faParams.get(AccountConstant.GovermentAccountingSystem) : "false";
        if ("true".equalsIgnoreCase(newGovermentAccountingSystem)) {
            this.chkNotCalDep.setVisible(true);
            this.chkNotCalDep.setEnabled(true);
        } else {
            this.chkNotCalDep.setVisible(false);
            this.chkNotCalDep.setEnabled(false);
        }
        LanguageInfo enInfo = new LanguageInfo(LocaleUtils.locale_L1);
        LanguageInfo chInfo = new LanguageInfo(LocaleUtils.locale_L2);
        if (this.txtName.getItemBy(enInfo) == null && this.txtName.getItemBy(chInfo) != null) {
            this.txtName.setItemData(enInfo, (Object)this.txtName.getItemBy(chInfo));
        }
    }

    private void removeListener() {
        this.chkGroupControlUseLimtAndPureRate.removeMouseListener(this.mouseListener);
    }

    private void registerListener() {
        this.chkGroupControlUseLimtAndPureRate.addMouseListener(this.mouseListener);
    }

    private void changeUseLimitAndPureRate() {
        if (this.isParentNode()) {
            if (this.chkGroupControlUseLimtAndPureRate.getSelected() == 32) {
                this.setSelectedStatus();
                if (this.getOprtState().equals("EDIT")) {
                    int useLimit = this.formatTxtUseLimit.getIntegerValue();
                    BigDecimal prePureRate = new BigDecimal(0.0);
                    if (this.formatTxtPrePureRate.getBigDecimalValue() != null) {
                        prePureRate = this.formatTxtPrePureRate.getBigDecimalValue();
                    }
                    this.formatTxtUseLimitFrom.setValue((Object)useLimit);
                    this.formatTxtUseLimitTo.setValue((Object)useLimit);
                    this.formatTxtPureRateFrom.setValue((Object)prePureRate);
                    this.formatTxtPureRateTo.setValue((Object)prePureRate);
                }
            } else {
                this.setUNSelectStatus();
                if (this.getOprtState().equals("EDIT")) {
                    int useLimitFrom = this.formatTxtUseLimitFrom.getIntegerValue();
                    BigDecimal prePureRateFrom = new BigDecimal(0.0);
                    if (this.formatTxtPureRateFrom.getBigDecimalValue() != null) {
                        prePureRateFrom = this.formatTxtPureRateFrom.getBigDecimalValue();
                    }
                    this.formatTxtUseLimit.setValue((Object)useLimitFrom);
                    this.formatTxtPrePureRate.setValue((Object)prePureRateFrom);
                }
            }
        }
    }

    private void setSelectedStatus() {
        this.formatTxtUseLimit.setVisible(false);
        this.formatTxtPrePureRate.setVisible(false);
        this.formatTxtUseLimitFrom.setVisible(true);
        this.formatTxtUseLimitTo.setVisible(true);
        this.formatTxtPureRateFrom.setVisible(true);
        this.formatTxtPureRateTo.setVisible(true);
        this.setUseLimitFormat(this.formatTxtUseLimitFrom);
        this.setUseLimitFormat(this.formatTxtUseLimitTo);
        this.setPrePureRateFormat(this.formatTxtPureRateFrom);
        this.setPrePureRateFormat(this.formatTxtPureRateTo);
    }

    private void setUNSelectStatus() {
        this.formatTxtUseLimit.setVisible(true);
        this.formatTxtPrePureRate.setVisible(true);
        this.setUseLimitFormat(this.formatTxtUseLimit);
        this.setPrePureRateFormat(this.formatTxtPrePureRate);
        this.formatTxtUseLimitFrom.setVisible(false);
        this.formatTxtUseLimitTo.setVisible(false);
        this.formatTxtPureRateFrom.setVisible(false);
        this.formatTxtPureRateTo.setVisible(false);
    }

    private void loadUseLimitAndPureRate() {
        boolean isLastLeaf = this.editData.isIsLeaf();
        int level = this.editData.getLevel();
        if (isLastLeaf && level > 1) {
            this.chkGroupControlUseLimtAndPureRate.setEnabled(false);
        } else {
            FaCatInfo parentInfo = (FaCatInfo)this.getUIContext().get("ParentNode");
            if (parentInfo != null) {
                this.chkGroupControlUseLimtAndPureRate.setEnabled(false);
            }
        }
        if (this.chkGroupControlUseLimtAndPureRate.getSelected() == 32) {
            this.setSelectedStatus();
        } else {
            this.setUNSelectStatus();
        }
    }

    private void setUseLimitFormat(KDFormattedTextField textField) {
        textField.setHorizontalAlignment(4);
        textField.setDataType(0);
        textField.setDataVerifierType(12);
        textField.setMaximumValue((Comparable)new Integer(9999));
        textField.setMinimumValue((Comparable)new Integer(0));
        textField.setPrecision(0);
        textField.setSupportedEmpty(false);
    }

    private void setPrePureRateFormat(KDFormattedTextField textField) {
        textField.setHorizontalAlignment(4);
        textField.setNegatived(false);
        textField.setDataType(1);
        textField.setPrecision(2);
        textField.setMaximumValue((Comparable)new BigDecimal("100"));
        textField.setSupportedEmpty(false);
    }

    private boolean isParentNode() {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        return aCompanyOrgUnitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4");
    }

    private void setGCUseLimitAndPureRateStatus() {
        if (this.isParentNode()) {
            this.chkGroupControlUseLimtAndPureRate.setEnabled(true);
        } else {
            this.chkGroupControlUseLimtAndPureRate.setEnabled(false);
        }
    }

    @Override
    protected void setUIStatus() {
        super.setUIStatus();
        try {
            if (this.getOprtState().equals("EDIT")) {
                if (this.editData.getId() != null && this.editData.getDepreciationPolicy() != null) {
                    FilterInfo filterInfo = new FilterInfo();
                    FilterItemInfo filterItemInfo = new FilterItemInfo("assetCat.id", (Object)this.editData.getId().toString(), CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    IFaCurCard iFaCurCardFactory = FaCurCardFactory.getRemoteInstance();
                    if (iFaCurCardFactory.exists(filterInfo)) {
                        this.prmtDepreciationPolicy.setAccessAuthority(1);
                        this.chkCalcuByEvaluate.setEnabled(false);
                    }
                    if (this.checkImport()) {
                        this.txtName.setEditable(false);
                        this.txtNumber.setEditable(false);
                        this.ksPGroupLevel.setEditable(false);
                        this.prmtDepreciationPolicy.setAccessAuthority(1);
                        this.txtNumberRule.setEditable(false);
                        this.bizPromptdecValPolicy.setAccessAuthority(0);
                    }
                }
            } else if (this.getOprtState().equals("ADDNEW")) {
                this.prmtDepreciationPolicy.setAccessAuthority(0);
                this.chkCalcuByEvaluate.setEnabled(true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected IObjectValue createNewData() {
        FaCatInfo aFaCatInfo = new FaCatInfo();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        CtrlUnitInfo aCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        aFaCatInfo.setCompany(aCompanyOrgUnitInfo);
        aFaCatInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        aFaCatInfo.setPrePureRate(new BigDecimal("0.00"));
        aFaCatInfo.setIsGroup(false);
        aFaCatInfo.setSourceMode(FaBaseDataSouceEnum.NEW);
        aFaCatInfo.setGroupLevel(0);
        try {
            if (this.getUIContext() != null) {
                FaCatInfo parentInfo = (FaCatInfo)this.getUIContext().get("ParentNode");
                IFaCat iFaCatFactory = FaCatFactory.getRemoteInstance();
                if (parentInfo != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("depreMode.number"));
                    sic.add(new SelectorItemInfo("depreMode.name"));
                    parentInfo = iFaCatFactory.getFaCatInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId()), sic);
                    if (this.getOprtState().equals("ADDNEW")) {
                        aFaCatInfo.setGroupLevel(parentInfo.getGroupLevel());
                        aFaCatInfo.setGcUseLimitAndPureRate(parentInfo.isGcUseLimitAndPureRate());
                        if (parentInfo.isGcUseLimitAndPureRate()) {
                            aFaCatInfo.setUseLimitFrom(parentInfo.getUseLimitFrom());
                            aFaCatInfo.setUseLimitTo(parentInfo.getUseLimitTo());
                            aFaCatInfo.setPrePureRateFrom(parentInfo.getPrePureRateFrom());
                            aFaCatInfo.setPrePureRateTo(parentInfo.getPrePureRateTo());
                        } else {
                            aFaCatInfo.setUseLimit(parentInfo.getUseLimit());
                            aFaCatInfo.setPrePureRate(parentInfo.getPrePureRate());
                        }
                        aFaCatInfo.setDepreMode(parentInfo.getDepreMode());
                    }
                    aFaCatInfo.setParent(parentInfo);
                } else {
                    aFaCatInfo.setParent(null);
                    if (this.getOprtState().equals("ADDNEW")) {
                        if (!aCtrlUnitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                            aFaCatInfo.setGroupLevel(0);
                        } else {
                            aFaCatInfo.setGroupLevel(1);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return aFaCatInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaCatFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("classfication.id"));
        sic.add(new SelectorItemInfo("classfication.number"));
        sic.add(new SelectorItemInfo("classfication.name"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("depreMode.id"));
        sic.add(new SelectorItemInfo("depreMode.number"));
        sic.add(new SelectorItemInfo("depreMode.name"));
        sic.add(new SelectorItemInfo("DepreciationPolicy.id"));
        sic.add(new SelectorItemInfo("DepreciationPolicy.number"));
        sic.add(new SelectorItemInfo("DepreciationPolicy.name"));
        sic.add(new SelectorItemInfo("decValPolicy.id"));
        sic.add(new SelectorItemInfo("decValPolicy.number"));
        sic.add(new SelectorItemInfo("decValPolicy.name"));
        sic.add(new SelectorItemInfo("parent.groupLevel"));
        sic.add(new SelectorItemInfo("parent.useLimit"));
        sic.add(new SelectorItemInfo("parent.useLimitFrom"));
        sic.add(new SelectorItemInfo("parent.useLimitTo"));
        sic.add(new SelectorItemInfo("parent.prePureRate"));
        sic.add(new SelectorItemInfo("parent.prePureRateFrom"));
        sic.add(new SelectorItemInfo("parent.prePureRateTo"));
        sic.add(new SelectorItemInfo("parent.depreMode"));
        sic.add(new SelectorItemInfo("style.*"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.setParent((FaCatInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.prmtDepreciationPolicy.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_DeprPolicyIsNull"));
            this.prmtDepreciationPolicy.requestFocus();
            SysUtil.abort();
        }
        if (this.bizPromptdecValPolicy.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_decValPolicyIsNull"));
            this.bizPromptdecValPolicy.requestFocus();
            SysUtil.abort();
        }
        if (this.txtNumberRule.getText() == null || this.txtNumberRule.getText().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_NumberRuleIsNull"));
            this.bizPromptdecValPolicy.requestFocus();
            SysUtil.abort();
        }
        FaCatInfo parentInfo = null;
        BigDecimal parentUseLimitFrom = null;
        BigDecimal parentUseLimitTo = null;
        BigDecimal parentPrePureRateFrom = null;
        BigDecimal parentPrePureRateTo = null;
        if (this.getUIContext() != null) {
            parentInfo = (FaCatInfo)this.getUIContext().get("ParentNode");
            IFaCat iFaCatFactory = FaCatFactory.getRemoteInstance();
            if (parentInfo != null) {
                parentInfo = iFaCatFactory.getFaCatInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId()));
            } else {
                CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
                CompanyOrgUnitInfo parentCompany = aCompanyOrgUnitInfo.getParent();
                if (parentCompany != null) {
                    String parentCompanyId = parentCompany.getId().toString();
                    String catNumber = this.txtNumber.getText();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)catNumber));
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)parentCompanyId));
                    view.setFilter(filter);
                    FaCatCollection catCollection = iFaCatFactory.getFaCatCollection(view);
                    if (catCollection != null && catCollection.size() > 0) {
                        parentInfo = catCollection.get(0);
                    }
                }
            }
            if (parentInfo != null) {
                parentUseLimitFrom = parentInfo.getBigDecimal("uselimitfrom");
                parentUseLimitTo = parentInfo.getBigDecimal("uselimitto");
                parentPrePureRateFrom = parentInfo.getPrePureRateFrom();
                parentPrePureRateTo = parentInfo.getPrePureRateTo();
            }
        }
        BigDecimal useLimitFrom = this.formatTxtUseLimitFrom.getBigDecimalValue();
        BigDecimal useLimitTo = this.formatTxtUseLimitTo.getBigDecimalValue();
        BigDecimal prePureRateFrom = this.formatTxtPureRateFrom.getBigDecimalValue();
        BigDecimal prePureRateTo = this.formatTxtPureRateTo.getBigDecimalValue();
        if (this.chkGroupControlUseLimtAndPureRate.getSelected() == 32) {
            if (useLimitFrom == null || useLimitFrom.compareTo(ZERO) == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_UseLimitRangIllegal"));
                this.formatTxtUseLimitFrom.requestFocus();
                SysUtil.abort();
            } else if (useLimitTo == null || useLimitTo.compareTo(ZERO) == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_UseLimitRangIllegal"));
                this.formatTxtUseLimitTo.requestFocus();
                SysUtil.abort();
            } else if (useLimitTo.intValue() < useLimitFrom.intValue()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_UseLimitRangIllegal"));
                this.formatTxtUseLimitTo.requestFocus();
                SysUtil.abort();
            }
            if (prePureRateFrom == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_PureRateRangIllegal"));
                this.formatTxtPureRateFrom.requestFocus();
                SysUtil.abort();
            } else if (prePureRateTo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_PureRateRangIllegal"));
                this.formatTxtPureRateTo.requestFocus();
                SysUtil.abort();
            } else if (prePureRateTo.compareTo(prePureRateFrom) == -1) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_PureRateRangIllegal"));
                this.formatTxtPureRateTo.requestFocus();
                SysUtil.abort();
            }
            if (parentInfo != null) {
                if (parentUseLimitFrom != null && parentUseLimitTo != null && (useLimitFrom.compareTo(parentUseLimitFrom) == -1 || useLimitFrom.compareTo(parentUseLimitTo) == 1 || useLimitTo.compareTo(parentUseLimitTo) == 1)) {
                    MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_UseLimitOutOfGroupRang") + parentInfo.getUseLimitFrom() + "~" + parentInfo.getUseLimitTo() + EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"59_FaCatEditUI")));
                    this.formatTxtUseLimitFrom.requestFocus();
                    SysUtil.abort();
                }
                if (parentPrePureRateFrom != null && parentPrePureRateTo != null && (prePureRateFrom.compareTo(parentPrePureRateFrom) == -1 || prePureRateFrom.compareTo(parentPrePureRateTo) == 1 || prePureRateTo.compareTo(parentPrePureRateTo) == 1)) {
                    MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", (String)"FaCatEditUI_PureRateOutOfGroupRang") + parentInfo.getPrePureRateFrom().setScale(2, 4) + "% ~ " + parentInfo.getPrePureRateTo().setScale(2, 4) + "%"));
                    this.formatTxtPureRateFrom.requestFocus();
                    SysUtil.abort();
                }
            }
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(aCompanyOrgUnitInfo);
        super.actionCopy_actionPerformed(e);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.requestFocus();
    }

    @Override
    protected ITreeBase getTreeInterface() throws Exception {
        return FaCatFactory.getRemoteInstance();
    }

    public boolean checkImport() throws Exception {
        FaCatInfo data = this.editData;
        if (data.getSourceMode() != null && data.getSourceMode() == FaBaseDataSouceEnum.IMPORT) {
            return true;
        }
        String catNumber = data.getNumber();
        FaCatCollection importedCats = FaCatFactory.getRemoteInstance().getFaCatCollection("select id where number = '" + catNumber + "' and sourceMode = 2");
        return importedCats.size() > 0;
    }
}

