/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyCollection;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyFactory;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeCollection;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaSimulateDeprSchemeFactory;
import com.kingdee.eas.fi.fa.basedata.FaSimulateDeprSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.basedata.IFADepreciationPolicy;
import com.kingdee.eas.fi.fa.basedata.IFaDepreciationMode;
import com.kingdee.eas.fi.fa.basedata.client.AbstractFaSimulateDeprSchemEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Iterator;

public class FaSimulateDeprSchemEditUI
extends AbstractFaSimulateDeprSchemEditUI {
    private CompanyOrgUnitInfo currCompany;
    private static final String NUMBER = "number";
    private static final String DEPRMODE = "deprMode";
    private static final String DEPRPOLICY = "deprPolicy";
    private static final String SELECT = "select";
    public static final int rateScale = 2;
    private int amountScale = 10;
    private static final BigDecimal MAXVAL = FaClientUtils.MAX_DECIMAL;
    private static final BigDecimal MINVAL = FaClientUtils.MIN_DECIMAL;
    private static final BigDecimal MAXINTVAL = new BigDecimal("9999999999");
    private static final BigDecimal MAXVALRATE = new BigDecimal("100.00");
    private static final BigDecimal MINVALRATE = new BigDecimal("0.00");
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.basedata.client.FaDecValPolicyUIResource";
    FADepreciationPolicyCollection deprPolicyCol = null;
    FaDepreciationModeCollection deprModeCol = null;

    private void setPrecision() {
        this.amountScale = this.getCurrencyScale();
        this.ftxtAccuDepr.setPrecision(this.amountScale);
        this.ftxtAccuDepr.setMaximumValue((Comparable)MAXVAL);
        this.ftxtAccuDepr.setMinimumValue((Comparable)MINVAL);
        this.ftxtAccuDepr.setSupportedEmpty(true);
        this.ftxtAccuDepr.setNegatived(false);
        this.ftxtAccuDepr.setRemoveingZeroInDispaly(false);
        this.ftxtAccuDepr.setHorizontalAlignment(4);
        this.ftxtAssetValue.setPrecision(this.amountScale);
        this.ftxtAssetValue.setMaximumValue((Comparable)MAXVAL);
        this.ftxtAssetValue.setMinimumValue((Comparable)MINVAL);
        this.ftxtAssetValue.setSupportedEmpty(true);
        this.ftxtAssetValue.setNegatived(false);
        this.ftxtAssetValue.setRemoveingZeroInDispaly(false);
        this.ftxtAssetValue.setHorizontalAlignment(4);
        this.ftxtDecValue.setPrecision(this.amountScale);
        this.ftxtDecValue.setMaximumValue((Comparable)MAXVAL);
        this.ftxtDecValue.setMinimumValue((Comparable)MINVAL);
        this.ftxtDecValue.setSupportedEmpty(true);
        this.ftxtDecValue.setNegatived(false);
        this.ftxtDecValue.setRemoveingZeroInDispaly(false);
        this.ftxtDecValue.setHorizontalAlignment(4);
        this.ftxtEvaluateValue.setPrecision(this.amountScale);
        this.ftxtEvaluateValue.setMaximumValue((Comparable)MAXVAL);
        this.ftxtEvaluateValue.setMinimumValue((Comparable)MINVAL);
        this.ftxtEvaluateValue.setSupportedEmpty(true);
        this.ftxtEvaluateValue.setNegatived(false);
        this.ftxtEvaluateValue.setRemoveingZeroInDispaly(false);
        this.ftxtEvaluateValue.setHorizontalAlignment(4);
        this.ftxtUsedYears.setPrecision(0);
        this.ftxtUsedYears.setSupportedEmpty(true);
        this.ftxtUsedYears.setMaximumValue((Comparable)MAXINTVAL);
        this.ftxtUsedYears.setNegatived(false);
        this.ftxtUsedYears.setHorizontalAlignment(4);
        this.ftxtUseYears.setPrecision(0);
        this.ftxtUseYears.setSupportedEmpty(true);
        this.ftxtUseYears.setMaximumValue((Comparable)MAXINTVAL);
        this.ftxtUseYears.setNegatived(false);
        this.ftxtUseYears.setHorizontalAlignment(4);
        this.ftxtNeatRemValRate.setMaximumValue((Comparable)MAXVALRATE);
        this.ftxtNeatRemValRate.setMinimumValue((Comparable)MINVALRATE);
        this.ftxtNeatRemValRate.setPrecision(2);
        this.ftxtNeatRemValRate.setNegatived(false);
        this.ftxtNeatRemValRate.setHorizontalAlignment(4);
        this.ftxtNeatRemValRate.setSupportedEmpty(true);
    }

    private int getCurrencyScale() {
        int currencyScale = -1;
        if (currencyScale == -1) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("precision"));
            ObjectUuidPK pk = new ObjectUuidPK(this.getCurrentCompany().getBaseCurrency().getId());
            try {
                CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk, sic);
                currencyScale = currencyInfo.getPrecision();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return currencyScale == -1 ? 2 : currencyScale;
    }

    protected CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            try {
                BOSUuid id = SysContext.getSysContext().getCurrentFIUnit().getId();
                this.currCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return this.currCompany;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.decideToStore();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String strTemp;
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            strTemp = EASResource.getString((String)RESOURCE_PATH, (String)"numIsNull");
            this.txtNumber.requestFocusInWindow();
            MsgBox.showInfo((Component)((Object)this), (String)strTemp);
            SysUtil.abort();
        }
        if (this.mltxtName.getSelectedItem().toString() == null || this.mltxtName.getSelectedItem().toString().trim().length() == 0) {
            strTemp = EASResource.getString((String)RESOURCE_PATH, (String)"nameIsNull");
            this.mltxtName.requestFocusInWindow();
            MsgBox.showInfo((Component)((Object)this), (String)strTemp);
            SysUtil.abort();
        }
        this.txtNumber.requestFocusInWindow();
        super.beforeStoreFields(e);
    }

    private void decideToStore() {
        String number;
        Iterator iter;
        Boolean select;
        IRow row = null;
        String selectedNumber = null;
        int size = this.kdtDeprMode.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtDeprMode.getRow(i);
            select = (Boolean)row.getCell(SELECT).getValue();
            if (!select.booleanValue()) continue;
            selectedNumber = row.getCell(NUMBER).getValue().toString();
        }
        try {
            IFaDepreciationMode faDeprMode = FaDepreciationModeFactory.getRemoteInstance();
            FaDepreciationModeCollection deprCol = faDeprMode.getFaDepreciationModeCollection();
            iter = deprCol.iterator();
            while (iter.hasNext()) {
                FaDepreciationModeInfo deprModeInfo = (FaDepreciationModeInfo)iter.next();
                number = deprModeInfo.getNumber();
                if (selectedNumber == null || !selectedNumber.equals(number)) continue;
                this.editData.setDeprMode(deprModeInfo);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        size = this.kdtDeprPolicy.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtDeprPolicy.getRow(i);
            select = (Boolean)row.getCell(SELECT).getValue();
            if (!select.booleanValue()) continue;
            selectedNumber = row.getCell(NUMBER).getValue().toString();
        }
        try {
            IFADepreciationPolicy faDeprPolicy = FADepreciationPolicyFactory.getRemoteInstance();
            FADepreciationPolicyCollection deprCol = faDeprPolicy.getFADepreciationPolicyCollection();
            iter = deprCol.iterator();
            while (iter.hasNext()) {
                FADepreciationPolicyInfo deprPolicyInfo = (FADepreciationPolicyInfo)iter.next();
                number = deprPolicyInfo.getNumber();
                if (selectedNumber == null || !selectedNumber.equals(number)) continue;
                this.editData.setDeprPolicy(deprPolicyInfo);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void initListener() {
        super.initListener();
        this.kdtDeprMode.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() != 1) {
                    return;
                }
                IRow row = null;
                int size = FaSimulateDeprSchemEditUI.this.kdtDeprMode.getRowCount();
                for (int i = 0; i < size; ++i) {
                    row = FaSimulateDeprSchemEditUI.this.kdtDeprMode.getRow(i);
                    row.getCell(FaSimulateDeprSchemEditUI.SELECT).setValue((Object)Boolean.FALSE);
                }
                int rowIndex = e.getRowIndex();
                FaSimulateDeprSchemEditUI.this.kdtDeprMode.getRow(rowIndex).getCell(FaSimulateDeprSchemEditUI.SELECT).setValue((Object)Boolean.TRUE);
                FaSimulateDeprSchemEditUI.this.kdtDeprMode.reLayoutAndPaint();
            }
        });
        this.kdtDeprPolicy.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() != 1) {
                    return;
                }
                IRow row = null;
                int size = FaSimulateDeprSchemEditUI.this.kdtDeprPolicy.getRowCount();
                for (int i = 0; i < size; ++i) {
                    row = FaSimulateDeprSchemEditUI.this.kdtDeprPolicy.getRow(i);
                    row.getCell(FaSimulateDeprSchemEditUI.SELECT).setValue((Object)Boolean.FALSE);
                }
                int rowIndex = e.getRowIndex();
                FaSimulateDeprSchemEditUI.this.kdtDeprPolicy.getRow(rowIndex).getCell(FaSimulateDeprSchemEditUI.SELECT).setValue((Object)Boolean.TRUE);
                FaSimulateDeprSchemEditUI.this.kdtDeprPolicy.reLayoutAndPaint();
            }
        });
    }

    protected IObjectValue createNewData() {
        FaSimulateDeprSchemeInfo objectValue = new FaSimulateDeprSchemeInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        try {
            this.deprModeCol = FaDepreciationModeFactory.getRemoteInstance().getFaDepreciationModeCollection();
            FaDepreciationModeInfo firstDeprModeInfo = this.deprModeCol.get(0);
            objectValue.setDeprMode(firstDeprModeInfo);
            this.deprPolicyCol = FADepreciationPolicyFactory.getRemoteInstance().getFADepreciationPolicyCollection();
            FADepreciationPolicyInfo firstDeprPolicyInfo = this.deprPolicyCol.get(0);
            objectValue.setDeprPolicy(firstDeprPolicyInfo);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaSimulateDeprSchemeFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.kdtDeprMode.checkParsed();
        this.kdtDeprPolicy.checkParsed();
        this.loadDeprMode();
        this.loadDeprPolicy();
    }

    private void loadDeprMode() {
        this.kdtDeprMode.removeRows();
        try {
            if (!"ADDNEW".equals(this.getOprtState())) {
                this.deprModeCol = FaDepreciationModeFactory.getRemoteInstance().getFaDepreciationModeCollection();
            }
            IRow row = null;
            ICell cell = null;
            Iterator iter = this.deprModeCol.iterator();
            while (iter.hasNext()) {
                FaDepreciationModeInfo deprModeInfo = (FaDepreciationModeInfo)iter.next();
                String number = deprModeInfo.getNumber();
                String name = deprModeInfo.getName();
                if (FaUtils.isWorkLoadMethod(deprModeInfo) || FaUtils.isWellOnlyMethod(deprModeInfo)) continue;
                row = this.kdtDeprMode.addRow();
                cell = row.getCell(DEPRMODE);
                cell.setValue((Object)name);
                cell = row.getCell(NUMBER);
                cell.setValue((Object)number);
                cell = row.getCell(SELECT);
                cell.setValue((Object)Boolean.FALSE);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.decideToDisplay(this.editData.getDeprMode(), this.editData.getDeprPolicy());
    }

    private void loadDeprPolicy() {
        this.kdtDeprPolicy.removeRows();
        try {
            if (!"ADDNEW".equals(this.getOprtState())) {
                this.deprPolicyCol = FADepreciationPolicyFactory.getRemoteInstance().getFADepreciationPolicyCollection();
            }
            IRow row = null;
            ICell cell = null;
            Iterator iter = this.deprPolicyCol.iterator();
            while (iter.hasNext()) {
                FADepreciationPolicyInfo deprPolicyInfo = (FADepreciationPolicyInfo)iter.next();
                String number = deprPolicyInfo.getNumber();
                String name = deprPolicyInfo.getName();
                row = this.kdtDeprPolicy.addRow();
                cell = row.getCell(DEPRPOLICY);
                cell.setValue((Object)name);
                cell = row.getCell(NUMBER);
                cell.setValue((Object)number);
                cell = row.getCell(SELECT);
                cell.setValue((Object)Boolean.FALSE);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.decideToDisplay(this.editData.getDeprMode(), this.editData.getDeprPolicy());
    }

    private void decideToDisplay(FaDepreciationModeInfo deprModeInfo, FADepreciationPolicyInfo deprPolicyInfo) {
        String number;
        int i;
        String rightModeNumber = deprModeInfo.getNumber();
        String rightPolicyNumber = deprPolicyInfo.getNumber();
        IRow modeRow = null;
        IRow policyRow = null;
        int size = this.kdtDeprMode.getRowCount();
        for (i = 0; i < size; ++i) {
            modeRow = this.kdtDeprMode.getRow(i);
            number = modeRow.getCell(NUMBER).getValue().toString();
            if (rightModeNumber == null || number == null || !rightModeNumber.equals(number)) continue;
            modeRow.getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        size = this.kdtDeprPolicy.getRowCount();
        for (i = 0; i < size; ++i) {
            policyRow = this.kdtDeprPolicy.getRow(i);
            number = policyRow.getCell(NUMBER).getValue().toString();
            if (rightPolicyNumber == null || number == null || !rightPolicyNumber.equals(number)) continue;
            policyRow.getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo(DEPRMODE));
        sic.add(new SelectorItemInfo("deprMode.*"));
        sic.add(new SelectorItemInfo(DEPRPOLICY));
        sic.add(new SelectorItemInfo("deprPolicy.*"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("creator"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPrecision();
    }
}

