/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaSubsidiaryFacilityFactory;
import com.kingdee.eas.fi.fa.basedata.FaSubsidiaryFacilityInfo;
import com.kingdee.eas.fi.fa.basedata.client.AbstractFaSubsidiaryFacilityEditUI;
import com.kingdee.eas.fi.fa.manage.FaBakFacilityFactory;
import com.kingdee.eas.fi.fa.manage.FaBizFacilityFactory;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityFactory;
import com.kingdee.eas.fi.fa.manage.FaMonFacilityFactory;
import com.kingdee.eas.fi.fa.manage.IFaFacility;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FaSubsidiaryFacilityEditUI
extends AbstractFaSubsidiaryFacilityEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaSubsidiaryFacilityEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtName.setRequired(true);
        this.txtNumber.setRequired(true);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionSave.setVisible(false);
    }

    protected IObjectValue createNewData() {
        FaSubsidiaryFacilityInfo info = new FaSubsidiaryFacilityInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Object obj = this.getUIContext().get("ParentNode");
        if (obj instanceof TreeBaseInfo) {
            info.put("type", obj);
        }
        return info;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || "".equalsIgnoreCase(this.txtNumber.getText().trim())) {
            this.txtNumber.requestFocus();
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (this.txtName.getDefaultLangItemData() == null || "".equalsIgnoreCase(this.txtName.getDefaultLangItemData().toString())) {
            this.txtName.requestFocus();
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        if (!this.txtNumber.getText().trim().equals(this.editData.getNumber()) || !this.txtName.getDefaultLangItemData().toString().equals(this.editData.getName())) {
            this.updateFaFacility();
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || "".equalsIgnoreCase(this.txtNumber.getText().trim())) {
            this.txtNumber.requestFocus();
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (this.txtName.getDefaultLangItemData() == null || "".equalsIgnoreCase(this.txtName.getDefaultLangItemData().toString())) {
            this.txtName.requestFocus();
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        if (!this.txtNumber.getText().trim().equals(this.editData.getNumber()) || !this.txtName.getDefaultLangItemData().toString().equals(this.editData.getName())) {
            this.updateFaFacility();
        }
        super.actionSave_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaSubsidiaryFacilityFactory.getRemoteInstance();
    }

    private void updateFaFacility() throws BOSException, EASBizException {
        String oldNumber = this.editData.getNumber();
        String oldName = this.editData.getName();
        String newNumber = this.txtNumber.getText().trim();
        String newName = this.txtName.getName().trim();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("facilityNumber", (Object)oldNumber));
        filter.getFilterItems().add(new FilterItemInfo("facilityName", (Object)oldName));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("facilityNumber"));
        sic.add(new SelectorItemInfo("facilityName"));
        IFaFacility[] iFaFacilities = new IFaFacility[]{FaCurFacilityFactory.getRemoteInstance(), FaMonFacilityFactory.getRemoteInstance(), FaBakFacilityFactory.getRemoteInstance(), FaBizFacilityFactory.getRemoteInstance()};
        int length = iFaFacilities.length;
        for (int i = 0; i < length; ++i) {
            CoreBaseCollection faFacilityCollection = iFaFacilities[i].getCollection(view);
            int size = faFacilityCollection.size();
            for (int j = 0; j < size; ++j) {
                CoreBaseInfo faFacilityInfo = faFacilityCollection.get(j);
                faFacilityInfo.setString("facilityNumber", newNumber);
                faFacilityInfo.setString("facilityName", newName);
                iFaFacilities[i].updatePartial(faFacilityInfo, sic);
            }
        }
    }
}

