/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaBaseDataSouceEnum;
import com.kingdee.eas.fi.fa.basedata.FaBasicException;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.client.AbstractFaTreeEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaSpinnerChangeListener;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public abstract class FaTreeEditUI
extends AbstractFaTreeEditUI {
    protected static final String RES_PATH = "com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource";
    private static final String SOURCE_MODE = "sourceMode";
    private static final String GROUP_LEVEL = "groupLevel";
    private int minGroupLevel = 1;
    protected CtrlUnitInfo aCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
    protected CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
    protected CUBDControlInfo cuControl;
    protected CompanyOrgUnitCollection orgUnitCollection;

    protected void initListener() {
        this.ksPGroupLevel.addChangeListener((ChangeListener)new FaSpinnerChangeListener(9999, 0));
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        IObjectValue ov = dataObject;
        super.setDataObject(ov);
        this.editData = (TreeBaseInfo)ov;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setUIStatus();
    }

    private void setProperGroupLevel() throws BOSException, Exception {
        CompanyOrgUnitInfo companyOrgUnitInfo;
        if (this.editData instanceof FaAlterModeInfo && ("001".equals(this.editData.getNumber()) || "002".equals(this.editData.getNumber()))) {
            this.minGroupLevel = 2;
        }
        if ((companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit().getParent()) == null) {
            return;
        }
        TreeBaseCollection treeColl = this.getTreeInterface().getTreeBaseCollection("select * where number = '" + this.editData.getNumber() + "' and company.id = '" + companyOrgUnitInfo.getId().toString() + "'");
        if (treeColl.size() == 0) {
            return;
        }
        TreeBaseInfo treeInfo = treeColl.get(0);
        if (treeInfo.get(GROUP_LEVEL) == null) {
            return;
        }
        this.minGroupLevel = (Integer)treeInfo.get(GROUP_LEVEL);
        boolean isNew = true;
        if (this.editData.get(SOURCE_MODE) != null) {
            isNew = 1 == Integer.parseInt(this.editData.get(SOURCE_MODE).toString());
        }
        this.ksPGroupLevel.setEnabled(true);
        if (isNew && this.editData.get("parent") == null) {
            this.ksPGroupLevel.setEnabled(true);
        }
        if (isNew && this.editData.get("parent") != null) {
            int groupLevel = (Integer)((TreeBaseInfo)this.editData.get("parent")).get(GROUP_LEVEL);
            this.ksPGroupLevel.setModel((SpinnerModel)new SpinnerNumberModel((Integer)this.ksPGroupLevel.getValue(), groupLevel, 9999, 1));
        }
        if (!isNew) {
            this.ksPGroupLevel.setModel((SpinnerModel)new SpinnerNumberModel((Integer)this.ksPGroupLevel.getValue(), this.minGroupLevel, 9999, 1));
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            this.verifyRemoveLine(this.editData.getId().toString());
        }
        super.actionRemove_actionPerformed(e);
    }

    private void verifyRemoveLine(String strId) throws BOSException, EASBizException, FaBasicException, Exception {
        if (StringUtils.isEmpty((String)strId)) {
            return;
        }
        FilterInfo filterInfo0 = new FilterInfo();
        filterInfo0.getFilterItems().add(new FilterItemInfo("parent", (Object)strId));
        if (this.getBizInterface().exists(filterInfo0)) {
            throw new FaBasicException(FaBasicException.REMOVE_CHILD_FIRST);
        }
        TreeBaseInfo dataInfo = this.getTreeInterface().getTreeBaseInfo((IObjectPK)new ObjectUuidPK(strId));
        if (dataInfo == null) {
            return;
        }
        if (!FaBaseDataSouceEnum.NEW.equals(dataInfo.get(SOURCE_MODE))) {
            boolean canDelete = false;
            if (this.getCUControl() != null) {
                canDelete = this.getCUControl().isIsSubordinateDeletable();
            }
            if (!canDelete) {
                throw new FaBasicException(FaBasicException.CURRENT_CU_NO_PERMISSION);
            }
        }
        if (this.getSubCUCollection().size() != 0) {
            HashSet<BOSUuid> cardId = new HashSet<BOSUuid>();
            Iterator it = this.getSubCUCollection().iterator();
            while (it.hasNext()) {
                cardId.add(((CompanyOrgUnitInfo)it.next()).getId());
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)dataInfo.getNumber()));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)dataInfo.getName()));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", cardId, CompareType.INCLUDE));
            if (this.getBizInterface().exists(filterInfo)) {
                throw new FaBasicException(FaBasicException.IS_REFERENCE_CANNOT_DEL);
            }
        }
    }

    private CUBDControlInfo getCUControl() throws EASBizException, BOSException {
        if (this.cuControl == null) {
            ICUBDControl cubd = CUBDControlFactory.getRemoteInstance();
            this.cuControl = cubd.getBDCtrlInfo(new FaCatInfo().getBOSType().toString(), this.aCtrlUnitInfo.getId().toString());
        }
        return this.cuControl;
    }

    protected void setUIStatus() {
        block12: {
            try {
                SpinnerNumberModel model = (SpinnerNumberModel)this.ksPGroupLevel.getModel();
                model.setMinimum(new Comparable<Number>(){

                    @Override
                    public int compareTo(Number o) {
                        return o.intValue() <= 0 ? 1 : 0;
                    }
                });
                if (this.getOprtState().equals("ADDNEW")) {
                    this.txtName.setEnabled(true);
                    this.txtName.setEditable(true);
                    this.txtNumber.setEditable(true);
                    TreeBaseInfo parent = (TreeBaseInfo)this.editData.get("parent");
                    if (parent != null) {
                        this.ksPGroupLevel.setEnabled(true);
                        this.ksPGroupLevel.setModel((SpinnerModel)new SpinnerNumberModel((Integer)this.ksPGroupLevel.getValue(), (Integer)this.ksPGroupLevel.getValue(), 9999, 1));
                    } else {
                        this.ksPGroupLevel.setEnabled(true);
                    }
                    break block12;
                }
                if (!this.getOprtState().equals("EDIT")) break block12;
                this.setProperGroupLevel();
                boolean isDistribute = this.isDistribute();
                boolean isReferenced = false;
                try {
                    this.getTreeInterface().isReferenced((IObjectPK)new ObjectUuidPK(this.editData.getId()));
                }
                catch (ObjectReferedException ex) {
                    isReferenced = true;
                }
                EntityViewInfo entryViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)this.editData.getId().toString().trim()));
                entryViewInfo.setFilter(filterInfo);
                CtrlUnitInfo aCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
                if (this.getBizInterface().exists(filterInfo) || isReferenced || isDistribute) {
                    this.ksPGroupLevel.setEnabled(false);
                }
                boolean isNew = true;
                if (this.editData.get(SOURCE_MODE) != null) {
                    boolean bl = isNew = 1 == Integer.parseInt(this.editData.get(SOURCE_MODE).toString());
                }
                if (this.getBizInterface().exists(filterInfo) || !isNew || isReferenced || isDistribute) {
                    this.txtName.setEditable(false);
                    this.txtName.setEnabled(false);
                    this.txtNumber.setEditable(false);
                } else {
                    if (aCtrlUnitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4") && this.editData.getLevel() == 1) {
                        this.ksPGroupLevel.setEnabled(true);
                    }
                    this.txtName.setEnabled(true);
                    this.txtName.setEditable(true);
                    this.txtNumber.setEditable(true);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private boolean isDistribute() throws Exception {
        if (this.getSubCUCollection().size() != 0) {
            HashSet<BOSUuid> cardId = new HashSet<BOSUuid>();
            Iterator it = this.getSubCUCollection().iterator();
            while (it.hasNext()) {
                cardId.add(((CompanyOrgUnitInfo)it.next()).getId());
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.editData.getNumber()));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)this.editData.getName()));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", cardId, CompareType.INCLUDE));
            if (this.getBizInterface().exists(filterInfo)) {
                return true;
            }
        }
        return false;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"strNumberIsNull"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        } else {
            if (this.numberIsIllegal(this.txtNumber.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"numberIsIllegal"));
                this.txtNumber.requestFocus();
                SysUtil.abort();
            }
            this.editData.setNumber(this.txtNumber.getText());
            try {
                this.getTreeInterface().checkNumberDup((DataBaseInfo)this.editData);
            }
            catch (EASBizException ex) {
                this.txtNumber.requestFocus();
                throw ex;
            }
        }
        if (this.editData.getName() == null || this.editData.getName().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"strNameIsNull"));
            this.txtName.requestFocus();
            SysUtil.abort();
        } else {
            boolean isfileName = StringUtils.isFileName((String)this.editData.getName());
            if (!isfileName) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"strIllegalName"));
                this.txtName.requestFocus();
                SysUtil.abort();
            }
            try {
                this.getTreeInterface().checkNameDup((DataBaseInfo)this.editData);
            }
            catch (EASBizException ex) {
                this.txtName.requestFocus();
                throw ex;
            }
        }
    }

    private boolean numberIsIllegal(String number) {
        return false;
    }

    private CompanyOrgUnitCollection getSubCUCollection() throws EASBizException, BOSException {
        if (this.orgUnitCollection == null) {
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)this.aCompanyOrgUnitInfo.getId()));
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getCompanOrgUnitViewInfo());
            this.orgUnitCollection = companyOrgUnit.getCompanyOrgUnitCollection(view);
        }
        return this.orgUnitCollection;
    }

    protected SelectorItemCollection getCompanOrgUnitViewInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent"));
        return sic;
    }

    protected abstract ITreeBase getTreeInterface() throws Exception;

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
        aCompanyOrgUnitInfo = this.getUIContext().get("cuInfo") != null ? (CompanyOrgUnitInfo)this.getUIContext().get("cuInfo") : SysContext.getSysContext().getCurrentFIUnit();
        if (this.editData != null && this.editData.getLevel() == 1) {
            if (!aCompanyOrgUnitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.First_Level");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
        } else if (this.editData != null) {
            int groupLevel = Integer.parseInt(this.editData.get(GROUP_LEVEL).toString());
            if (aCompanyOrgUnitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                if (this.editData.getLevel() > groupLevel && groupLevel != 0) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.BigLevel");
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                    return;
                }
            } else if (this.editData.getLevel() <= groupLevel && groupLevel != 0) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.LittleLevel");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
        }
        super.actionAddNew_actionPerformed(e);
    }
}

