/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptItemQuery;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractAddDynaItemUI;
import com.kingdee.eas.fi.gr.dynamic.client.DynaHeadItem;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class AddDynaItemUI
extends AbstractAddDynaItemUI {
    private static final Logger logger = CoreUIObject.getLogger(AddDynaItemUI.class);
    protected int COL_ID = 0;
    protected int COL_ITEM_NUMBER = 1;
    protected int COL_ITEM_NAME = 2;
    protected int COL_DATAELEMENT = 3;
    protected int COL_VALUETYPE = 4;
    protected int COL_YEAR = 5;
    protected int COL_PERIOD = 6;
    private ArrayList preDynaHeadItemList = null;
    private ArrayList dynaHeadItemList = null;
    RPTItemCollection rptItemCL = null;
    private Set<String> selectedItems = new HashSet<String>();

    public AddDynaItemUI() throws Exception {
        this.initControl();
    }

    private void initControl() {
        this.kbtnSelectOne.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.kbtnSelectOne.setText(null);
        this.kbtnUnSelectOne.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.kbtnUnSelectOne.setText(null);
        this.kbtnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.kbtnSelectAll.setText(null);
        this.kbtnUnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.kbtnUnSelectAll.setText(null);
        this.kDTRptItem.getSelectManager().setSelectMode(2);
        this.kDTDynaItem.getSelectManager().setSelectMode(2);
        this.kDTDynaItem.checkParsed();
        this.kDTDynaItem.getColumn("year").getStyleAttributes().setHided(true);
        this.kDTDynaItem.getColumn("period").getStyleAttributes().setHided(true);
        SpinnerNumberModel yearModel = new SpinnerNumberModel(0, -500, 5000, 1);
        SpinnerNumberModel periodModel = new SpinnerNumberModel(0, -4000, 400, 1);
    }

    public void onLoad() throws Exception {
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.initParament();
        this.initControlData();
        this.loadDynaItem();
        this.loadRptItem();
        this.addListioner();
    }

    private void initParament() {
        this.preDynaHeadItemList = (ArrayList)this.getUIContext().get("DynaHeadItemList");
        this.dynaHeadItemList = (ArrayList)this.preDynaHeadItemList.clone();
    }

    private void loadDynaItem() {
        this.bindingDynaItemListToTable(this.dynaHeadItemList, this.kDTDynaItem);
    }

    private void addListioner() {
        this.kDCReportClass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    AddDynaItemUI.this.loadRptItem();
                }
                catch (Exception exp) {
                    AddDynaItemUI.this.handUIException(exp);
                }
            }
        });
    }

    private void initControlData() throws Exception {
        CslClientHelper.initDataElementCombox((KDComboBox)this.kDCDataElem, (boolean)false, (boolean)true, (boolean)false);
        EntityViewInfo viewInfo = new EntityViewInfo();
        CslGradeManageUtil.filterRptItemTypeGradeManage((EntityViewInfo)viewInfo, null);
        SorterItemCollection sorterItems = new SorterItemCollection();
        SorterItemInfo numberSorter = new SorterItemInfo("number");
        numberSorter.setSortType(SortType.ASCEND);
        sorterItems.add(numberSorter);
        viewInfo.setSorter(sorterItems);
        CoreBaseCollection reportClassCL = ReportClassFactory.getRemoteInstance().getCollection(viewInfo);
        if (reportClassCL != null && reportClassCL.size() > 0) {
            int j = reportClassCL.size();
            for (int i = 0; i < j; ++i) {
                this.kDCReportClass.addItem((Object)reportClassCL.getObject(i));
            }
        }
        this.kDCReportClass.addItem((Object)"");
    }

    private void loadRptItem() throws BOSException {
        IRPTItem iRptItem = RPTItemFactory.getRemoteInstance();
        RptItemQuery itemQuery = new RptItemQuery();
        itemQuery.setQueryReportClass(true);
        itemQuery.setIncludeFreezed(false);
        if (this.kDCReportClass.getSelectedItem().equals("")) {
            itemQuery.setFilterReportClassID("");
        } else {
            ReportClassInfo reportClass = (ReportClassInfo)this.kDCReportClass.getSelectedItem();
            itemQuery.setFilterReportClassID(reportClass.getId().toString());
        }
        this.rptItemCL = iRptItem.getCollectionNoChild(itemQuery);
        this.bindingRPTItemListToTable(this.rptItemCL, this.kDTRptItem);
    }

    private void bindingRPTItemListToTable(RPTItemCollection rptArr, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        table.getSelectManager().setSelectMode(10);
        int count = rptArr == null ? 0 : rptArr.size();
        RPTItemInfo rpt = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            rpt = rptArr.get(i);
            r = table.addRow();
            r.getCell(0).setValue((Object)rpt.getId());
            r.getCell(1).setValue((Object)rpt);
            r.getCell(2).setValue((Object)rpt.getName());
        }
    }

    private void bindingDynaItemListToTable(ArrayList dynaItemList, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        table.getSelectManager().setSelectMode(10);
        int count = dynaItemList.size();
        DynaHeadItem dyna = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            dyna = (DynaHeadItem)dynaItemList.get(i);
            if (!this.moveSelectedItems(dyna, true)) continue;
            r = table.addRow();
            this.bindInfoToRow(dyna, r);
        }
    }

    private void bindingDynaItemListFromTable(ArrayList dynaItemList, KDTable table) {
        int count = table.getRowCount();
        dynaItemList.clear();
        DynaHeadItem dyna = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            dyna = new DynaHeadItem();
            r = table.getRow(i);
            this.bindInfoFromRow(dyna, r);
            dynaItemList.add(i, dyna);
        }
    }

    private void bindInfoToRow(DynaHeadItem dyna, IRow iRow) {
        iRow.getCell(this.COL_ITEM_NUMBER).setValue((Object)dyna.rptItem.getNumber());
        iRow.getCell(this.COL_ITEM_NUMBER).setUserObject((Object)dyna.rptItem);
        iRow.getCell(this.COL_ITEM_NAME).setValue((Object)dyna.rptItem.getName());
        iRow.getCell(this.COL_DATAELEMENT).setValue((Object)dyna.dataElement.getName());
        iRow.getCell(this.COL_DATAELEMENT).setUserObject((Object)dyna.dataElement);
        iRow.getCell(this.COL_VALUETYPE).setValue((Object)dyna.valueType);
    }

    private void bindInfoFromRow(DynaHeadItem dyna, IRow iRow) {
        dyna.rptItem = (RPTItemInfo)iRow.getCell(this.COL_ITEM_NUMBER).getUserObject();
        dyna.dataElement = (DataElementInfo)iRow.getCell(this.COL_DATAELEMENT).getUserObject();
        dyna.valueType = (ValueTypeEnum)iRow.getCell(this.COL_VALUETYPE).getValue();
        dyna.year = 0;
        dyna.period = 0;
    }

    private DynaHeadItem createNewDynaItem(RPTItemInfo rptItem) {
        DynaHeadItem dynaItem = new DynaHeadItem();
        dynaItem.rptItem = rptItem;
        dynaItem.dataElement = (DataElementInfo)this.kDCDataElem.getSelectedItem();
        dynaItem.valueType = (ValueTypeEnum)this.kDCValueType.getSelectedItem();
        dynaItem.year = 0;
        dynaItem.period = 0;
        return dynaItem;
    }

    @Override
    protected void kbtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.destroyWindow();
    }

    @Override
    protected void kbtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnConfirm_actionPerformed(e);
        this.bindingDynaItemListFromTable(this.dynaHeadItemList, this.kDTDynaItem);
        if (DynaHeadItem.checkDuplicate(this.dynaHeadItemList)) {
            MsgBox.showWarning((String)CslRptUtil.getString((String)"AddDynaItemDupItem"));
            SysUtil.abort();
        }
        this.preDynaHeadItemList.clear();
        for (DynaHeadItem element : this.dynaHeadItemList) {
            this.preDynaHeadItemList.add(element);
        }
        this.getUIWindow().close();
        this.destroyWindow();
    }

    @Override
    protected void kbtnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnSelectAll_actionPerformed(e);
        this.kDTDynaItem.removeRows();
        for (RPTItemInfo rptItem : this.rptItemCL) {
            DynaHeadItem dynaItem = this.createNewDynaItem(rptItem);
            if (!this.moveSelectedItems(dynaItem, true)) continue;
            IRow iRow = this.kDTDynaItem.addRow();
            this.bindInfoToRow(dynaItem, iRow);
        }
    }

    @Override
    protected void kbtnSelectOne_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnSelectOne_actionPerformed(e);
        this.checkSelected(this.kDTRptItem);
        ArrayList list = this.getSelectedRows(this.kDTRptItem);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            int index = (Integer)iter.next();
            RPTItemInfo rptItem = (RPTItemInfo)this.kDTRptItem.getRow(index).getCell(this.COL_ITEM_NUMBER).getValue();
            DynaHeadItem dynaItem = this.createNewDynaItem(rptItem);
            if (!this.moveSelectedItems(dynaItem, true)) continue;
            IRow iRow = this.kDTDynaItem.addRow();
            this.bindInfoToRow(dynaItem, iRow);
        }
    }

    @Override
    protected void kbtnUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnUnSelectAll_actionPerformed(e);
        this.kDTDynaItem.removeRows();
        this.selectedItems.clear();
    }

    @Override
    protected void kbtnUnSelectOne_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnUnSelectOne_actionPerformed(e);
        this.checkSelected(this.kDTDynaItem);
        ArrayList list = this.getSelectedRows(this.kDTDynaItem);
        Object[] index = list.toArray();
        Arrays.sort(index);
        IRow row = null;
        for (int i = index.length; i > 0; --i) {
            row = this.kDTDynaItem.getRow(((Integer)index[i - 1]).intValue());
            this.moveSelectedItems(row.getCell("itemNumber").getValue().toString(), ((DataElementInfo)row.getCell("dataElement").getUserObject()).getNumber(), ((ValueTypeEnum)row.getCell("valueType").getValue()).getValue(), false);
            this.kDTDynaItem.removeRow(((Integer)index[i - 1]).intValue());
        }
    }

    public void checkSelected(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected ArrayList getSelectedRows(KDTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = table.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                Integer tempIndex = new Integer(j);
                if (list.contains(tempIndex)) continue;
                list.add(tempIndex);
            }
        }
        return list;
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        IRow[] rows = this.getTableSelection(this.kDTDynaItem);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[0].getRowIndex() == 0) {
                return;
            }
        } else {
            return;
        }
        this.kDTDynaItem.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            int r = rows[i].getRowIndex();
            if (r == 0) break;
            moved = true;
            this.kDTDynaItem.removeRow(r);
            this.kDTDynaItem.addRow(r - 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.kDTDynaItem);
            sel.setTop(r - 1);
            sel.setBottom(r - 1);
            sel.setMode(2);
            this.kDTDynaItem.getSelectManager().add(sel);
        }
        if (moved) {
            this.kDTDynaItem.setRefresh(true);
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        int r;
        int rowcount = this.kDTDynaItem.getRowCount();
        IRow[] rows = this.getTableSelection(this.kDTDynaItem);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[rows.length - 1].getRowIndex() == rowcount - 1) {
                return;
            }
        } else {
            return;
        }
        this.kDTDynaItem.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = rows.length - 1; i >= 0 && (r = (row = rows[i]).getRowIndex()) != rowcount - 1; --i) {
            moved = true;
            this.kDTDynaItem.removeRow(r);
            this.kDTDynaItem.addRow(r + 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.kDTDynaItem);
            sel.setTop(r + 1);
            sel.setBottom(r + 1);
            sel.setMode(2);
            this.kDTDynaItem.getSelectManager().add(sel);
        }
        if (moved) {
            this.kDTDynaItem.setRefresh(true);
        }
    }

    protected IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            for (int row = block.getBeginRow(); row <= block.getEndRow(); ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.kdLocateText.getText())) {
            int index1 = this.kDTRptItem.getColumnIndex("itemNumber");
            int index2 = this.kDTRptItem.getColumnIndex("itemName");
            CslRptUIUtil.tableMainLocate((KDTable)this.kDTRptItem, (String)this.kdLocateText.getText(), (int[])new int[]{index1, index2});
        }
    }

    private boolean moveSelectedItems(DynaHeadItem dyna, boolean isToRight) {
        return this.moveSelectedItems(dyna.getRptItem().getNumber(), dyna.getDataElement().getNumber(), dyna.getValueType().getValue(), isToRight);
    }

    private boolean moveSelectedItems(String itemNumber, String dataElementNumber, int valueType, boolean isToRight) {
        StringBuffer key = new StringBuffer();
        key.append(itemNumber).append(dataElementNumber).append(valueType);
        if (isToRight) {
            if (this.selectedItems.contains(key.toString())) {
                return false;
            }
            this.selectedItems.add(key.toString());
        } else {
            this.selectedItems.remove(key.toString());
        }
        return true;
    }

    class RowIdxComparer
    implements Comparator {
        RowIdxComparer() {
        }

        public int compare(Object row1, Object row2) {
            return ((IRow)row1).getRowIndex() - ((IRow)row2).getRowIndex();
        }
    }
}

