/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgTypeForEntityEnum;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractDynaItemWizardUI;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import com.kingdee.eas.fi.gr.dynamic.fill.DynaItemBeforeFill;
import com.kingdee.eas.fi.gr.dynamic.fill.GradeFillDynaItem;
import com.kingdee.eas.fi.gr.dynamic.fill.IFillDynaItem;
import com.kingdee.eas.fi.gr.dynamic.fill.NormalFillDynaItem;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateCoverUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class DynaItemWizardUI
extends AbstractDynaItemWizardUI {
    private static final long serialVersionUID = -2442882514970969546L;
    private static final Logger logger = CoreUIObject.getLogger(DynaItemWizardUI.class);
    private Sheet curSheet = null;
    private Sheet oldSheet = null;
    private List listAllItem = null;
    private List listSelectedItem = null;
    private DynaParameters param;
    private AsstActTypeUtils assistantType;
    private boolean isAutoExe;
    public boolean isReport = false;
    private Point activePoint = null;
    private OrgTypeForEntityEnum currentOrgType = OrgTypeForEntityEnum.NULL;
    private AsstActTypeInfo asstActTypeInfo;
    private Map itemsMap = new HashMap();
    private Map selectItemMap = new HashMap();
    private String curView = "0";
    private String rptDataCollectNumber = "ACTUALDATA";
    private static int AUTOFILL_ITEM_SIZE = 10000;
    private static final String AUTOFILL_ITEM_NUMBER = "KEY_CSLPARAM_AUTOFILL_ITEM_NUMBER";
    private boolean paramIsTrue = true;
    private boolean isIncludeFreezedParam = false;
    private int autoFillItemSize = 0;
    private DynaItemBeforeFill dynaItemBeforeFill;
    private IFillDynaItem fillDynaItem;
    private OrgUnitInfo company = null;

    public void onLoad() throws Exception {
        super.onLoad();
        CtrlUnitInfo cu = null;
        if (this.getUIContext().get("Company") != null) {
            this.company = (OrgUnitInfo)this.getUIContext().get("Company");
            cu = this.company == null || this.company.getCU() == null ? SysContext.getSysContext().getCurrentCtrlUnit() : this.company.getCU();
        } else {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
            cu = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.paramIsTrue = RptUtil.isTrue((Object)ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(cu.getId()), (String)"fi_rp_004"));
        this.isIncludeFreezedParam = RptUtil.isTrue((Object)ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(cu.getId()), (String)"GR_CSL_IsIncludeFreezedbyAsstAct"));
        this.curSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        boolean isIncludeOtherDC = false;
        if (this.getUIContext().containsKey("editData")) {
            Object object = this.getUIContext().get("editData");
            if (object instanceof TemplateInfo) {
                isIncludeOtherDC = ((TemplateInfo)object).isIncludeOtherDC();
                if (this.getUIContext().containsKey("curView")) {
                    this.curView = (String)this.getUIContext().get("curView");
                }
            } else {
                this.isReport = true;
                if (object instanceof ReportInfo) {
                    this.rptDataCollectNumber = ((ReportInfo)object).getDataCollectNumber();
                } else if (object instanceof CslReportInfo) {
                    this.rptDataCollectNumber = ((CslReportInfo)object).getDataCollectNumber();
                }
            }
        }
        if (this.getUIContext().get("autoExe") != null && ((Boolean)this.getUIContext().get("autoExe")).booleanValue()) {
            this.isAutoExe = true;
            this.activePoint = (Point)this.getUIContext().get("Active_Point");
            this.cbxCoverRecord.setSelected(true);
        } else {
            this.isAutoExe = false;
            this.activePoint = new Point(this.curSheet.getActiveCol(), this.curSheet.getActiveRow());
        }
        this.tblAllItem.getSelectManager().setSelectMode(2);
        this.tblSelectedItem.getSelectManager().setSelectMode(2);
        this.dynaItemBeforeFill = new DynaItemBeforeFill(this.paramIsTrue, this.curSheet, this.isReport, this.activePoint, this.isAutoExe, this.company, null);
        this.param = this.dynaItemBeforeFill.getParam();
        this.dynaItemBeforeFill.setReportPropertyAdapter((IReportPropertyAdapter)this.getUIContext().get("ReportPropertyAdapter"));
        this.fillDynaItem = this.param.getDynaItemSource() == 0 && this.param.isGrade() ? new GradeFillDynaItem(this.dynaItemBeforeFill) : new NormalFillDynaItem(this.dynaItemBeforeFill, isIncludeOtherDC, this.curView, this.rptDataCollectNumber);
        if (this.isAutoExe) {
            boolean isListener = DynaItemListener.getisListener();
            DynaItemListener.setListener(false);
            this.disposeUIWindow();
            this.autoFill();
            DynaItemListener.setListener(isListener);
        } else {
            this.autoFillItemSize = DynaItemWizardUI.getAutoFillItemNUmberParam(AUTOFILL_ITEM_NUMBER);
            boolean b = this.loadData();
            if (!b) {
                return;
            }
        }
        this.checkIncludeFreezed.setSelected(false);
        this.checkIncludeFreezed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DynaItemWizardUI.this.loadData();
                }
                catch (Exception e1) {
                    logger.error((Object)"actionSearch", (Throwable)e1);
                }
            }
        });
    }

    private List getListAllItem() {
        if (this.listAllItem == null) {
            this.listAllItem = new ArrayList();
        }
        return this.listAllItem;
    }

    private List getListSelectedItem() {
        if (this.listSelectedItem == null) {
            this.listSelectedItem = new ArrayList();
        }
        return this.listSelectedItem;
    }

    private void autoFill() throws Exception {
        this.assistantType = this.dynaItemBeforeFill.getAssistantType();
        if (this.assistantType == null) {
            return;
        }
        this.asstActTypeInfo = this.dynaItemBeforeFill.getAsstActTypeInfo();
        if (this.asstActTypeInfo == null) {
            return;
        }
        this.cmbOrgView.setVisible(false);
        this.cbxAssistant.setVisible(false);
        String cacheKey = this.buildCacheKeyValue();
        Object curfillData = this.itemsMap.get(cacheKey);
        boolean isOnlyFillHavingDataItem = CslRptUtil.getCslParam(null, (String)"IsOnlyFillHavingDataItem");
        if (this.isAutoExe && curfillData != null && !((List)curfillData).isEmpty() && !isOnlyFillHavingDataItem) {
            this.fill((ArrayList)curfillData);
        } else {
            IMetaDataPK queryPK = this.dynaItemBeforeFill.getQueryPK(false, this.isIncludeFreezedParam);
            IQueryExecutor exec = this.dynaItemBeforeFill.getQueryExecutor(queryPK, OrgTypeForEntityEnum.NULL, this.isIncludeFreezedParam);
            this.setAssitantSubTypeFilterForByParam(exec);
            List fillData = this.dynaItemBeforeFill.getFillData(exec, queryPK);
            ArrayList copyData = null;
            if (fillData != null && !fillData.isEmpty()) {
                copyData = new ArrayList(fillData.size());
                copyData.addAll(fillData);
            }
            this.fill(fillData);
            this.itemsMap.put(cacheKey, copyData);
        }
    }

    private void setAssitantSubTypeFilterForByParam(IQueryExecutor exec) {
        if (this.param.isGrade() && this.param.getDynaItemSource() == 0) {
            this.setAssistantSubTypeFilterForGradeSum(exec);
        } else if (this.param.getDynaItemSource() != 0) {
            this.setAssistantSubTypeFilterForFillGard(exec);
        }
    }

    private String buildCacheKeyValue() {
        String asstHGAttribute = this.asstActTypeInfo.getAsstHGAttribute();
        if (this.param.isGrade() && this.param.getDynaItemSource() == 0 && this.dynaItemBeforeFill != null && this.dynaItemBeforeFill.getGradeEntryInfo() != null && this.dynaItemBeforeFill.getGradeEntryInfo().getDetailSource() != 0 && DynamicTemplateUtility.isBaseAsstActType(asstHGAttribute)) {
            return asstHGAttribute + this.dynaItemBeforeFill.getGradeEntryInfo().getAsstActSubTypeString();
        }
        return asstHGAttribute + this.param.getAssistantTypeSubType();
    }

    private void setAssistantSubTypeFilterForGradeSum(IQueryExecutor exec) {
        String asstHGAttribute;
        if (this.dynaItemBeforeFill != null && this.dynaItemBeforeFill.getGradeEntryInfo() != null && this.dynaItemBeforeFill.getGradeEntryInfo().getDetailSource() != 0 && DynamicTemplateUtility.isBaseAsstActType(asstHGAttribute = this.dynaItemBeforeFill.getAsstActTypeInfo().getAsstHGAttribute())) {
            String groups = this.dynaItemBeforeFill.getGradeEntryInfo().getAsstActSubTypeString();
            this.setFilterByNumber(exec, asstHGAttribute, groups);
        }
    }

    private void autoRCFill() throws Exception {
        this.assistantType = this.dynaItemBeforeFill.getAssistantType();
        if (this.assistantType == null) {
            return;
        }
        this.asstActTypeInfo = this.dynaItemBeforeFill.getAsstActTypeInfo();
        if (this.asstActTypeInfo == null) {
            return;
        }
        this.cmbOrgView.setVisible(false);
        this.cbxAssistant.setVisible(false);
        List<AsstActObject> oldFillData = this.getDataByNum(this.oldSheet, this.activePoint);
        ArrayList newBPointList = DynamicTemplateUtility.getBasePointList(this.curSheet);
        Point newBasePoint = DynamicTemplateCoverUtil.findBasePoint(this.curSheet, this.oldSheet, newBPointList, this.activePoint);
        List<AsstActObject> newTblItemData = this.getDataByNum(this.curSheet, newBasePoint);
        if (oldFillData != null && newTblItemData != null) {
            this.removeSamItemData(oldFillData, newTblItemData);
        }
        this.fill(oldFillData, true);
    }

    private void removeSamItemData(List<AsstActObject> oldFillData, List<AsstActObject> newTblItemData) {
        for (int i = oldFillData.size() - 1; i >= 0; --i) {
            AsstActObject oldAsst = oldFillData.get(i);
            for (int j = newTblItemData.size() - 1; j >= 0; --j) {
                AsstActObject newAsst = newTblItemData.get(j);
                if (!oldAsst.getLongNumber().equals(newAsst.getLongNumber())) continue;
                oldFillData.remove(i);
                newTblItemData.remove(i);
            }
        }
    }

    private List<AsstActObject> getDataByNum(Sheet sheet, Point basePoint) {
        boolean isHorizon;
        if (basePoint == null) {
            return null;
        }
        ArrayList<AsstActObject> fillDataList = new ArrayList<AsstActObject>();
        DynaParameters parameters = DynamicTemplateUtility.getDynaParametersFromCell(sheet, basePoint.y, basePoint.x);
        boolean bl = isHorizon = parameters.getSpreadStyle() == 1;
        if (parameters == null || parameters.getDefaultCounter() == 0) {
            return null;
        }
        int actRowCount = parameters.getDefaultCounter();
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(parameters, basePoint, sheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        for (int j = 1; j <= actRowCount; ++j) {
            ItemFormula itemNumber;
            Cell cell = null;
            Range firstCol = null;
            int temPosion = j;
            temPosion += boforeSumFormulaCount;
            if (isHorizon) {
                cell = sheet.getCell(basePoint.y + 1, basePoint.x + temPosion, false);
                firstCol = sheet.getRange(basePoint.y, basePoint.x + temPosion);
            } else {
                cell = sheet.getCell(basePoint.y + temPosion, basePoint.x + 1, false);
                firstCol = sheet.getRange(basePoint.y + temPosion, basePoint.x);
            }
            if (cell == null || (itemNumber = NewRptUtil.getItemFormula((Cell)cell, (Point)basePoint)) == null || itemNumber.getDItemNumber() == null) continue;
            String number = this.getNumber(itemNumber.getDItemNumber());
            AsstActObject acctAct = new AsstActObject("", number, itemNumber.getDItemNumber(), firstCol.getValue().getValue().toString(), false, false);
            fillDataList.add(acctAct);
        }
        return fillDataList;
    }

    private String getNumber(String dItemNumber) {
        int index = dItemNumber.lastIndexOf("!");
        if (index == -1) {
            return dItemNumber;
        }
        String number = dItemNumber.substring(index + 1, dItemNumber.length());
        return number;
    }

    public void initReportCover() throws Exception {
        super.onLoad();
        this.initialParam();
        boolean isListener = DynaItemListener.getisListener();
        DynaItemListener.setListener(false);
        this.disposeUIWindow();
        this.autoRCFill();
        DynaItemListener.setListener(isListener);
    }

    private void initialParam() throws Exception {
        CtrlUnitInfo cu = null;
        if (this.getUIContext().get("Company") != null) {
            this.company = (OrgUnitInfo)this.getUIContext().get("Company");
            cu = this.company == null || this.company.getCU() == null ? SysContext.getSysContext().getCurrentCtrlUnit() : this.company.getCU();
        } else {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
            cu = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.paramIsTrue = RptUtil.isTrue((Object)ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(cu.getId()), (String)"fi_rp_004"));
        this.curSheet = (Sheet)this.getUIContext().get("tempTable");
        this.oldSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        boolean isIncludeOtherDC = false;
        if (this.getUIContext().containsKey("editData")) {
            Object object = this.getUIContext().get("editData");
            if (object instanceof TemplateInfo) {
                isIncludeOtherDC = ((TemplateInfo)object).isIncludeOtherDC();
                if (this.getUIContext().containsKey("curView")) {
                    this.curView = (String)this.getUIContext().get("curView");
                }
            } else {
                this.isReport = true;
                if (object instanceof ReportInfo) {
                    this.rptDataCollectNumber = ((ReportInfo)object).getDataCollectNumber();
                } else if (object instanceof CslReportInfo) {
                    this.rptDataCollectNumber = ((CslReportInfo)object).getDataCollectNumber();
                }
            }
        }
        this.activePoint = (Point)this.getUIContext().get("Active_Point");
        this.tblAllItem.getSelectManager().setSelectMode(2);
        this.tblSelectedItem.getSelectManager().setSelectMode(2);
        this.dynaItemBeforeFill = new DynaItemBeforeFill(this.paramIsTrue, this.curSheet, this.oldSheet, this.isReport, this.activePoint, this.isAutoExe, this.company, null);
        this.param = this.dynaItemBeforeFill.getParam();
        if (this.param == null) {
            return;
        }
        this.dynaItemBeforeFill.setReportPropertyAdapter((IReportPropertyAdapter)this.getUIContext().get("ReportPropertyAdapter"));
        if (this.param.getDynaItemSource() == 0 && this.param.isGrade()) {
            this.fillDynaItem = new GradeFillDynaItem(this.dynaItemBeforeFill);
        } else {
            this.dynaItemBeforeFill.setRptCover(true);
            this.fillDynaItem = new NormalFillDynaItem(this.dynaItemBeforeFill, isIncludeOtherDC, this.curView, this.rptDataCollectNumber);
        }
    }

    private void fill(List curfillData) throws Exception {
        this.fill(curfillData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill(List fillData, Boolean isRptCover) throws Exception {
        int j;
        AsstActObject ditemInfo;
        if (fillData == null || fillData.isEmpty()) {
            return;
        }
        if (!(isRptCover.booleanValue() || !"costOrg".equals(this.asstActTypeInfo.getAsstHGAttribute()) || this.param.getDynaItemSource() == 1 && this.param.isGrade())) {
            ArrayList<AsstActObject> l = new ArrayList<AsstActObject>();
            ditemInfo = null;
            for (j = 0; j < fillData.size(); ++j) {
                ditemInfo = (AsstActObject)fillData.get(j);
                if (!ditemInfo.isBizUnit()) continue;
                l.add(ditemInfo);
            }
            fillData.clear();
            fillData.addAll(l);
        }
        if (!(isRptCover.booleanValue() || !this.asstActTypeInfo.isIsMultilevel() || this.param.getDynaItemSource() == 1 && this.param.isGrade())) {
            ArrayList<AsstActObject> newList = new ArrayList<AsstActObject>();
            ditemInfo = null;
            for (j = 0; j < fillData.size(); ++j) {
                ditemInfo = (AsstActObject)fillData.get(j);
                if (ditemInfo.isSelfAsstActaiatem() && CslRptUtil.isLeaf((List)fillData, (AsstActObject)ditemInfo)) {
                    ditemInfo.setLeaf(true);
                }
                if (!ditemInfo.isLeaf()) continue;
                newList.add(ditemInfo);
            }
            fillData.clear();
            fillData.addAll(newList);
        }
        Map tempStyle = null;
        Point basePoint = new Point(this.dynaItemBeforeFill.getLeft(), this.dynaItemBeforeFill.getTop());
        tempStyle = new HashMap();
        tempStyle = DynamicTemplateUtility.getCurBasePointFirstLineStyle(tempStyle, this.curSheet, basePoint);
        boolean autoCalculate = this.curSheet.getBook().isAutoCalculate();
        this.curSheet.getBook().setCalculate(false);
        boolean isListener = DynaItemListener.getisListener();
        try {
            this.curSheet.getBook().getUndoManager().enable(false);
            this.curSheet.getBook().getUndoManager().startGroup();
            DynaItemListener.setListener(false);
            this.fillDynaItem.setFillData(fillData);
            this.fillDynaItem.setCoverRecord(this.cbxCoverRecord.isSelected());
            this.fillDynaItem.prepare();
            this.fillDynaItem.fill();
            if (tempStyle == null) {
                return;
            }
            DynamicTemplateUtility.setCurBasePointFirstLineStyle(tempStyle, this.curSheet, basePoint);
            if (this.cbxCoverRecord.isSelected()) {
                DynamicTemplateUtility.reAdjustSheetCurBasePointAlign(basePoint, this.curSheet);
            } else {
                int existRow = this.param.getDefaultCounter() - this.fillDynaItem.getAppendSize() - 1;
                if (existRow < 0) {
                    existRow = 0;
                }
                DynamicTemplateUtility.reAdjustSheetCurBasePointAlign(basePoint, this.curSheet, existRow);
            }
            tempStyle = null;
        }
        finally {
            DynaItemListener.setListener(isListener);
            this.curSheet.getBook().getUndoManager().enable(true);
            this.curSheet.getBook().getUndoManager().endGroup();
            this.curSheet.getBook().setCalculate(autoCalculate);
            if (!this.isAutoExe && autoCalculate) {
                this.curSheet.getBook().calc();
                this.curSheet.getBook().setActiveSheet(this.curSheet);
            }
            if (this.getUIContext().get("spreadContext") != null) {
                ((SpreadContext)this.getUIContext().get("spreadContext")).clearQueue();
            }
        }
    }

    private boolean loadData() throws EASBizException, BOSException {
        try {
            for (int i = 0; i < this.tblSelectedItem.getRowCount(); ++i) {
                this.selectItemMap.put(this.tblSelectedItem.getRow(i).getCell(2).getValue(), null);
            }
            int dynaItemSource = this.dynaItemBeforeFill.getParam().getDynaItemSource();
            if (dynaItemSource == 0 && !this.dynaItemBeforeFill.getParam().isGrade() && !this.isAutoExe) {
                this.destroyWindow();
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Manual_NotUseWizard")));
            }
            AsstActTypeUtils asstActTypeUtils = this.assistantType = this.dynaItemBeforeFill.getAssistantType() == null ? this.dynaItemBeforeFill.getParam().getAssistantType() : this.dynaItemBeforeFill.getAssistantType();
            if (this.assistantType == null) {
                if (!this.isAutoExe) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Manual_NotUseWizard")));
                }
                boolean bl = false;
                return bl;
            }
            this.lblItem.setText(this.getAssistantType().properityAlias);
            this.asstActTypeInfo = this.dynaItemBeforeFill.getAsstActTypeInfo();
            if (this.asstActTypeInfo == null) {
                boolean bl = false;
                return bl;
            }
            this.cmbOrgView.setVisible(false);
            this.cbxAssistant.setVisible(false);
            if ("companyOrg".equals(this.asstActTypeInfo.getAsstHGAttribute())) {
                this.initCmbOrgView();
            }
            this.loadTblAllItem();
        }
        finally {
            this.selectItemMap.clear();
        }
        return true;
    }

    private void loadTblAllItem() throws EASBizException, BOSException {
        String mappingFieldName = this.asstActTypeInfo.getAsstHGAttribute();
        boolean isShowAssistant = false;
        if ("companyOrg".equals(mappingFieldName)) {
            this.cmbOrgView.setVisible(true);
            this.cbxAssistant.setVisible(true);
            if (this.cbxAssistant.isSelected()) {
                isShowAssistant = true;
            }
        } else {
            this.cmbOrgView.setVisible(false);
            this.cbxAssistant.setVisible(false);
        }
        IMetaDataPK queryPK = this.dynaItemBeforeFill.getQueryPK(isShowAssistant, this.isIncludeFreezedParam);
        boolean isIncludeFreezed = this.checkIncludeFreezed.isSelected();
        IQueryExecutor exec = this.dynaItemBeforeFill.getQueryExecutor(queryPK, this.currentOrgType, this.isIncludeFreezedParam && isIncludeFreezed);
        this.setAssitantSubTypeFilterForByParam(exec);
        int rowCount = exec.getRowCount();
        if (rowCount > this.autoFillItemSize) {
            this.lab.setVisible(true);
            this.tblAllItem.removeRows();
            return;
        }
        this.lab.setVisible(false);
        try {
            this.listAllItem = this.dynaItemBeforeFill.getFillData(exec, queryPK);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.tblAllItem.removeRows();
        this.addArrayListToTable(this.getListAllItem(), this.tblAllItem);
    }

    private void setAssistantSubTypeFilterForFillGard(IQueryExecutor exec) {
        String asstHGAttribute;
        if (this.param.getDynaItemSource() != 0 && DynamicTemplateUtility.isBaseAsstActType(asstHGAttribute = this.param.getAssistantType().getAsstHGAttribute()) && this.param != null && this.param.getAssistantTypeSubType() != null) {
            String groups = this.param.getAssistantTypeSubType();
            this.setFilterByNumber(exec, asstHGAttribute, groups);
        }
    }

    private void setFilterByNumber(IQueryExecutor exec, String asstHGAttribute, String groups) {
        EntityViewInfo viewInfo = exec.getObjectView();
        try {
            FilterInfo filter = this.dynaItemBeforeFill.getAssistantSubTypeFilterByNumber(asstHGAttribute, groups, true);
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(new FilterInfo());
            }
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private SelectorItemCollection getSelectorItemCollection(String mappingFieldName) throws Exception {
        return this.dynaItemBeforeFill.getSelectorItemCollection(mappingFieldName);
    }

    private void initCmbOrgView() throws BOSException {
        this.cbxAssistant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DynaItemWizardUI.this.cbxAssistant.getSelected() == 32 || DynaItemWizardUI.this.cbxAssistant.getSelected() == 16) {
                    try {
                        DynaItemWizardUI.this.loadTblAllItem();
                    }
                    catch (Exception e1) {
                        DynaItemWizardUI.this.handleException(e1);
                    }
                }
            }
        });
        this.cmbOrgView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OrgTypeForEntityEnum orgType = (OrgTypeForEntityEnum)DynaItemWizardUI.this.cmbOrgView.getSelectedItem();
                    try {
                        DynaItemWizardUI.this.currentOrgType = orgType;
                        if (orgType.getValue() == 0 || orgType.getValue() == 1) {
                            DynaItemWizardUI.this.cbxAssistant.setEnabled(true);
                            DynaItemWizardUI.this.cbxAssistant.setSelected(false);
                        } else {
                            DynaItemWizardUI.this.cbxAssistant.setEnabled(false);
                            DynaItemWizardUI.this.cbxAssistant.setSelected(false);
                        }
                        DynaItemWizardUI.this.loadTblAllItem();
                    }
                    catch (Exception e1) {
                        DynaItemWizardUI.this.handleException(e1);
                    }
                }
            }
        });
        DefaultComboBoxModel<OrgTypeForEntityEnum> model = new DefaultComboBoxModel<OrgTypeForEntityEnum>();
        Iterator iter = OrgTypeForEntityEnum.iterator();
        while (iter.hasNext()) {
            OrgTypeForEntityEnum orgType = (OrgTypeForEntityEnum)iter.next();
            model.addElement(orgType);
        }
        this.cmbOrgView.setModel(model);
        this.cmbOrgView.setSelectedIndex(0);
        this.cmbOrgView.setEditable(false);
    }

    private void addArrayToList(Object[] objects, AsstActTypeInfo info) throws EASBizException, BOSException {
        this.listAllItem = this.dynaItemBeforeFill.getFillData(objects, info, this.getListSelectedItem());
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        ProgressDialogNew progressDialog = null;
        CoreUI owner = (CoreUI)this.getUIContext().get("Owner");
        this.disposeUIWindow();
        if (owner == null) {
            this.fill(this.getListSelectedItem());
            return;
        }
        progressDialog = ProgressDialogHelper.createProgressDialogNew((CoreUI)owner, (boolean)true);
        progressDialog.setWindowMsgTitle(CslRptUtil.getString((String)"773_fillDone"));
        String str = owner.getUITitle();
        if (str != null) {
            str = str.substring(str.indexOf("-") + 1, str.length());
        }
        progressDialog.setMsg("");
        progressDialog.setUiTitle(str + CslRptUtil.getString((String)"774_fillDone2"));
        String companyNumber = SysContext.getSysContext().getCurrentOrgUnit().getNumber();
        progressDialog.setCompanyNumber(companyNumber);
        progressDialog.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(CslRptUtil.getString((String)"771_dyitemFill"), -1);
                    monitor.subTaskBegin(CslRptUtil.getString((String)"772_fill"));
                    DynaItemWizardUI.this.fill(DynaItemWizardUI.this.getListSelectedItem());
                    monitor.subTaskBegin(CslRptUtil.getString((String)"773_fillDone"));
                }
                catch (Exception e) {
                    logger.error((Object)"dynamic report fill error.", (Throwable)e);
                    monitor.done();
                }
                finally {
                    monitor.done();
                }
            }
        }, progressDialog);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        int index = this.tblAllItem.getLayoutManager().getVertical(1).getLast();
        super.actionAdd_actionPerformed(e);
        ArrayList items = this.getSelectedItemsFromTable(this.tblAllItem);
        CslRptUtil.addArrayListToArrayList((ArrayList)((ArrayList)this.getListSelectedItem()), (ArrayList)items);
        Collections.sort(this.getListSelectedItem());
        this.addArrayListToTable(this.getListSelectedItem(), this.tblSelectedItem);
        Collections.sort(this.getListAllItem());
        this.addArrayListToTable(this.getListAllItem(), this.tblAllItem);
        try {
            this.tblAllItem.scrollToVisible(index - 1, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionReduce_actionPerformed(ActionEvent e) throws Exception {
        super.actionReduce_actionPerformed(e);
        ArrayList items = this.getSelectedItemsFromTable(this.tblSelectedItem);
        CslRptUtil.addArrayListToArrayList((ArrayList)((ArrayList)this.getListAllItem()), (ArrayList)items);
        this.addArrayListToTable(this.getListSelectedItem(), this.tblSelectedItem);
        Collections.sort(this.getListAllItem());
        this.addArrayListToTable(this.getListAllItem(), this.tblAllItem);
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        CslRptUtil.addArrayListToArrayList((ArrayList)((ArrayList)this.getListSelectedItem()), (ArrayList)((ArrayList)this.getListAllItem()));
        this.getListAllItem().clear();
        Collections.sort(this.getListSelectedItem());
        this.addArrayListToTable(this.getListSelectedItem(), this.tblSelectedItem);
        this.addArrayListToTable(this.getListAllItem(), this.tblAllItem);
    }

    @Override
    public void actionReduceAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionReduceAll_actionPerformed(e);
        CslRptUtil.addArrayListToArrayList((ArrayList)((ArrayList)this.getListAllItem()), (ArrayList)((ArrayList)this.getListSelectedItem()));
        this.getListSelectedItem().clear();
        this.addArrayListToTable(this.getListSelectedItem(), this.tblSelectedItem);
        Collections.sort(this.getListAllItem());
        this.addArrayListToTable(this.getListAllItem(), this.tblAllItem);
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUp_actionPerformed(e);
        List ric = this.getArrtItem(this.tblSelectedItem.getName());
        int n = ric.size();
        int selectRow = this.tblSelectedItem.getSelectManager().getActiveRowIndex();
        if (n != 0 && selectRow > 0 && selectRow < n) {
            Collections.swap(ric, selectRow, selectRow - 1);
        }
        this.addArrayListToTable(this.getListSelectedItem(), this.tblSelectedItem);
        if (n != 0 && selectRow > 0 && selectRow < n) {
            this.tblSelectedItem.getSelectManager().setActiveRowIndex(selectRow - 1);
        }
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        List ric = this.getArrtItem(this.tblSelectedItem.getName());
        int n = ric.size();
        int selectRow = this.tblSelectedItem.getSelectManager().getActiveRowIndex();
        if (n != 0 && selectRow >= 0 && selectRow < n - 1) {
            Collections.swap(ric, selectRow, selectRow + 1);
        }
        this.addArrayListToTable(this.getListSelectedItem(), this.tblSelectedItem);
        if (n != 0 && selectRow >= 0 && selectRow < n - 1) {
            this.tblSelectedItem.getSelectManager().setActiveRowIndex(selectRow + 1);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnReduce.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnReduceAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    private void addArrayListToTable(List rptArr, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        table.getSelectManager().setSelectMode(10);
        int count = rptArr.size();
        AsstActObject baseInfo = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            baseInfo = (AsstActObject)rptArr.get(i);
            if (this.selectItemMap.containsKey(baseInfo.getId())) continue;
            r = table.addRow();
            String number = baseInfo.getNumber();
            if (baseInfo.isMultiLevel()) {
                String[] numbers = baseInfo.getLongNumber().split("!");
                String space = "";
                for (int j = 1; j < numbers.length; ++j) {
                    space = space + "  ";
                }
                r.getCell(0).setValue((Object)(space + number));
            } else {
                r.getCell(0).setValue((Object)number);
            }
            r.getCell(1).setValue((Object)baseInfo.getName());
            r.getCell(2).setValue((Object)baseInfo.getId());
            r.getCell(3).setValue((Object)baseInfo);
        }
    }

    private ArrayList getSelectedItemsFromTable(KDTable table) {
        ArrayList<AsstActObject> selectedItems = null;
        int size = table.getSelectManager().size();
        int startRow = 0;
        int endRow = 0;
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            if (sb.getMode() == 8) {
                startRow = 0;
                endRow = table.getRowCount() - 1;
            } else {
                startRow = sb.getTop();
                endRow = sb.getBottom();
            }
            int n = endRow;
            for (int j = startRow; j <= n; ++j) {
                if (selectedItems == null) {
                    selectedItems = new ArrayList<AsstActObject>();
                }
                AsstActObject baseInfo = (AsstActObject)table.getRow(j).getCell(3).getValue();
                selectedItems.add(baseInfo);
                this.getArrtItem(table.getName()).remove(baseInfo);
            }
        }
        return selectedItems;
    }

    private List getArrtItem(String tableName) {
        List items = null;
        if (tableName.equals(this.tblAllItem.getName())) {
            items = this.getListAllItem();
        } else if (tableName.equals(this.tblSelectedItem.getName())) {
            items = this.getListSelectedItem();
        }
        return items;
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionSearch_actionPerformed(e);
        String queryName = this.dynaItemBeforeFill.getQueryQueryName(this.cbxAssistant.isSelected(), this.isIncludeFreezedParam);
        String mappingFieldName = this.asstActTypeInfo.getAsstHGAttribute();
        Window owner = ComponentUtil.getOwnerWindow((Component)((Object)this));
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        KDCommonPromptDialog dlg = owner instanceof Frame ? new KDCommonPromptDialog((Frame)owner){

            public void refresh() {
                super.refresh();
                DynaItemWizardUI.this.hidedColumn(this.kdTMain);
            }
        } : new KDCommonPromptDialog((Dialog)owner){

            public void refresh() {
                super.refresh();
                DynaItemWizardUI.this.hidedColumn(this.kdTMain);
            }
        };
        QueryAgent queryAgent = new QueryAgent();
        queryAgent.setQueryInfoPK(MetaDataPK.create((String)queryName));
        queryAgent.setEnabledMultiSelection(true);
        if (mappingFieldName.equals("adminOrg") || mappingFieldName.equals("companyOrg") || mappingFieldName.equals("costOrg") || mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg")) {
            queryAgent.getQueryExecutor().option().isIgnorePermissionCheck = true;
        }
        SelectorItemCollection sic = this.getSelectorItemCollection(mappingFieldName);
        queryAgent.setSelectorCollection(sic);
        queryAgent.getQueryInfo().clearExtendedProperties();
        dlg.setQueryInfo(queryAgent.getQueryInfo());
        DynaItemBeforeFill bak = this.dynaItemBeforeFill;
        boolean isIncludeFreezed = this.checkIncludeFreezed.isSelected();
        EntityViewInfo view = this.buildSearchView(this.asstActTypeInfo, this.company, isIncludeFreezed);
        dlg.setEntityViewInfo(view);
        dlg.setSelectorCollection(queryAgent.getSelectorCollection());
        dlg.setQueryExecutor(queryAgent.getQueryExecutor());
        dlg.setEnabledMultiSelection(queryAgent.isEnabledMultiSelection());
        dlg.setReturnValueType(queryAgent.getReturnValueType());
        dlg.setTitle(this.assistantType.properityAlias);
        dlg.getQueryInfo().setAlias(this.assistantType.properityAlias);
        bizPromptBox.setQueryInfo(queryName);
        dlg.setParentF7(bizPromptBox);
        dlg.show();
        if (!dlg.isCanceled()) {
            Object[] objects = (Object[])dlg.getData();
            if (objects == null) {
                return;
            }
            this.getListAllItem().clear();
            this.addArrayToList(objects, this.asstActTypeInfo);
            this.addArrayListToTable(this.getListAllItem(), this.tblAllItem);
        } else {
            this.dynaItemBeforeFill = bak;
        }
    }

    public void hidedColumn(KDTabbedPane kdTMain) {
        IColumn curColumn = null;
        String[] hidedColumns = new String[]{"browseGroup.id", "id"};
        for (Component cur : kdTMain.getComponents()) {
            if (!(cur instanceof KDTable)) continue;
            for (String curHidedCol : hidedColumns) {
                curColumn = ((KDTable)cur).getColumn(curHidedCol);
                if (curColumn == null) continue;
                curColumn.getStyleAttributes().setHided(true);
            }
        }
    }

    private AsstActTypeUtils getAssistantType() {
        return this.assistantType;
    }

    public EntityViewInfo buildSearchView(AsstActTypeInfo info, OrgUnitInfo company, boolean isIncludeFreeZed) throws EASBizException, BOSException {
        boolean paramIsTrue = false;
        if (company != null && this.company != null && company.getId().equals((Object)this.company.getId())) {
            paramIsTrue = this.paramIsTrue;
        } else {
            if (company == null) {
                company = SysContext.getSysContext().getCurrentFIUnit();
            }
            paramIsTrue = RptUtil.isTrue((Object)ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(company.getCU().getId()), (String)"fi_rp_004"));
        }
        int top = 0;
        int left = 0;
        DynaParameters params = null;
        if (this.dynaItemBeforeFill != null) {
            top = this.dynaItemBeforeFill.getTop();
            left = this.dynaItemBeforeFill.getLeft();
            params = this.dynaItemBeforeFill.getParam();
        }
        this.dynaItemBeforeFill = new DynaItemBeforeFill(this.isReport, paramIsTrue, company, null);
        if (top > 0 || left > 0) {
            this.dynaItemBeforeFill.setTop(top);
            this.dynaItemBeforeFill.setLeft(left);
        }
        if (params != null) {
            this.dynaItemBeforeFill.setParam(params);
        }
        EntityViewInfo viewInfo = this.dynaItemBeforeFill.buildSearchView(info, isIncludeFreeZed);
        String mappingFieldName = info.getAsstHGAttribute();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider") || mappingFieldName.equals("material")) {
            DataBaseCollection col;
            FilterInfo filter = viewInfo.getFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            if ((col = this.dynaItemBeforeFill.getBaseDataGroup(null, mappingFieldName)) == null || col.size() <= 0) {
                FilterItemInfo filterItem = new FilterItemInfo("id", (Object)"", CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                if (filter.getFilterItems().size() > 0 && !StringUtils.isEmpty((String)filter.getMaskString())) {
                    filter.setMaskString("(" + filter.getMaskString() + ") and #" + (filter.getFilterItems().size() - 1));
                }
            } else {
                String groupSql = null;
                String idName = null;
                if (mappingFieldName.equals("customer")) {
                    idName = "browseGroup.id";
                    groupSql = " select a.fid from T_BD_CSSPGroup a,T_BD_CSSPGroupStandard b where   a.fcsspgroupstandardid=b.fid and b.ftype in (0,1)";
                } else if (mappingFieldName.equals("provider")) {
                    idName = "browseGroup.id";
                    groupSql = " select a.fid from T_BD_CSSPGroup a,T_BD_CSSPGroupStandard b where   a.fcsspgroupstandardid=b.fid and b.ftype in (0,2)";
                } else if (mappingFieldName.equals("material")) {
                    idName = "materialGroup.id";
                    groupSql = " select fid from T_BD_MaterialGroup where fdeletedStatus=1 ";
                }
                if (groupSql != null) {
                    FilterItemInfo filterItem = new FilterItemInfo(idName, (Object)groupSql, CompareType.INNER);
                    filter.getFilterItems().add(filterItem);
                    if (filter.getFilterItems().size() > 0 && !StringUtils.isEmpty((String)filter.getMaskString())) {
                        filter.setMaskString("(" + filter.getMaskString() + ") and #" + (filter.getFilterItems().size() - 1));
                    }
                }
            }
        }
        return viewInfo;
    }

    public EntityViewInfo buildSearchView4DynaTmplUtilUsed(AsstActTypeInfo info, OrgUnitInfo company, boolean isIncludeFreeZed) throws EASBizException, BOSException {
        boolean paramIsTrue = false;
        if (company != null && this.company != null && company.getId().equals((Object)this.company.getId())) {
            paramIsTrue = this.paramIsTrue;
        } else {
            if (company == null) {
                company = SysContext.getSysContext().getCurrentFIUnit();
            }
            paramIsTrue = RptUtil.isTrue((Object)ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(company.getCU().getId()), (String)"fi_rp_004"));
        }
        this.dynaItemBeforeFill = new DynaItemBeforeFill(this.isReport, paramIsTrue, company, null);
        return this.dynaItemBeforeFill.buildSearchView(info, isIncludeFreeZed);
    }

    private static int getAutoFillItemNUmberParam(String key) {
        String value = null;
        int ret = AUTOFILL_ITEM_SIZE;
        value = CSLParamUtil.getStringCslParamValue(null, (String)key);
        ret = !StringUtils.isEmpty((String)value) ? Integer.parseInt(value) : AUTOFILL_ITEM_SIZE;
        return ret;
    }
}

