/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.CompareTypeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiInterCheckageFilterUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Dimension;
import java.math.BigDecimal;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MultiInterCheckageFilterUI
extends AbstractMultiInterCheckageFilterUI {
    private static final Logger logger = Logger.getLogger(MultiInterCheckageFilterUI.class);
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String selectAll;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws BOSException, EASBizException {
        UnionF7Helper.UnionF7 f7;
        this.txtDiffValue.setDataType(BigDecimal.class);
        this.txtDiffValue.setPrecision(2);
        this.txtDiffValue.setRemoveingZeroInDispaly(false);
        this.txtDiffValue.setRemoveingZeroInEdit(true);
        this.txtDiffValue.setMaximumNumber((Number)new BigDecimal(9.9999999E7));
        this.txtDiffValue.setMinimumNumber((Number)new BigDecimal(-9.9999999E7));
        if (this.pp == null) {
            this.pp = new RptProperties();
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
        }
        this.selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        this.cboCurrency.addItem((Object)this.selectAll);
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        CurrencyCollection currencyCollection = iCurrency.getCurrencyCollection(viewInfo, true);
        if (currencyCollection != null && currencyCollection.size() > 0) {
            this.cboCurrency.addItems(currencyCollection.toArray());
        }
        this.comboElimTemplet.addItem((Object)this.selectAll);
        IElimTemplet iElimTemplet = ElimTempletFactory.getRemoteInstance();
        ElimTempletCollection elimTempletCollection = null;
        FilterInfo fInfo = new FilterInfo();
        FilterItemInfo filterElimTemplet = new FilterItemInfo("CheckedStatus", (Object)new Integer(2), CompareType.EQUALS);
        fInfo.getFilterItems().add(filterElimTemplet);
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        set.add(new Integer(3));
        filterElimTemplet = new FilterItemInfo("elimType", set, CompareType.INCLUDE);
        fInfo.getFilterItems().add(filterElimTemplet);
        viewInfo.setFilter(fInfo);
        elimTempletCollection = iElimTemplet.getElimTempletCollection(viewInfo);
        if (elimTempletCollection != null && elimTempletCollection.size() > 0) {
            this.comboElimTemplet.addItems(elimTempletCollection.toArray());
        }
        this.combConfirmStatue.removeAllItems();
        this.combConfirmStatue.addItem((Object)this.selectAll);
        this.combConfirmStatue.addItem((Object)CheckageConfirmEnum.Confirm);
        this.combConfirmStatue.addItem((Object)CheckageConfirmEnum.UnConfirm);
        try {
            f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            f7.setMultiSelect(false);
            this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            this.prmtCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
            this.prmtCompany.setSelector((KDPromptSelector)f7);
            this.prmtCompany.setDisplayFormat("$name$");
            this.prmtCompany.setEditFormat("$number$");
            this.prmtCompany.setCommitFormat("$number$;$name$");
            this.prmtCompany.setEditable(true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        try {
            f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            f7.setMultiSelect(false);
            this.prmtTargetCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            this.prmtTargetCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
            this.prmtTargetCompany.setSelector((KDPromptSelector)f7);
            this.prmtTargetCompany.setDisplayFormat("$name$");
            this.prmtTargetCompany.setEditFormat("$number$");
            this.prmtTargetCompany.setCommitFormat("$number$;$name$");
            this.prmtTargetCompany.setEditable(true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        this.combDiffMode.removeAllItems();
        this.combDiffMode.addItem((Object)this.selectAll);
        this.combDiffMode.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum").toArray());
        this.combDiffValue.removeAllItems();
        this.combDiffValue.addItem((Object)this.selectAll);
        this.combDiffValue.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.commonquery.CompareTypeEnum").toArray());
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public RptProperties getCustomCondition() {
        try {
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        if (this.prmtCompany.getValue() == null) {
            this.pp.remove("fromCompany");
        } else {
            this.pp.setString("fromCompany", ((OrgUnitInfo)this.prmtCompany.getValue()).getId().toString());
        }
        if (this.prmtTargetCompany.getValue() == null) {
            this.pp.remove("toCompany");
        } else {
            this.pp.setString("toCompany", ((OrgUnitInfo)this.prmtTargetCompany.getValue()).getId().toString());
        }
        if (this.cboCurrency.getSelectedIndex() == 0) {
            this.pp.remove("fromCurrency");
        } else {
            this.pp.setString("fromCurrency", ((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.cboCurrency.getSelectedIndex() == 0) {
            this.pp.remove("toCurrency");
        } else {
            this.pp.setString("toCurrency", ((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.comboElimTemplet.getSelectedIndex() == 0) {
            this.pp.remove("templet");
        } else {
            this.pp.setString("templet", ((ElimTempletInfo)this.comboElimTemplet.getSelectedItem()).getId().toString());
        }
        this.pp.setInt("diffMode", this.combDiffMode.getSelectedIndex() == 0 ? 0 : ((DiffModeEnum)this.combDiffMode.getSelectedItem()).getValue());
        if (this.combDiffValue.getSelectedIndex() == 0) {
            this.pp.remove("diffValueMode");
        } else {
            this.pp.setString("diffValueMode", ((CompareTypeEnum)this.combDiffValue.getSelectedItem()).getValue());
        }
        if (this.txtDiffValue.getBigDecimalValue() == null) {
            this.pp.remove("diffValue");
        } else {
            this.pp.setBigDecimal("diffValue", this.txtDiffValue.getBigDecimalValue());
        }
        if (this.combConfirmStatue.getSelectedIndex() == 0) {
            this.pp.remove("confirmStatue");
        } else {
            this.pp.setInt("confirmStatue", ((CheckageConfirmEnum)this.combConfirmStatue.getSelectedItem()).getValue());
        }
        this.pp.setBoolean("chkNotEqualZero", Boolean.valueOf(this.chkNotEqualZero.isSelected()));
        this.pp.setBoolean("chkNotAudit", Boolean.valueOf(this.chkNotAudit.isSelected()));
        return this.pp;
    }

    public void setCustomCondition(RptProperties pp) {
        this.pp = pp;
        this.fillDataToUI();
    }

    private void fillDataToUI() {
        BigDecimal diffValue;
        String diffValueMode;
        int diffMode;
        int status;
        String companyId;
        String fromCurrencyId;
        this.clearUI();
        if (this.pp.containsKey("fromCurrency") && (fromCurrencyId = this.pp.getString("fromCurrency")) != null) {
            for (int j = 1; j < this.cboCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(fromCurrencyId)) continue;
                this.cboCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("templet")) {
            String templetId = this.pp.getString("templet");
            for (int k = 1; k < this.comboElimTemplet.getItemCount(); ++k) {
                ElimTempletInfo templetInfo = (ElimTempletInfo)this.comboElimTemplet.getItemAt(k);
                if (!templetInfo.getId().toString().equals(templetId)) continue;
                this.comboElimTemplet.setSelectedIndex(k);
                break;
            }
        }
        if (this.pp.containsKey("fromCompany") && this.pp.getObject("fromCompany") != null) {
            companyId = (String)this.pp.getObject("fromCompany");
            try {
                FullOrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.prmtCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.pp.containsKey("toCompany") && this.pp.getObject("toCompany") != null) {
            companyId = (String)this.pp.getObject("toCompany");
            try {
                FullOrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.prmtTargetCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.pp.containsKey("confirmStatue") && (status = Integer.parseInt(this.pp.getString("confirmStatue"))) != 0) {
            this.combConfirmStatue.setSelectedItem((Object)CheckageConfirmEnum.getEnum((int)status));
        }
        if (this.pp.containsKey("diffMode") && (diffMode = Integer.parseInt(this.pp.getString("diffMode"))) != 0) {
            this.combDiffMode.setSelectedItem((Object)DiffModeEnum.getEnum((int)diffMode));
        }
        if (this.pp.containsKey("diffValueMode") && (diffValueMode = this.pp.getString("diffValueMode")) != null) {
            this.combDiffValue.setSelectedItem((Object)CompareTypeEnum.getEnum((String)diffValueMode));
        }
        if (this.pp.containsKey("diffValue") && (diffValue = new BigDecimal(this.pp.getString("diffValue"))) != null) {
            this.txtDiffValue.setValue((Object)diffValue);
        }
        if (this.pp.containsKey("chkNotAudit")) {
            this.chkNotAudit.setSelected(this.pp.getBoolean("chkNotAudit"));
        }
        if (this.pp.containsKey("chkNotEqualZero")) {
            this.chkNotEqualZero.setSelected(this.pp.getBoolean("chkNotEqualZero"));
        }
    }

    private void clearUI() {
        this.prmtCompany.setValue(null);
        this.prmtTargetCompany.setValue(null);
        this.cboCurrency.setSelectedItem((Object)this.selectAll);
        this.comboElimTemplet.setSelectedItem((Object)this.selectAll);
        this.combConfirmStatue.setSelectedIndex(0);
        this.txtDiffValue.setValue(null);
        this.combDiffMode.setSelectedIndex(0);
        this.combDiffValue.setSelectedIndex(0);
        this.chkNotAudit.setSelected(false);
        this.chkNotEqualZero.setSelected(false);
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }
}

