/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTExchItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTExchItemDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTInterItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.dynamic.AbstractMultiInterItemDataInfo;
import com.kingdee.eas.fi.gr.dynamic.MultiInterItemDataCollection;
import com.kingdee.eas.fi.gr.dynamic.MultiInterItemDataFactory;
import com.kingdee.eas.fi.gr.dynamic.client.AbstractMultiInterItemDataImportUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MultiInterItemDataImportUI
extends AbstractMultiInterItemDataImportUI {
    public static final String InterItemData = "INTERITEMDATA";
    public static final String ExchItemData = "EXCHITEMDATA";
    public static final String InvestItemData = "INVESTITEMDATA";
    public static final String MultiInterItemData = "MultiInterItemData";
    private Map reportDatas;
    private String importType;
    private String currencyId;
    private Map params = new HashMap();
    boolean isDelete = false;
    OrgTreeInfo treeInfo = null;
    Integer year = null;
    Integer period = null;
    Integer periodType = null;
    OrgUnitInfo orgunit = null;
    boolean isOpenOnCompany = false;
    private boolean isCanceled = false;
    private static final String resource = "com.kingdee.eas.fi.gr.dynamic.MultiInterCheckageResource";
    private static final String TEMPLATENUMBER = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.MultiInterCheckageResource", (String)"TEMPLATENUMBER");
    private static final String COMPANY = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.MultiInterCheckageResource", (String)"Company");
    private static final String TEMPLATE = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.MultiInterCheckageResource", (String)"TempletName");
    private static final String CURRENCY = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.MultiInterCheckageResource", (String)"CURRENCY");
    private Set reportIdSet = new HashSet();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.setRefresh(false);
        this.loadReport();
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
        int rowCount = this.tblMain.getExpandedRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ICell cell = this.tblMain.getCell(i, "select");
            if (cell == null) continue;
            cell.getStyleAttributes().setLocked(false);
            cell.setValue((Object)Boolean.FALSE);
        }
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Object o;
                ICell cll;
                int n;
                IRow row;
                if (e.getKeyCode() == 32 && (row = MultiInterItemDataImportUI.this.tblMain.getRow(n = MultiInterItemDataImportUI.this.tblMain.getSelectManager().getActiveRowIndex())) != null && (cll = row.getCell("select")) != null && (o = cll.getValue()) != null && o instanceof Boolean) {
                    cll.setValue((Object)new Boolean((Boolean)o == false));
                }
            }
        });
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDeselectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnSearch.setVisible(true);
        this.btnSearch.setEnabled(true);
        this.actionOk.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.actionSelectAll.setEnabled(true);
        this.actionDeslectAll.setEnabled(true);
        if (this.isDelete) {
            this.cbxCover.setVisible(false);
            this.kDLabel1.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"71_MultiInterItemDataImportUI"));
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"72_MultiInterItemDataImportUI"));
        } else {
            this.cbxCover.setSelected(true);
            this.cbxCover.setEnabled(false);
        }
        this.comboQueryField.addItem((Object)TEMPLATENUMBER);
        this.comboQueryField.addItem((Object)COMPANY);
        this.comboQueryField.addItem((Object)TEMPLATE);
        this.comboQueryField.addItem((Object)CURRENCY);
    }

    private void loadReport() throws BOSException, EASBizException {
        String tmp;
        this.currencyId = (String)this.getUIContext().get("KEY_CURRENCY_ID");
        this.importType = (String)this.getUIContext().get("KEY_DynaItemData_TYPE");
        CSLContext context = CSLContext.getInstance();
        int mergeMode = 100;
        if (this.getUIContext().get("KEY_ISCOMPANY") == null || !((Boolean)this.getUIContext().get("KEY_ISCOMPANY")).booleanValue()) {
            this.isOpenOnCompany = false;
            mergeMode = CSLContextHelper.getSysParamanager().getMergeType();
            this.params.put("KeyOrgTree", context.getCurOrgBound());
            this.params.put("KeyOrgUnit", context.getCurOrgGroup());
            this.params.put("Year", new Integer(context.getCurRptYear()));
            this.params.put("Period", new Integer(context.getCurRptPeriod()));
            this.params.put("Day", context.getCurReportDate());
            this.params.put("PeriodType", new Integer(context.getCurRptPeriodType().getValue()));
            this.params.put("MERGETYPE", new Integer(mergeMode));
            this.params.put("KEY_CURRENCY_ID", this.currencyId);
        } else if (this.getUIContext().get("KEY_ISCOMPANY") != null && ((Boolean)this.getUIContext().get("KEY_ISCOMPANY")).booleanValue()) {
            this.isOpenOnCompany = true;
            if (this.getUIContext().get("orgTreeId") != null) {
                this.treeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("orgTreeId").toString())));
            }
            this.params.put("KeyOrgTree", this.treeInfo);
            this.orgunit = SysContext.getSysContext().getCurrentOrgUnit();
            this.year = (Integer)this.getUIContext().get("year");
            this.period = (Integer)this.getUIContext().get("period");
            this.periodType = (Integer)this.getUIContext().get("periodType");
            this.params.put("KeyOrgUnit", this.orgunit);
            this.params.put("Year", this.year);
            this.params.put("Period", this.period);
            this.params.put("PeriodType", this.periodType);
            this.params.put("MERGETYPE", new Integer(100));
            this.params.put("KEY_CURRENCY_ID", this.currencyId);
        }
        Boolean b = (Boolean)this.getUIContext().get("isDelete");
        if (b != null) {
            this.isDelete = b;
        }
        StringBuffer ids = new StringBuffer();
        if (!this.isDelete) {
            this.reportDatas = this.importType.equals(InterItemData) ? RPTInterItemDataFactory.getRemoteInstance().getImportData(this.params) : (this.importType.equals(ExchItemData) ? RPTExchItemDataFactory.getRemoteInstance().getImportData(this.params) : (this.importType.equals(MultiInterItemData) ? MultiInterItemDataFactory.getRemoteInstance().getImportData(this.params) : InvestItemDataFactory.getRemoteInstance().getImportData(this.params)));
            this.reportIdSet.clear();
            for (String reportId : this.reportDatas.keySet()) {
                this.reportIdSet.add(reportId);
                ids.append("'").append(reportId).append("',");
            }
        } else {
            String reportId;
            Object info;
            int i;
            Object col;
            String oql = "select report where orgBound.id = '";
            oql = this.isOpenOnCompany ? oql + this.treeInfo.getId().toString() + "'" : oql + context.getCurOrgBound().getId().toString() + "'";
            if (mergeMode == 1) {
                oql = oql + " and importedGroup.id = '" + context.getCurOrgGroup().getId().toString() + "'";
            }
            StringBuffer oqlWhere = new StringBuffer();
            if (this.isOpenOnCompany) {
                oqlWhere.append(" and year = ").append(this.year);
                oqlWhere.append(" and period = ").append(this.period);
                oqlWhere.append(" and periodType = ").append(this.periodType);
            } else {
                oqlWhere.append(" and year = ").append(context.getCurRptYear());
                oqlWhere.append(" and period = ").append(context.getCurRptPeriod());
                oqlWhere.append(" and periodType = ").append(context.getCurRptPeriodType().getValue());
            }
            ArrayList<String> reportIds = new ArrayList<String>();
            if (this.importType.equals(InterItemData)) {
                oql = oql + oqlWhere.toString();
                col = RPTInterItemDataFactory.getRemoteInstance().getRPTInterItemDataCollection(oql);
                for (i = 0; i < col.size(); ++i) {
                    info = col.get(i);
                    reportId = info.getReport().getId().toString();
                    if (reportIds.contains(reportId)) continue;
                    reportIds.add(reportId);
                }
            } else if (this.importType.equals(ExchItemData)) {
                oql = oql + oqlWhere.toString();
                col = RPTExchItemDataFactory.getRemoteInstance().getCollection(oql);
                for (i = 0; i < col.size(); ++i) {
                    info = (RPTExchItemDataInfo)col.get(i);
                    reportId = info.getReport().getId().toString();
                    if (reportIds.contains(reportId)) continue;
                    reportIds.add(reportId);
                }
            } else if (this.importType.equals(MultiInterItemData)) {
                oql = oql + oqlWhere.toString();
                col = MultiInterItemDataFactory.getRemoteInstance().getCollection(oql);
                for (i = 0; i < col.size(); ++i) {
                    info = ((MultiInterItemDataCollection)((Object)col)).get(i);
                    reportId = ((AbstractMultiInterItemDataInfo)info).getReport().getId().toString();
                    if (reportIds.contains(reportId)) continue;
                    reportIds.add(reportId);
                }
            } else {
                col = InvestItemDataFactory.getRemoteInstance().getInvestItemDataCollection(oql);
                for (i = 0; i < col.size(); ++i) {
                    info = col.get(i);
                    reportId = info.getReport().getId().toString();
                    if (reportIds.contains(reportId)) continue;
                    reportIds.add(reportId);
                }
            }
            this.reportIdSet.clear();
            for (int i2 = 0; i2 < reportIds.size(); ++i2) {
                String reportId2 = (String)reportIds.get(i2);
                this.reportIdSet.add(reportId2);
                ids.append("'").append(reportId2).append("',");
            }
        }
        if (StringUtils.isEmpty((String)(tmp = ids.toString()))) {
            return;
        }
        tmp = tmp.substring(0, tmp.length() - 1);
        CslReportCollection collection = CslReportFactory.getRemoteInstance().getCslReportCollection("select id, name,template.number,orgUnit.name,sourceCurrency.name, currency.name, periodType, year, period, committedStatus where id in (" + tmp + ")");
        this.fillTable(collection);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        int size = this.tblMain.getRowCount();
        if (this.isDelete) {
            StringBuffer ids = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                Boolean b;
                IRow row = this.tblMain.getRow(i);
                Object value = row.getCell(0).getValue();
                if (!(value instanceof Boolean) || !(b = (Boolean)value).booleanValue()) continue;
                String reportId = (String)row.getCell("id").getValue();
                ids.append("'").append(reportId).append("',");
            }
            String tmp = ids.toString();
            if (StringUtils.isEmpty((String)tmp)) {
                return;
            }
            tmp = tmp.substring(0, tmp.length() - 1);
            String oql = " where report.id in (" + tmp + ")";
            if (this.importType.equals(InterItemData)) {
                RPTInterItemDataFactory.getRemoteInstance().delete(oql);
            } else if (this.importType.equals(ExchItemData)) {
                RPTExchItemDataFactory.getRemoteInstance().delete(oql);
            } else if (this.importType.equals(MultiInterItemData)) {
                MultiInterItemDataFactory.getRemoteInstance().delete(oql);
            } else {
                InvestItemDataFactory.getRemoteInstance().delete(oql);
            }
        } else {
            HashMap importDatas = new HashMap();
            for (int i = 0; i < size; ++i) {
                Boolean b;
                IRow row = this.tblMain.getRow(i);
                Object value = row.getCell(0).getValue();
                if (!(value instanceof Boolean) || !(b = (Boolean)value).booleanValue()) continue;
                String reportId = (String)row.getCell("id").getValue();
                importDatas.put(reportId, this.reportDatas.get(reportId));
            }
            if (importDatas == null || importDatas.size() <= 0) {
                return;
            }
            String error = this.importType.equals(InterItemData) ? RPTInterItemDataFactory.getRemoteInstance().importInterItemData(this.cbxCover.isSelected(), importDatas, this.params) : (this.importType.equals(ExchItemData) ? RPTExchItemDataFactory.getRemoteInstance().importExchItemData(this.cbxCover.isSelected(), importDatas, this.params) : (this.importType.equals(MultiInterItemData) ? MultiInterItemDataFactory.getRemoteInstance().importInterItemData(this.cbxCover.isSelected(), importDatas, this.params) : InvestItemDataFactory.getRemoteInstance().importInvestItemData(this.cbxCover.isSelected(), importDatas, this.params)));
            if (!StringUtils.isEmpty((String)error)) {
                UIContext ctx = new UIContext((Object)this);
                ctx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"73_MultiInterItemDataImportUI"));
                ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
                SimpleNotePad.showMessageByModel((UIContext)ctx, (String)error);
            }
        }
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isCanceled = true;
        this.destroyWindow();
    }

    @Override
    public void actionDeselectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeselectAll_actionPerformed(e);
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"select", (Boolean)Boolean.FALSE);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"select", (Boolean)Boolean.TRUE);
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionSearch_actionPerformed(e);
        if (this.reportIdSet == null || this.reportIdSet.size() == 0) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        Iterator it = this.reportIdSet.iterator();
        while (it.hasNext()) {
            String reportId = it.next().toString();
            ids.append("'").append(reportId).append("',");
        }
        ids.delete(ids.length() - 1, ids.length());
        String queryTxt = this.txtQueryTxt.getText();
        if (queryTxt == null || queryTxt.length() == 0) {
            CslReportCollection collection = CslReportFactory.getRemoteInstance().getCslReportCollection("select id, name,template.number, orgUnit.name,sourceCurrency.name, currency.name, periodType, year, period, committedStatus where id in (" + ids.toString() + ")");
            this.fillTable(collection);
        } else {
            String likeField = null;
            Object selectItem = this.comboQueryField.getSelectedItem();
            if (selectItem.equals(COMPANY)) {
                likeField = "orgUnit.name";
            } else if (selectItem.equals(TEMPLATE)) {
                likeField = "name";
            } else if (selectItem.equals(TEMPLATENUMBER)) {
                likeField = "template.number";
            } else if (selectItem.equals(CURRENCY)) {
                likeField = "currency.name";
            }
            CslReportCollection collection = CslReportFactory.getRemoteInstance().getCslReportCollection("select id, name,template.number, orgUnit.name,sourceCurrency.name, currency.name, periodType, year, period, committedStatus  where id in (" + ids.toString() + " ) and " + likeField + " like '%" + queryTxt + "%' ");
            this.fillTable(collection);
        }
    }

    private void fillTable(CslReportCollection collection) {
        this.tblMain.removeRows();
        for (CslReportInfo report : collection) {
            IRow row = this.tblMain.addRow();
            ICell cell = row.getCell("id");
            cell.setValue((Object)report.getId().toString());
            cell = row.getCell("reportName");
            cell.setValue((Object)report.getName());
            cell = row.getCell("reportNumber");
            cell.setValue((Object)report.getTemplate().getNumber());
            cell = row.getCell("companyName");
            cell.setValue((Object)report.getOrgUnit().getName());
            cell = row.getCell("sourceCurrency");
            cell.setValue((Object)report.getSourceCurrency().getName());
            cell = row.getCell("currency");
            cell.setValue((Object)report.getCurrency().getName());
            cell = row.getCell("periodType");
            cell.setValue((Object)report.getPeriodType().getAlias());
            cell = row.getCell("year");
            cell.setValue((Object)new Integer(report.getYear()));
            cell = row.getCell("period");
            cell.setValue((Object)new Integer(report.getPeriod()));
            cell = row.getCell("status");
            cell.setValue((Object)report.getCommittedStatus().getAlias());
            cell = row.getCell("select");
            cell.setValue((Object)Boolean.FALSE);
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

