/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.calctree;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.calctree.CalcTreeBuild;
import com.kingdee.eas.fi.nlm.calctree.CalcTreeNode;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CalcTree {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.calctree.CalcTree");
    private static CalcTreeNode calcTree;

    private CalcTree() {
    }

    public static void calc(Context ctx, Object conditionValue, Map<String, Object> params, Map<String, Object> result) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException, ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (calcTree == null) {
            CalcTree.initCalcTree(ctx);
        }
        ArrayList<String> queryPathList = new ArrayList<String>();
        CalcTreeNode calcTreeNode = CalcTree.queryCalcNode(conditionValue, calcTree, 0, queryPathList);
        queryPathList.add(calcTreeNode.getCalcMethod());
        String calcClass = calcTreeNode.getCalcClass();
        String calcMethod = calcTreeNode.getCalcMethod();
        Class<?> implClass = Class.forName(calcClass);
        Method implMethod = implClass.getMethod(calcMethod, Context.class, Map.class, Map.class);
        params.put("queryPathList", queryPathList);
        implMethod.invoke(implClass.newInstance(), ctx, params, result);
    }

    public static void getCalcMessage(Context ctx, Object conditionValue, Map<String, Object> params, Map<String, Object> result) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (calcTree == null) {
            CalcTree.initCalcTree(ctx);
        }
        ArrayList<String> queryPathList = new ArrayList<String>();
        CalcTreeNode calcTreeNode = CalcTree.queryCalcNode(conditionValue, calcTree, 0, queryPathList);
        result.put("calcType", ((FaLeaseInBillNewInfo)conditionValue).get("calcType"));
        result.put("queryPathList", queryPathList);
        result.put("queryMethod", calcTreeNode.getCalcMethod());
    }

    public static List<List<String>> levelOrder() {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        if (calcTree == null) {
            return res;
        }
        LinkedList<CalcTreeNode> queue = new LinkedList<CalcTreeNode>();
        queue.addLast(calcTree);
        while (!queue.isEmpty()) {
            int size = queue.size();
            ArrayList<String> list = new ArrayList<String>();
            while (size-- > 0) {
                CalcTreeNode node = (CalcTreeNode)queue.pollFirst();
                list.add(node.getNumber() + ":" + node.getName() + ":" + node.getSonConditionType());
                if (node.getSonList() == null) continue;
                for (CalcTreeNode children : node.getSonList()) {
                    queue.addLast(children);
                }
            }
            res.add(list);
        }
        return res;
    }

    private static CalcTreeNode queryCalcNode(Object conditionObject, CalcTreeNode treeNode, int depth, ArrayList<String> queryPathList) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (treeNode == null || treeNode.isLeaf()) {
            return treeNode;
        }
        if ("calculation".equals(treeNode.getSonConditionType())) {
            queryPathList.add("\u8c03\u7528\u516c\u5f0f\u8ba1\u7b97");
            queryPathList.add(treeNode.getSonList().get(0).getName());
            return CalcTree.queryCalcNode(conditionObject, treeNode.getSonList().get(0), depth + 1, queryPathList);
        }
        String conditionClass = treeNode.getConditionalJudgmentClass();
        String conditionMethod = treeNode.getConditionalJudgmentMethod();
        String conditionField = treeNode.getConditionalJudgmentField();
        Class<?> implClass = Class.forName(conditionClass);
        Class<?> fieldClass = Class.forName(conditionField);
        Method implMethod = implClass.getMethod(conditionMethod, fieldClass);
        String conditionValue = (String)implMethod.invoke(implClass.newInstance(), conditionObject);
        queryPathList.add(treeNode.getSonConditionName());
        List<CalcTreeNode> calcTreeNodes = treeNode.getSonList();
        for (CalcTreeNode tmpNode : calcTreeNodes) {
            if (!tmpNode.getConditionValue().equals(conditionValue)) continue;
            queryPathList.add(tmpNode.getName());
            return CalcTree.queryCalcNode(conditionObject, tmpNode, depth + 1, queryPathList);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initCalcTree(Context ctx) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        try (InputStream inputStream = null;){
            inputStream = new ByteArrayInputStream(CalcTreeBuild.getCalcTreeBuildString().getBytes("UTF-8"));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbd = dbf.newDocumentBuilder();
            Document doc = dbd.parse(inputStream);
            if (doc == null) {
                throw new FileNotFoundException((ctx == null ? "\u5ba2\u6237\u7aef\u62a5\u9519\uff1a" : "\u670d\u52a1\u7aef\u62a5\u9519\uff1a") + "\u627e\u4e0d\u5230\u914d\u7f6e\u6587\u4ef6\uff1afl_calc_terminate_bill_tree.xml;");
            }
            XPathFactory f = XPathFactory.newInstance();
            XPath path = f.newXPath();
            Node treeNode = (Node)path.evaluate("calc_tree", doc, XPathConstants.NODE);
            calcTree = CalcTree.initCalcTree(treeNode, treeNode.getChildNodes(), treeNode.getAttributes().getNamedItem("conditional_judgment_class").getNodeValue(), treeNode.getAttributes().getNamedItem("calc_class").getNodeValue());
        }
    }

    private static CalcTreeNode initCalcTree(Node currentNode, NodeList childNodeList, String conditionalJudgmentClass, String calcClass) {
        NamedNodeMap attr = currentNode.getAttributes();
        CalcTreeNode currentTreeNode = new CalcTreeNode();
        currentTreeNode.setId(attr.getNamedItem("id").getNodeValue());
        currentTreeNode.setNumber(attr.getNamedItem("number").getNodeValue());
        currentTreeNode.setName(attr.getNamedItem("name").getNodeValue());
        currentTreeNode.setLeaf(Boolean.parseBoolean(attr.getNamedItem("is_leaf").getNodeValue()));
        currentTreeNode.setConditionValue(attr.getNamedItem("condition_value") == null ? null : attr.getNamedItem("condition_value").getNodeValue());
        if (currentTreeNode.isLeaf()) {
            currentTreeNode.setCalcClass(calcClass);
            currentTreeNode.setCalcMethod(attr.getNamedItem("calc_method").getNodeValue());
            currentTreeNode.setCalcField(attr.getNamedItem("calc_field").getNodeValue());
        }
        Node sonNodeList = null;
        int j = childNodeList.getLength();
        for (int i = 0; i < j; ++i) {
            if (childNodeList.item(i).getNodeType() != 1) continue;
            sonNodeList = childNodeList.item(i);
            break;
        }
        if ("son_list".equals(sonNodeList == null ? "" : sonNodeList.getNodeName())) {
            currentTreeNode.setSonConditionName(sonNodeList == null ? null : sonNodeList.getAttributes().getNamedItem("name").getNodeValue());
            currentTreeNode.setSonConditionType(sonNodeList == null ? null : sonNodeList.getAttributes().getNamedItem("condition_type").getNodeValue());
            currentTreeNode.setConditionalJudgmentClass(conditionalJudgmentClass);
            currentTreeNode.setConditionalJudgmentMethod(sonNodeList == null ? null : (sonNodeList.getAttributes().getNamedItem("conditional_judgment_method") == null ? null : sonNodeList.getAttributes().getNamedItem("conditional_judgment_method").getNodeValue()));
            currentTreeNode.setConditionalJudgmentField(sonNodeList == null ? null : (sonNodeList.getAttributes().getNamedItem("conditional_judgment_field") == null ? null : sonNodeList.getAttributes().getNamedItem("conditional_judgment_field").getNodeValue()));
            NodeList tmpList = sonNodeList.getChildNodes();
            ArrayList<CalcTreeNode> calcTreeNodes = new ArrayList<CalcTreeNode>(tmpList.getLength());
            int j2 = tmpList.getLength();
            for (int i = 0; i < j2; ++i) {
                if (tmpList.item(i) == null || tmpList.item(i).getNodeType() != 1) continue;
                calcTreeNodes.add(CalcTree.initCalcTree(tmpList.item(i), tmpList.item(i).getChildNodes(), conditionalJudgmentClass, calcClass));
            }
            currentTreeNode.setSonList(calcTreeNodes);
        }
        return currentTreeNode;
    }
}

