/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptFactory;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.FaLeaseBizStatusEnum;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.IFaAmortizedCostRpt;
import com.kingdee.eas.fi.nlm.IFaLeaseInBillNew;
import com.kingdee.eas.fi.nlm.client.AbstractFaAmortizedCostListRptUI;
import com.kingdee.eas.fi.nlm.client.FaAmortizedCostListRptConditionUI;
import com.kingdee.eas.fi.nlm.client.FaLeaseInNewEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaAmortizedCostListRptUI
extends AbstractFaAmortizedCostListRptUI {
    private static final long serialVersionUID = 8661456851223723778L;
    private static final Logger logger = CoreUIObject.getLogger(FaAmortizedCostListRptUI.class);
    private static final int DEFAULT_DISPLAY_CURRENCY_SCALE = 2;
    private static final int DEFAULT_DISPLAY_RATE_SCALE = 4;
    private int currencyScale = 2;
    private int currencyScaleOC = 2;
    private static final String KEY_DATE = "date";
    private static final String KEY_MONTH = "month";
    private static final String KEY_CASHFLOW = "cashflow";
    private static final String KEY_INITRIGHTOFUSEASSET = "initRightOfUseAsset";
    private static final String KEY_INITLIABILITYPRINCIPAL = "initLiabilityPrincipal";
    private static final String KEY_INITUNCFMFNCCOST = "initUnCfmFncCost";
    private static final String KEY_INITLIABILITYBALANCE = "initLiabilityBalance";
    private static final String KEY_CURDEPRECIATION = "curDepreciation";
    private static final String KEY_CURACCDEPRECIATION = "curAccDepreciation";
    private static final String KEY_CURINTERESTPAYMENT = "curInterestPayment";
    private static final String KEY_CURACCINTERESTPAYMENT = "curAccInterestPayment";
    private static final String KEY_ENDRIGHTOFUSEASSET = "endRightOfUseAsset";
    private static final String KEY_ENDLIABILITYPRINCIPAL = "endLiabilityPrincipal";
    private static final String KEY_ENDUNCFMFNCCOST = "endUnCfmFncCost";
    private static final String KEY_ENDLIABILITYBALANCE = "endLiabilityBalance";
    private static final String KEY_InitialAssetDecValue = "initialAssetDecValue";
    private CompanyOrgUnitInfo curCompany;
    private CommonQueryDialog commonQueryDialog;
    private EntityViewInfo billView = new EntityViewInfo();
    private FaAmortizedCostListRptConditionUI faACRCondUI;
    private int curPageIndex = 0;
    private FaLeaseInBillNewCollection curLeaseInBillCol = new FaLeaseInBillNewCollection();
    private FaAmortizedCostRptInfo curACRpt = null;
    private FaAmortizedCostRptCollection curACRptColCache = new FaAmortizedCostRptCollection();

    public void onLoad() throws Exception {
        block4: {
            super.onLoad();
            try {
                FaClientUtils.checkBeforeOnload4Fl((Map)this.getUIContext(), (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
            }
            catch (EASBizException e) {
                if ("002".equals(e.getSubCode())) break block4;
                throw e;
            }
        }
        this.currencyScale = this.getCurrentCompany().getBaseCurrency().getPrecision();
        Map uiCtx = this.getUIContext();
        String leaseInBillId = (String)uiCtx.get("ID");
        if (leaseInBillId != null) {
            this.setCurrencyScaleOC(leaseInBillId);
            this.loadDataById(leaseInBillId);
            this.initUI();
            this.setData2UI();
        } else {
            this.popFilterDialog();
        }
    }

    private void loadDataById(String leaseInBillId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)leaseInBillId));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        this.billView = view;
        this.loadData(view);
    }

    private void popFilterDialog() throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.commonQueryDialog.setParentUIClassName("com.kingdee.eas.fi.fa.rpt.client.FaAmortizedCostListRptUI");
            MetaDataPK queryFaLeaseInNewQueryPK = new MetaDataPK("com.kingdee.eas.fi.fa.manage.FaLeaseInNewQuery");
            this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryFaLeaseInNewQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(true);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setDisShowRowCount(true);
            this.faACRCondUI = new FaAmortizedCostListRptConditionUI();
            this.faACRCondUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.condition"));
            this.commonQueryDialog.addUserPanel((KDPanel)this.faACRCondUI);
            this.commonQueryDialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.condQuery"));
            FACommonProcessor process = new FACommonProcessor();
            process.set("parentDialog", (Object)this.commonQueryDialog);
            this.commonQueryDialog.setProcessor((IProcessor)process);
            this.commonQueryDialog.setHeight(380);
            this.commonQueryDialog.setWidth(580);
        }
        if (this.commonQueryDialog.show()) {
            this.handleBillView();
            this.reset();
            this.loadData(this.billView);
            this.initUI();
            this.setData2UI();
        } else {
            SysUtil.abort();
        }
    }

    private void initUI() {
        this.btnQuery.setEnabled(true);
        this.btnViewBill.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        if (this.curLeaseInBillCol.size() <= 1) {
            this.setPageBtnsEn(false, false, false, false);
        } else {
            this.setPageBtnsEn(false, false, true, true);
        }
        this.lblContractNum.setText("");
        this.lblContractCat.setText("");
        this.lblDiscountRate.setText("");
        this.lblCurrency.setText("");
        this.lblNPV.setText("");
        this.tblMain.repaint();
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        this.tblMain.setEnabled(false);
    }

    private void setData2UI() throws EASBizException, BOSException, SQLException, ParseException {
        if (this.curACRpt != null) {
            this.setData2Head(this.curACRpt);
            this.setData2Table(this.curACRpt);
        }
    }

    private void handleBillView() {
        FaAmortizedCostListRptConditionUI condUI = (FaAmortizedCostListRptConditionUI)this.commonQueryDialog.getUserPanel(0);
        this.billView = this.commonQueryDialog.getEntityViewInfoResult();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo customFilter = this.billView.getFilter();
        SorterItemCollection customSortItemCol = this.billView.getSorter();
        SorterItemCollection sortItemCol = new SorterItemCollection();
        sic.add("id");
        Map<String, Object> cond = condUI.getCustomCond();
        CompanyOrgUnitInfo comInfo = (CompanyOrgUnitInfo)cond.get("company");
        Date dateBeginFrom = (Date)cond.get("dateBeginFrom");
        Date dateBeginTo = (Date)cond.get("dateBeginTo");
        Date dateEndFrom = (Date)cond.get("dateEndFrom");
        Date dateEndTo = (Date)cond.get("dateEndTo");
        FaLeaseInBillNewInfo billInfoFrom = (FaLeaseInBillNewInfo)cond.get("leaseInNumFrom");
        FaLeaseInBillNewInfo billInfoTo = (FaLeaseInBillNewInfo)cond.get("leaseInNumTo");
        FaContractCatInfo catInfo = (FaContractCatInfo)cond.get("contractCat");
        CostCenterOrgUnitInfo ccInfo = (CostCenterOrgUnitInfo)cond.get("costCenter");
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)cond.get("useDepartment");
        CurrencyInfo cInfo = (CurrencyInfo)cond.get("currency");
        String isExpiredStr = cond.get("isExpired") == null ? null : (String)cond.get("isExpired");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isExempt", (Object)false));
        if (comInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comInfo.getId().toString()));
        }
        if (dateBeginFrom != null) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)dateBeginFrom, CompareType.GREATER_EQUALS));
        }
        if (dateBeginTo != null) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)dateBeginTo, CompareType.LESS_EQUALS));
        }
        if (dateEndFrom != null) {
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)dateEndFrom, CompareType.GREATER_EQUALS));
        }
        if (dateEndTo != null) {
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)dateEndTo, CompareType.LESS_EQUALS));
        }
        if (catInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("contractCat.id", (Object)catInfo.getId().toString()));
        }
        if (billInfoFrom != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)billInfoFrom.getNumber(), CompareType.GREATER_EQUALS));
        }
        if (billInfoTo != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)billInfoTo.getNumber(), CompareType.LESS_EQUALS));
        }
        if (ccInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)ccInfo.getId().toString()));
        }
        if (adminInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("useDepartment.id", (Object)adminInfo.getId().toString()));
        }
        if (cInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)cInfo.getId().toString()));
        }
        if (isExpiredStr != null) {
            filter.getFilterItems().add(new FilterItemInfo("isExpire", (Object)Boolean.valueOf(isExpiredStr)));
        }
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)2));
        StringBuffer filterMaskStr = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i == 0) {
                filterMaskStr.append("#");
            } else {
                filterMaskStr.append(" AND #");
            }
            filterMaskStr.append(i);
        }
        filter.setMaskString(filterMaskStr.toString());
        try {
            customFilter.mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.billView.setSelector(sic);
        if (customSortItemCol == null || customSortItemCol.size() <= 0) {
            sortItemCol.add(new SorterItemInfo("number"));
            sortItemCol.add(new SorterItemInfo("beginDate"));
            this.billView.setSorter(sortItemCol);
        }
    }

    private void loadData(EntityViewInfo view) throws BOSException, EASBizException {
        this.curLeaseInBillCol = this.queryLeaseInBillCol(view);
        if (this.curLeaseInBillCol.size() > 0) {
            this.curACRpt = this.queryACRptByBillId(this.curLeaseInBillCol.get(0).getId());
            if (this.curACRpt != null) {
                this.curACRptColCache.add(this.curACRpt);
            } else {
                this.curACRptColCache.add(new FaAmortizedCostRptInfo());
            }
            for (int i = 0; i < this.curLeaseInBillCol.size() - 1; ++i) {
                this.curACRptColCache.add(new FaAmortizedCostRptInfo());
            }
        }
    }

    private void setData2Head(FaAmortizedCostRptInfo rptInfo) {
        FaLeaseInBillNewInfo billInfo = rptInfo.getLeaseInBill();
        if (billInfo == null) {
            return;
        }
        this.lblContractNum.setText(billInfo.getNumber());
        this.lblContractCat.setText(billInfo.getContractCat().getName());
        this.lblDiscountRate.setText(billInfo.getDiscountRate() != null ? billInfo.getDiscountRate().setScale(4, 4) + "%" : "");
        this.lblCurrency.setText(billInfo.getCurrency() != null ? billInfo.getCurrency().getName() : "");
        this.conNameLabelText.setText(billInfo.getContractName() != null ? billInfo.getContractName() : "");
        if (billInfo.getLiabilitiesCvMethod() == null || billInfo.getLiabilitiesCvMethod() == FaLiabilitiesCvMethodEnum.DAY && billInfo.getDepreciationMethod() == DepreciationMethodEnum.First) {
            this.kDLabel6.setVisible(true);
            this.lblNPV.setVisible(true);
            this.lblNPV.setText(String.valueOf(this.formatDisplayBD(rptInfo.getNPV())));
        } else {
            this.kDLabel6.setVisible(false);
            this.lblNPV.setVisible(false);
        }
    }

    private void updateCurrencyLablePosition(boolean move) {
        Rectangle rectangleVaule;
        Rectangle rectangleLable;
        if (move) {
            rectangleLable = new Rectangle(672, 18, 61, 19);
            rectangleVaule = new Rectangle(724, 18, 92, 19);
        } else {
            rectangleLable = new Rectangle(851, 18, 41, 19);
            rectangleVaule = new Rectangle(885, 18, 80, 19);
        }
        this.kDLabel5.setBounds(rectangleLable);
        this.add((Component)this.kDLabel5, new KDLayout.Constraints(rectangleLable.x, rectangleLable.y, rectangleLable.width, rectangleLable.height, 0));
        this.lblCurrency.setBounds(rectangleVaule);
        this.add((Component)this.lblCurrency, new KDLayout.Constraints(rectangleVaule.x, rectangleVaule.y, rectangleVaule.width, rectangleVaule.height, 0));
    }

    private void setData2Table(FaAmortizedCostRptInfo rpt) throws EASBizException, BOSException, SQLException, ParseException {
        if (rpt.getLeaseInBill() == null) {
            return;
        }
        Date leaseBillChangeDate = this.getChangeDate(rpt.getLeaseInBill().getId().toString());
        FaLeaseInBillNewInfo leaseInBillNewInfo = this.getNewBillInfo(rpt.getLeaseInBill().getId().toString());
        FaLeaseInBillNewInfo rptLeaseInBillInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(rpt.getLeaseInBill().getId()));
        this.setCurrencyScaleOC(rpt.getLeaseInBill().getId().toString());
        this.tblMain.repaint();
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        this.tblMain.setEnabled(false);
        if (rpt.getLeaseInBill().getLiabilitiesCvMethod() == null || rpt.getLeaseInBill().getLiabilitiesCvMethod() == FaLiabilitiesCvMethodEnum.DAY && rpt.getLeaseInBill().getDepreciationMethod() == DepreciationMethodEnum.First) {
            this.tblMain.getColumn(KEY_DATE).getStyleAttributes().setHided(false);
            this.tblMain.getColumn(KEY_MONTH).getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn(KEY_DATE).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(KEY_MONTH).getStyleAttributes().setHided(false);
        }
        FaAmortizedCostRptEntryCollection rptEntryCol = rpt.getEntry();
        try {
            int orginScale = this.getCurrencyScale(rpt.getLeaseInBill().getCurrency().getId().toString());
            BigDecimal tmpOne = new BigDecimal(0.0);
            tmpOne.setScale(8, 4);
            int j = rptEntryCol.size();
            for (int i = 0; i < j; ++i) {
                FaAmortizedCostRptEntryInfo entry = rptEntryCol.get(i);
                this.tblMain.addRow();
                if (entry.getDate() != null) {
                    if (leaseInBillNewInfo != null && this.compareDateIfPreDay(leaseInBillNewInfo.getBeginDate(), entry.getDate())) {
                        this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                    }
                } else {
                    Calendar cld1 = Calendar.getInstance();
                    cld1.set(entry.getMonth() / 100, entry.getMonth() % 100 - 1, 1, 0, 0, 0);
                    if (leaseInBillNewInfo != null && this.compareDateIfPreDay(leaseBillChangeDate, cld1.getTime())) {
                        this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                    }
                }
                if (rptLeaseInBillInfo.getBizStatus() == FaLeaseBizStatusEnum.HAVE_RETROACTIVE_ADJUSTMENT) {
                    this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                this.tblMain.getRow(i).getCell(KEY_DATE).setValue((Object)entry.getDate());
                this.tblMain.getRow(i).getCell(KEY_MONTH).setValue((Object)entry.getMonth());
                this.tblMain.getRow(i).getCell(KEY_CASHFLOW).setValue((Object)this.formatOriginScale(entry.getCashflow(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_INITLIABILITYPRINCIPAL).setValue((Object)this.formatOriginScale(entry.getInitLiabilityPrincipal(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_INITUNCFMFNCCOST).setValue((Object)this.formatOriginScale(entry.getInitUnCfmFncCost(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_INITLIABILITYBALANCE).setValue((Object)this.formatOriginScale(entry.getInitLiabilityBalance(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_CURINTERESTPAYMENT).setValue((Object)this.formatOriginScale(entry.getCurInterestPayment(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_CURACCINTERESTPAYMENT).setValue((Object)this.formatOriginScale(entry.getCurAccInterestPayment(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_ENDLIABILITYPRINCIPAL).setValue((Object)this.formatOriginScale(entry.getEndLiabilityPrincipal(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_ENDUNCFMFNCCOST).setValue((Object)this.formatOriginScale(entry.getEndUnCfmFncCost(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_ENDLIABILITYBALANCE).setValue((Object)this.formatOriginScale(entry.getEndLiabilityBalance(), orginScale));
                this.tblMain.getRow(i).getCell(KEY_INITRIGHTOFUSEASSET).setValue((Object)this.formatDisplayBD(entry.getInitRightOfUseAsset()));
                this.tblMain.getRow(i).getCell(KEY_CURDEPRECIATION).setValue((Object)this.formatDisplayBD(entry.getCurDepreciation()));
                this.tblMain.getRow(i).getCell(KEY_CURACCDEPRECIATION).setValue((Object)this.formatDisplayBD(entry.getCurAccDepreciation()));
                this.tblMain.getRow(i).getCell(KEY_ENDRIGHTOFUSEASSET).setValue((Object)this.formatDisplayBD(entry.getEndRightOfUseAsset()));
                this.tblMain.getRow(i).getCell(KEY_InitialAssetDecValue).setValue((Object)this.formatDisplayBD(entry.getInitialAssetDecValue()));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String[] amtKeys = new String[]{KEY_INITRIGHTOFUSEASSET, KEY_CURDEPRECIATION, KEY_CURACCDEPRECIATION, KEY_ENDRIGHTOFUSEASSET, KEY_InitialAssetDecValue};
        String[] amtOCKeys = new String[]{KEY_INITLIABILITYPRINCIPAL, KEY_INITUNCFMFNCCOST, KEY_INITLIABILITYBALANCE, KEY_CURINTERESTPAYMENT, KEY_CURACCINTERESTPAYMENT, KEY_ENDLIABILITYPRINCIPAL, KEY_ENDUNCFMFNCCOST, KEY_ENDLIABILITYBALANCE};
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])amtKeys, (String)FaClientUtils.getDecimalFormat((int)this.currencyScale));
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])amtOCKeys, (String)FaClientUtils.getDecimalFormat((int)this.currencyScaleOC));
    }

    private BigDecimal formatDisplayBD(BigDecimal value) {
        if (value != null) {
            return value.setScale(this.currencyScale, 4);
        }
        return new BigDecimal("0").setScale(this.currencyScale);
    }

    private BigDecimal formatOriginScale(BigDecimal value, int percision) {
        if (value != null) {
            return value.setScale(percision, 4);
        }
        return new BigDecimal("0").setScale(this.currencyScale);
    }

    protected int getCurrencyScale(String Id) throws EASBizException, BOSException {
        return CurrencyFactory.getRemoteInstance().getValue("select precision where id='" + Id + "'").getInt("precision");
    }

    private BigDecimal formatDisplayOCBD(BigDecimal value) {
        if (value != null) {
            return value.setScale(this.currencyScaleOC, 4);
        }
        return new BigDecimal("0").setScale(this.currencyScaleOC);
    }

    protected CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        if (this.curCompany == null) {
            String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            this.curCompany = this.getCompanyById(companyID);
        }
        return this.curCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        sic.add(new SelectorItemInfo("accountTable"));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    private FaLeaseInBillNewCollection queryLeaseInBillCol(EntityViewInfo view) throws BOSException {
        String[] masks;
        HashMap<Integer, FilterItemInfo> addMap = new HashMap<Integer, FilterItemInfo>();
        HashMap<Integer, String> relateMap = new HashMap<Integer, String>();
        String oldMaskString = view.getFilter().getMaskString();
        if (oldMaskString == null) {
            return this.getLIBNBizInterface().getFaLeaseInBillNewCollection(view);
        }
        if (!view.getFilter().getFilterItems().toString().contains("lessor")) {
            return this.getLIBNBizInterface().getFaLeaseInBillNewCollection(view);
        }
        for (String s : masks = oldMaskString.trim().split(" #")) {
            if (!Character.valueOf(s.charAt(0)).toString().matches("[0-9]+")) continue;
            Integer key = Integer.parseInt(Character.valueOf(s.charAt(0)).toString());
            relateMap.put(key, s.substring(1));
        }
        StringBuilder newMaskString = new StringBuilder();
        newMaskString.append(masks[0]);
        int j = 0;
        for (int i = 0; i < view.getFilter().getFilterItems().size(); ++i) {
            FilterItemInfo info = view.getFilter().getFilterItems().get(i);
            String propertyName = (String)info.getStateManager().getStateValue("propertyName");
            if ("lessor".equalsIgnoreCase(propertyName)) {
                String oldString = info.toString();
                newMaskString.append("(").append(" #").append(j++).append(" OR");
                addMap.put(j - 1, new FilterItemInfo(oldString.replace("lessor", "supplierLessor.name")));
                newMaskString.append(" #").append(j++).append(" OR");
                addMap.put(j - 1, new FilterItemInfo(oldString.replace("lessor", "innerCompanyLessor.name")));
                newMaskString.append(" #").append(j++).append(" )").append((String)relateMap.get(i));
                addMap.put(j - 1, new FilterItemInfo(oldString.replace("lessor", "customerLessor.name")));
                continue;
            }
            newMaskString.append(" #").append(j++).append((String)relateMap.get(i));
            addMap.put(j - 1, info);
        }
        EntityViewInfo newView = new EntityViewInfo();
        newView.setFilter(new FilterInfo());
        newView.setSelector(new SelectorItemCollection());
        newView.setSorter(new SorterItemCollection());
        newView.getFilter().setMaskString(newMaskString.toString());
        for (int i = 0; i < addMap.size(); ++i) {
            newView.getFilter().getFilterItems().add((FilterItemInfo)addMap.get(i));
        }
        return this.getLIBNBizInterface().getFaLeaseInBillNewCollection(newView);
    }

    private FaAmortizedCostRptInfo queryACRptByBillId(BOSUuid billId) throws EASBizException, BOSException {
        return this.getACRBizInfterface().getACRptByBillId((IObjectPK)new ObjectUuidPK(billId));
    }

    private IFaLeaseInBillNew getLIBNBizInterface() throws BOSException {
        return FaLeaseInBillNewFactory.getRemoteInstance();
    }

    private IFaAmortizedCostRpt getACRBizInfterface() throws BOSException {
        return FaAmortizedCostRptFactory.getRemoteInstance();
    }

    private void reset() {
        this.curPageIndex = 0;
        this.curACRpt = null;
        this.curACRptColCache = new FaAmortizedCostRptCollection();
        this.curLeaseInBillCol = new FaLeaseInBillNewCollection();
    }

    private void setPageBtnsEn(boolean first, boolean pre, boolean next, boolean last) {
        this.btnFirst.setEnabled(first);
        this.btnPre.setEnabled(pre);
        this.btnNext.setEnabled(next);
        this.btnLast.setEnabled(last);
    }

    private void checkCache() throws EASBizException, BOSException {
        if (this.curACRptColCache.get(this.curPageIndex) == null || this.curACRptColCache.get(this.curPageIndex).getId() == null) {
            this.curACRpt = this.queryACRptByBillId(this.curLeaseInBillCol.get(this.curPageIndex).getId());
            if (this.curACRpt == null) {
                this.curACRpt = new FaAmortizedCostRptInfo();
                this.curACRptColCache.set(this.curPageIndex, this.curACRpt);
            } else {
                this.curACRptColCache.set(this.curPageIndex, this.curACRpt);
            }
        } else {
            this.curACRpt = this.curACRptColCache.get(this.curPageIndex);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.reset();
        this.loadData(this.billView);
        this.initUI();
        this.setData2UI();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.popFilterDialog();
    }

    @Override
    public void actionLinkViewBill_actionPerformed(ActionEvent e) throws Exception {
        if (this.curACRpt == null || this.curACRpt.getLeaseInBill() == null) {
            return;
        }
        Map uiContext = this.getUIContext();
        uiContext.put("ID", this.curACRpt.getLeaseInBill().getId().toString());
        uiContext.put("isFromInitBill", this.curACRpt.getLeaseInBill().isIsHistory());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaLeaseInNewEditUI.class.getName(), uiContext, null, "FINDVIEW");
        uiWindow.show();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        if (this.curLeaseInBillCol.size() < 0) {
            return;
        }
        this.curPageIndex = 0;
        this.checkCache();
        this.setData2UI();
        this.setPageBtnsEn(false, false, true, true);
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        if (this.curLeaseInBillCol.size() > 0 && this.curPageIndex > 0) {
            --this.curPageIndex;
            this.checkCache();
            this.setData2UI();
            if (this.curPageIndex > 0) {
                this.setPageBtnsEn(true, true, true, true);
            } else {
                this.setPageBtnsEn(false, false, true, true);
            }
        }
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        if (this.curLeaseInBillCol.size() > 0 && this.curPageIndex < this.curLeaseInBillCol.size() - 1) {
            ++this.curPageIndex;
            this.checkCache();
            this.setData2UI();
            if (this.curPageIndex < this.curLeaseInBillCol.size() - 1) {
                this.setPageBtnsEn(true, true, true, true);
            } else {
                this.setPageBtnsEn(true, true, false, false);
            }
        }
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        if (this.curLeaseInBillCol.size() < 0) {
            return;
        }
        this.curPageIndex = this.curLeaseInBillCol.size() - 1;
        this.checkCache();
        this.setData2UI();
        this.setPageBtnsEn(true, true, false, false);
    }

    private void setCurrencyScaleOC(String leaseBillId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        FaLeaseInBillNewInfo billInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseBillId), sic);
        this.currencyScaleOC = billInfo.getCurrency().getPrecision();
    }

    private Date getChangeDate(String faLeaseinBillNewId) throws BOSException, SQLException, ParseException, EASBizException {
        FaLeaseInBillNewInfo faLeaseInBillNewInfo;
        Date changeDate = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FChangeDate \n");
        sql.append("FROM T_FA_FaNLMChangeAssetItem \n");
        sql.append("WHERE FLEASEINBILLOLDID = '" + faLeaseinBillNewId + "'\n");
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rowSet.next()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            changeDate = sdf.parse(rowSet.getString("FChangeDate"));
        } else {
            changeDate = null;
        }
        if (changeDate != null && (faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(faLeaseinBillNewId))).getDepreciationMethod() == DepreciationMethodEnum.Second) {
            Calendar cld1 = Calendar.getInstance();
            cld1.setTime(changeDate);
            cld1.set(cld1.get(1), cld1.get(2), 1, 0, 0, 0);
            return cld1.getTime();
        }
        return changeDate;
    }

    private FaLeaseInBillNewInfo getNewBillInfo(String faLeaseinBillOldId) {
        FaLeaseInBillNewInfo newBillInfo = null;
        Date changeDate = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * \n");
        sql.append(" FROM T_FA_FaNLMChangeAssetItem \n");
        sql.append("WHERE FLEASEINBILLOLDID = '" + faLeaseinBillOldId + "'\n");
        try {
            IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            if (rowSet.next()) {
                newBillInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("FLEASEINBILLNEWID")));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                changeDate = sdf.parse(rowSet.getString("FChangeDate"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return newBillInfo;
    }

    private boolean compareDateIfPreDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        long DATE_TIME_MILLIS = 86400000L;
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        int subDay = (int)((cld2.getTimeInMillis() - cld1.getTimeInMillis()) / 86400000L);
        return subDay >= 0;
    }
}

