/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.client.TreeColumn;
import com.kingdee.eas.fi.nlm.FaPayFrequencyEnum;
import com.kingdee.eas.fi.nlm.client.AbstractFaAssetCalculationReportRptListUI;
import com.kingdee.eas.fi.nlm.client.FaAssetCalculationDetailListUI;
import com.kingdee.eas.fi.nlm.client.FaAssetCalculationRptCondUI;
import com.kingdee.eas.fi.nlm.client.FaLeaseInNewEditUI;
import com.kingdee.eas.fi.nlm.client.FaRptQueryPanel;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaAssetCalculationReportRptListUI
extends AbstractFaAssetCalculationReportRptListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaAssetCalculationReportRptListUI.class);
    private String company;
    private Date startDateField;
    private Date endDateField;
    private String leaseBillNumber;
    private CurrencyInfo currencyInfo;
    private int basePrecision = 2;
    public static String NLM_REPORT_EXPORT = "fa_assetcalculationreportrpt_export";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.lblPeriod.setVisible(false);
        this.btnViewCard.setEnabled(true);
    }

    @Override
    public void actionViewCard_actionPerformed(ActionEvent e) throws Exception {
        int selectRow;
        if (this.tblMain.getSelectManager().get() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((selectRow = this.tblMain.getSelectManager().get().getBeginRow()) == -1) {
            return;
        }
        ICell cardIdCell = this.tblMain.getRow(selectRow).getCell("FID");
        if (cardIdCell == null || cardIdCell.getValue() == null) {
            return;
        }
        String cardId = cardIdCell.getValue().toString();
        if (cardId != null && !cardId.trim().equals("")) {
            try {
                Map uiContext = this.getUIContext();
                uiContext.put("ID", cardId);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaLeaseInNewEditUI.class.getName(), uiContext, null, "FINDVIEW");
                uiWindow.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    @Override
    protected void initTable() {
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    FaAssetCalculationReportRptListUI.this.doTableDoubleClick(e);
                }
            }
        });
    }

    @Override
    protected void applyData(Map result) throws Exception {
        this.basePrecision = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currCompany.getBaseCurrency().getId())).getPrecision();
        this.result = result;
        this.resultSql = (FaDaoSqlObject)result.get("resultSql");
        if (result.get("tempTableName") != null) {
            this.tempTableName = result.get("tempTableName").toString();
        }
        this.initTableColumn(null);
        this.formatData();
        if (this.isVirtualMode()) {
            this.treeIdList = null;
            this.allIdList = null;
            this.firstLoadData = true;
            this.tblMain.getDataRequestManager().setDataRequestMode(1);
            this.tblMain.removeRows();
        }
    }

    @Override
    protected void fillDataToTable(IRowSet rows, int start) throws Exception {
        if (rows == null) {
            return;
        }
        KDTColumns cols = this.tblMain.getColumns();
        int rowIndex = start;
        rows.beforeFirst();
        while (rows.next()) {
            this.insertRow(rowIndex, rows, cols);
            ++rowIndex;
        }
    }

    @Override
    protected void initTableColumn(List sumColumnNames) {
        this.tblMain.checkParsed(true);
        this.initConditionField(this.getCustomCond());
        this.tblMain.getColumn("rentWithTax").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)this.basePrecision));
        this.tblMain.getColumn("rentWithoutTax").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)this.basePrecision));
        this.tblMain.getColumn("initialAsset").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)this.basePrecision));
    }

    @Override
    protected TreeColumn getTreeColumn() {
        return null;
    }

    @Override
    protected void initCommonQueryDialog() throws Exception {
        super.initCommonQueryDialog();
        this.commonQueryDialog.setHeight(430);
        this.commonQueryDialog.setWidth(540);
    }

    @Override
    protected boolean isShowFilter() {
        return true;
    }

    @Override
    protected boolean isShowSorter() {
        return true;
    }

    @Override
    protected PeriodInfo getProperStrartPeriodInfo() throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
    }

    @Override
    protected boolean isAllowVirtualOrg() {
        return false;
    }

    @Override
    protected void displayPeriodInfo() {
    }

    @Override
    protected FaRptQueryPanel getConditionUI() throws Exception {
        return new FaAssetCalculationRptCondUI();
    }

    @Override
    protected String getQueryName() {
        return "FaAssetCalculationReportQuery";
    }

    @Override
    protected String getDaoClassName() {
        return "FaAssetCalculationListDao";
    }

    private void initConditionField(Map conditionMap) {
        this.company = (String)conditionMap.get("def_company_id");
        this.startDateField = (Date)conditionMap.get("startDate");
        this.beginDate.setValue((Object)this.startDateField);
        this.endDateField = (Date)conditionMap.get("endDate");
        this.endDate.setValue((Object)this.endDateField);
        this.leaseBillNumber = (String)conditionMap.get("leaseBillNumber");
        this.currencyInfo = (CurrencyInfo)conditionMap.get("currencyID");
    }

    private void insertRow(int rowIndex, IRowSet rows, KDTColumns cols) throws SQLException {
        IRow row = this.tblMain.getRow2(rowIndex);
        if (row == null) {
            row = this.tblMain.addRow(rowIndex);
        }
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            String key = cols.getColumnKey(i);
            if ("fiAccountDate".equals(key) || "dpInitCfmDate".equals(key) || "beginDate".equals(key) || "endDate".equals(key) || "contractDiscountDate".equals(key)) {
                row.getCell(key).setValue((Object)rows.getDate(key));
            } else if ("payFrequency".equals(key)) {
                row.getCell(key).setValue((Object)(FaPayFrequencyEnum.getEnum(Integer.parseInt(rows.getObject(key).toString())) == null ? "" : FaPayFrequencyEnum.getEnum(Integer.parseInt(rows.getObject(key).toString())).getAlias()));
            } else {
                row.getCell(key).setValue(rows.getObject(key));
            }
            if ("initialAsset".equals(key)) {
                row.getCell(key).getStyleAttributes().setBackground(this.tblMain.getRequiredColor());
            }
            if ("calculationDetail".equals(key)) {
                row.getCell(key).getStyleAttributes().setFontColor(new Color(0, 162, 255, 255));
            }
            if (rows.getObject(key) != null) continue;
            row.getCell(key).getStyleAttributes().setBackground(new Color(222, 222, 222, 255));
        }
    }

    private void doTableDoubleClick(KDTMouseEvent e) {
        if (e.getColIndex() != this.tblMain.getColumnIndex("calculationDetail")) {
            return;
        }
        int rowNumber = e.getRowIndex();
        if (this.tblMain.getCell(rowNumber, "FID") == null) {
            return;
        }
        String billID = (String)this.tblMain.getCell(rowNumber, "FID").getValue();
        if (billID != null) {
            this.setCursorOfWair();
            UIContext modelContext = new UIContext();
            modelContext.put((Object)"CardID", (Object)billID);
            IUIWindow modelWindow = null;
            try {
                modelWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FaAssetCalculationDetailListUI.class.getName(), (Map)modelContext, null, null);
            }
            catch (UIException uiException) {
                uiException.printStackTrace();
            }
            if (modelWindow != null) {
                modelWindow.show();
            }
            this.setCursorOfDefault();
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        CompanyOrgUnitInfo company = this.currCompany;
        if (this.currCompany != null && user != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(company.getId());
            ObjectUuidPK userPk = new ObjectUuidPK(user.getId());
            String permItemName = NLM_REPORT_EXPORT;
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
        }
        super.actionExport_actionPerformed(e);
    }
}

