/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.FaDiscountRateFactory;
import com.kingdee.eas.fi.nlm.client.AbstractFaDiscountRateListUI;
import com.kingdee.eas.fi.nlm.client.FaDiscountRateEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FindDialog;
import com.kingdee.eas.framework.client.ListFind;
import com.kingdee.eas.util.client.EASResource;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FaDiscountRateListUI
extends AbstractFaDiscountRateListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaDiscountRateListUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.nlm.FaDiscountRateResource";
    private static final String KEY_DATE = "date";
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_LIFECYCLESTART = "lifeCycleStart";
    private static final String KEY_LIFECYCLEEND = "lifeCycleEnd";
    private static final String KEY_RATE = "rate";
    private static final String KEY_CU = "cu";
    private static final int RATE_PRECISION = 4;
    private static final int LIFECYCLE_PRECISION = 0;
    private static final BigDecimal MAX_LIFECYCLE = new BigDecimal("9999");
    private CompanyOrgUnitInfo curCompany;

    public void onLoad() throws Exception {
        FaClientUtils.checkBeforeOnload4Fl();
        super.onLoad();
        this.initUI();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String currentCompany = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        this.searchHigherLevelCU(currentCompany, filter);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" or #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        return filter;
    }

    private void initUI() throws EASBizException, BOSException {
        this.prmtCurrency.setRequired(false);
        this.datePicker.setValue(null);
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])new String[]{KEY_LIFECYCLESTART, KEY_LIFECYCLEEND}, (String)FaClientUtils.getDecimalFormat((int)0));
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])new String[]{KEY_RATE}, (String)FaClientUtils.getDecimalFormat((int)3));
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(KEY_DATE).setGroup(true);
        this.tblMain.getColumn(KEY_DATE).setMergeable(true);
        this.tblMain.getColumn(KEY_CURRENCY).setGroup(true);
        this.tblMain.getColumn(KEY_CURRENCY).setMergeable(true);
        this.tblMain.getColumn(KEY_CU).setGroup(true);
        this.tblMain.getColumn(KEY_CU).setMergeable(true);
        this.tblMain.getGroupManager().group();
    }

    private void initCheckPermissionUI() {
        this.menuEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
    }

    protected void initListener() {
        super.initListener();
        this.datePicker.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                CurrencyInfo currencyInfo = null;
                FilterInfo filterInfo = new FilterInfo();
                if (FaDiscountRateListUI.this.prmtCurrency.getValue() instanceof CurrencyInfo) {
                    currencyInfo = (CurrencyInfo)FaDiscountRateListUI.this.prmtCurrency.getValue();
                }
                if (e.getNewValue() != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(FaDiscountRateListUI.KEY_DATE, (Object)((Date)e.getNewValue())));
                }
                if (currencyInfo != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyInfo.getId()));
                }
                FaDiscountRateListUI.this.query(filterInfo);
                FaDiscountRateListUI.this.datePicker.transferFocus();
                FaDiscountRateListUI.this.tblMain.dispatchEvent((AWTEvent)new FocusEvent((Component)FaDiscountRateListUI.this.tblMain, 1004, true));
                FaDiscountRateListUI.this.tblMain.requestFocusInWindow();
            }
        });
        this.prmtCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (!(e.getNewValue() instanceof CurrencyInfo) && e.getNewValue() != null) {
                    if (!(e.getOldValue() instanceof CurrencyInfo)) {
                        FaDiscountRateListUI.this.prmtCurrency.setValue(null);
                    } else {
                        FaDiscountRateListUI.this.prmtCurrency.setValue(e.getOldValue());
                    }
                }
                Date date = (Date)FaDiscountRateListUI.this.datePicker.getValue();
                FilterInfo filterInfo = new FilterInfo();
                if (e.getNewValue() != null && e.getNewValue() instanceof CurrencyInfo) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)e.getNewValue()).getId()));
                }
                if (date != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(FaDiscountRateListUI.KEY_DATE, (Object)date));
                }
                FaDiscountRateListUI.this.query(filterInfo);
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int rowIndex = e.getSelectBlock().getTop();
                FaDiscountRateListUI.this.checkIfCurrentCompanyData(FaDiscountRateListUI.this.tblMain.getRow(rowIndex));
            }
        });
    }

    private void query(FilterInfo filterInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        try {
            this.excuteQuery(viewInfo, true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"118_FaDiscountRateListUI") + e.getMessage()));
        }
    }

    protected FindDialog getFindDialog() throws Exception {
        FindDialog findDialog = super.getFindDialog();
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        String[] locateNames = new String[]{KEY_DATE, KEY_CURRENCY, KEY_LIFECYCLESTART, KEY_LIFECYCLEEND, KEY_RATE, KEY_CU};
        ArrayList<ListFind> findPropertyName = new ArrayList<ListFind>();
        for (int i = 0; i < locateNames.length; ++i) {
            if (this.tblMain.getColumn(locateNames[i]) == null) continue;
            String cellValue = "";
            cellValue = locateNames[i].equals(KEY_LIFECYCLESTART) ? EASResource.getString((String)RESOURCE_PATH, (String)KEY_LIFECYCLESTART) : (locateNames[i].equals(KEY_LIFECYCLEEND) ? EASResource.getString((String)RESOURCE_PATH, (String)KEY_LIFECYCLEEND) : this.tblMain.getHeadRow(0).getCell(locateNames[i]).getValue().toString());
            ListFind cEnum = new ListFind(locateNames[i], cellValue);
            findPropertyName.add(cEnum);
        }
        findDialog = win instanceof Frame ? new FindDialog((Frame)win, "", findPropertyName, true) : new FindDialog((Dialog)win, "", findPropertyName, true);
        findDialog.addFindListListener(this.getFindListListener());
        return findDialog;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return FaDiscountRateEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaDiscountRateFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            ICell cell = this.tblMain.getCell(i, KEY_LIFECYCLEEND);
            if (!(cell.getValue() instanceof Integer && (Integer)cell.getValue() == 0 || cell.getValue() instanceof Integer && ((Integer)cell.getValue()).intValue() == MAX_LIFECYCLE.intValue()) && cell.getValue() != null) continue;
            cell.setValue((Object)"-");
        }
    }

    protected CompanyOrgUnitInfo getCurCompany() throws BOSException, EASBizException {
        if (this.curCompany == null) {
            this.curCompany = FaClientUtils.getCurrentCompany();
        }
        return this.curCompany;
    }

    private void searchHigherLevelCU(String currentCompany, FilterInfo filter) {
        if (currentCompany == null) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany, CompareType.EQUALS));
        try {
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
            AdminOrgUnitInfo orgUnitInfo = (AdminOrgUnitInfo)iAdmin.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany));
            if (orgUnitInfo == null || orgUnitInfo.getParent() == null) {
                this.searchHigherLevelCU(null, filter);
            } else {
                this.searchHigherLevelCU(orgUnitInfo.getParent().getId().toString(), filter);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("searchHigherLevelCU" + e.getMessage()));
        }
        catch (EASBizException e) {
            logger.error((Object)("searchHigherLevelCU" + e.getMessage()));
        }
    }

    private void checkIfCurrentCompanyData(IRow iRow) {
        String currentCompanyName = SysContext.getSysContext().getCurrentOrgUnit().getName();
        if (currentCompanyName.equals(iRow.getCell(6).getValue().toString())) {
            this.menuEdit.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionRemove.setVisible(true);
        } else {
            this.menuEdit.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
        }
    }
}

