/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.client.AbstractFaNewLeasePolicyListUI;
import com.kingdee.eas.fi.nlm.client.FaNewLeasePolicyEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class FaNewLeasePolicyListUI
extends AbstractFaNewLeasePolicyListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaNewLeasePolicyListUI.class);

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String currentCompany = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        this.searchHigherLevelCU(currentCompany, filter);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" or #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        return filter;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected String getEditUIName() {
        return FaNewLeasePolicyEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaNewLeasePolicyFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int rowIndex = e.getSelectBlock().getTop();
                ICell cell = FaNewLeasePolicyListUI.this.tblMain.getRow(rowIndex).getCell("deletedStatus");
                if (cell != null && ((Boolean)cell.getValue()).booleanValue()) {
                    FaNewLeasePolicyListUI.this.actionEdit.setEnabled(false);
                    FaNewLeasePolicyListUI.this.actionRemove.setEnabled(false);
                    FaNewLeasePolicyListUI.this.actionCancel.setEnabled(true);
                    FaNewLeasePolicyListUI.this.actionCancelCancel.setEnabled(false);
                } else {
                    FaNewLeasePolicyListUI.this.actionEdit.setEnabled(true);
                    FaNewLeasePolicyListUI.this.actionRemove.setEnabled(true);
                    FaNewLeasePolicyListUI.this.actionCancel.setEnabled(false);
                    FaNewLeasePolicyListUI.this.actionCancelCancel.setEnabled(true);
                }
                FaNewLeasePolicyListUI.this.checkIfCurrentCompanyData(FaNewLeasePolicyListUI.this.tblMain.getRow(rowIndex));
            }
        });
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelCancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelCancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
        }
        this.refreshList();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (!this.isDoRequestData() || this.mainQuery == null) {
            return;
        }
        if (this.isHasQyeryPK() && this.tblMain.getDataRequestManager().getDataRequestMode() == 1) {
            this.tblMain_doRequestRowSetForHasQueryPK(e);
        } else {
            this.tblMain_doRequestRowSetForNoQueryPK(e);
        }
    }

    private void searchHigherLevelCU(String currentCompany, FilterInfo filter) {
        if (currentCompany == null) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany, CompareType.EQUALS));
        try {
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
            AdminOrgUnitInfo orgUnitInfo = (AdminOrgUnitInfo)iAdmin.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany));
            if (orgUnitInfo == null || orgUnitInfo.getParent() == null) {
                this.searchHigherLevelCU(null, filter);
            } else {
                this.searchHigherLevelCU(orgUnitInfo.getParent().getId().toString(), filter);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("searchHigherLevelCU" + e.getMessage()));
        }
        catch (EASBizException e) {
            logger.error((Object)("searchHigherLevelCU" + e.getMessage()));
        }
    }

    private void checkIfCurrentCompanyData(IRow iRow) {
        String currentCompanyName = SysContext.getSysContext().getCurrentOrgUnit().getName();
        if (currentCompanyName.equals(iRow.getCell(5).getValue().toString())) {
            this.btnEdit.setVisible(true);
            this.btnRemove.setVisible(true);
            this.btnCancelCancel.setVisible(true);
            this.btnCancel.setVisible(true);
        } else {
            this.btnEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.btnCancel.setVisible(false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyIfRefToNewLeaseBill();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.verifyIfRefToNewLeaseBill();
        super.actionRemove_actionPerformed(e);
    }

    private void verifyIfRefToNewLeaseBill() throws BOSException, EASBizException {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String newLeasePolicyID = (String)idList.get(0);
        if (FaLeaseInBillNewFactory.getRemoteInstance().exists("where newLeasePolicyRef = '" + newLeasePolicyID + "'")) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"186_FaNewLeasePolicyEditUI"));
            SysUtil.abort();
        }
    }
}

