/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.PaymentBillUI;
import com.kingdee.eas.fi.cas.client.ReceivingBillUI;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLessorTypeEnum;
import com.kingdee.eas.fi.nlm.FaRentDirectionEnum;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillEntryCollection;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillEntryFactory;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillFactory;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillInfo;
import com.kingdee.eas.fi.nlm.client.AbstractFaRentSettlementBillEditUI;
import com.kingdee.eas.fi.nlm.client.FaLeaseInNewEditUI;
import com.kingdee.eas.fi.nlm.client.flutils.FlUtils;
import com.kingdee.eas.fi.nlm.client.print.FLPrintHelper;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaRentSettlementBillEditUI
extends AbstractFaRentSettlementBillEditUI {
    private static final long serialVersionUID = -7047123488308644645L;
    private static final Logger logger = CoreUIObject.getLogger(FaRentSettlementBillEditUI.class);
    private static final String RES_PATH_FA = "com.kingdee.eas.fi.fa.manage.FaResource";
    private static final String RES_PATH_RS = "com.kingdee.eas.fi.nlm.FaRentSettlementBillResource";
    private static final int DEFAULT_RATE_SCALE = 4;
    private static final int DEFAULT_CURRENCY_SCALE = 2;
    private int currencyScale = 2;
    private int currencyScaleOC = 2;
    private static final String KEY_PLANWITHTAXAMT = "planWithTaxAmt";
    private static final String KEY_TAXRATE = "taxRate";
    private static final String KEY_TAXAMT = "taxAmt";
    private static final String KEY_PLANWITHOUTTAXAMT = "planWithoutTaxAmt";
    private static final String KEY_WITHTAXAMT = "withTaxAmt";
    private static final String KEY_FIVOUCHERED = "fiVouchered";
    private boolean isEnableCrossPeriodVoucherGeneration = false;
    private CompanyOrgUnitInfo currCompany;
    private FaRentSettlementBillEntryCollection curSelectedEntryCol = null;

    public void onLoad() throws Exception {
        block2: {
            try {
                FaClientUtils.checkBeforeOnload4Fl((Map)this.getUIContext(), (CompanyOrgUnitInfo)this.getCurrentCompany());
            }
            catch (EASBizException e) {
                if ("002".equals(e.getSubCode())) break block2;
                throw e;
            }
        }
        super.onLoad();
        this.currencyScale = this.getCurrentCompany().getBaseCurrency().getPrecision();
        this.initUI();
        this.setTextFieldOCPrecision(this.editData.getCurrency());
    }

    private void initUI() {
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnVoucher.setVisible(true);
        this.btnDelVoucher.setVisible(true);
        this.menuWorkflow.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.menuItemSubmit.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.menuView.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuItemCreateFrom.setVisible(false);
        this.btnLinkViewLeaseBill.setEnabled(true);
        this.btnLinkViewRPBill.setEnabled(true);
        this.actionAttachment.setEnabled(true);
        this.numTxtWithTaxAmt.setPrecision(this.currencyScale);
        this.kdtEntry.getSelectManager().setSelectMode(10);
        FaClientUtils.changeTableNumberFormat((KDTable)this.kdtEntry, (String[])new String[]{KEY_TAXRATE}, (String)FaClientUtils.getDecimalFormat((int)3));
        FaClientUtils.changeTableNumberFormat((KDTable)this.kdtEntry, (String[])new String[]{KEY_PLANWITHTAXAMT, KEY_TAXAMT, KEY_PLANWITHOUTTAXAMT, KEY_WITHTAXAMT}, (String)FaClientUtils.getDecimalFormat((int)this.currencyScale));
    }

    private void updateDapBtnStatus(boolean isAfterLoadField) {
        try {
            this.isEnableCrossPeriodVoucherGeneration = FaManageUtils.getFaParamValue(null, (String)"NLM_310", (String)this.getCurrentCompany().getId().toString());
            PeriodInfo currentPeriod = FaClientUtils.getFLCurrentPeriod((CompanyOrgUnitInfo)FaClientUtils.getCurrentCompany());
            Date planDate = new Date();
            if (this.editData != null) {
                planDate = this.editData.getEntries().get(0).getPlanDate();
            }
            boolean fiVouchered = false;
            if (isAfterLoadField) {
                fiVouchered = this.editData.isFiVouchered();
            } else {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(KEY_FIVOUCHERED);
                CoreBaseInfo sourceBill = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
                fiVouchered = sourceBill.getBoolean(KEY_FIVOUCHERED);
            }
            if (fiVouchered) {
                this.actionVoucher.setEnabled(false);
                this.actionDelVoucher.setEnabled(true);
                if (!(this.isEnableCrossPeriodVoucherGeneration || planDate.compareTo(currentPeriod.getBeginDate()) >= 0 && planDate.compareTo(currentPeriod.getEndDate()) <= 0)) {
                    this.actionDelVoucher.setEnabled(false);
                }
            } else {
                this.actionVoucher.setEnabled(true);
                this.actionDelVoucher.setEnabled(false);
                if (!(this.isEnableCrossPeriodVoucherGeneration || planDate.compareTo(currentPeriod.getBeginDate()) >= 0 && planDate.compareTo(currentPeriod.getEndDate()) <= 0)) {
                    this.actionVoucher.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("leaseInBill.id");
        sic.add("leaseInBill.number");
        sic.add("leaseInBill.lessorType");
        sic.add("leaseInBill.CustomerLessor.id");
        sic.add("leaseInBill.InnerCompanyLessor.id");
        sic.add("leaseInBill.SupplierLessor.id");
        sic.add("currency.*");
        sic.add("entries.id");
        FaRentSettlementBillInfo bill = FaRentSettlementBillFactory.getRemoteInstance().getFaRentSettlementBillInfo(pk, sic);
        if (bill == null) {
            return null;
        }
        sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("voucher.id");
        sic.add("voucher.number");
        Date planDateFrom = (Date)this.getUIContext().get("planDateFrom");
        Date planDateTo = (Date)this.getUIContext().get("planDateTo");
        Integer genRpBill = (Integer)this.getUIContext().get("genRpBill");
        FilterInfo filter = new FilterInfo();
        if (planDateFrom != null) {
            filter.getFilterItems().add(new FilterItemInfo("planDate", (Object)planDateFrom, CompareType.GREATER_EQUALS));
        }
        if (planDateTo != null) {
            filter.getFilterItems().add(new FilterItemInfo("planDate", (Object)planDateTo, CompareType.LESS_EQUALS));
        }
        if (genRpBill != null) {
            filter.getFilterItems().add(new FilterItemInfo("genRpBill", (Object)genRpBill, CompareType.LESS_EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)pk.toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        FaRentSettlementBillEntryCollection entryCol = FaRentSettlementBillEntryFactory.getRemoteInstance().getFaRentSettlementBillEntryCollection(view);
        bill.put("entries", (Object)entryCol);
        return bill;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setLessor();
        this.updateDapBtnStatus(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected IObjectValue createNewData() {
        return new FaRentSettlementBillInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaRentSettlementBillFactory.getRemoteInstance();
    }

    private void setLessor() {
        Object itemObj = this.comboBoxLessorType.getSelectedItem();
        if (itemObj == null) {
            return;
        }
        FaLessorTypeEnum item = (FaLessorTypeEnum)((Object)itemObj);
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            switch (item.getValue()) {
                case 2: {
                    if (this.editData.getLeaseInBill().getCustomerLessor() == null) break;
                    this.prmtLessor.setValue((Object)CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(this.editData.getLeaseInBill().getCustomerLessor().getId()), selector));
                    break;
                }
                case 3: {
                    if (this.editData.getLeaseInBill().getInnerCompanyLessor() == null) break;
                    this.prmtLessor.setValue((Object)CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.editData.getLeaseInBill().getInnerCompanyLessor().getId()), selector));
                    break;
                }
                case 1: {
                    if (this.editData.getLeaseInBill().getSupplierLessor() == null) break;
                    this.prmtLessor.setValue((Object)SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(this.editData.getLeaseInBill().getSupplierLessor().getId()), selector));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private BigDecimal formatDisplayBD(BigDecimal value) {
        if (value != null) {
            return value.setScale(this.currencyScale, 4);
        }
        return BigDecimal.ZERO;
    }

    protected CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        if (this.currCompany == null) {
            String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            this.currCompany = this.getCompanyById(companyID);
        }
        return this.currCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    private void invokePrint(boolean preview) throws Exception {
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        BOSQueryDelegate data = FLPrintHelper.getPrintManagerForFaRentSettlementEditUI((IObjectCollection)billCol, new KDTable[]{this.kdtEntry});
        if (preview) {
            appHlp.printPreview("/FI/FL/FaRentSettlementBill", (Object)data, (Component)((Object)this));
        } else {
            appHlp.print("/FI/FL/FaRentSettlementBill", (Object)data, (Component)((Object)this));
        }
    }

    private void updateEntriesVoucherStatus() throws EASBizException, BOSException, Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(KEY_FIVOUCHERED);
        sic.add("voucher.id");
        sic.add("voucher.number");
        FaRentSettlementBillInfo srcBill = (FaRentSettlementBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
        this.editData.setFiVouchered(srcBill.isFiVouchered());
        this.editData.setVoucher(srcBill.getVoucher());
        this.editData.getEntries().get(0).setFiVouchered(srcBill.isFiVouchered());
        this.editData.getEntries().get(0).setVoucher(srcBill.getVoucher());
        this.loadFields();
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkTerminateForCreatTo();
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkForGenVoucher4Fl();
        this.checkTerminate();
        super.actionVoucher_actionPerformed(e);
        this.updateDapBtnStatus(false);
        this.updateEntriesVoucherStatus();
    }

    private void checkTerminate() throws EASBizException, BOSException {
        if (this.editData != null) {
            FaRentSettlementBillFactory.getRemoteInstance().checkTerminated(this.editData.getLeaseBillId(), this.editData.getEntries().get(0).getPlanDate());
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        this.updateDapBtnStatus(false);
        this.updateEntriesVoucherStatus();
    }

    @Override
    public void actionLinkViewLeaseBill_actionPerformed(ActionEvent e) throws Exception {
        String leaseBillId = this.editData.getLeaseBillId();
        if (leaseBillId == null) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("isHistory");
        FaLeaseInBillNewInfo leaseInBillInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseBillId), selector);
        Map uiContext = this.getUIContext();
        uiContext.put("ID", leaseBillId);
        uiContext.put("isFromInitBill", leaseInBillInfo.isIsHistory());
        if (this.editData.getRentDirection() == FaRentDirectionEnum.RENT_IN) {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaLeaseInNewEditUI.class.getName(), uiContext, null, "FINDVIEW");
            uiWindow.show();
        }
        uiContext.put("ID", this.editData.getId().toString());
    }

    @Override
    public void actionLinkViewRPBill_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            return;
        }
        if (this.curSelectedEntryCol == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FaRentSettlementBillResource.selectOneEntryAtLeast"));
            SysUtil.abort();
        }
        String billId = this.curSelectedEntryCol.get(0).getRpBillId();
        boolean genRpBill = this.curSelectedEntryCol.get(0).isGenRpBill();
        if (billId == null && !genRpBill) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FaRentSettlementBillResource.notPaidOrReceived"));
            SysUtil.abort();
        }
        if (billId == null && genRpBill) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FaRentSettlementBillResource.isHistoryPlan"));
            SysUtil.abort();
        }
        Map uiContext = this.getUIContext();
        uiContext.put("ID", billId);
        IUIWindow uiWindow = this.editData.getRentDirection() == FaRentDirectionEnum.RENT_IN ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(PaymentBillUI.class.getName(), uiContext, null, "FINDVIEW") : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ReceivingBillUI.class.getName(), uiContext, null, "FINDVIEW");
        uiWindow.show();
        uiContext.put("ID", this.editData.getId().toString());
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrint(true);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrint(false);
    }

    private void setTextFieldOCPrecision(CurrencyInfo currencyInfo) {
        if (currencyInfo == null || currencyInfo.getPrecision() == 0) {
            return;
        }
        this.currencyScaleOC = currencyInfo.getPrecision();
        this.kdtEntry.getColumn(KEY_PLANWITHTAXAMT).getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)currencyInfo.getPrecision()));
        this.kdtEntry.getColumn(KEY_TAXAMT).getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)currencyInfo.getPrecision()));
        this.kdtEntry.getColumn(KEY_PLANWITHOUTTAXAMT).getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)currencyInfo.getPrecision()));
    }

    private void checkTerminateForCreatTo() throws BOSException {
        if (this.editData != null) {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT bill.FID FROM T_Fa_FaTerminateBill bill, T_Fa_FaTerminateBillEntry entry ");
            sql.append("WHERE bill.FID = entry.FBillId AND entry.FLeaseInBillId = '" + this.editData.getLeaseBillId() + "' AND bill.FTerminateDate <= {d '" + this.editData.getEntries().get(0).getPlanDate() + "'}");
            IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            try {
                if (rowSet.next()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FaRentSettlementBillResource.hasTerminated"));
                    SysUtil.abort();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
        FlUtils.checkAdjustmentPeriodForNLM(e.getActionCommand());
    }
}

