/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.excelUtils.ExcelUtil;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.fi.nlm.NlmListFactory;
import com.kingdee.eas.fi.nlm.client.AbstractFaRptLeaseInNewExportLedgerConditionUI;
import com.kingdee.eas.fi.nlm.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.nlm.client.FaRptLeaseInNewStatusConditionUI;
import com.kingdee.eas.fi.nlm.client.view.FLCompanyTreeSelectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FaRptLeaseInNewExportLedgerConditionUI
extends AbstractFaRptLeaseInNewExportLedgerConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(FaRptLeaseInNewExportLedgerConditionUI.class);
    private static final String EXCEL2003 = "excel97-2003(.xls)";
    private static final String EXCEL2007 = "excel2007(.xlsx)";
    private static final String EXCEL2003_SUFFIX = ".xls";
    private static final String EXCEL2007_SUFFIX = ".xlsx";
    private KDFileChooser chooser;
    protected JDialog dialog;
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.nlm.FaRptLeaseInNewExportLedgerConditionUIResource";
    private CompanyTreeSelectUI ctsUI;
    protected static final String START_PERIOD_YEAR = "startYear";
    protected static final String START_PERIOD_NUMBER = "startNumber";
    protected static final String END_PERIOD_YEAR = "endYear";
    protected static final String END_PERIOD_NUMBER = "endNumber";
    protected static final String BALANCE_DISPALYDATE = "balanceDispalyAsOfDate";
    private static final HashMap<String, String> relaMap = new HashMap();
    private PeriodInfo currentPeriod;
    private static final String[] head;
    private static final List<String> needAddColumns;
    private Integer startYear;
    private Integer endYear;
    private Integer startNumber;
    private Integer endNumber;
    private Date balanceDispalyAsOfDate;
    private CompanyOrgUnitInfo curCompany;
    private HSSFCellStyle headColumnStyle = null;
    private HSSFCellStyle commTotalStyle;
    private HSSFCellStyle commStyle;
    private XSSFCellStyle headColumnStyle_2007 = null;
    private XSSFCellStyle commTotalStyle_2007;
    private XSSFCellStyle commStyle_2007;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;
    private boolean isVirCompany;

    public FaRptLeaseInNewExportLedgerConditionUI() throws Exception {
        this.addListener();
        this.chooser = new KDFileChooser();
        this.chooser.setFileFilter((FileFilter)new FileNameExtensionFilter(EXCEL2007, "xlsx"));
        this.chooser.setAcceptAllFileFilterUsed(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws EASBizException, BOSException {
        this.btnExport.setVisible(true);
        this.btnExport.setEnabled(true);
        this.curCompany = FaClientUtils.getCurrentCompany();
        boolean bl = this.isVirCompany = !this.curCompany.isIsBizUnit();
        if (this.curCompany.isIsBizUnit()) {
            this.boxCompany.setValue((Object)this.curCompany);
            this.btnCompany.setVisible(false);
            this.btnCompany.setEnabled(false);
            this.boxCompany.setEnabled(false);
        } else {
            this.boxCompany.setEnabled(false);
            this.boxCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
            if (this.boxCompany.getData() == null) {
                this.spnStartYear.setEnabled(false);
                this.spnStartNumber.setEnabled(false);
                this.spnEndYear.setEnabled(false);
                this.spnEndNumber.setEnabled(false);
            }
        }
        this.currentPeriod = this.getCurrentPeriod();
        if (this.currentPeriod != null) {
            this.spnStartYear.setValue((Object)this.currentPeriod.getPeriodYear());
            this.spnStartNumber.setValue((Object)this.currentPeriod.getPeriodNumber());
            this.spnEndYear.setValue((Object)this.currentPeriod.getPeriodYear());
            this.spnEndNumber.setValue((Object)this.currentPeriod.getPeriodNumber());
        }
        if (this.currentPeriod != null) {
            this.BoxBalanceDispalyAsOfDate.setValue((Object)this.currentPeriod.getEndDate());
        }
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.boxCompany.getData());
        if (this.boxCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.boxCompany.getData());
        }
        this.dialog.show();
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        super.btnExport_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    protected void BoxBalanceDispalyAsOfDate_dataChanged(DataChangeEvent e) throws Exception {
        this.BoxBalanceDispalyAsOfDate.setValue((Object)this.getMonEnd());
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setVisible(false);
        this.disposeUIWindow();
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.balanceDispalyAsOfDate = (Date)this.BoxBalanceDispalyAsOfDate.getValue();
        if (this.balanceDispalyAsOfDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"isBalanceDispalyAsOfDateNotNull"));
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String time = sdf.format(new Date());
        String defaultName = EASResource.getString((String)RESOURCE_PATH, (String)"default_name") + time;
        this.chooser.setSelectedFile(new File(defaultName));
        int rVal = this.chooser.showSaveDialog((Component)((Object)this));
        if (rVal == 0) {
            String description = this.chooser.getFileFilter().getDescription();
            String fileName = this.chooser.getSelectedFile().toString();
            if (!fileName.endsWith(description = EXCEL2003.equals(description) ? EXCEL2003_SUFFIX : EXCEL2007_SUFFIX)) {
                this.txtFilePath.setText(this.chooser.getSelectedFile().toString() + description);
            } else {
                this.txtFilePath.setText(this.chooser.getSelectedFile().toString());
            }
        } else {
            return;
        }
        String path = this.txtFilePath.getText();
        File file = new File(path);
        URI uri = file.toURI();
        uri = uri.normalize();
        path = uri.toString();
        if (path == null || path.trim().length() == 0) {
            this.txtFilePath.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"select_file_first"));
            return;
        }
        if (file.exists() && file.isFile()) {
            String option = EASResource.getString((String)RESOURCE_PATH, (String)"isFileCoverWith");
            if (0 != MsgBox.showConfirm2((String)option)) {
                return;
            }
        } else {
            file.createNewFile();
        }
        if (file != null) {
            String alias = this.getRptTitle() + " export fileName:" + file.getName() + " export UI:" + ((Object)((Object)this)).getClass().getName();
            BOSObjectType bosObjectType = BOSObjectType.create((String)"EXPEXCEL");
            IObjectPK logPK = LogUtil.beginLog(null, (String)"export", (BOSObjectType)bosObjectType, null, (String)alias);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
        if (!path.endsWith(EXCEL2003_SUFFIX) && path.endsWith(EXCEL2007_SUFFIX)) {
            this.export2007(path, file);
        }
    }

    @Override
    public void actionFileOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionFileOpen_actionPerformed(e);
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        FaRptLeaseInNewStatusConditionUI ui = new FaRptLeaseInNewStatusConditionUI();
        this.ctsUI = new FLCompanyTreeSelectUI(ui);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.boxCompany.getData());
        if (this.boxCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.boxCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaRptLeaseInNewExportLedgerConditionUI.this.boxCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export2003(String path, File file) throws BOSException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "sheet1");
        List<Map<String, Object>> resultList = this.getResultList();
        HSSFRow headRow = sheet.createRow(0);
        for (int i = 0; i < head.length; ++i) {
            HSSFCell headCell = headRow.createCell(i);
            headCell.setCellValue((RichTextString)new HSSFRichTextString(head[i]));
            headCell.setCellType(CellType.STRING);
            headCell.setCellStyle(this.getHeadColumnStyle(wb));
        }
        HSSFRow rowData = null;
        for (int i = 0; i < resultList.size(); ++i) {
            Map<String, Object> rows = resultList.get(i);
            rowData = sheet.createRow(i + 1);
            HSSFCell cell = null;
            for (int j = 0; j < head.length; ++j) {
                HSSFCellStyle style;
                cell = rowData.createCell(j);
                if (needAddColumns.contains(head[j])) {
                    if (rows.get(head[j]) == null) {
                        cell.setCellType(CellType.STRING);
                        cell.setCellValue("");
                    } else {
                        cell.setCellValue(((BigDecimal)rows.get(head[j])).doubleValue());
                        cell.setCellType(CellType.NUMERIC);
                    }
                    style = this.getCellStyle2003(wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
                    style.setAlignment(HorizontalAlignment.RIGHT);
                    cell.setCellStyle(style);
                    continue;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString((String)rows.get(head[j])));
                cell.setCellType(CellType.STRING);
                style = this.getCellStyle2003(wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
                style.setAlignment(HorizontalAlignment.LEFT);
                cell.setCellStyle(style);
            }
        }
        try {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                String msg = EASResource.getString((String)RESOURCE_PATH, (String)"success_to") + path;
                MsgBox.showInfo((String)msg);
                this.disposeUIWindow();
            }
            catch (FileNotFoundException e1) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileopened"));
                SysUtil.abort();
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            finally {
                if (out != null) {
                    FaRptLeaseInNewExportLedgerConditionUI.safeClose(out);
                }
            }
            ExcelUtil.showFile((String)path);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export2007(String path, File file) throws BOSException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "sheet1");
        XSSFRow headRow = sheet.createRow(0);
        for (int i = 0; i < head.length; ++i) {
            XSSFCell headCell = headRow.createCell(i);
            headCell.setCellValue((RichTextString)new XSSFRichTextString(head[i]));
            headCell.setCellType(CellType.STRING);
            headCell.setCellStyle((CellStyle)this.getHeadColumnStyle(wb));
        }
        List<Map<String, Object>> resultList = this.getResultList();
        XSSFRow rowData = null;
        for (int i = 0; i < resultList.size(); ++i) {
            Map<String, Object> rows = resultList.get(i);
            rowData = sheet.createRow(i + 1);
            XSSFCell cell = null;
            for (int j = 0; j < head.length; ++j) {
                XSSFCellStyle style;
                cell = rowData.createCell(j);
                if (needAddColumns.contains(head[j])) {
                    if (rows.get(head[j]) == null) {
                        cell.setCellType(CellType.STRING);
                        cell.setCellValue("");
                    } else {
                        cell.setCellValue(((BigDecimal)rows.get(head[j])).doubleValue());
                        cell.setCellType(CellType.NUMERIC);
                    }
                    style = this.getCellStyle2007(wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
                    style.setAlignment(HorizontalAlignment.RIGHT);
                    cell.setCellStyle((CellStyle)style);
                    continue;
                }
                cell.setCellValue((RichTextString)new XSSFRichTextString((String)rows.get(head[j])));
                cell.setCellType(CellType.STRING);
                style = this.getCellStyle2007(wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
                style.setAlignment(HorizontalAlignment.LEFT);
                cell.setCellStyle((CellStyle)style);
            }
        }
        try {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                String msg = EASResource.getString((String)RESOURCE_PATH, (String)"success_to") + path;
                MsgBox.showInfo((String)msg);
                this.disposeUIWindow();
            }
            catch (FileNotFoundException e1) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileopened"));
                SysUtil.abort();
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            finally {
                if (out != null) {
                    FaRptLeaseInNewExportLedgerConditionUI.safeClose(out);
                }
            }
            ExcelUtil.showFile((String)path);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private HSSFCellStyle getCellStyle2003(HSSFWorkbook wb, short bgcolor) {
        HSSFCellStyle numberStyle = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        numberStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return numberStyle;
    }

    private XSSFCellStyle getCellStyle2007(XSSFWorkbook wb, short bgcolor) {
        XSSFCellStyle numberStyle = wb.createCellStyle();
        XSSFDataFormat format = wb.createDataFormat();
        numberStyle.setDataFormat(format.getFormat("@"));
        return numberStyle;
    }

    private HSSFCellStyle getHeadColumnStyle(HSSFWorkbook wb) {
        this.headColumnStyle = wb.createCellStyle();
        this.headColumnStyle.setBorderBottom(BorderStyle.THIN);
        this.headColumnStyle.setBorderTop(BorderStyle.THIN);
        this.headColumnStyle.setBorderLeft(BorderStyle.THIN);
        this.headColumnStyle.setBorderRight(BorderStyle.THIN);
        this.headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
        this.headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.headColumnStyle.setHidden(false);
        return this.headColumnStyle;
    }

    private XSSFCellStyle getHeadColumnStyle(XSSFWorkbook wb) {
        this.headColumnStyle_2007 = wb.createCellStyle();
        this.headColumnStyle_2007.setBorderBottom(BorderStyle.THIN);
        this.headColumnStyle_2007.setBorderTop(BorderStyle.THIN);
        this.headColumnStyle_2007.setBorderLeft(BorderStyle.THIN);
        this.headColumnStyle_2007.setBorderRight(BorderStyle.THIN);
        this.headColumnStyle_2007.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
        this.headColumnStyle_2007.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.headColumnStyle_2007.setAlignment(HorizontalAlignment.CENTER);
        this.headColumnStyle_2007.setVerticalAlignment(VerticalAlignment.CENTER);
        this.headColumnStyle_2007.setHidden(false);
        return this.headColumnStyle_2007;
    }

    private List<Map<String, Object>> getResultList() throws BOSException {
        this.startYear = (Integer)this.spnStartYear.getValue();
        this.endYear = (Integer)this.spnEndYear.getValue();
        this.startNumber = (Integer)this.spnStartNumber.getValue();
        this.endNumber = (Integer)this.spnEndNumber.getValue();
        this.balanceDispalyAsOfDate = (Date)this.BoxBalanceDispalyAsOfDate.getValue();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String condDateString = sdf.format(this.balanceDispalyAsOfDate);
        String condDateYearString = condDateString.split("-")[0];
        String condDateMonthString = condDateString.split("-")[1];
        LocalDate tempDate = LocalDate.parse(condDateString);
        LocalDate monthEnd = tempDate.with(TemporalAdjusters.lastDayOfMonth());
        String monthEndString = monthEnd.toString();
        ArrayList<String> companyIds = new ArrayList<String>();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (!this.btnCompany.isEnabled()) {
            companyIds.add(((CompanyOrgUnitInfo)this.boxCompany.getData()).getId().toString());
        } else {
            this.buildCompanIdList((TreeNode)this.boxCompany.getData(), companyIds);
        }
        int startFNumber = String.valueOf(this.startNumber).getBytes().length == 1 ? Integer.valueOf(String.valueOf(this.startYear).concat("0").concat(String.valueOf(this.startNumber))).intValue() : Integer.valueOf(String.valueOf(this.startYear).concat(String.valueOf(this.startNumber))).intValue();
        int endFNumber = String.valueOf(this.endNumber).getBytes().length == 1 ? Integer.valueOf(String.valueOf(this.endYear).concat("0").concat(String.valueOf(this.endNumber))).intValue() : Integer.valueOf(String.valueOf(this.endYear).concat(String.valueOf(this.endNumber))).intValue();
        StringBuilder sql = new StringBuilder();
        sql.append("select DISTINCT\r\n\t\"ComName\",\r\n\t\"BillName\",\r\n\t\"ConName\",\r\n\t\"UseType\",\r\n\t\"UseClass\",\r\n\t\"UseDep\",\r\n\t\"ConNumber\",\r\n\t\"LessorName\",\r\n\t\"LeaseCycle\",\r\n\t\"LeaseBegin\",\r\n\t\"LeaseEnd\",\r\n\t\"BeleftMonth\",\r\n\t\"RentWithoutTax\",\r\n\t\"CostPmWithoutTax\",\r\n\t\"InitProperty\",\r\n\t\"PropertyCurent\",\r\n\t\"AccDep\",\r\n\t\"AssetDecValue\",\r\n\t\"NetValue\",\r\n\t\"AccPayment\",\r\n\t\"OrgValue\",\r\n\t\"LeasePayCur\",\r\n\t\"UnFee\",\r\n\t\"UnCurFee\",\r\n\t\"LeaseOrgValue\",\r\n\t\"LeaseCurFee\",\r\n\t\"ConStatus\",\r\n\t\"TerDate\", \r\n    ofnumber\r\nfrom\r\n\t(select\r\n\t\tbill.fid,\r\n\t\tbill.FPERIODID,\r\n\t\tbill.FCOMPANYID,\r\n\t\tbill.FUSEDEPARTMENTID,\r\n\t\tbill.FNumber \"BillName\",\r\n\t\tbill.FContractName \"ConName\",\r\n\t\tcat.FName_l2 \"UseClass\",\r\n\t\tbill.FContractNumber \"ConNumber\",\r\n\t\tbill.FLeaseCycle \"LeaseCycle\",\r\n\t\tbill.FBeginDate \"LeaseBegin\",\r\n\t\tbill.FEndDate \"LeaseEnd\",\r\n\t\tbill.FRentWithoutTaxNew \"RentWithoutTax\",\r\n\t\tbill.FCostPmWithoutTax1 \"CostPmWithoutTax\",\r\n\t\t(case\r\n\t\t\twhen (bill.FLeaseType='1' or bill.FLeaseType is null) then bill.FInitialAsset\r\n\t\t\telse bill.FinanceInitialAsset\r\n\t\tend) \"InitProperty\",\r\n\t\t(case\r\n\t\t\twhen (bill.FLeaseType='1' or bill.FLeaseType is null) then bill.FInitialLiability\r\n\t\t\telse bill.FinanceReLiabilityWithTax\r\n\t\tend) \"OrgValue\",\r\n\t\t(case\r\n\t\t\twhen (bill.FLeaseType='1' or bill.FLeaseType is null) then bill.FUnrecognizedFinanceFee\r\n\t\t\telse bill.FinanceReUnrFinExpenses\r\n\t\tend) \"UnFee\",\t\t\r\n\t\tcase (bill.FBizStatus)\r\n\t\t    WHEN 0 THEN '\u6b63\u5728\u65b0\u589e' \r\n\t\t\tWHEN 1 THEN '\u65b0\u589e\u5b8c\u6bd5'\r\n\t\t\tWHEN 2 THEN '\u6b63\u5728\u53d8\u66f4'\r\n\t\t\tWHEN 3 THEN '\u53d8\u66f4\u5b8c\u6bd5'\r\n\t\t\tWHEN 4 THEN '\u6b63\u5728\u7ec8\u6b62'\r\n\t\t\tWHEN 5 THEN '\u7ec8\u6b62\u5b8c\u6bd5'\r\n\t\t\tWHEN 6 THEN '\u6b63\u5728\u8c03\u6574'\r\n\t\t\tWHEN 7 THEN '\u8c03\u6574\u5b8c\u6bd5'\r\n\t\t\tWHEN 8 THEN '\u6b63\u5728\u51cf\u503c'\r\n\t\t\tWHEN 9 THEN '\u51cf\u503c\u5b8c\u6bd5'\r\n\t\t\tWHEN 10 THEN '\u6b63\u5728\u8ffd\u6eaf\u8c03\u6574'\r\n\t\t\tWHEN 11 THEN '\u8ffd\u6eaf\u8c03\u6574\u5b8c\u6bd5'\r\n\t\t\tELSE '' END \"ConStatus\",\r\n\t\t((CASE \r\n\t\t\tWHEN (supplierlessor.FName_l2 IS NULL) THEN N'' \r\n\t\t\tELSE supplierlessor.FName_l2 \r\n\t\tEND || CASE  \r\n\t\t\tWHEN (innercompanylessor.FName_l2 IS NULL) THEN N'' \r\n\t\t\tELSE innercompanylessor.FName_l2 \r\n\t\tEND) || CASE  \r\n\t\t\tWHEN (customerlessor.FName_l2 IS NULL) THEN N'' \r\n\t\t\tELSE customerlessor.FName_l2 \r\n\t\tEND) \"LessorName\",\r\n\t\t(case \r\n\t\t\twhen (cat.FPARENTID is null) THEN cat.FName_l2 \r\n\t\t\tELSE (SELECT FName_l2 from T_FA_FAContractCat where fid =cat.FPARENTID) end) \"UseType\",\r\n\t\t\t(case \r\n\t\t\t\twhen dayofmonth(bill.FENDDATE) - dayofmonth(date'" + monthEndString + "') >=0 then  ((year(bill.FENDDATE) - \r\n\t\t\t\tyear(date'" + monthEndString + "')) * 12 + month(bill.FENDDATE) - month(date'" + monthEndString + "') +1) \r\n\t\t\t\telse ((year(bill.FENDDATE) - \r\n\t\t\t\tyear(date'" + monthEndString + "')) * 12 +  month(bill.FENDDATE) - \r\n\t\t\t\tmonth(date'" + monthEndString + "')) \r\n\t\t\tend) \"BeleftMonth\" \r\n\t\tfrom\r\n\t\t\tT_FA_FALEASEINBILLNEW bill\r\n\t\t\t\r\n\t\tLEFT JOIN\r\n\t\t\tT_BD_Supplier supplierlessor \r\n\t\t\t\tON bill.FSupplierLessorID = supplierlessor.FID  \r\n\t\tLEFT JOIN\r\n\t\t\tT_ORG_Company innercompanylessor \r\n\t\t\t\tON bill.FInnerCompanyLessorID = innercompanylessor.FID  \r\n\t\tLEFT JOIN\r\n\t\t\tT_BD_Customer customerlessor \r\n\t\t\t\tON bill.FCustomerLessorID = customerlessor.FID  \r\n\t\tleft join\r\n\t\t\tT_FA_FAContractCat cat \r\n\t\t\t\ton bill.FCONTRACTCATID = cat.FID) tempbill ");
        sql.append(" left join\r\n\t\t(\r\n\t\t\tselect\r\n\t\t\t\trpt.FNPV \"LeaseOrgValue\",\r\n\t\t\t\trpt.FLEASEINBILLID\r\n\t\t\tfrom\r\n\t\t\t\tT_FA_FAAMORTIZEDCOSTRPT rpt \r\n\t\t\t) temprpt  \r\n\t\t\t\ton tempbill.fid = temprpt.FLEASEINBILLID ");
        sql.append(" left join\r\n\t\t\t(\r\n\t\t\t\tselect\r\n\t\t\t\t\t\"PropertyCurent\",\r\n\t\t\t\t\t\"AccDep\",\r\n\t\t\t\t\t\"AccPayment\",\r\n\t\t\t\t\t\"LeasePayCur\",\r\n\t\t\t\t\t\"UnCurFee\",\r\n\t\t\t\t\t\"LeaseCurFee\",\r\n\t\t\t\t\t\"AssetDecValue\",\r\n\t\t\t\t\t\"PropertyCurent\"-\"AccDep\"-\"AssetDecValue\" \"NetValue\",\r\n\t\t\t\t\tFLEASEINBILLID\r\n\t\t\t\tfrom\r\n\t\t\t\t\t(select\r\n\t\t\t\t\t\tsum(entry.FEndRightOfUseAsset) \"PropertyCurent\",\r\n\t\t\t\t\t\tsum(entry.FCurAccDepreciation) \"AccDep\",\r\n\t\t\t\t\t\tsum(entry.FCurAccInterestPayment) \"AccPayment\",\r\n\t\t\t\t\t\tsum(entry.FEndLiabilityPrincipal) \"LeasePayCur\",\r\n\t\t\t\t\t\tsum(entry.FEndUnCfmFncCost) \"UnCurFee\",\r\n\t\t\t\t\t\tsum(entry.FEndLiabilityBalance) \"LeaseCurFee\",\r\n\t\t\t\t\t    FLEASEINBILLID\r\n\t\t\t\t\tfrom\r\n\t\t\t\t\t\tT_FA_FAAMORTIZEDCOSTRPT rpt \r\n\t\t\t\t\tLEFT JOIN\r\n\t\t\t\t\t\tT_Fa_FaAmortizedCostRptEntry entry \r\n\t\t\t\t\t\t\tON rpt.FId = entry.FAmortizedCostRptId \r\n\t\t\t\t\twhere\r\n\t\t\t\t\t\tentry.FDATE = date'" + monthEndString + "' group by  rpt.FLEASEINBILLID) t1 \r\n\t\t\t\tLEFT JOIN\r\n\t\t\t\t\t(\r\n\t\t\t\t\t\tselect\r\n\t\t\t\t\t\t\tsum(entry.FInitialAssetDecValue) \"AssetDecValue\",\r\n\t\t\t\t\t\t\tFLEASEINBILLID \"id\"\r\n\t\t\t\t\t\tfrom\r\n\t\t\t\t\t\t\tT_FA_FAAMORTIZEDCOSTRPT rpt \r\n\t\t\t\t\t\tLEFT JOIN\r\n\t\t\t\t\t\t\tT_Fa_FaAmortizedCostRptEntry entry \r\n\t\t\t\t\t\t\t\tON rpt.FId = entry.FAmortizedCostRptId \r\n\t\t\t\t\t\twhere\r\n\t\t\t\t\t\t\tentry.FDATE <= date'" + monthEndString + "' group by  rpt.FLEASEINBILLID \r\n\t\t\t\t\t) t2  \r\n\t\t\t\t\t\ton t1.FLEASEINBILLID = t2.id \r\n\t\t\t\t) temprpt1  \r\n\t\t\t\t\ton tempbill.fid = temprpt1.FLEASEINBILLID");
        sql.append(" left join\r\n\t\t\t\t(\r\n\t\t\t\t\tselect\r\n\t\t\t\t\t\tterminate.FTERMINATEDATE \"TerDate\",\r\n\t\t\t\t\t\tterminateentry.FLEASEINBILLID \r\n\t\t\t\t\tfrom\r\n\t\t\t\t\t\tT_FA_FATERMINATEBILL terminate \r\n\t\t\t\t\tleft join\r\n\t\t\t\t\t\tT_FA_FATERMINATEBILLENTRY terminateentry  \r\n\t\t\t\t\t\t\ton terminateentry.fbillid = terminate.fid\r\n\t\t\t\t\t) tempterminate  \r\n\t\t\t\t\t\ton tempbill.fid = tempterminate.FLEASEINBILLID ");
        sql.append(" left join\r\n\t\t\t\t\t(\r\n\t\t\t\t\tselect \r\n\t\t\t\t\t\torg.FName_l2 \"ComName\",\r\n\t\t\t\t\t\torg.FNUMBER, \r\n\t\t\t\t\t\torg.fid\r\n\t\t\t\t\t from T_ORG_BaseUnit org) \r\n\t\t\t\t\t org1\r\n\t\t\t\t\t\ton org1.fid = tempbill.FCOMPANYID");
        sql.append(" left join\r\n\t\t\t\t\t(\r\n\t\t\t\t\tselect \r\n\t\t\t\t\t\torg.FName_l2 \"UseDep\",\r\n\t\t\t\t\t\torg.FNUMBER ofnumber, \r\n\t\t\t\t\t\torg.fid\r\n\t\t\t\t\t from T_ORG_BaseUnit org) \r\n\t\t\t\t\t org2\r\n\t\t\t\t\t\ton org2.fid = tempbill.FUSEDEPARTMENTID");
        sql.append(" left join\r\n\t\t\t\t(\r\n\t\t\t\tselect\r\n\t\t\t\tfid,\r\n\t\t\t\tFNUMBER\r\n\t\t\t\t\tfrom T_BD_Period) period\r\n\t\t\t on period.fid= tempbill.FPERIODID\r\n\t\t\t where\r\n\t\t\t  period.fnumber >= '" + startFNumber + "'      and   period.fnumber <='" + endFNumber + "'");
        if (companyIds.size() > 0) {
            sql.append(" and ");
            if (companyIds.size() == 1) {
                sql.append(" org1.fid ='" + (String)companyIds.get(0) + "'");
            } else {
                for (int i = 0; i < companyIds.size(); ++i) {
                    if (i == 0) {
                        sql.append(" (org1.fid ='" + (String)companyIds.get(i) + "'");
                        continue;
                    }
                    sql.append(" or org1.fid ='" + (String)companyIds.get(i) + "'");
                }
                sql.append(")");
            }
        }
        sql.append(" order by ofnumber,\t\"BillName\"\r\n");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < head.length; ++i) {
                    String zhKey = EASResource.getString((String)RESOURCE_PATH, (String)(i + "-ExportLedger"));
                    String key = relaMap.get(zhKey);
                    if (!Arrays.asList(head).contains(zhKey)) continue;
                    Object value = needAddColumns.contains(zhKey) ? (i == 11 ? (rs.getBigDecimal(key) == null ? null : (rs.getBigDecimal(key).compareTo(BigDecimal.ZERO) > 0 ? rs.getBigDecimal(key) : BigDecimal.ZERO)) : rs.getBigDecimal(key)) : String.valueOf(rs.getObject(key) == null ? "" : rs.getObject(key));
                    map.put(zhKey, value);
                }
                resultList.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultList;
    }

    public static void safeClose(FileOutputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private PeriodInfo getCurrentPeriod() throws EASBizException, BOSException {
        if (this.currentPeriod == null) {
            this.currentPeriod = FaClientUtils.getFLCurrentPeriod((CompanyOrgUnitInfo)this.curCompany);
        }
        return this.currentPeriod;
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    protected void addListener() throws Exception {
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptLeaseInNewExportLedgerConditionUI.this.fireStartYearChange();
                FaRptLeaseInNewExportLedgerConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptLeaseInNewExportLedgerConditionUI.this.fireEndYearChange();
                FaRptLeaseInNewExportLedgerConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnStartNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptLeaseInNewExportLedgerConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnEndNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptLeaseInNewExportLedgerConditionUI.this.firePeriodChange(e);
            }
        });
        this.boxCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaRptLeaseInNewExportLedgerConditionUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    private void fireStartYearChange() {
        String periodTypeID = this.curCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.spnStartYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = 1;
            Integer maxPeriod = periodNum;
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnStartNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnStartNumber.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void fireEndYearChange() {
        String periodTypeID = this.curCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.spnEndYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = 1;
            Integer maxPeriod = periodNum;
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnEndNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnEndNumber.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartNumber) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndNumber.setValue(this.spnStartNumber.getValue());
            } else {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartNumber.setValue(this.spnEndNumber.getValue());
            }
        }
    }

    private void companyChanged(Object data) {
        if (data == null) {
            this.spnStartYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnStartYear.setModel((SpinnerModel)tmpModel);
            this.spnStartNumber.setModel((SpinnerModel)tmpModel);
            this.spnEndYear.setModel((SpinnerModel)tmpModel);
            this.spnEndNumber.setModel((SpinnerModel)tmpModel);
        } else {
            this.spnStartYear.setEnabled(true);
            this.spnStartNumber.setEnabled(true);
            this.spnEndYear.setEnabled(true);
            this.spnEndNumber.setEnabled(true);
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.curCompany.getId().toString());
            }
            try {
                String periodTypeID = this.curCompany.getAccountPeriodType().getId().toString();
                Map periodYears = NlmListFactory.getRemoteInstance().findPeriodYearsForNLM(idList);
                SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel startPeriodSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endPeriodSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodStartNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPerioEndNumber = (Integer)periodYears.get("MaxPeriodNumber");
                startYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                startYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
                endYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                endYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
                this.spnStartYear.setValue(periodYears.get("MaxPeriodYear"));
                this.spnEndYear.setValue(periodYears.get("MaxPeriodYear"));
                Map periodNumOfYear = FaListFactory.getRemoteInstance().findMinMaxPeriodsOfYear(this.maxPeriodYear.intValue(), periodTypeID);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    startPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    startPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                startPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnStartNumber.setModel((SpinnerModel)startPeriodSpinnerNumberModel);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    endPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    endPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                endPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnEndNumber.setModel((SpinnerModel)endPeriodSpinnerNumberModel);
                this.spnStartNumber.setValue(periodYears.get("MaxPeriodNumber"));
                this.spnEndNumber.setValue(periodYears.get("MaxPeriodNumber"));
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
    }

    private Date getMonEnd() {
        this.balanceDispalyAsOfDate = (Date)this.BoxBalanceDispalyAsOfDate.getValue();
        if (this.balanceDispalyAsOfDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String condDateString = sdf.format(this.balanceDispalyAsOfDate);
            LocalDate tempDate = LocalDate.parse(condDateString);
            LocalDate monthEnd = tempDate.with(TemporalAdjusters.lastDayOfMonth());
            Instant instant1 = Timestamp.valueOf(monthEnd.atTime(LocalTime.MIDNIGHT)).toInstant();
            Date monthEndDate = Date.from(instant1);
            return monthEndDate;
        }
        return null;
    }

    static {
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"0-ExportLedger"), "ComName");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"1-ExportLedger"), "BillName");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"2-ExportLedger"), "ConName");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"3-ExportLedger"), "UseType");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"4-ExportLedger"), "UseClass");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"5-ExportLedger"), "UseDep");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"6-ExportLedger"), "ConNumber");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"7-ExportLedger"), "LessorName");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"8-ExportLedger"), "LeaseCycle");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"9-ExportLedger"), "LeaseBegin");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"10-ExportLedger"), "LeaseEnd");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"11-ExportLedger"), "BeleftMonth");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"12-ExportLedger"), "RentWithoutTax");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"13-ExportLedger"), "CostPmWithoutTax");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"14-ExportLedger"), "InitProperty");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"15-ExportLedger"), "PropertyCurent");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"16-ExportLedger"), "AccDep");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"17-ExportLedger"), "AssetDecValue");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"18-ExportLedger"), "NetValue");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"19-ExportLedger"), "AccPayment");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"20-ExportLedger"), "OrgValue");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"21-ExportLedger"), "LeasePayCur");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"22-ExportLedger"), "UnFee");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"23-ExportLedger"), "UnCurFee");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"24-ExportLedger"), "LeaseOrgValue");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"25-ExportLedger"), "LeaseCurFee");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"26-ExportLedger"), "ConStatus");
        relaMap.put(EASResource.getString((String)RESOURCE_PATH, (String)"27-ExportLedger"), "TerDate");
        head = new String[]{EASResource.getString((String)RESOURCE_PATH, (String)"0-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"1-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"2-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"3-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"4-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"5-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"6-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"7-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"8-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"9-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"10-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"11-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"12-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"13-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"14-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"15-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"16-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"17-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"18-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"19-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"20-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"21-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"22-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"23-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"24-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"25-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"26-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"27-ExportLedger")};
        needAddColumns = Arrays.asList(EASResource.getString((String)RESOURCE_PATH, (String)"8-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"11-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"12-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"13-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"14-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"15-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"16-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"17-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"18-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"19-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"20-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"21-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"22-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"23-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"24-ExportLedger"), EASResource.getString((String)RESOURCE_PATH, (String)"25-ExportLedger"));
    }
}

