/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaBillBaseEntityCollection;
import com.kingdee.eas.fi.fa.manage.FaBillBaseEntityInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.nlm.AbstractFaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaDispositionEnum;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaPayFrequencyEnum;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillEntryCollection;
import com.kingdee.eas.fi.nlm.FaTerminateBillEntryInfo;
import com.kingdee.eas.fi.nlm.FaTerminateBillFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillInfo;
import com.kingdee.eas.fi.nlm.FaTerminateMode;
import com.kingdee.eas.fi.nlm.FlCalcTreeCalcTypeEnum;
import com.kingdee.eas.fi.nlm.IFaPaymentPlanNew;
import com.kingdee.eas.fi.nlm.calctree.CalcTree;
import com.kingdee.eas.fi.nlm.client.AbstractFaTerminateBillEditUI;
import com.kingdee.eas.fi.nlm.client.NLMTerminateCalculationProcessUI;
import com.kingdee.eas.fi.nlm.client.dialog.FaLeaseInBillNewQueryWithResultDialog;
import com.kingdee.eas.fi.nlm.client.flutils.FlUtils;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class FaTerminateBillEditUI
extends AbstractFaTerminateBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaTerminateBillEditUI.class);
    private List leaseBillIdList = new ArrayList();
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    PeriodInfo currentPeriod = null;
    private static final Color GRAY = new Color(222, 222, 222, 255);
    private static final String KEY_InitialAssetDecValue = "initialAssetDecValue";

    public FaTerminateBillEditUI() throws Exception {
        this.setPreferredSize(new Dimension(1013, 562));
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setTotalAcumDepreAmt(this.readStrAsBigDecimalAndCheckFormat(this.txtTotalAcumDepreAmt.getText()));
        this.editData.setTotalAcumInterestExpe(this.readStrAsBigDecimalAndCheckFormat(this.txtTotalAcumInterestExpe.getText()));
        this.editData.setTotalBeginAssets(this.readStrAsBigDecimalAndCheckFormat(this.txtTotalBeginAssets.getText()));
        this.editData.setTotalBeginLiabilities(this.readStrAsBigDecimalAndCheckFormat(this.txtTotalBeginLiabilities.getText()));
        this.editData.setTotalPaidRent(this.readStrAsBigDecimalAndCheckFormat(this.txtTotalPaidRent.getText()));
        this.editData.setTotalUnacknFinaCharges(this.readStrAsBigDecimalAndCheckFormat(this.txtTotalUnacknFinaCharges.getText()));
    }

    public void onLoad() throws Exception {
        this.currentPeriod = this.getCurPeriod();
        this.initTableStyle();
        super.onLoad();
        this.chkIsCreateLease.setVisible(false);
        this.actionFilterCard.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.initBottomTextFieldStyle();
        this.setBtnStatus();
        this.txtDescription.setMaxLength(200);
        this.txtNumber.setEditable(false);
        this.txtNumber.setEnabled(true);
        this.contNumber.setEnabled(true);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.viewCalculationProcess.setEnabled(true);
        this.updateDapBtnStatus();
        if (this.comboTerminateMode.getSelectedItem() == FaTerminateMode.COMPLETELYL_TERMINATION || this.comboTerminateMode.getSelectedItem() == FaTerminateMode.FULL_TERMINATION) {
            this.getDetailTable().getColumn("isCreateLeaseInBill").getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn("isCreateLeaseInBill").getStyleAttributes().setBackground(GRAY);
            this.getDetailTable().getColumn("ratio").getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn("ratio").getStyleAttributes().setBackground(GRAY);
        } else {
            this.getDetailTable().getColumn("isCreateLeaseInBill").getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn("isCreateLeaseInBill").getStyleAttributes().setBackground(GRAY);
            this.getDetailTable().getColumn("ratio").getStyleAttributes().setLocked(false);
            this.getDetailTable().getColumn("ratio").getStyleAttributes().setBackground(this.getDetailTable().getRequiredColor());
        }
        this.viewCalculationProcess.setVisible(false);
    }

    protected void checkBeforeOnload() throws Exception {
        FaClientUtils.checkBeforeOnload4Fl((Map)this.getUIContext(), (CompanyOrgUnitInfo)this.getCurCompany());
    }

    protected String getStatusBarTitle() {
        if (this.currCompany != null && !this.currCompany.isIsBizUnit()) {
            return null;
        }
        PeriodInfo curP = null;
        try {
            curP = this.getCurPeriod();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (curP == null) {
            return null;
        }
        return EASResource.getString((String)this.resClassName, (String)"currentPeriod") + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), curP.getPeriodYear(), curP.getPeriodNumber());
    }

    private PeriodInfo getCurPeriod() {
        try {
            if (this.currentPeriod == null) {
                this.currentPeriod = FaClientUtils.getFLCurrentPeriod();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.currentPeriod;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.updateDapBtnStatus();
        if (this.comboTerminateMode.getSelectedItem() == FaTerminateMode.RETROSPECT_TERMINATION) {
            this.setEntryStyle(true);
        }
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    private void updateDapBtnStatus() {
        block5: {
            if (this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                try {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("fiVouchered");
                    CoreBaseInfo sourceBill = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
                    if (sourceBill.getBoolean("fiVouchered")) {
                        this.actionVoucher.setEnabled(false);
                        this.actionDelVoucher.setEnabled(true);
                        break block5;
                    }
                    this.actionVoucher.setEnabled(true);
                    this.actionDelVoucher.setEnabled(false);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            } else {
                this.actionVoucher.setEnabled(false);
                this.actionDelVoucher.setEnabled(false);
            }
        }
    }

    public BigDecimal readStrAsBigDecimalAndCheckFormat(String str) {
        if (str == null || str.length() == 0) {
            return BigDecimal.ZERO;
        }
        DecimalFormat format = new DecimalFormat(FaClientUtils.getDecimalFormat((int)this.getCurrencyScale()));
        format.setParseBigDecimal(true);
        ParsePosition position = new ParsePosition(0);
        BigDecimal parse = (BigDecimal)format.parse(str, position);
        if (str.length() == position.getIndex()) {
            return parse;
        }
        return null;
    }

    private void setBtnStatus() {
        if (this.editData != null) {
            this.actionAudit.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
            this.actionUnAudit.setEnabled(this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED);
            this.actionSubmit.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
            this.setEditableColumn("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()), this.reverseEditableColumn(), this.getEditableColumn());
        } else {
            this.actionAudit.setEnabled(true);
            this.actionUnAudit.setEnabled(false);
        }
        if (this.editData.getEffectedStatus() != EffectedStatusEnum.EFFECTED) {
            this.actionUnAudit.setEnabled(false);
            this.actionAudit.setEnabled(false);
        }
        if (!this.isEnableUndo) {
            this.actionUnAudit.setVisible(this.isEnableUndo);
            this.actionUnAudit.setEnabled(this.isEnableUndo);
        }
        if (FaClientUtils.isFromWorkflow((Map)this.getUIContext())) {
            this.actionEdit.setEnabled(false);
            this.actionAddLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        }
        if (this.editData != null) {
            if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
                this.actionEdit.setEnabled(false);
                this.actionSubmit.setEnabled(true);
                this.actionAddLine.setEnabled(true);
                this.actionRemoveLine.setEnabled(true);
            } else {
                this.actionEdit.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
                this.actionSubmit.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
                this.actionAddLine.setEnabled(false);
                this.actionRemoveLine.setEnabled(false);
            }
        }
    }

    private void initBottomTextFieldStyle() {
        this.txtTotalAcumDepreAmt.setBorder(BorderFactory.createEmptyBorder());
        this.txtTotalAcumDepreAmt.setEditable(true);
        this.txtTotalAcumDepreAmt.setEnabled(true);
        this.txtTotalAcumDepreAmt.setFocusable(false);
        this.txtTotalAcumDepreAmt.setCustomBackgroundColor(this.getBackground());
        this.txtTotalAcumInterestExpe.setBorder(BorderFactory.createEmptyBorder());
        this.txtTotalAcumInterestExpe.setEditable(true);
        this.txtTotalAcumInterestExpe.setEnabled(true);
        this.txtTotalAcumInterestExpe.setFocusable(false);
        this.txtTotalAcumInterestExpe.setCustomBackgroundColor(this.getBackground());
        this.txtTotalBeginAssets.setBorder(BorderFactory.createEmptyBorder());
        this.txtTotalBeginAssets.setEditable(true);
        this.txtTotalBeginAssets.setEnabled(true);
        this.txtTotalBeginAssets.setFocusable(false);
        this.txtTotalBeginAssets.setCustomBackgroundColor(this.getBackground());
        this.txtTotalBeginLiabilities.setBorder(BorderFactory.createEmptyBorder());
        this.txtTotalBeginLiabilities.setEditable(true);
        this.txtTotalBeginLiabilities.setEnabled(true);
        this.txtTotalBeginLiabilities.setFocusable(false);
        this.txtTotalBeginLiabilities.setCustomBackgroundColor(this.getBackground());
        this.txtTotalPaidRent.setBorder(BorderFactory.createEmptyBorder());
        this.txtTotalPaidRent.setEditable(true);
        this.txtTotalPaidRent.setEnabled(true);
        this.txtTotalPaidRent.setFocusable(false);
        this.txtTotalPaidRent.setCustomBackgroundColor(this.getBackground());
        this.txtTotalUnacknFinaCharges.setBorder(BorderFactory.createEmptyBorder());
        this.txtTotalUnacknFinaCharges.setEditable(true);
        this.txtTotalUnacknFinaCharges.setEnabled(true);
        this.txtTotalUnacknFinaCharges.setFocusable(false);
        this.txtTotalUnacknFinaCharges.setCustomBackgroundColor(this.getBackground());
    }

    private void initTableStyle() {
        this.detailTable.checkParsed();
        this.currCompany = SysContext.getSysContext().getCurrentFIUnit();
        IColumn dispositionOfAssetsColumn = this.detailTable.getColumn("dispositionOfAssets");
        IColumn terAssetDisposalGainColumn = this.detailTable.getColumn("terAssetDisposalGain");
        IColumn initialAssetColumn = this.detailTable.getColumn("initialAsset");
        IColumn initialLiabilityColumn = this.detailTable.getColumn("initialLiability");
        IColumn unrecognizedFinanceFeeColumn = this.detailTable.getColumn("unrecognizedFinanceFee");
        IColumn paidRentColumn = this.detailTable.getColumn("paidRent");
        IColumn terPaidRentColumn = this.detailTable.getColumn("terPaidRent");
        IColumn ratioColumn = this.detailTable.getColumn("ratio");
        IColumn acumDepreAmtColumn = this.detailTable.getColumn("acumDepreAmt");
        IColumn acumInterestExpeColumn = this.detailTable.getColumn("acumInterestExpe");
        IColumn assetDisposalGainColumn = this.detailTable.getColumn("assetDisposalGain");
        IColumn retrospectAdjustDate = this.detailTable.getColumn("retrospectAdjustDate");
        IColumn retrospectAcumDepreAmt = this.detailTable.getColumn("retrospectAcumDepreAmt");
        IColumn retrospectUFFee = this.detailTable.getColumn("retrospectUFFee");
        IColumn retrospectPaidRent = this.detailTable.getColumn("retrospectPaidRent");
        IColumn initialAssetDecValue = this.detailTable.getColumn(KEY_InitialAssetDecValue);
        IColumn retrospectDecValue = this.detailTable.getColumn("retrospectDecValue");
        IColumn terAssetDisposalGain = this.detailTable.getColumn("terAssetDisposalGain");
        IColumn terInitialAsset = this.detailTable.getColumn("terInitialAsset");
        IColumn terInitialLiability = this.detailTable.getColumn("terInitialLiability");
        IColumn terUFinanceFee = this.detailTable.getColumn("terUFinanceFee");
        IColumn terAcumDepreAmt = this.detailTable.getColumn("terAcumDepreAmt");
        IColumn terAcumInterestExpe = this.detailTable.getColumn("terAcumInterestExpe");
        IColumn terRetrAcumDepreAmt = this.detailTable.getColumn("terRetrAcumDepreAmt");
        IColumn terRetrUFFee = this.detailTable.getColumn("terRetrUFFee");
        IColumn terRetrPaidRent = this.detailTable.getColumn("terRetrPaidRent");
        IColumn terRetrDecValue = this.detailTable.getColumn("terRetrDecValue");
        IColumn remainLeasePayment = this.detailTable.getColumn("remainLeasePayment");
        IColumn terInitialAssetDecValue = this.detailTable.getColumn("terInitialAssetDecValue");
        Object[] c = new Object[]{initialAssetColumn, initialLiabilityColumn, unrecognizedFinanceFeeColumn, paidRentColumn, terPaidRentColumn, ratioColumn, acumDepreAmtColumn, acumInterestExpeColumn, assetDisposalGainColumn, terAssetDisposalGain, this.txtTotalAcumDepreAmt, this.txtTotalAcumInterestExpe, this.txtTotalBeginAssets, this.txtTotalBeginLiabilities, this.txtTotalPaidRent, this.txtTotalUnacknFinaCharges, retrospectAcumDepreAmt, retrospectUFFee, retrospectPaidRent, initialAssetDecValue, retrospectDecValue, terInitialAsset, terInitialLiability, terUFinanceFee, terAcumDepreAmt, terAcumInterestExpe, terRetrAcumDepreAmt, terRetrUFFee, terRetrPaidRent, terRetrDecValue, remainLeasePayment, terInitialAssetDecValue};
        try {
            this.setComponentPrecision(c, this.getCurrencyScale());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        paidRentColumn.setRequired(true);
        terPaidRentColumn.setRequired(true);
        terPaidRentColumn.getStyleAttributes().setLocked(false);
        ratioColumn.setRequired(true);
        retrospectAdjustDate.setRequired(true);
        retrospectAdjustDate.getStyleAttributes().setLocked(false);
        dispositionOfAssetsColumn.setRequired(true);
        terAssetDisposalGainColumn.setRequired(true);
        KDComboBox dispositionCombox = new KDComboBox();
        dispositionCombox.addItems(FaDispositionEnum.getEnumList().toArray());
        KDTDefaultCellEditor dispositionEditor = new KDTDefaultCellEditor((JComboBox)dispositionCombox);
        dispositionOfAssetsColumn.setEditor((ICellEditor)dispositionEditor);
        this.txtTotalAcumDepreAmt.setEnabled(false);
        this.txtTotalAcumInterestExpe.setEnabled(false);
        this.txtTotalBeginAssets.setEnabled(false);
        this.txtTotalBeginLiabilities.setEnabled(false);
        this.txtTotalPaidRent.setEnabled(false);
        this.txtTotalUnacknFinaCharges.setEnabled(false);
        this.setEntryStyle(this.comboTerminateMode.getSelectedItem() == FaTerminateMode.RETROSPECT_TERMINATION);
    }

    protected void initCtrlComponent() throws Exception {
        FaUtils.freezeTable((KDTable)this.getDetailTable(), (int)6);
    }

    protected void setDefaultValue(IObjectValue dataObject) {
        FaBillBaseInfo baseInfo = (FaBillBaseInfo)dataObject;
        if (baseInfo.getId() == null || baseInfo.getId().equals((Object)"")) {
            try {
                CompanyOrgUnitInfo company = this.getCurCompany();
                baseInfo.setCompany(company);
                baseInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                baseInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                baseInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
                baseInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
                baseInfo.setFiVouchered(false);
                UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
                baseInfo.setHandler(aUserInfo);
                baseInfo.setCreator(aUserInfo);
                baseInfo.setPeriod(FaClientUtils.getFLCurrentPeriod((CompanyOrgUnitInfo)company));
            }
            catch (Exception e) {
                this.isOnLoadExceptionAbort = true;
                this.handUIException(e);
                SysUtil.abort();
            }
            baseInfo.setNumber(this.getRuleNumber(baseInfo));
        }
    }

    public void checkSelected() {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.setBtnStatus();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setBtnStatus();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrint(false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrint(true);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        try {
            FaLeaseInBillNewQueryWithResultDialog dialog = new FaLeaseInBillNewQueryWithResultDialog();
            if (this.getUIWindow() == null) {
                dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                dialog.setOwner((Component)((Object)this));
            }
            HashMap hmParam = this.gethmParamD();
            boolean isRange = "true".equals(hmParam.get("FA_040").toString());
            FACommonProcessor processor = (FACommonProcessor)dialog.getCommonQueryParam().getProcessors();
            if (processor == null) {
                processor = new FACommonProcessor();
            }
            processor.setRange(isRange);
            dialog.setProcessor((IProcessor)processor);
            dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            dialog.setEntityViewInfo(new EntityViewInfo());
            dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.nlm", "FaLeaseInNewQuery"));
            dialog.setTitle(this.getUITitle());
            dialog.setHeight(525);
            dialog.setOpenType(1);
            if (this.pkTerminateDate.getValue() == null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.nlm.FaLeaseResource", (String)"terminateDateIsNull");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            dialog.setTerminateDate((Date)this.pkTerminateDate.getValue());
            dialog.setUseDefaultFilter(false);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.appendFilterItem("company.id", (Object)companyId);
            filterInfo.appendFilterItem("checkedStatus", (Object)2);
            StringBuffer filterBuffer = new StringBuffer("select teme.FLeaseInBillID from T_FA_FaTerminateBillEntry teme,T_FA_FaTerminateBill tem where (tem.fid = teme.fbillid and tem.fcompanyid = '");
            filterBuffer.append(companyId);
            filterBuffer.append("'");
            if (this.editData.getId() != null) {
                filterBuffer.append(" and tem.fid <>'");
                filterBuffer.append(this.editData.getId().toString());
                filterBuffer.append("')");
            } else {
                filterBuffer.append(")");
            }
            if (this.leaseBillIdList != null && this.leaseBillIdList.size() > 0) {
                HashSet idSet = new HashSet(this.leaseBillIdList);
                filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.NOTINCLUDE));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)filterBuffer.toString(), CompareType.NOTINNER));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(6), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(7), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(10), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(11), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(4), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(8), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isExempt", (Object)false, CompareType.EQUALS));
            Date tmDateTmp = (Date)this.pkTerminateDate.getValue();
            if (this.editData.getTerminateMode() == FaTerminateMode.COMPLETELYL_TERMINATION) {
                filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)tmDateTmp, CompareType.LESS_EQUALS));
            } else if (this.editData.getTerminateMode() == FaTerminateMode.EARLY_TERMINATION || this.editData.getTerminateMode() == FaTerminateMode.RETROSPECT_TERMINATION) {
                filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)tmDateTmp, CompareType.GREATER_EQUALS));
            }
            dialog.setFilterInfo(filterInfo);
            dialog.setSelectMode(10);
            dialog.setResultPanelTitle(EASResource.getString((String)RESOURCE_PATH, (String)"FALEASEINBILL_LIST"));
            if (dialog.show() || dialog.hasKeyValue()) {
                FaTerminateBillEntryCollection selectedCards = dialog.getSelectedCards();
                if (selectedCards == null) {
                    SysUtil.abort();
                } else {
                    FaTerminateBillEntryCollection entrys = selectedCards;
                    HashSet<String> leaseInIdSet = new HashSet<String>();
                    Date tmDate = (Date)this.pkTerminateDate.getValue();
                    for (int i = 0; i < entrys.size(); ++i) {
                        leaseInIdSet.add(entrys.get(i).getLeaseInBill().getId().toString());
                    }
                    Map paidRentMap = FaTerminateBillFactory.getRemoteInstance().getPaidRentAmt(leaseInIdSet, tmDate, this.editData.getTerminateMode(), tmDateTmp);
                    Map deprInterestMap = FaTerminateBillFactory.getRemoteInstance().getDeprInterestAmt(leaseInIdSet, tmDate, this.editData.getTerminateMode(), tmDateTmp);
                    for (int i = 0; i < entrys.size(); ++i) {
                        FaTerminateBillEntryInfo lineData = entrys.get(i);
                        if (this.leaseBillIdList.contains(lineData.getLeaseInBill().getId().toString())) continue;
                        String leaseInBillId = lineData.getLeaseInBill().getId().toString();
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add("*");
                        sic.add("Currency.*");
                        sic.add("exchangeRate.*");
                        sic.add("exchangeRate.exchangeAux.*");
                        FaLeaseInBillNewInfo leaseInBillTmp = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseInBillId), sic);
                        BigDecimal[] deprInterest = (BigDecimal[])deprInterestMap.get(leaseInBillId);
                        lineData.setDeprStatus(deprInterestMap.containsKey(leaseInBillId + "deprStatus"));
                        lineData.setPaidRent(paidRentMap.get(leaseInBillId) == null ? BigDecimal.ZERO : (BigDecimal)paidRentMap.get(leaseInBillId));
                        if (leaseInBillTmp.getInitAccDepreciation() == null || this.editData.getTerminateMode() == FaTerminateMode.COMPLETELYL_TERMINATION) {
                            lineData.setAcumDepreAmt(deprInterest == null ? BigDecimal.ZERO : deprInterest[0]);
                        } else {
                            lineData.setAcumDepreAmt(deprInterest == null ? BigDecimal.ZERO : deprInterest[0]);
                        }
                        lineData.setAcumInterestExpe(deprInterest == null ? BigDecimal.ZERO : deprInterest[1]);
                        if (this.editData.getTerminateMode() == FaTerminateMode.RETROSPECT_TERMINATION) {
                            lineData.setRetrospectAdjustDate(tmDateTmp);
                            lineData.setRetrospectPaidRent(paidRentMap.get(leaseInBillId + "adjust") == null ? BigDecimal.ZERO : (BigDecimal)paidRentMap.get(leaseInBillId + "adjust"));
                            lineData.setRetrospectAcumDepreAmt(deprInterest == null ? BigDecimal.ZERO : deprInterest[2]);
                            lineData.setRetrospectUFFee(deprInterest == null ? BigDecimal.ZERO : deprInterest[3]);
                        }
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        leaseInBillTmp.put("terminateType", this.editData.getTerminateMode().getName());
                        params.put("leaseInBillId", leaseInBillTmp.getId().toString());
                        params.put("leaseInBill", leaseInBillTmp);
                        leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_INIT_AMOUNT.getName());
                        CalcTree.calc(null, leaseInBillTmp, params, resultMap);
                        lineData.setInitialAsset((BigDecimal)resultMap.get("initialAsset"));
                        lineData.setInitialLiability((BigDecimal)resultMap.get("initialLiability"));
                        lineData.setUnrecognizedFinanceFee((BigDecimal)resultMap.get("unrecognizedFinanceFee"));
                        params.put("terminateDate", tmDate);
                        params.put("adjustDate", tmDateTmp);
                        params.put("billEndDate", leaseInBillTmp.getEndDate());
                        leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_DEC_VALUE.getName());
                        CalcTree.calc(null, leaseInBillTmp, params, resultMap);
                        lineData.setInitialAssetDecValue((BigDecimal)resultMap.get(KEY_InitialAssetDecValue));
                        if (this.editData.getTerminateMode() == FaTerminateMode.RETROSPECT_TERMINATION) {
                            leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_RETR_DEC_VALUE.getName());
                            CalcTree.calc(null, leaseInBillTmp, params, resultMap);
                            lineData.setRetrospectDecValue((BigDecimal)resultMap.get("retrospectDecValue"));
                        }
                        leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_REMAINING_LEASE_PAYMENTS.getName());
                        CalcTree.calc(null, leaseInBillTmp, params, resultMap);
                        lineData.setOrgRemainLeasePayment((BigDecimal)resultMap.get("remainLeasePayment"));
                        lineData.setRemainLeasePayment((BigDecimal)resultMap.get("remainLeasePayment"));
                        leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_UNRECOGNIZED_FINANCING.getName());
                        CalcTree.calc(null, leaseInBillTmp, params, resultMap);
                        lineData.setOrgFinanceFeeBalance((BigDecimal)resultMap.get("unrecognizedFinanceFeeBalance"));
                        lineData.setUnrecognizedFinanceFeeBalance((BigDecimal)resultMap.get("unrecognizedFinanceFeeBalance"));
                        this.setTerFieldValue(lineData, leaseInBillTmp.getCurrency().getPrecision(), this.getCurrencyScale());
                        BigDecimal exchangeRateInfo = leaseInBillTmp.getExchangeRateValue();
                        if (leaseInBillTmp.getExchangeRate() != null && leaseInBillTmp.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                            exchangeRateInfo = new BigDecimal("1").divide(exchangeRateInfo);
                        }
                        BigDecimal tmpOne = lineData.getRemainLeasePayment().subtract(lineData.getUnrecognizedFinanceFeeBalance());
                        BigDecimal tmpTwo = lineData.getTerAcumDepreAmt().add(lineData.getTerInitialAssetDecValue()).subtract(lineData.getTerInitialAsset());
                        BigDecimal assetDisposalGain = tmpOne.add(tmpTwo);
                        assetDisposalGain = assetDisposalGain.multiply(exchangeRateInfo);
                        lineData.setAssetDisposalGain(assetDisposalGain);
                        lineData.setTerAssetDisposalGain(assetDisposalGain.setScale(this.getCurrencyScale(), 4));
                        if (new BigDecimal("0").compareTo(lineData.getTerAssetDisposalGain()) == 1) {
                            lineData.setDispositionOfAssets(FaDispositionEnum.PROFIT);
                        } else {
                            lineData.setDispositionOfAssets(FaDispositionEnum.DEFICIT);
                        }
                        lineData.setBill(this.editData);
                        IRow row = this.getDetailTable().addRow();
                        this.loadLineFields(this.getDetailTable(), row, (IObjectValue)lineData);
                        row.setUserObject((Object)lineData);
                        this.afterAddLine(this.detailTable, (IObjectValue)lineData);
                    }
                }
            } else {
                SysUtil.abort();
            }
        }
        catch (EASBizException e1) {
            MsgBox.showError((String)e1.getMessage());
            SysUtil.abort();
        }
        catch (BOSException e1) {
            MsgBox.showError((String)e1.getMessage());
            SysUtil.abort();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            SysUtil.abort();
        }
        super.actionAddLine_actionPerformed(e);
    }

    private void setTerFieldValue(FaTerminateBillEntryInfo lineData, int currencyPrecisionOC, int currencyPrecision) {
        lineData.setRatio(new BigDecimal("100"));
        BigDecimal ratio = lineData.getRatio().divide(new BigDecimal("100"));
        lineData.setTerPaidRent(lineData.getPaidRent().multiply(ratio).setScale(currencyPrecisionOC, 4));
        lineData.setTerInitialAsset(lineData.getInitialAsset().multiply(ratio).setScale(currencyPrecision, 4));
        lineData.setTerInitialLiability(lineData.getInitialLiability().multiply(ratio).setScale(currencyPrecisionOC, 4));
        lineData.setTerUFinanceFee(lineData.getUnrecognizedFinanceFee().multiply(ratio).setScale(currencyPrecisionOC, 4));
        lineData.setTerAcumDepreAmt(lineData.getAcumDepreAmt().multiply(ratio).setScale(currencyPrecision, 4));
        lineData.setTerAcumInterestExpe(lineData.getAcumInterestExpe().multiply(ratio).setScale(currencyPrecisionOC, 4));
        lineData.setTerInitialAssetDecValue(lineData.getInitialAssetDecValue().multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal retrAcumDepreAmt = lineData.getRetrospectAcumDepreAmt() == null ? BigDecimal.ZERO : lineData.getRetrospectAcumDepreAmt();
        lineData.setTerRetrAcumDepreAmt(retrAcumDepreAmt.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal retrospectUFFee = lineData.getRetrospectUFFee() == null ? BigDecimal.ZERO : lineData.getRetrospectUFFee();
        lineData.setTerRetrUFFee(retrospectUFFee.multiply(ratio).setScale(currencyPrecisionOC, 4));
        BigDecimal retrospectPaidRent = lineData.getRetrospectPaidRent() == null ? BigDecimal.ZERO : lineData.getRetrospectPaidRent();
        lineData.setTerRetrPaidRent(retrospectPaidRent.multiply(ratio).setScale(currencyPrecisionOC, 4));
        BigDecimal retrospectDecValue = lineData.getRetrospectDecValue() == null ? BigDecimal.ZERO : lineData.getRetrospectDecValue();
        lineData.setTerRetrDecValue(retrospectDecValue.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal orgRemainLeasePayment = lineData.getOrgRemainLeasePayment() == null ? BigDecimal.ZERO : lineData.getOrgRemainLeasePayment();
        lineData.setRemainLeasePayment(orgRemainLeasePayment.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal orgFinanceFeeBalance = lineData.getOrgFinanceFeeBalance() == null ? BigDecimal.ZERO : lineData.getOrgFinanceFeeBalance();
        lineData.setUnrecognizedFinanceFeeBalance(orgFinanceFeeBalance.multiply(ratio).setScale(currencyPrecision, 4));
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        FaTerminateBillEntryInfo entryInfo = (FaTerminateBillEntryInfo)lineData;
        this.editData.setTotalBeginAssets(this.editData.getTotalBeginAssets().add(entryInfo.getTerInitialAsset()));
        this.editData.setTotalBeginLiabilities(this.editData.getTotalBeginLiabilities().add(entryInfo.getTerInitialLiability()));
        this.editData.setTotalUnacknFinaCharges(this.editData.getTotalUnacknFinaCharges().add(entryInfo.getTerUFinanceFee()));
        this.editData.setTotalAcumDepreAmt(this.editData.getTotalAcumDepreAmt().add(entryInfo.getTerAcumDepreAmt()));
        this.editData.setTotalPaidRent(this.editData.getTotalPaidRent().add(entryInfo.getTerPaidRent() == null ? BigDecimal.ZERO : entryInfo.getTerPaidRent()));
        this.editData.setTotalAcumInterestExpe(this.editData.getTotalAcumInterestExpe().add(entryInfo.getTerAcumInterestExpe()));
        this.txtTotalBeginAssets.setNumberValue((Number)this.editData.getTotalBeginAssets());
        this.txtTotalBeginLiabilities.setNumberValue((Number)this.editData.getTotalBeginLiabilities());
        this.txtTotalUnacknFinaCharges.setNumberValue((Number)this.editData.getTotalUnacknFinaCharges());
        this.txtTotalAcumDepreAmt.setNumberValue((Number)this.editData.getTotalAcumDepreAmt());
        this.txtTotalPaidRent.setNumberValue((Number)this.editData.getTotalPaidRent());
        this.txtTotalAcumInterestExpe.setNumberValue((Number)this.editData.getTotalAcumInterestExpe());
        String leaseBillId = entryInfo.getLeaseInBill().getId().toString();
        if (!this.leaseBillIdList.contains(leaseBillId)) {
            this.leaseBillIdList.add(leaseBillId);
        }
        super.afterAddLine(table, lineData);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        FaTerminateBillEntryInfo entryInfo = (FaTerminateBillEntryInfo)lineData;
        if (entryInfo.getTerInitialAsset() != null) {
            this.editData.setTotalBeginAssets(this.editData.getTotalBeginAssets().subtract(entryInfo.getTerInitialAsset()));
        }
        if (entryInfo.getTerInitialLiability() != null) {
            this.editData.setTotalBeginLiabilities(this.editData.getTotalBeginLiabilities().subtract(entryInfo.getTerInitialLiability()));
        }
        if (entryInfo.getTerUFinanceFee() != null) {
            this.editData.setTotalUnacknFinaCharges(this.editData.getTotalUnacknFinaCharges().subtract(entryInfo.getTerUFinanceFee()));
        }
        if (entryInfo.getTerAcumDepreAmt() != null) {
            this.editData.setTotalAcumDepreAmt(this.editData.getTotalAcumDepreAmt().subtract(entryInfo.getTerAcumDepreAmt()));
        }
        if (entryInfo.getTerPaidRent() != null) {
            this.editData.setTotalPaidRent(this.editData.getTotalPaidRent().subtract(entryInfo.getTerPaidRent() == null ? BigDecimal.ZERO : entryInfo.getTerPaidRent()));
        }
        if (entryInfo.getTerAcumInterestExpe() != null) {
            this.editData.setTotalAcumInterestExpe(this.editData.getTotalAcumInterestExpe().subtract(entryInfo.getTerAcumInterestExpe()));
        }
        this.txtTotalBeginAssets.setNumberValue((Number)this.editData.getTotalBeginAssets());
        this.txtTotalBeginLiabilities.setNumberValue((Number)this.editData.getTotalBeginLiabilities());
        this.txtTotalUnacknFinaCharges.setNumberValue((Number)this.editData.getTotalUnacknFinaCharges());
        this.txtTotalAcumDepreAmt.setNumberValue((Number)this.editData.getTotalAcumDepreAmt());
        this.txtTotalPaidRent.setNumberValue((Number)this.editData.getTotalPaidRent());
        this.txtTotalAcumInterestExpe.setNumberValue((Number)this.editData.getTotalAcumInterestExpe());
        this.leaseBillIdList.remove(entryInfo.getLeaseInBill().getId().toString());
        super.afterRemoveLine(table, lineData);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkForGenVoucher4Fl();
        super.actionVoucher_actionPerformed(e);
        this.updateDapBtnStatus();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        this.updateDapBtnStatus();
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        if (this.editData.getId() == null || this.editData.getId().toString().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SAVE_FIRST"));
            return;
        }
        if (this.editData.getEffectedStatus() == EffectedStatusEnum.TEMPSTORE) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SUBMIT_FIRST"));
            return;
        }
        super.actionAudit_actionPerformed(e);
        this.setBtnStatus();
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        this.setBtnStatus();
    }

    protected IObjectValue createNewData() {
        FaTerminateBillInfo billInfo = new FaTerminateBillInfo();
        PeriodInfo period = null;
        period = this.getCurPeriod();
        billInfo.setTerminateDate(period.getEndDate());
        billInfo.setTerminateMode(FaTerminateMode.COMPLETELYL_TERMINATION);
        billInfo.setIsCreateLease(false);
        billInfo.setTotalBeginAssets(BigDecimal.ZERO);
        billInfo.setTotalBeginLiabilities(BigDecimal.ZERO);
        billInfo.setTotalUnacknFinaCharges(BigDecimal.ZERO);
        billInfo.setTotalAcumDepreAmt(BigDecimal.ZERO);
        billInfo.setTotalPaidRent(BigDecimal.ZERO);
        billInfo.setTotalAssetDisposalGain(BigDecimal.ZERO);
        billInfo.setTotalAcumInterestExpe(BigDecimal.ZERO);
        UserInfo creator = SysContext.getSysContext().getCurrentUserInfo();
        billInfo.setCreator(creator);
        billInfo.setCompany(this.getCurCompany());
        billInfo.setNumber(this.getRuleNumber(billInfo));
        this.leaseBillIdList.clear();
        return billInfo;
    }

    protected void initListener() {
        super.initListener();
        this.pkTerminateDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaTerminateBillEditUI.this.terminateDateChange(eventObj);
            }
        });
        this.comboTerminateMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaTerminateBillEditUI.this.terminateModeDateChange(e);
            }
        });
        this.detailTable.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getValue() instanceof Date) {
                    FaTerminateBillEditUI.this.refreshRetrospectData((Date)e.getValue());
                }
                if (e.getColIndex() == 4) {
                    FaTerminateBillEditUI.this.refreshPaidRent();
                }
                if (e.getColIndex() == 2) {
                    FaTerminateBillEditUI.this.refreshOtherValue((BigDecimal)e.getValue(), e.getRowIndex());
                    FaTerminateBillEditUI.this.setIsCreateLeaseInBillStatus((BigDecimal)e.getValue());
                }
                FaTerminateBillEditUI.this.refreshAssetDisposalGain();
                FaTerminateBillEditUI.this.refreshTotalData();
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    private void setIsCreateLeaseInBillStatus(BigDecimal value) {
        if (value.compareTo(new BigDecimal("100")) == 1) {
            IRow iRow = this.getDetailTable().getRow(this.getDetailTable().getSelectManager().getActiveRowIndex());
            iRow.getCell("ratio").setValue((Object)new BigDecimal("100"));
            iRow.getCell("isCreateLeaseInBill").setValue((Object)false);
            return;
        }
        if (value.compareTo(new BigDecimal("100")) == 0) {
            IRow iRow = this.getDetailTable().getRow(this.getDetailTable().getSelectManager().getActiveRowIndex());
            iRow.getCell("isCreateLeaseInBill").setValue((Object)false);
        } else {
            IRow iRow = this.getDetailTable().getRow(this.getDetailTable().getSelectManager().getActiveRowIndex());
            iRow.getCell("isCreateLeaseInBill").setValue((Object)true);
        }
    }

    private void refreshPaidRent() {
        IRow iRow = this.getDetailTable().getRow(this.getDetailTable().getSelectManager().getActiveRowIndex());
        BigDecimal ratio = new BigDecimal(iRow.getCell("ratio").getValue().toString()).divide(new BigDecimal("100"));
        iRow.getCell("paidRent").setValue((Object)new BigDecimal(iRow.getCell("terPaidRent").getValue().toString()).divide(ratio, this.getCurrencyScale(), 4));
    }

    private void refreshOtherValue(BigDecimal ratio, int rowIndex) {
        IRow lineData = this.getDetailTable().getRow(rowIndex);
        String leaseInBillNumber = (String)lineData.getCell("leaseInBillNumber").getValue();
        ratio = ratio.divide(new BigDecimal("100"));
        AbstractFaLeaseInBillNewInfo billInfo = null;
        try {
            billInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo("select Currency.* where number = '" + leaseInBillNumber + "' and company.id = '" + this.getCurrentCompanyID() + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        int currencyPrecision = this.getCurrencyScale();
        int currencyPrecisionOC = billInfo.getCurrency().getPrecision();
        BigDecimal paidRent = lineData.getCell("paidRent").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("paidRent").getValue();
        lineData.getCell("terPaidRent").setValue((Object)paidRent.multiply(ratio).setScale(currencyPrecisionOC, 4));
        BigDecimal initialAsset = lineData.getCell("initialAsset").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("initialAsset").getValue();
        lineData.getCell("terInitialAsset").setValue((Object)initialAsset.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal initialLiability = lineData.getCell("initialLiability").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("initialLiability").getValue();
        lineData.getCell("terInitialLiability").setValue((Object)initialLiability.multiply(ratio).setScale(currencyPrecisionOC, 4));
        BigDecimal unrecognizedFinanceFee = lineData.getCell("unrecognizedFinanceFee").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("unrecognizedFinanceFee").getValue();
        lineData.getCell("terUFinanceFee").setValue((Object)unrecognizedFinanceFee.multiply(ratio).setScale(currencyPrecisionOC, 4));
        BigDecimal acumDepreAmt = lineData.getCell("acumDepreAmt").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("acumDepreAmt").getValue();
        lineData.getCell("terAcumDepreAmt").setValue((Object)acumDepreAmt.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal acumInterestExpe = lineData.getCell("acumInterestExpe").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("acumInterestExpe").getValue();
        lineData.getCell("terAcumInterestExpe").setValue((Object)acumInterestExpe.multiply(ratio).setScale(currencyPrecisionOC, 4));
        BigDecimal initialAssetDecValue = lineData.getCell(KEY_InitialAssetDecValue).getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell(KEY_InitialAssetDecValue).getValue();
        lineData.getCell("terInitialAssetDecValue").setValue((Object)initialAssetDecValue.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal retrospectAcumDepreAmt = lineData.getCell("retrospectAcumDepreAmt").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("retrospectAcumDepreAmt").getValue();
        lineData.getCell("terRetrAcumDepreAmt").setValue((Object)retrospectAcumDepreAmt.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal retrospectUFFee = lineData.getCell("retrospectUFFee").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("retrospectUFFee").getValue();
        lineData.getCell("terRetrUFFee").setValue((Object)retrospectUFFee.multiply(ratio).setScale(currencyPrecisionOC, 4));
        BigDecimal retrospectPaidRent = lineData.getCell("retrospectPaidRent").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("retrospectPaidRent").getValue();
        lineData.getCell("terRetrPaidRent").setValue((Object)retrospectPaidRent.multiply(ratio).setScale(currencyPrecisionOC, 4));
        BigDecimal retrospectDecValue = lineData.getCell("retrospectDecValue").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("retrospectDecValue").getValue();
        lineData.getCell("terRetrDecValue").setValue((Object)retrospectDecValue.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal orgRemainLeasePayment = lineData.getCell("orgRemainLeasePayment").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("orgRemainLeasePayment").getValue();
        lineData.getCell("remainLeasePayment").setValue((Object)orgRemainLeasePayment.multiply(ratio).setScale(currencyPrecision, 4));
        BigDecimal orgFinanceFeeBalance = lineData.getCell("orgFinanceFeeBalance").getValue() == null ? BigDecimal.ZERO : (BigDecimal)lineData.getCell("orgFinanceFeeBalance").getValue();
        lineData.getCell("unrecognizedFinanceFeeBalance").setValue((Object)orgFinanceFeeBalance.multiply(ratio).setScale(currencyPrecision, 4));
    }

    protected void initWorkButton() {
        this.actionAddLine.setEnabled(true);
        this.btnEntryAdd.setText(null);
        this.btnEntryRemove.setText(null);
        this.btnEntryAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnEntryRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        super.initWorkButton();
    }

    private void terminateDateChange(DataChangeEvent eventObj) {
        if ("VIEW".equals(this.oprtState) || "FINDVIEW".equals(this.oprtState)) {
            return;
        }
        Date newDate = (Date)eventObj.getNewValue();
        if (newDate == null) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"terminateDateIsNull");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.pkTerminateDate.setValue(eventObj.getOldValue());
            return;
        }
        if (this.currentPeriod != null && (newDate.compareTo(this.currentPeriod.getEndDate()) > 0 || newDate.compareTo(this.currentPeriod.getBeginDate()) < 0)) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"terminateDateInPeriod", (Object[])new Object[]{this.currentPeriod.toString()});
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.pkTerminateDate.setValue(eventObj.getOldValue(), false);
            return;
        }
        this.removeAllEntryRows();
    }

    private void terminateModeDateChange(ItemEvent itemEvent) {
        if ("VIEW".equals(this.oprtState) || "FINDVIEW".equals(this.oprtState)) {
            return;
        }
        FaTerminateMode faTerminateMode = (FaTerminateMode)((Object)itemEvent.getItem());
        this.editData.setTerminateMode(faTerminateMode);
        this.removeAllEntryRows();
        this.setEntryStyle(faTerminateMode == FaTerminateMode.RETROSPECT_TERMINATION);
        if (faTerminateMode == FaTerminateMode.COMPLETELYL_TERMINATION || faTerminateMode == FaTerminateMode.FULL_TERMINATION) {
            this.getDetailTable().getColumn("isCreateLeaseInBill").getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn("isCreateLeaseInBill").getStyleAttributes().setBackground(GRAY);
            this.getDetailTable().getColumn("ratio").getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn("ratio").getStyleAttributes().setBackground(GRAY);
        } else {
            this.getDetailTable().getColumn("isCreateLeaseInBill").getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn("isCreateLeaseInBill").getStyleAttributes().setBackground(GRAY);
            this.getDetailTable().getColumn("ratio").getStyleAttributes().setLocked(false);
            this.getDetailTable().getColumn("ratio").getStyleAttributes().setBackground(this.getDetailTable().getRequiredColor());
        }
    }

    private void refreshTotalData() {
        this.editData.setTotalBeginAssets(BigDecimal.ZERO);
        this.editData.setTotalBeginLiabilities(BigDecimal.ZERO);
        this.editData.setTotalUnacknFinaCharges(BigDecimal.ZERO);
        this.editData.setTotalAcumDepreAmt(BigDecimal.ZERO);
        this.editData.setTotalAcumInterestExpe(BigDecimal.ZERO);
        this.editData.setTotalPaidRent(BigDecimal.ZERO);
        int j = this.detailTable.getRowCount();
        for (int i = 0; i < j; ++i) {
            IRow currentRow = this.detailTable.getRow(i);
            FaTerminateBillEntryInfo entryInfo = (FaTerminateBillEntryInfo)currentRow.getUserObject();
            Object terInitialAsset = currentRow.getCell("terInitialAsset").getValue();
            this.editData.setTotalBeginAssets(this.editData.getTotalBeginAssets().add(terInitialAsset == null ? BigDecimal.ZERO : (BigDecimal)terInitialAsset));
            Object terInitialLiability = currentRow.getCell("terInitialLiability").getValue();
            this.editData.setTotalBeginLiabilities(this.editData.getTotalBeginLiabilities().add(terInitialLiability == null ? BigDecimal.ZERO : (BigDecimal)terInitialLiability));
            Object terUFinanceFee = currentRow.getCell("terUFinanceFee").getValue();
            this.editData.setTotalUnacknFinaCharges(this.editData.getTotalUnacknFinaCharges().add(terUFinanceFee == null ? BigDecimal.ZERO : (BigDecimal)terUFinanceFee));
            Object terAcumDepreAmt = currentRow.getCell("terAcumDepreAmt").getValue();
            this.editData.setTotalAcumDepreAmt(this.editData.getTotalAcumDepreAmt().add(terAcumDepreAmt == null ? BigDecimal.ZERO : (BigDecimal)terAcumDepreAmt));
            Object terAcumInterestExpe = currentRow.getCell("terAcumInterestExpe").getValue();
            this.editData.setTotalAcumInterestExpe(this.editData.getTotalAcumInterestExpe().add(terAcumInterestExpe == null ? BigDecimal.ZERO : (BigDecimal)terAcumInterestExpe));
            Object terPaidRent = currentRow.getCell("terPaidRent").getValue();
            this.editData.setTotalPaidRent(this.editData.getTotalPaidRent().add(terPaidRent == null ? BigDecimal.ZERO : (BigDecimal)terPaidRent));
        }
        this.txtTotalBeginAssets.setNumberValue((Number)this.editData.getTotalBeginAssets());
        this.txtTotalBeginLiabilities.setNumberValue((Number)this.editData.getTotalBeginLiabilities());
        this.txtTotalUnacknFinaCharges.setNumberValue((Number)this.editData.getTotalUnacknFinaCharges());
        this.txtTotalAcumDepreAmt.setNumberValue((Number)this.editData.getTotalAcumDepreAmt());
        this.txtTotalAcumInterestExpe.setNumberValue((Number)this.editData.getTotalAcumInterestExpe());
        this.txtTotalPaidRent.setNumberValue((Number)this.editData.getTotalPaidRent());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaTerminateBillFactory.getRemoteInstance();
    }

    protected String getEntryKeyName() {
        return "entry";
    }

    protected String[] getEditableColumn() {
        return new String[]{"dispositionOfAssets", "isCreateLeaseInBill", "terPaidRent", "ratio", "retrospectAdjustDate", "remainLeasePayment"};
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("effectedStatus");
        selectors.add("deletedStatus");
        selectors.add("checkedStatus");
        selectors.add("blockedStatus");
        selectors.add("fiVouchered");
        selectors.add("company.id");
        selectors.add("company.number");
        selectors.add("company.name");
        return selectors;
    }

    protected void setDefaultUIButtonStatus() {
        if (this.editData != null) {
            this.actionSubmit.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
        } else {
            this.actionSubmit.setEnabled(true);
        }
        super.setDefaultUIButtonStatus();
    }

    public void checkModified() throws Exception {
        if (this.isModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SUBMIT_FIRST"));
            SysUtil.abort();
        }
    }

    protected boolean isEntryModify() {
        FaBillBaseEntityInfo defaultEntry;
        FaBillBaseEntityInfo newEntry;
        if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return false;
        }
        FaBillBaseEntityCollection newEntryCol = this.getBillBaseEntryCollection((IObjectValue)this.editData);
        if ("ADDNEW".equals(this.getOprtState()) && newEntryCol.size() == 1 && (newEntry = newEntryCol.get(0)).equals((Object)(defaultEntry = (FaBillBaseEntityInfo)this.createNewDetailData(this.detailTable)))) {
            return false;
        }
        if (newEntryCol.size() != this.oldEntryCol.size()) {
            return true;
        }
        int size = newEntryCol.size();
        for (int i = 0; i < size; ++i) {
            if (newEntryCol.get(i) == null || newEntryCol.get(i) != null && this.oldEntryCol.get(i) != null && ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.oldEntryCol.get(i), (AbstractObjectValue)newEntryCol.get(i))) continue;
            return true;
        }
        return false;
    }

    protected void verifyBeforeSubmit(ActionEvent e) throws Exception {
        FaTerminateBillEntryCollection entry;
        String msg;
        this.storeFields();
        Date date = (Date)this.pkTerminateDate.getValue();
        if (date == null) {
            msg = EASResource.getString((String)RESOURCE_PATH, (String)"terminateDateIsNull");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        if (this.currentPeriod != null && (date.compareTo(this.currentPeriod.getEndDate()) > 0 || date.compareTo(this.currentPeriod.getBeginDate()) < 0)) {
            msg = EASResource.getString((String)RESOURCE_PATH, (String)"terminateDateInPeriod", (Object[])new Object[]{this.currentPeriod.toString()});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        if ((entry = this.editData.getEntry()) == null || entry.size() == 0) {
            String msg2 = EASResource.getString((String)RESOURCE_PATH, (String)"ENTRY_EMPTY");
            MsgBox.showInfo((String)msg2);
            SysUtil.abort();
        }
        SelectorItemCollection sicLeaseInBill = new SelectorItemCollection();
        sicLeaseInBill.add("isDeductible");
        sicLeaseInBill.add("leaseType");
        sicLeaseInBill.add("payFrequency");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("rentPeriod");
        sic.add("paymentWithoutTax");
        sic.add("paymentWithTax");
        view.setSelector(sic);
        IFaPaymentPlanNew iFaPaymentPlanNew = FaPaymentPlanNewFactory.getRemoteInstance();
        for (int i = 0; i < entry.size(); ++i) {
            String entryStr = EASResource.getString((String)RESOURCE_PATH, (String)"entry");
            if (entry.get(i).getPaidRent() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)(entryStr + (i + 1) + EASResource.getString((String)RESOURCE_PATH, (String)"paidRentNotNull")));
                SysUtil.abort();
            }
            if (entry.get(i).getRatio() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)(entryStr + (i + 1) + EASResource.getString((String)RESOURCE_PATH, (String)"ratioNotNull")));
                SysUtil.abort();
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("head.id", (Object)entry.get(i).getLeaseInBill().getId().toString()));
            view.setFilter(filter);
            FaPaymentPlanNewCollection ppCol = iFaPaymentPlanNew.getFaPaymentPlanNewCollection(view);
            ppCol.sort("rentPeriod");
            FaLeaseInBillNewInfo faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(entry.get(i).getLeaseInBill().getId()), sicLeaseInBill);
            if (!this.checkPayOff(faLeaseInBillNewInfo) && ppCol.size() != 0 || entry.get(i).getPaidRent().compareTo(ZERO) == 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)(entryStr + (i + 1) + EASResource.getString((String)RESOURCE_PATH, (String)"paidRentIsZeroWithAdvance")));
            SysUtil.abort();
        }
    }

    private boolean checkPayOff(FaLeaseInBillNewInfo billInfo) {
        FaPayFrequencyEnum payFrequency = billInfo.getPayFrequency();
        FaLeaseTypeEnum leaseType = billInfo.getLeaseType() == null ? FaLeaseTypeEnum.OPERATING_LEASE : billInfo.getLeaseType();
        boolean isPayFrequency = FaPayFrequencyEnum.PAY_IN_ADVANCE == payFrequency;
        boolean isLeaseType = FaLeaseTypeEnum.OPERATING_LEASE == leaseType;
        return isPayFrequency && isLeaseType;
    }

    protected boolean isShowCardFilter() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRuleNumber(FaBillBaseInfo baseInfo) {
        String number = null;
        ICodingRuleManager iCodingRuleManager = null;
        CompanyOrgUnitInfo company = this.getCurCompany();
        try {
            if (baseInfo.getCompany() == null) {
                baseInfo.setCompany(company);
            }
            iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, company.getId().toString());
            boolean isViewCodeRule = iCodingRuleManager.isAddView((IObjectValue)baseInfo, company.getId().toString());
            number = isCodingRule && isViewCodeRule ? iCodingRuleManager.readNumber((IObjectValue)baseInfo, company.getId().toString()) : "";
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        finally {
            if (number == null && this.isNeedCodeRule()) {
                SysUtil.abort();
            }
        }
        return number;
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (this.editData == null) {
            return;
        }
        FaTerminateBillEntryCollection entry = this.editData.getEntry();
        if (this.editData != null && entry != null) {
            for (int i = 0; i < entry.size(); ++i) {
                String leaseInBillId = entry.get(i).getLeaseInBill().getId().toString();
                if (this.leaseBillIdList.contains(leaseInBillId)) continue;
                this.leaseBillIdList.add(leaseInBillId);
            }
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected void invokePrint(boolean preview) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaTerminateBillNewEditUI((IObjectCollection)billCol, (KDTable[])tables);
        if (preview) {
            appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
        } else {
            appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
        }
    }

    protected String getPrintPath() {
        return "/FI/FL/FaTerminateBill";
    }

    private void removeAllEntryRows() {
        this.detailTable.removeRows();
        this.editData.setTotalBeginAssets(new BigDecimal("0"));
        this.editData.setTotalBeginLiabilities(new BigDecimal("0"));
        this.editData.setTotalUnacknFinaCharges(new BigDecimal("0"));
        this.editData.setTotalAcumDepreAmt(new BigDecimal("0"));
        this.editData.setTotalPaidRent(new BigDecimal("0"));
        this.editData.setTotalAcumInterestExpe(new BigDecimal("0"));
        this.txtTotalBeginAssets.setNumberValue((Number)this.editData.getTotalBeginAssets());
        this.txtTotalBeginLiabilities.setNumberValue((Number)this.editData.getTotalBeginLiabilities());
        this.txtTotalUnacknFinaCharges.setNumberValue((Number)this.editData.getTotalUnacknFinaCharges());
        this.txtTotalAcumDepreAmt.setNumberValue((Number)this.editData.getTotalAcumDepreAmt());
        this.txtTotalPaidRent.setNumberValue((Number)this.editData.getTotalPaidRent());
        this.txtTotalAcumInterestExpe.setNumberValue((Number)this.editData.getTotalAcumInterestExpe());
        this.leaseBillIdList.clear();
    }

    private void setEntryStyle(boolean isRetrospectTermination) {
        IColumn retrospectAdjustDate = this.detailTable.getColumn("retrospectAdjustDate");
        KDDatePicker kdDatePicker = new KDDatePicker();
        kdDatePicker.setDisplay(true);
        kdDatePicker.setEditable(true);
        kdDatePicker.setDatePattern("yyyy-MM-dd");
        kdDatePicker.setTimeEnabled(false);
        kdDatePicker.setValue((Object)new Date());
        kdDatePicker.setSupportedEmpty(false);
        retrospectAdjustDate.setEditor((ICellEditor)new KDTDefaultCellEditor(kdDatePicker));
        retrospectAdjustDate.getStyleAttributes().setHided(!isRetrospectTermination);
        IColumn retrospectAcumDepreAmt = this.detailTable.getColumn("terRetrAcumDepreAmt");
        retrospectAcumDepreAmt.getStyleAttributes().setHided(!isRetrospectTermination);
        IColumn retrospectUFFee = this.detailTable.getColumn("terRetrUFFee");
        retrospectUFFee.getStyleAttributes().setHided(!isRetrospectTermination);
        IColumn retrospectPaidRent = this.detailTable.getColumn("terRetrPaidRent");
        retrospectPaidRent.getStyleAttributes().setHided(!isRetrospectTermination);
        IColumn terRetrDecValue = this.detailTable.getColumn("terRetrDecValue");
        terRetrDecValue.getStyleAttributes().setHided(!isRetrospectTermination);
    }

    private void refreshRetrospectData(Date retrospectAdjustDate) {
        try {
            IRow iRow = this.getDetailTable().getRow(this.getDetailTable().getSelectManager().getActiveRowIndex());
            HashSet<String> leaseInIdSet = new HashSet<String>();
            String leaseInBillNumber = iRow.getCell("leaseInBillNumber").getValue().toString();
            String leaseInBillId = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo("where number = '" + leaseInBillNumber + "'").getId().toString();
            leaseInIdSet.add(leaseInBillId);
            Date tmDate = (Date)this.pkTerminateDate.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("Currency.*");
            sic.add("exchangeRate.*");
            sic.add("exchangeRate.exchangeAux.*");
            FaLeaseInBillNewInfo leaseInBillTmp = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseInBillId), sic);
            int currencyPrecision = this.getCurrencyScale();
            int currencyPrecisionOC = leaseInBillTmp.getCurrency().getPrecision();
            Map paidRentMap = FaTerminateBillFactory.getRemoteInstance().getPaidRentAmt(leaseInIdSet, tmDate, this.editData.getTerminateMode(), retrospectAdjustDate);
            Map deprInterestMap = FaTerminateBillFactory.getRemoteInstance().getDeprInterestAmt(leaseInIdSet, tmDate, this.editData.getTerminateMode(), retrospectAdjustDate);
            BigDecimal[] deprInterest = (BigDecimal[])deprInterestMap.get(leaseInBillId);
            BigDecimal ratio = (BigDecimal)iRow.getCell("ratio").getValue();
            ratio = ratio.divide(new BigDecimal("100"));
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            HashMap<String, Object> params = new HashMap<String, Object>();
            leaseInBillTmp.put("terminateType", this.editData.getTerminateMode().getName());
            params.put("leaseInBillId", leaseInBillTmp.getId().toString());
            params.put("leaseInBill", leaseInBillTmp);
            params.put("terminateDate", tmDate);
            params.put("adjustDate", retrospectAdjustDate);
            leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_RETR_DEC_VALUE.getName());
            CalcTree.calc(null, leaseInBillTmp, params, resultMap);
            leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_REMAINING_LEASE_PAYMENTS.getName());
            CalcTree.calc(null, leaseInBillTmp, params, resultMap);
            leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_UNRECOGNIZED_FINANCING.getName());
            CalcTree.calc(null, leaseInBillTmp, params, resultMap);
            BigDecimal retrospectDecValue = (BigDecimal)resultMap.get("retrospectDecValue");
            iRow.getCell("retrospectDecValue").setValue((Object)retrospectDecValue);
            iRow.getCell("terRetrDecValue").setValue((Object)((BigDecimal)iRow.getCell("retrospectDecValue").getValue()).multiply(ratio).setScale(currencyPrecision, 4));
            leaseInBillTmp.put("calcType", FlCalcTreeCalcTypeEnum.CALC_DEC_VALUE.getName());
            CalcTree.calc(null, leaseInBillTmp, params, resultMap);
            BigDecimal initialAssetDecValue = resultMap.get(KEY_InitialAssetDecValue) == null ? BigDecimal.ZERO : (BigDecimal)resultMap.get(KEY_InitialAssetDecValue);
            iRow.getCell(KEY_InitialAssetDecValue).setValue((Object)initialAssetDecValue);
            iRow.getCell("terInitialAssetDecValue").setValue((Object)initialAssetDecValue.multiply(ratio).setScale(currencyPrecision, 4));
            BigDecimal unrecognizedFinanceFeeBalance = resultMap.get("unrecognizedFinanceFeeBalance") == null ? BigDecimal.ZERO : (BigDecimal)resultMap.get("unrecognizedFinanceFeeBalance");
            BigDecimal remainLeasePayment = resultMap.get("remainLeasePayment") == null ? BigDecimal.ZERO : (BigDecimal)resultMap.get("remainLeasePayment");
            iRow.getCell("unrecognizedFinanceFeeBalance").setValue((Object)unrecognizedFinanceFeeBalance);
            iRow.getCell("remainLeasePayment").setValue((Object)remainLeasePayment);
            iRow.getCell("paidRent").setValue((Object)(paidRentMap.get(leaseInBillId) == null ? BigDecimal.ZERO : paidRentMap.get(leaseInBillId)));
            iRow.getCell("terPaidRent").setValue((Object)((BigDecimal)iRow.getCell("paidRent").getValue()).multiply(ratio).setScale(currencyPrecisionOC, 4));
            iRow.getCell("acumDepreAmt").setValue((Object)(deprInterest == null ? BigDecimal.ZERO : deprInterest[0]));
            iRow.getCell("terAcumDepreAmt").setValue((Object)((BigDecimal)iRow.getCell("acumDepreAmt").getValue()).multiply(ratio).setScale(currencyPrecision, 4));
            iRow.getCell("acumInterestExpe").setValue((Object)(deprInterest == null ? BigDecimal.ZERO : deprInterest[1]));
            iRow.getCell("terAcumInterestExpe").setValue((Object)((BigDecimal)iRow.getCell("acumInterestExpe").getValue()).multiply(ratio).setScale(currencyPrecisionOC, 4));
            iRow.getCell("retrospectPaidRent").setValue((Object)(paidRentMap.get(leaseInBillId + "adjust") == null ? BigDecimal.ZERO : paidRentMap.get(leaseInBillId + "adjust")));
            iRow.getCell("terRetrPaidRent").setValue((Object)((BigDecimal)iRow.getCell("retrospectPaidRent").getValue()).multiply(ratio).setScale(currencyPrecisionOC, 4));
            iRow.getCell("retrospectAcumDepreAmt").setValue((Object)(deprInterest == null ? BigDecimal.ZERO : deprInterest[2]));
            iRow.getCell("terRetrAcumDepreAmt").setValue((Object)((BigDecimal)iRow.getCell("retrospectAcumDepreAmt").getValue()).multiply(ratio).setScale(currencyPrecision, 4));
            iRow.getCell("retrospectUFFee").setValue((Object)(deprInterest == null ? BigDecimal.ZERO : deprInterest[3]));
            iRow.getCell("terRetrUFFee").setValue((Object)((BigDecimal)iRow.getCell("retrospectUFFee").getValue()).multiply(ratio).setScale(currencyPrecisionOC, 4));
        }
        catch (Exception e) {
            MsgBox.showError((String)e.toString());
        }
    }

    private void refreshAssetDisposalGain() {
        try {
            IRow iRow = this.getDetailTable().getRow(this.getDetailTable().getSelectManager().getActiveRowIndex());
            String leaseInBillNumber = iRow.getCell("leaseInBillNumber").getValue().toString();
            String leaseInBillId = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo("where number = '" + leaseInBillNumber + "' and company.id = '" + this.getCurrentCompanyID() + "'").getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("Currency.*");
            sic.add("exchangeRate.*");
            sic.add("exchangeRate.exchangeAux.*");
            FaLeaseInBillNewInfo leaseInBillTmp = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseInBillId), sic);
            BigDecimal tmpOne = new BigDecimal(iRow.getCell("orgRemainLeasePayment").getValue().toString()).subtract(new BigDecimal(iRow.getCell("orgFinanceFeeBalance").getValue().toString()));
            BigDecimal tmpTwo = new BigDecimal(iRow.getCell("acumDepreAmt").getValue().toString()).add(new BigDecimal(iRow.getCell(KEY_InitialAssetDecValue).getValue().toString()).subtract(new BigDecimal(iRow.getCell("initialAsset").getValue().toString())));
            BigDecimal tmpAdd = tmpOne.add(tmpTwo);
            BigDecimal ratio = new BigDecimal(iRow.getCell("ratio").getValue().toString()).divide(new BigDecimal("100"));
            BigDecimal assetDisposalGain = tmpAdd.multiply(ratio);
            iRow.getCell("assetDisposalGain").setValue((Object)assetDisposalGain.setScale(this.getCurrencyScale(), 4));
            iRow.getCell("terAssetDisposalGain").setValue((Object)assetDisposalGain.setScale(this.getCurrencyScale(), 4));
            if (new BigDecimal("0").compareTo((BigDecimal)iRow.getCell("terAssetDisposalGain").getValue()) == 1) {
                iRow.getCell("dispositionOfAssets").setValue((Object)FaDispositionEnum.PROFIT);
            } else {
                iRow.getCell("dispositionOfAssets").setValue((Object)FaDispositionEnum.DEFICIT);
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)e.toString());
        }
    }

    @Override
    public void actionViewCalculationProcess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewCalculationProcess_actionPerformed(e);
        int activeRow = this.detailTable.getSelectManager().getActiveRowIndex();
        if (activeRow == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u70b9\u51fb\u8ba1\u7b97\u8fc7\u7a0b");
            return;
        }
        IRow iRow = this.detailTable.getRow(activeRow);
        FaLeaseInBillNewInfo billNewInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo("where number = '" + iRow.getCell("leaseInBillNumber").getValue() + "'");
        billNewInfo.put("terminateType", ((FaTerminateMode)((Object)this.comboTerminateMode.getSelectedItem())).getName());
        billNewInfo.put("terminateDate", this.pkTerminateDate.getSqlDate());
        billNewInfo.put("adjustDate", iRow.getCell("retrospectAdjustDate") == null ? null : iRow.getCell("retrospectAdjustDate").getValue());
        UIContext modelContext = new UIContext();
        modelContext.put((Object)"billNewInfo", (Object)billNewInfo);
        modelContext.put((Object)"ratio", iRow.getCell("ratio").getValue());
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_PAID_RENT_AMT.getName(), iRow.getCell("terPaidRent").getValue());
        BigDecimal terInitialAsset = (BigDecimal)iRow.getCell("terInitialAsset").getValue();
        BigDecimal terInitialLiability = (BigDecimal)iRow.getCell("terInitialLiability").getValue();
        BigDecimal terUFinanceFee = (BigDecimal)iRow.getCell("terUFinanceFee").getValue();
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_INIT_AMOUNT.getName(), (Object)new BigDecimal[]{terInitialAsset, terInitialLiability, terUFinanceFee});
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_DEC_VALUE.getName(), iRow.getCell("terInitialAssetDecValue").getValue());
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_ACUM_DEPRE_AMT.getName(), iRow.getCell("terAcumDepreAmt").getValue());
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_ACUM_INTEREST_EXPE.getName(), iRow.getCell("terAcumInterestExpe").getValue());
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_RETR_PAID_RENT_AMT.getName(), iRow.getCell("terRetrPaidRent").getValue());
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_RETR_ACUM_DEPRE_AMT.getName(), iRow.getCell("terRetrAcumDepreAmt").getValue());
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_RETR_ACUM_INTEREST_EXPE.getName(), iRow.getCell("terRetrUFFee").getValue());
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_ASSET_DISPOSAL_GAIN.getName(), iRow.getCell("terAssetDisposalGain").getValue());
        modelContext.put((Object)FlCalcTreeCalcTypeEnum.CALC_UNRECOGNIZED_FINANCING.getName(), iRow.getCell("terAcumInterestExpe").getValue());
        IUIWindow modelWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NLMTerminateCalculationProcessUI.class.getName(), (Map)modelContext, null, null);
        modelWindow.show();
    }

    public void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
        FlUtils.checkAdjustmentPeriodForNLM(e.getActionCommand());
    }
}

