/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.FaTerminateMode;
import com.kingdee.eas.fi.nlm.client.AbstractFaTerminateBillFilterUI;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class FaTerminateBillFilterUI
extends AbstractFaTerminateBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FaTerminateBillFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.auditPanel.setOpaque(false);
        this.initControl();
    }

    private void initControl() throws Exception {
        this.radioBtnAll.setSelected(true);
        this.dpTerminamteDateFrom.setValue(null);
        this.dpTerminamteDateTo.setValue(null);
        this.modeComboBox.addItem((Object)"");
    }

    @Override
    protected void radioBtnAll_actionPerformed(ActionEvent e) throws Exception {
        super.radioBtnAll_actionPerformed(e);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo templateFilterItemInfo;
        FilterItemInfo templateFilterItemInfo2;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        FaClientUtils.checkComp4Fl(null, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            items.add(companyFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.tfNumberFrom.getText() != null && this.tfNumberFrom.getText().trim().length() > 0) {
            templateFilterItemInfo2 = new FilterItemInfo("number", (Object)this.tfNumberFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo2);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.tfNumberTo.getText() != null && this.tfNumberTo.getText().trim().length() > 0) {
            templateFilterItemInfo2 = new FilterItemInfo("number", (Object)this.tfNumberTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo2);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.dpTerminamteDateFrom.getValue() != null) {
            Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.dpTerminamteDateFrom.getValue()));
            templateFilterItemInfo = new FilterItemInfo("terminateDate", (Object)dateFrom, CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.dpTerminamteDateTo.getValue() != null) {
            Date dateTo = new Date(DateTimeUtils.truncateDate((Date)((Date)this.dpTerminamteDateTo.getValue())).getTime() + 86400000L - 1L);
            templateFilterItemInfo = new FilterItemInfo("terminateDate", (Object)dateTo, CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.modeComboBox.getSelectedItem() != null && !"".equals(this.modeComboBox.getSelectedItem())) {
            templateFilterItemInfo2 = new FilterItemInfo("terminateMode", (Object)((FaTerminateMode)((Object)this.modeComboBox.getSelectedItem())).getValue());
            items.add(templateFilterItemInfo2);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.radioBtnAudit.isSelected()) {
            FilterItemInfo audited = new FilterItemInfo("checkedStatus", (Object)new Integer(2));
            items.add(audited);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (this.radioBtnUnAudit.isSelected()) {
            FilterItemInfo unAudited = new FilterItemInfo("checkedStatus", (Object)new Integer(1));
            items.add(unAudited);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        return filter;
    }

    public void loadData(EntityViewInfo viewInfo) {
        this.clear();
        try {
            FilterItemCollection currentFilterItemCollection = viewInfo.getFilter().getFilterItems();
            if (currentFilterItemCollection == null || currentFilterItemCollection.size() == 0) {
                return;
            }
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
                String number;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equals("number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.tfNumberFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.tfNumberTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("terminateDate") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    this.dpTerminamteDateFrom.setValue(filterItemInfo.getCompareValue());
                }
                if (filterItemInfo.getPropertyName().equals("terminateDate") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    this.dpTerminamteDateTo.setValue(filterItemInfo.getCompareValue());
                }
                if (filterItemInfo.getPropertyName().equals("terminateMode")) {
                    String model = filterItemInfo.getCompareValue().toString();
                    this.modeComboBox.setSelectedItem((Object)FaTerminateMode.getEnum(model));
                }
                if (filterItemInfo.getPropertyName().equals("checkedStatus") && filterItemInfo.getCompareValue() != null) {
                    if ((Integer)filterItemInfo.getCompareValue() == 2) {
                        this.radioBtnAudit.setSelected(true);
                    } else if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.radioBtnUnAudit.setSelected(true);
                    }
                }
                if (!filterItemInfo.getPropertyName().equals("checkedStatus") || filterItemInfo.getCompareValue() != null) continue;
                this.radioBtnAll.setSelected(true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        this.radioBtnAll.setSelected(true);
        this.modeComboBox.setSelectedIndex(this.modeComboBox.getItemCount() - 1);
        this.dpTerminamteDateFrom.setValue(null);
        this.dpTerminamteDateTo.setValue(null);
        this.tfNumberFrom.setText("");
        this.tfNumberTo.setText("");
    }
}

