/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.FlCalcNodeTypeEnum;
import com.kingdee.eas.fi.nlm.NLMCalcTreeCollection;
import com.kingdee.eas.fi.nlm.NLMCalcTreeFactory;
import com.kingdee.eas.fi.nlm.NLMCalcTreeInfo;
import com.kingdee.eas.fi.nlm.client.AbstractNLMCalcTreeListUI;
import com.kingdee.eas.fi.nlm.client.NLMCalcTreeEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NLMCalcTreeListUI
extends AbstractNLMCalcTreeListUI {
    private static final Logger logger = CoreUIObject.getLogger(NLMCalcTreeListUI.class);

    public void onLoad() throws Exception {
        FaClientUtils.checkBeforeOnload4Fl();
        super.onLoad();
        this.createXMLFile.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.getUserObject() instanceof NLMCalcTreeInfo) {
            NLMCalcTreeInfo nLMCalcTreeInfo = (NLMCalcTreeInfo)treeNode.getUserObject();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String selectID = this.getSelectedKeyValue();
        this.verifyRemoveLine(selectID);
        super.actionRemove_actionPerformed(e);
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"209_NLMCalcTreeListUI");
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        FilterInfo filterInfo = viewInfo.getFilter() == null ? new FilterInfo() : viewInfo.getFilter();
        StringBuffer sb = new StringBuffer(filterInfo.getMaskString() == null ? "" : filterInfo.getMaskString());
        int maskCount = filterInfo.getFilterItems().size();
        FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)this.aCompanyOrgUnitInfo.getId().toString(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(companyFilterItemInfo);
        if (maskCount != 0) {
            if (sb.toString().length() == 0 && maskCount == 1) {
                sb.append("#0 and #1");
            } else {
                sb = new StringBuffer("(" + sb.toString() + ")");
                sb.append(" and #").append(maskCount);
            }
        } else {
            sb.append("#0");
        }
        filterInfo.setMaskString(sb.toString());
        viewInfo.setFilter(filterInfo);
        boolean isSortByNum = false;
        SorterItemCollection sortCollection = viewInfo.getSorter();
        if (sortCollection != null && sortCollection.size() > 0) {
            for (int i = 0; i < sortCollection.size(); ++i) {
                SorterItemInfo aSorterItemInfo = sortCollection.get(i);
                if (!aSorterItemInfo.getPropertyName().equalsIgnoreCase("number")) continue;
                isSortByNum = true;
                break;
            }
        }
        if (!isSortByNum) {
            SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
            aSorterItemInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(aSorterItemInfo);
        }
        return exec;
    }

    protected String getEditUIName() {
        return NLMCalcTreeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return NLMCalcTreeFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return NLMCalcTreeFactory.getRemoteInstance();
    }

    public TreeBaseInfo getData() throws Exception {
        Object keyValue;
        NLMCalcTreeInfo nlmCalcTreeInfo = null;
        if (this.tblMain.getSelectManager().get() == null) {
            return null;
        }
        int rowIndex = this.tblMain.getSelectManager().get().getTop();
        IRow row = this.tblMain.getRow(rowIndex);
        ICell cell = row.getCell(this.getKeyFieldName());
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if ((keyValue = cell.getValue()) != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)keyValue.toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("creator.number"));
            nlmCalcTreeInfo = NLMCalcTreeFactory.getRemoteInstance().getNLMCalcTreeInfo((IObjectPK)pk, sic);
        }
        return nlmCalcTreeInfo;
    }

    public AbstractObjectCollection getDataCollection() throws Exception {
        NLMCalcTreeCollection nlmCalcTreeCollection = new NLMCalcTreeCollection();
        HashSet<Object> result = new HashSet<Object>();
        int size = this.tblMain.getSelectManager().size();
        for (int count = 0; count < size; ++count) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(count);
            if (selectBlock == null) {
                return null;
            }
            int beginRow = selectBlock.getTop();
            int endRow = selectBlock.getBottom();
            for (int i = beginRow; i <= endRow; ++i) {
                Object keyValue;
                IRow row = this.tblMain.getRow(i);
                ICell cell = row.getCell(this.getKeyFieldName());
                if (cell == null) {
                    MsgBox.showError((Component)Util.getWindow((Component)((Object)this)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if ((keyValue = cell.getValue()) == null) continue;
                result.add(keyValue);
            }
        }
        if (result.size() > 0) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", result, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("creator.number"));
            ev.setFilter(filter);
            ev.getSelector().addObjectCollection((IObjectCollection)sic);
            nlmCalcTreeCollection = NLMCalcTreeFactory.getRemoteInstance().getNLMCalcTreeCollection(ev);
        }
        return nlmCalcTreeCollection;
    }

    @Override
    public void actionCreateXMLFile_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateXMLFile_actionPerformed(e);
        NLMCalcTreeInfo rootInfo = NLMCalcTreeFactory.getRemoteInstance().getNLMCalcTreeInfo("where parent.id is null");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            Document document = db.newDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement(rootInfo.getNodeType().getName());
            root.setAttribute("id", rootInfo.getId().toString());
            root.setAttribute("number", rootInfo.getNumber());
            root.setAttribute("name", rootInfo.getName());
            root.setAttribute("is_leaf", String.valueOf(rootInfo.isIsLeaf()));
            root.setAttribute("conditional_judgment_class", rootInfo.getConditionalJudgmentClass());
            root.setAttribute("calc_class", rootInfo.getCalcClass());
            NLMCalcTreeCollection childCollection = NLMCalcTreeFactory.getRemoteInstance().getNLMCalcTreeCollection("where parent.id = '" + rootInfo.getId().toString() + "'");
            List<Element> childList = this.getChildList(document, childCollection);
            for (Element element : childList) {
                root.appendChild(element);
            }
            document.appendChild(root);
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("indent", "yes");
            tf.transform(new DOMSource(document), new StreamResult(new File("D:\\pt_eas800_patch\\workspace\\fi_fa_manage\\dev\\src\\com\\kingdee\\eas\\fi\\fa\\manage\\calctree\\fl_calc_terminate_bill_tree.xml").toURI().getPath()));
            System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"210_NLMCalcTreeListUI"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"211_NLMCalcTreeListUI"));
        }
    }

    private List<Element> getChildList(Document document, NLMCalcTreeCollection childCollection) throws BOSException {
        if (childCollection == null || childCollection.size() == 0) {
            return new ArrayList<Element>();
        }
        ArrayList<Element> nodeList = new ArrayList<Element>();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            NLMCalcTreeInfo calcTreeInfo = childCollection.get(i);
            Element node = document.createElement(calcTreeInfo.getNodeType().getName());
            node.setAttribute("id", calcTreeInfo.getId().toString());
            node.setAttribute("number", calcTreeInfo.getNumber());
            node.setAttribute("name", calcTreeInfo.getName());
            node.setAttribute("is_leaf", String.valueOf(calcTreeInfo.isIsLeaf()));
            if (calcTreeInfo.getNodeType() == FlCalcNodeTypeEnum.calc_tree) {
                node.setAttribute("conditional_judgment_class", calcTreeInfo.getConditionalJudgmentClass());
                node.setAttribute("calc_class", calcTreeInfo.getCalcClass());
            }
            if (calcTreeInfo.getNodeType() == FlCalcNodeTypeEnum.son_list) {
                node.setAttribute("condition_type", calcTreeInfo.getConditionType());
                node.setAttribute("conditional_judgment_method", calcTreeInfo.getConditionalJudgmentMethod());
                node.setAttribute("conditional_judgment_field", calcTreeInfo.getConditionalJudgmentField());
            }
            if (calcTreeInfo.getNodeType() == FlCalcNodeTypeEnum.tree_node) {
                node.setAttribute("condition_value", calcTreeInfo.getConditionValue());
            }
            if (calcTreeInfo.getNodeType() == FlCalcNodeTypeEnum.calc_node) {
                node.setAttribute("calc_method", calcTreeInfo.getCalcMethod());
                node.setAttribute("calc_field", calcTreeInfo.getCalcField());
            }
            NLMCalcTreeCollection children = NLMCalcTreeFactory.getRemoteInstance().getNLMCalcTreeCollection("where parent.id = '" + calcTreeInfo.getId().toString() + "'");
            List<Element> childNodeList = this.getChildList(document, children);
            for (Element element : childNodeList) {
                node.appendChild(element);
            }
            nodeList.add(node);
        }
        return nodeList;
    }
}

