/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortCollection;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.client.FaLeaseNewDepCostSharingEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FLNewDepKDTEditAdapter
extends KDTEditAdapter {
    private final String ID = "id";
    private final String LEASE_BILL = "leaseBill";
    private final String ACCOUNT_VIEW = "accountView";
    private final String APPORTION_SCALE = "apportionScale";
    private final String ASSET_ACT_TYPE = "asstActType";
    private final String ASSET_ACT_ITEM_OBJ = "asstActItemObj";
    private final String REMARK = "remark";
    private final String SEQ = "seq";
    private final String DEP_ID = "depID";
    private final String LEASE_BILL_ID = "leaseBillId";
    private final String LEASE_BILL_NUMBER = "leaseBillNumber";
    private final String Fa_Lease_Asst_Act_Composite = "faLeaseAsstActComposite";
    private final String Monthly_Dep_Amt_Scale = "monthlyDepAmtScale";
    private final String Monthly_Interest_Exp_Scale = "monthlyInterestExpScale";
    private final KDTable depTable;
    private final Component comp;
    private final CompanyOrgUnitInfo aCompanyOrgUnitInfo;
    private final PeriodInfo currPeriod;
    private final KDBizPromptBox kDBizPromptBoxAsstTypeItemF7;
    private final Map<String, String> modifyDataIndex;
    private final ArrayList<Map<String, Object>> storeTableData;
    private final Map<String, Set<Integer>> storeTableDataIndex;

    public FLNewDepKDTEditAdapter(KDTable depTable, Component comp, CompanyOrgUnitInfo aCompanyOrgUnitInfo, PeriodInfo currPeriod, KDBizPromptBox kDBizPromptBoxAsstTypeItemF7, ArrayList<Map<String, Object>> storeTableData, Map<String, Set<Integer>> storeTableDataIndex, Map<String, String> modifyDataIndex) {
        this.depTable = depTable;
        this.comp = comp;
        this.aCompanyOrgUnitInfo = aCompanyOrgUnitInfo;
        this.currPeriod = currPeriod;
        this.kDBizPromptBoxAsstTypeItemF7 = kDBizPromptBoxAsstTypeItemF7;
        this.storeTableData = storeTableData;
        this.storeTableDataIndex = storeTableDataIndex;
        this.modifyDataIndex = modifyDataIndex;
    }

    public void editStarted(KDTEditEvent e) {
        int lineNumber = e.getRowIndex();
        if (e.getColIndex() != 1 && this.depTable.getCell(lineNumber, "leaseBill").getValue() == null) {
            MsgBox.showInfo((Component)this.comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"91_FLNewDepKDTEditAdapter"));
            return;
        }
        this.setInfoForAsstActObject(e);
    }

    public void editStopped(KDTEditEvent e) {
        int lineNumber = e.getRowIndex();
        if (e.getColIndex() != 1 && this.depTable.getCell(lineNumber, "leaseBill").getValue() == null) {
            this.depTable.getCell(lineNumber, e.getColIndex()).setValue(e.getOldValue());
            return;
        }
        this.setStoreTableData(e);
        this.setInfoForAsstActTable(e);
        this.setInfoForAsstActF7(e);
        this.setInfoForApportionScale(e);
        this.setInfoForRemake(e);
    }

    private void setInfoForAsstActObject(KDTEditEvent e) {
        if (e.getColIndex() != 5) {
            return;
        }
        Object asstType = this.depTable.getCell(e.getRowIndex(), "asstActType").getValue();
        if (asstType != null) {
            this.kDBizPromptBoxAsstTypeItemF7.setDisplayFormat("$number$-$name$");
            this.kDBizPromptBoxAsstTypeItemF7.setEditFormat("$number$-$name$");
            this.kDBizPromptBoxAsstTypeItemF7.setCommitFormat("$number$");
            this.kDBizPromptBoxAsstTypeItemF7.setEditable(true);
            this.depTable.getColumn("asstActItemObj").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxAsstTypeItemF7));
            this.depTable.getCell(this.depTable.getRowCount() - 1, "asstActItemObj").getStyleAttributes().setLocked(false);
            FaClientUtils.assignSelector((KDBizPromptBox)this.kDBizPromptBoxAsstTypeItemF7, (AsstActTypeInfo)((AsstActTypeInfo)asstType), (CoreUIObject)((CoreUIObject)this.comp));
        }
    }

    private void setStoreTableData(KDTEditEvent e) {
        int lineNumber = e.getRowIndex();
        if (e.getColIndex() != 1 || e.getValue() != null && e.getOldValue() == e.getValue()) {
            return;
        }
        FaLeaseInBillNewInfo faLeaseInBillNewInfo = (FaLeaseInBillNewInfo)this.depTable.getCell(lineNumber, "leaseBill").getValue();
        if (faLeaseInBillNewInfo == null) {
            return;
        }
        FaDepreAndAmortCollection faDepreAndAmortCollection = this.getFaDepreAndAmortCollection(faLeaseInBillNewInfo.getId().toString());
        if (faDepreAndAmortCollection.size() == 0) {
            MsgBox.showInfo((Component)this.comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"92_FLNewDepKDTEditAdapter"));
            this.depTable.getCell(lineNumber, "leaseBill").setValue(null);
        } else {
            HashMap<String, Object> depData = new HashMap<String, Object>(12);
            if (this.modifyDataIndex.containsKey(faLeaseInBillNewInfo.getNumber())) {
                depData.put("id", this.modifyDataIndex.get(faLeaseInBillNewInfo.getNumber()));
            } else {
                depData.put("id", null);
            }
            depData.put("depID", faDepreAndAmortCollection.get(0).getId().toString());
            depData.put("monthlyDepAmtScale", faDepreAndAmortCollection.get(0).getMonthlyDepreAmt());
            depData.put("monthlyInterestExpScale", faDepreAndAmortCollection.get(0).getMonthlyInterestExpe());
            depData.put("leaseBillId", faLeaseInBillNewInfo.getId().toString());
            depData.put("leaseBillNumber", faLeaseInBillNewInfo.getNumber());
            depData.put("accountView", null);
            depData.put("faLeaseAsstActComposite", new ArrayList());
            depData.put("apportionScale", new BigDecimal("100"));
            depData.put("remark", null);
            while (lineNumber >= this.storeTableData.size()) {
                this.storeTableData.add(this.storeTableData.size(), null);
            }
            ((FaLeaseNewDepCostSharingEditUI)((Object)this.comp)).changeLineInTrueTable(lineNumber);
            ((FaLeaseNewDepCostSharingEditUI)((Object)this.comp)).removeLineInStoreTableData(lineNumber);
            this.storeTableData.add(lineNumber, depData);
            ((FaLeaseNewDepCostSharingEditUI)((Object)this.comp)).resetSoreTableDataIndex(lineNumber, -1, null);
            if (this.storeTableDataIndex.containsKey(faLeaseInBillNewInfo.getNumber())) {
                Set<Integer> indexSet = this.storeTableDataIndex.get(faLeaseInBillNewInfo.getNumber());
                indexSet.add(lineNumber);
            } else {
                HashSet<Integer> indexSet = new HashSet<Integer>();
                indexSet.add(lineNumber);
                this.storeTableDataIndex.put(faLeaseInBillNewInfo.getNumber(), indexSet);
            }
        }
    }

    private void setInfoForAsstActTable(KDTEditEvent e) {
        if (e.getColIndex() != 2 || e.getValue() != null && e.getOldValue() == e.getValue()) {
            return;
        }
        int lineNumber = e.getRowIndex();
        int influenceRowCount = 0;
        Map<String, Object> map = this.storeTableData.get(lineNumber);
        if (map == null) {
            MsgBox.showInfo((Component)this.comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"93_FLNewDepKDTEditAdapter"));
            return;
        }
        AccountViewInfo curAccountInfo = (AccountViewInfo)this.depTable.getCell(lineNumber, "accountView").getValue();
        map.put("accountView", curAccountInfo == null ? null : curAccountInfo.getId().toString());
        ArrayList arrayList = (ArrayList)map.get("faLeaseAsstActComposite");
        int j = arrayList.size();
        for (int i = 1; i < j; ++i) {
            this.depTable.removeRow(lineNumber + 1);
        }
        int count = arrayList.size();
        arrayList.clear();
        for (int i = 1; i < count; ++i) {
            this.storeTableData.remove(lineNumber + 1);
        }
        FaCurAsstActCompositCollection curCollection = FaClientUtils.getDeFaultFaCurAsstActCompositCollection((AccountViewInfo)curAccountInfo);
        if (curCollection != null && curCollection.size() > 0) {
            AsstActTypeCollection asstActTypeCollection = new AsstActTypeCollection();
            influenceRowCount = count - curCollection.size() + 1;
            this.depTable.getRow(lineNumber).getCell("asstActType").setValue((Object)curCollection.get(0).getAsstActType());
            this.depTable.getRow(lineNumber).getCell("asstActItemObj").setValue(null);
            this.depTable.getRow(lineNumber).getCell("asstActItemObj").getStyleAttributes().setLocked(false);
            arrayList.add(curCollection.get(0).getAsstActType().getId().toString());
            int j2 = curCollection.size();
            for (int i = 1; i < j2; ++i) {
                arrayList.add(curCollection.get(i).getAsstActType().getId().toString());
                this.storeTableData.add(lineNumber + 1, null);
                asstActTypeCollection.add(curCollection.get(i).getAsstActType());
                ((FaLeaseNewDepCostSharingEditUI)((Object)this.comp)).tableAddLine(this.depTable, lineNumber + i);
                this.depTable.getEditManager().stopEditing();
                this.depTable.getRow(lineNumber + i).getCell("id").setValue(this.depTable.getRow(lineNumber).getCell("id").getValue());
                this.depTable.getRow(lineNumber + i).getCell("leaseBill").setValue(this.depTable.getRow(lineNumber).getCell("leaseBill").getValue());
                this.depTable.getRow(lineNumber + i).getCell("accountView").setValue(this.depTable.getRow(lineNumber).getCell("accountView").getValue());
                this.depTable.getRow(lineNumber + i).getCell("apportionScale").setValue(this.depTable.getRow(lineNumber).getCell("apportionScale").getValue());
                this.depTable.getRow(lineNumber + i).getCell("remark").setValue(this.depTable.getRow(lineNumber).getCell("remark").getValue());
                this.depTable.getRow(lineNumber + i).getCell("seq").setValue(this.depTable.getRow(lineNumber).getCell("seq").getValue());
                this.depTable.getRow(lineNumber + i).getCell("asstActType").setValue((Object)curCollection.get(i).getAsstActType());
                this.depTable.getRow(lineNumber + i).getCell("asstActItemObj").setValue(null);
            }
            this.depTable.getMergeManager().mergeBlock(lineNumber, 0, curCollection.size() + lineNumber - 1, 0);
            this.depTable.getMergeManager().mergeBlock(lineNumber, 1, curCollection.size() + lineNumber - 1, 1);
            this.depTable.getMergeManager().mergeBlock(lineNumber, 2, curCollection.size() + lineNumber - 1, 2);
            this.depTable.getMergeManager().mergeBlock(lineNumber, 3, curCollection.size() + lineNumber - 1, 3);
            this.depTable.getMergeManager().mergeBlock(lineNumber, 6, curCollection.size() + lineNumber - 1, 6);
        } else {
            this.depTable.getRow(lineNumber).getCell("asstActType").setValue(null);
            this.depTable.getRow(lineNumber).getCell("asstActItemObj").setValue(null);
            this.depTable.getRow(lineNumber).getCell("asstActItemObj").getStyleAttributes().setLocked(true);
        }
        ((FaLeaseNewDepCostSharingEditUI)((Object)this.comp)).resetSoreTableDataIndex(lineNumber, influenceRowCount, null);
    }

    private void setInfoForAsstActF7(KDTEditEvent e) {
        int lineNumber = e.getRowIndex();
        int storeLineNumber = e.getRowIndex();
        if (e.getColIndex() != 5) {
            return;
        }
        String billNumber = ((FaLeaseInBillNewInfo)this.depTable.getCell(lineNumber, "leaseBill").getValue()).getNumber();
        Set<Integer> set = this.storeTableDataIndex.get(billNumber);
        while (!set.contains(storeLineNumber)) {
            --storeLineNumber;
        }
        Map<String, Object> map = this.storeTableData.get(storeLineNumber);
        ArrayList arrayList = (ArrayList)map.get("faLeaseAsstActComposite");
        AsstActTypeInfo asstActType = (AsstActTypeInfo)this.depTable.getCell(lineNumber, "asstActType").getValue();
        CoreBaseInfo asstActTypeObj = (CoreBaseInfo)this.depTable.getCell(lineNumber, "asstActItemObj").getValue();
        int j = arrayList.size();
        for (int i = 0; i < j; ++i) {
            if (!((String)arrayList.get(i)).startsWith(asstActType.getId().toString())) continue;
            if (asstActTypeObj != null) {
                arrayList.set(i, asstActType.getId().toString() + "#" + asstActTypeObj.getId().toString());
                break;
            }
            arrayList.set(i, asstActType.getId().toString());
            break;
        }
    }

    private void setInfoForApportionScale(KDTEditEvent e) {
        int lineNumber = e.getRowIndex();
        if (e.getColIndex() != 3) {
            return;
        }
        BigDecimal apportionScale = (BigDecimal)this.depTable.getCell(lineNumber, "apportionScale").getValue();
        if (apportionScale == null) {
            return;
        }
        Map<String, Object> map = this.storeTableData.get(lineNumber);
        map.put("apportionScale", apportionScale);
    }

    private void setInfoForRemake(KDTEditEvent e) {
        int lineNumber = e.getRowIndex();
        if (e.getColIndex() != 6) {
            return;
        }
        String remake = (String)this.depTable.getCell(lineNumber, "remark").getValue();
        if (remake == null) {
            return;
        }
        Map<String, Object> map = this.storeTableData.get(lineNumber);
        map.put("remark", remake);
    }

    private FaDepreAndAmortCollection getFaDepreAndAmortCollection(String billId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FID FROM T_Fa_FaDepreAndAmort WHERE FPeriodID = ? AND FCompanyId = ? \r\n");
        String companyId = this.aCompanyOrgUnitInfo.getId().toString();
        String curPeriodId = this.currPeriod.getId().toString();
        FaDepreAndAmortCollection faDepreAndAmortCollection = new FaDepreAndAmortCollection();
        try {
            faDepreAndAmortCollection = FaDepreAndAmortFactory.getRemoteInstance().getFaDepreAndAmortCollection("where period = '" + curPeriodId + "' and company = '" + companyId + "' and leaseInBill = '" + billId + "'");
        }
        catch (BOSException bosException) {
            bosException.printStackTrace();
        }
        return faDepreAndAmortCollection;
    }
}

