/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.pattern;

import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.nlm.pattern.dto.NLMPatternDTO;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbstractNLMPattern {
    private final String patternString;
    private final String replaceString;
    private final boolean isMultilevel;
    private final Map<String, Object> multiData;
    private final List<NLMPatternDTO> nlmPatternDTOList = new ArrayList<NLMPatternDTO>();
    private final List<AbstractNLMPattern> patternListForSecondaryReplacement = new ArrayList<AbstractNLMPattern>();
    private final KDTextArea textArea;

    protected AbstractNLMPattern(String patternString, String replaceString, boolean isMultilevel, Map<String, Object> multiData, KDTextArea textArea) {
        this.patternString = patternString;
        this.replaceString = replaceString;
        this.isMultilevel = isMultilevel;
        this.multiData = multiData;
        this.textArea = textArea;
    }

    protected String getReplaceString(String matchString) {
        if (this.isMultilevel) {
            Set<String> keySet = this.multiData.keySet();
            for (String key : keySet) {
                if (this.multiData.get(key) instanceof String) {
                    this.patternListForSecondaryReplacement.add(new AbstractNLMPattern(key, (String)this.multiData.get(key), false, null, this.textArea));
                    continue;
                }
                this.patternListForSecondaryReplacement.add(new AbstractNLMPattern(key, null, true, (Map)this.multiData.get(key), this.textArea));
            }
            StringBuilder result = new StringBuilder(matchString);
            for (AbstractNLMPattern nlmPattern : this.patternListForSecondaryReplacement) {
                Pattern pattern = Pattern.compile(nlmPattern.getPatternString());
                Matcher matcher = pattern.matcher(result);
                int count = 0;
                this.printLog(this.textArea, EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"290_AbstractNLMPattern") + nlmPattern.getPatternString());
                while (matcher.find()) {
                    this.printLog(this.textArea, EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"291_AbstractNLMPattern") + ++count + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"292_AbstractNLMPattern") + matcher.start() + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"293_AbstractNLMPattern") + matcher.end() + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"294_AbstractNLMPattern") + result.substring(matcher.start(), matcher.end()));
                    nlmPattern.markReplaceString(new NLMPatternDTO(matcher.start(), matcher.end(), nlmPattern.getReplaceString(result.substring(matcher.start(), matcher.end()))));
                }
                result = nlmPattern.runningReplaceString(result);
            }
            this.patternListForSecondaryReplacement.clear();
            return result.toString();
        }
        return this.replaceString.contains("invoke") ? this.invokeReplaceString(this.replaceString, matchString) : this.replaceString;
    }

    private String invokeReplaceString(String replaceString, String matchString) {
        StringBuilder result = new StringBuilder(replaceString);
        if (replaceString.contains("BOSUuid.create")) {
            Pattern pattern = Pattern.compile("invoke\\(BOSUuid.create\\(\"\\S*\"\\)\\)");
            Matcher matcher = pattern.matcher(result);
            while (matcher.find()) {
                String bosType = result.substring(matcher.start(), matcher.end()).replace("invoke(BOSUuid.create(\"", "").replace("\"))", "");
                result = result.replace(matcher.start(), matcher.end(), BOSUuid.create((String)bosType).toString());
            }
        }
        if (replaceString.contains("matchString.substring")) {
            result = new StringBuilder(matchString.substring(0, matchString.length() - 1) + "_DataUpgrade\"");
        }
        return result.toString();
    }

    protected void markReplaceString(NLMPatternDTO nlmPatternDTO) {
        this.nlmPatternDTOList.add(nlmPatternDTO);
    }

    protected StringBuilder runningReplaceString(StringBuilder str) {
        for (int i = this.nlmPatternDTOList.size() - 1; i >= 0; --i) {
            NLMPatternDTO nlmPatternDTO = this.nlmPatternDTOList.get(i);
            this.printLog(this.textArea, EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"295_AbstractNLMPattern") + str.substring(nlmPatternDTO.getStartIndex(), nlmPatternDTO.getEndIndex()) + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"296_AbstractNLMPattern") + nlmPatternDTO.getReplaceString());
            str.replace(nlmPatternDTO.getStartIndex(), nlmPatternDTO.getEndIndex(), nlmPatternDTO.getReplaceString());
        }
        this.nlmPatternDTOList.clear();
        return str;
    }

    public String getPatternString() {
        return this.patternString;
    }

    private void printLog(KDTextArea textArea, String log) {
        textArea.append("\n" + log);
    }
}

