/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.pattern;

import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.eas.fi.nlm.pattern.AbstractNLMPattern;
import com.kingdee.eas.fi.nlm.pattern.dto.NLMPatternDTO;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NLMPatternList {
    private final List<AbstractNLMPattern> patternList = new ArrayList<AbstractNLMPattern>();
    private final KDTextArea textArea;

    public NLMPatternList(List<Map<String, Object>> hashMapList, KDTextArea textArea) {
        this.textArea = textArea;
        for (Map<String, Object> hashMap : hashMapList) {
            this.recursionPrint(hashMap);
        }
    }

    public StringBuilder running(StringBuilder matcherString, KDTextArea textArea) {
        List<AbstractNLMPattern> patternList = this.patternList;
        for (AbstractNLMPattern nlmPattern : patternList) {
            Pattern pattern = Pattern.compile(nlmPattern.getPatternString());
            Matcher matcher = pattern.matcher(matcherString);
            int count = 0;
            this.printLog(textArea, EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"279_NLMPatternList") + nlmPattern.getPatternString());
            while (matcher.find()) {
                this.printLog(textArea, EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"280_NLMPatternList") + ++count + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"281_NLMPatternList") + matcher.start() + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"282_NLMPatternList") + matcher.end() + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"283_NLMPatternList") + matcherString.substring(matcher.start(), matcher.end()));
                nlmPattern.markReplaceString(new NLMPatternDTO(matcher.start(), matcher.end(), nlmPattern.getReplaceString(matcherString.substring(matcher.start(), matcher.end()))));
            }
            matcherString = nlmPattern.runningReplaceString(matcherString);
        }
        return matcherString;
    }

    private void recursionPrint(Map<String, Object> objectHashMap) {
        Set<String> keySet = objectHashMap.keySet();
        for (String key : keySet) {
            if (objectHashMap.get(key) instanceof String) {
                this.patternList.add(new AbstractNLMPattern(key, (String)objectHashMap.get(key), false, null, this.textArea));
                continue;
            }
            this.patternList.add(new AbstractNLMPattern(key, null, true, (Map)objectHashMap.get(key), this.textArea));
        }
    }

    private void printLog(KDTextArea textArea, String log) {
        textArea.append("\n" + log);
    }
}

