/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.rpt.CSLComment;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class CSLCommentsCollection
implements Serializable {
    private ArrayList comments = new ArrayList();
    private String rptID;
    private int rptYear;
    private int rptPeriod;
    private int rptPeriodType;

    public boolean setReportInfo(VirtualSheetParamInfo editData) {
        if (editData == null || editData.getId() == null) {
            return false;
        }
        this.rptID = editData.getId().toString();
        this.rptYear = editData.getInt("year");
        this.rptPeriod = editData.getInt("period");
        this.rptPeriodType = editData.getInt("periodType");
        return true;
    }

    public void add(RptCell cell, int rptClass) {
        if (cell != null) {
            String cmtString = cell.getCommentString();
            ItemFormula item = cell.getItemFormula();
            if (cmtString != null && item != null && item.isValidity()) {
                CSLComment cc = new CSLComment(cmtString, rptClass);
                cc.setItemInfo(item);
                this.comments.add(cc);
            }
        }
    }

    public void add(Cell cell, int rptClass) {
        RptCommentTank ct = CommentUtil.getReportComment((Cell)cell);
        if (ct != null) {
            int n = ct.getSize();
            for (int i = 0; i < n; ++i) {
                String cmtString = ct.getEntry(i).getContent();
                ItemFormula item = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (cmtString == null || item == null || !item.isValidity()) continue;
                CSLComment cc = new CSLComment(cmtString, rptClass);
                cc.setItemInfo(item);
                this.comments.add(cc);
            }
        }
    }

    public int getRptPeriodType() {
        return this.rptPeriodType;
    }

    public Collection getComments() {
        return this.comments;
    }

    public String getRptID() {
        return this.rptID;
    }

    public int getRptPeriod() {
        return this.rptPeriod;
    }

    public int getRptYear() {
        return this.rptYear;
    }
}

