/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.rpt.CellValueParster;
import com.kingdee.eas.fi.rpt.ExcelUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import org.apache.commons.lang.StringUtils;

public class FieldCellValueParster
extends CellValueParster {
    protected String fieldName;
    protected String flag;
    protected String filterInfo;

    @Override
    public String parse() {
        if (this.isCell()) {
            if (this.filterInfo.indexOf(":") < 0) {
                return this.getcellValue();
            }
            return this.getCellValues();
        }
        return "";
    }

    public FieldCellValueParster(Book book, String fieldName, String filterInfo, String flag) {
        super(book);
        this.fieldName = fieldName;
        this.filterInfo = filterInfo;
        this.flag = flag;
    }

    private boolean isCell() {
        return !StringUtils.isEmpty((String)this.filterInfo) && this.filterInfo.startsWith("$");
    }

    private String appendValues(String values) {
        StringBuffer bf = new StringBuffer();
        String[] vs = StringUtils.split((String)values, (String)";");
        for (int i = 0; i < vs.length; ++i) {
            String value = vs[i].trim();
            bf.append(" ");
            bf.append(this.fieldName);
            bf.append("=");
            bf.append(this.flag + value + this.flag);
            if (i == vs.length - 1) continue;
            bf.append(" or ");
        }
        return bf.toString();
    }

    @Override
    protected String getcellValue() {
        String col = this.getColumn();
        int x = ExcelUtil.getExcelCol(col);
        int y = ExcelUtil.getRowIndex(col);
        String values = this.getsheet(this.book, this.filterInfo).getRange(y - 1, x).getText();
        return this.appendValues(values);
    }

    protected String getColumn() {
        return this.filterInfo.substring(this.filterInfo.indexOf("!") + 1);
    }

    public String getCells() {
        return this.filterInfo.substring(this.filterInfo.indexOf(33) + 1);
    }

    private String getCellValues() {
        String cell = this.getCells();
        String[] cells = cell.split(":");
        if (cells.length != 2) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.client.QuerySchemeResource", (String)"fitler_erro"));
            SysUtil.abort();
        }
        String cellStart = cells[0];
        String cellend = cells[1];
        int colA = ExcelUtil.getExcelCol(cellStart);
        int colB = ExcelUtil.getExcelCol(cellend);
        int rowA = ExcelUtil.getRowIndex(cellStart);
        int rowB = ExcelUtil.getRowIndex(cellend);
        if (colA != colB && rowA != rowB || colA < 0 || colB < 0 || rowA < 0 || rowB < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.client.QuerySchemeResource", (String)"fitler_erro"));
            SysUtil.abort();
        }
        if (rowA == rowB) {
            return this.getRowCellValues(rowA, rowB, colA);
        }
        if (colA == colB) {
            return this.getColCellValues(colA, colB, rowA);
        }
        return "";
    }

    private String getRowCellValues(int rowA, int rowB, int colA) {
        StringBuffer bf = new StringBuffer();
        bf.append(" ");
        for (int i = rowA - 1; i < rowB; ++i) {
            String values = this.getsheet(this.book, this.filterInfo).getRange(i, colA).getText();
            bf.append(this.appendValues(values));
            if (i == rowB - 1) continue;
            bf.append(" or ");
        }
        return bf.toString();
    }

    private String getColCellValues(int colA, int colB, int rowA) {
        StringBuffer bf = new StringBuffer();
        bf.append(" ");
        for (int i = colA; i <= colB; ++i) {
            String values = this.getsheet(this.book, this.filterInfo).getRange(rowA - 1, i).getText();
            bf.append(this.appendValues(values));
            if (i == colB) continue;
            bf.append(" or ");
        }
        return bf.toString();
    }
}

