/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class NestedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -8542075273145413733L;
    private Throwable cause;

    public NestedRuntimeException(String msg) {
        super(msg);
    }

    public NestedRuntimeException(String msg, Throwable ex) {
        super(msg);
        this.cause = ex;
    }

    @Override
    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        Throwable cause = this.getCause();
        if (cause != null) {
            return message + "; nested exception is " + cause;
        }
        return message;
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        if (this.getCause() == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            this.getCause().printStackTrace(ps);
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.getCause() == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            this.getCause().printStackTrace(pw);
        }
    }

    public boolean contains(Class exClass) {
        if (exClass == null) {
            return false;
        }
        Throwable ex = this;
        while (ex != null) {
            if (exClass.isInstance(ex)) {
                return true;
            }
            if (ex instanceof NestedRuntimeException) {
                ex = ex.getCause();
                continue;
            }
            ex = null;
        }
        return false;
    }
}

