/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.rpt.CSLCompanyPattern;
import com.kingdee.eas.fi.rpt.CellValuePattern;
import com.kingdee.eas.fi.rpt.CurrentSheetCellValuePattern;
import com.kingdee.eas.fi.rpt.FeildCellValuePattern;
import com.kingdee.eas.fi.rpt.IReaderPattern;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class Parster {
    String sql;
    Book book;
    List readerPatterns;

    public Parster(String sql, Book book) {
        this.sql = sql;
        this.book = book;
        this.readerPatterns = new ArrayList();
    }

    public String getSql() {
        this.parseReaderPattern();
        for (int i = 0; i < this.readerPatterns.size(); ++i) {
            if (!(this.readerPatterns.get(i) instanceof IReaderPattern)) continue;
            IReaderPattern p = (IReaderPattern)this.readerPatterns.get(i);
            String filter = (String)p.getReaderPattern();
            String value = p.getValue();
            this.sql = StringUtils.replace((String)this.sql, (String)filter, (String)value);
        }
        return this.sql;
    }

    private int getEndFlagIndex(int begin, char endFlag) {
        for (int j = begin + 1; j < this.sql.length(); ++j) {
            if (this.sql.charAt(j) != endFlag) continue;
            return j;
        }
        return -1;
    }

    public boolean isFieldCellValuePattern(String str) {
        return str.indexOf("[") != -1 && str.indexOf("]") != -1 && str.indexOf("|") != -1;
    }

    public boolean isCellValuePattern(String str) {
        return str.indexOf("!") != -1 && str.indexOf("|") == -1;
    }

    public boolean isCurrentSheetCellValuePattern(String str) {
        return str.indexOf("$") >= 0;
    }

    public void appendReaderPattern(String str) {
        if (CSLCompanyPattern.isCLSCompanyPattern(str)) {
            CSLCompanyPattern pattern = new CSLCompanyPattern(str);
            this.readerPatterns.add(pattern);
        } else if (this.isFieldCellValuePattern(str)) {
            FeildCellValuePattern pattern = new FeildCellValuePattern(str, this.book);
            this.readerPatterns.add(pattern);
        } else if (this.isCellValuePattern(str)) {
            CellValuePattern pattern = new CellValuePattern(str, this.book);
            this.readerPatterns.add(pattern);
        } else if (this.isCurrentSheetCellValuePattern(str)) {
            CurrentSheetCellValuePattern pattern = new CurrentSheetCellValuePattern(str, this.book);
            this.readerPatterns.add(pattern);
        }
    }

    public void parseReaderPattern() {
        int start = 0;
        int end = 0;
        char beginFlag = "{".charAt(0);
        char endFlag = "}".charAt(0);
        if (!StringUtils.isEmpty((String)this.sql)) {
            for (int i = 0; i < this.sql.length(); ++i) {
                start = -1;
                end = -1;
                if (this.sql.charAt(i) != beginFlag) continue;
                start = i;
                end = this.getEndFlagIndex(i, endFlag);
                if (end <= start) continue;
                String sub = this.sql.substring(start, end + 1);
                this.appendReaderPattern(sub);
            }
        }
    }
}

