/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.ScriptContext;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.fa.facade.FaReportFacadeFactory;
import com.kingdee.eas.fi.fa.facade.IFaReportFacade;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItemDataService;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.DynaRptItemDataFacadeFactory;
import com.kingdee.eas.fi.gr.dynamic.IDynaRptItemDataFacade;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.CTypeEnum;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.IRptIndexFacade;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.Key;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptIndexFacadeFactory;
import com.kingdee.eas.fi.rpt.RptOrgRelaCollection;
import com.kingdee.eas.fi.rpt.RptOrgRelaInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptRefractor;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TablePorperts;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fi.rpt.api.IReportCaclProxy;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fm.fpl.FpFormulaFacadeFactory;
import com.kingdee.eas.fm.fpl.IFpFormulaFacade;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.bg.BgProviderFactory;
import com.kingdee.eas.ma.bg.IBgProvider;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ReportCaclProxy
implements IReportCaclProxy {
    public static final String PERMISSION_ACCOUNTVIEW = "bd_account_accountView_view";
    private static final String STR_SEPRATOR = "|";
    public static final String REFM_GROUPREPORT_CODE = "99";
    private IReportCacl reportCacl = null;
    private IBgProvider iBgProvider = null;
    private IFaReportFacade iFaProvider = null;
    private IInAcct iInAcct = null;
    private ICashManagement iCashMgt = null;
    private IRptIndexFacade iRptIndex = null;
    private IReport iReport = null;
    private Context ServerCtx = null;
    private ICompanyOrgUnit comp;
    private IOrgRange orgRange;
    private IPermission permission;
    private String userID;
    Map permissionOrgs = null;
    private KDTable calcTable = null;
    private Book book = null;
    private RptRefractor rptData = null;
    private RptSheetParamInfo rptSP = null;
    private IPeriod period = null;
    public static final int DT_CURRENT = 1;
    public static final int DT_START = 2;
    public static final int DT_END = 3;
    private IRPTItemDataService cslRptDataService = null;
    private IDynaRptItemDataFacade dynaRptItemDataFacade = null;
    private static final Logger log = Logger.getLogger((String)ReportCaclProxy.class.getName());

    public ReportCaclProxy() throws BOSException {
        this.calcTable = null;
        this.rptData = new RptRefractor(null);
        this.userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
    }

    public ReportCaclProxy(Context ctx) throws BOSException {
        this.calcTable = null;
        this.rptData = new RptRefractor(null);
        this.ServerCtx = ctx;
        this.userID = ctx.get((Object)"rptSchemeUserID") != null ? ctx.get((Object)"rptSchemeUserID").toString() : ctx.getCaller().toString();
    }

    public ReportCaclProxy(KDTable table, IObjectValue data) throws BOSException {
        this.calcTable = table;
        this.rptData = new RptRefractor(data);
        this.userID = ((UserInfo)SysContext.getSysContext().getCurrentUser()).getId().toString();
    }

    public ReportCaclProxy(Context ctx, KDTable table, IObjectValue data) throws BOSException {
        this.calcTable = table;
        this.rptData = new RptRefractor(data);
        this.ServerCtx = ctx;
        this.userID = ctx.get((Object)"rptSchemeUserID") != null ? ctx.get((Object)"rptSchemeUserID").toString() : ctx.getCaller().toString();
    }

    public ReportCaclProxy(Context ctx, Book book, IObjectValue data) throws BOSException {
        this.book = book;
        this.rptData = new RptRefractor(data);
        this.ServerCtx = ctx;
        this.userID = ctx == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : (ctx.get((Object)"rptSchemeUserID") != null ? ctx.get((Object)"rptSchemeUserID").toString() : ctx.getCaller().toString());
    }

    public ReportCaclProxy(Book book, IObjectValue data) throws BOSException {
        this(null, book, data);
    }

    private Sheet getCurrentCalcSheet() {
        Cell cell = (Cell)this.book.getDeps().getCurrentCalcNode();
        return cell.getSheet();
    }

    public void SetSheetParam(IObjectValue data) {
        this.rptSP = (RptSheetParamInfo)data;
    }

    public String getCompany() throws BOSException {
        try {
            return this.getOrgName(OrgType.Company.getName());
        }
        catch (EASBizException e) {
            return null;
        }
    }

    public String keyWord(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (this.calcTable != null) {
            ScriptContext sc = (ScriptContext)this.calcTable.getScriptManager().getRelationsObject().getCurrentListener();
            String keyValue = ((Key)((HashMap)TablePorperts.getInstance(sc.getTable()).get("keys")).get(name)).getKeyValue();
            return keyValue == null ? "" : keyValue;
        }
        HashMap hashMap = (HashMap)TablePorperts.getKeys(this.getCurrentCalcSheet());
        if (hashMap == null) {
            return "";
        }
        return ((Key)hashMap.get(name)).getKeyValue();
    }

    public String rptName() {
        VirtualSheetParamInfo info = this.rptData.getVirtualSheetParamInfo();
        return info == null ? "" : info.getName();
    }

    private String makeValidOrgcode(String orgCode) throws EASBizException, BOSException {
        if (orgCode == null || orgCode.length() < 1) {
            ReportInfo ri = this.rptData.getReportInfo();
            FullOrgUnitInfo ci = null;
            if (ri != null) {
                ci = ri.getCompany();
            } else {
                CslReportInfo cls = this.rptData.getCslReportInfo();
                ci = cls.getCompany();
            }
            if (ci == null && this.rptData.getCslReportInfo() instanceof CslReportInfo) {
                ci = this.rptData.getCslReportInfo().getOrgUnit();
            }
            return ci == null ? null : ci.getNumber();
        }
        return orgCode;
    }

    public String refm(String orgUnit, String tempType, String tempCode, int rptyear, int rptperiod, String sheetName, String cellName, String currency) throws BOSException, EASBizException {
        CurrencyInfo ci;
        String s;
        this.getRptSP();
        if (rptyear == 0) {
            rptyear = this.rptSP.getStartYear();
            if (rptyear == 0) {
                rptyear = this.rptData.getReportBaseInfo().getYear();
            }
            if (rptyear == 0) {
                s = this.rptDate("YYYY");
                rptyear = Integer.valueOf(s);
            }
        }
        if (rptperiod == 0) {
            rptperiod = this.rptSP.getStartPeriod();
            if (rptperiod == 0) {
                rptperiod = this.rptData.getReportBaseInfo().getPeriod();
            }
            if (rptperiod == 0) {
                s = this.rptDate("MM");
                rptperiod = Integer.valueOf(s);
            }
        }
        int periodType = -1;
        if (this.rptData.getReportBaseInfo().getPeriodType() != null) {
            periodType = this.rptData.getReportBaseInfo().getPeriodType().getValue();
        }
        if ((currency == null || currency.trim().length() == 0) && (ci = this.rptData.getReportBaseInfo().getCurrency()) != null) {
            currency = ci.getNumber();
        }
        tempType = tempType.equalsIgnoreCase(RptTmpTypeEnum.GROUPREPORT.getName()) ? REFM_GROUPREPORT_CODE : String.valueOf(RptTmpTypeEnum.getEnum(tempType).getValue());
        return this.getReportCacl().refm(this.makeValidOrgcode(orgUnit), rptyear, rptperiod, currency, tempType, tempCode, null, sheetName, cellName, periodType);
    }

    public String csRef(String orgUnit, String tempCode, String groupTempType, int rptyear, int rptperiod, String sheetName, String cellName, String currency) throws BOSException, EASBizException {
        CurrencyInfo ci;
        this.getRptSP();
        int curYear = this.rptData.getReportBaseInfo().getYear();
        short curPeriod = this.rptData.getReportBaseInfo().getPeriod();
        int int_periodType = this.rptData.getReportBaseInfo().getPeriodType().getValue();
        int[] arrYearAndPeriod = RPTDateUtil.getRptYearAndPeriod((int)curYear, (int)curPeriod, (int)int_periodType, (int)rptyear, (int)rptperiod);
        if (arrYearAndPeriod == null) {
            rptyear = curYear;
            rptperiod = curPeriod;
        } else {
            rptyear = arrYearAndPeriod[0];
            rptperiod = arrYearAndPeriod[1];
        }
        if ((currency == null || currency.trim().length() == 0) && (ci = this.rptData.getReportBaseInfo().getCurrency()) != null) {
            currency = ci.getNumber();
        }
        String tempType = String.valueOf(2);
        return this.getReportCacl().refm(this.makeValidOrgcode(orgUnit), rptyear, rptperiod, currency, tempType, tempCode, groupTempType, sheetName, cellName, -1);
    }

    public String AcctName(String orgNumber, String accountNumber) throws BOSException, ReportException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report != null && (orgNumber == null || orgNumber.length() <= 0) && report.getCompany() != null) {
            orgNumber = report.getCompany().getNumber().toString();
        }
        CompanyOrgUnitInfo orgInf = null;
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("accountTable.id"));
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber));
        CompanyOrgUnitCollection c = null;
        c = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev) : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx).getCompanyOrgUnitCollection(ev);
        if (c != null && c.size() > 0) {
            orgInf = c.get(0);
        }
        if (orgInf == null) {
            throw new ReportException(ReportException.ORGNULL);
        }
        AccountTableInfo act = orgInf.getAccountTable();
        if (act == null) {
            throw new ReportException(ReportException.ORGNULLACT);
        }
        EntityViewInfo ev1 = new EntityViewInfo();
        ev1.getSelector().add(new SelectorItemInfo("name"));
        ev1.setFilter(new FilterInfo());
        ev1.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
        ev1.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID", (Object)act.getId().toString()));
        AccountViewCollection c1 = null;
        c1 = this.ServerCtx == null ? AccountViewFactory.getRemoteInstance().getAccountViewCollection(ev1) : AccountViewFactory.getLocalInstance((Context)this.ServerCtx).getAccountViewCollection(ev1);
        if (c1 == null || c1.size() == 0) {
            throw new ReportException(ReportException.ACCNULL);
        }
        return c1.get(0).getName();
    }

    public String getOrgName(String orgType) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report != null) {
            CslReportInfo ci = this.rptData.getCslReportInfo();
            if (ci != null) {
                if (StringUtils.isEmpty((String)orgType)) {
                    return null;
                }
                if (OrgType.getEnum((String)orgType) == OrgType.UnionDebt && ci.getOrgUnit() != null) {
                    return ci.getOrgUnit().getName();
                }
                if (OrgType.getEnum((String)orgType) == OrgType.Company && ci.getCompany() != null) {
                    return ci.getCompany().getName();
                }
                if (OrgType.getEnum((String)orgType) == OrgType.ControlUnit) {
                    return ci.getCU().getName();
                }
                if (ci.getOrgUnit() != null) {
                    return ci.getOrgUnit().getName();
                }
                return null;
            }
            if (orgType == null || orgType.length() == 0 || OrgType.Company.getName().equalsIgnoreCase(orgType)) {
                return report.getCompany().getName();
            }
            if (OrgType.Admin.getName().equalsIgnoreCase(orgType)) {
                if (this.ServerCtx == null) {
                    return SysContext.getSysContext().getCurrentAdminUnit().getName();
                }
                return ContextUtil.getCurrentAdminUnit((Context)this.ServerCtx).getName();
            }
            RptOrgRelaCollection orgColl = report.getOrgRela();
            Iterator iter = orgColl.iterator();
            RptOrgRelaInfo rptOrg = null;
            while (iter.hasNext()) {
                rptOrg = (RptOrgRelaInfo)iter.next();
                if (rptOrg.getOrgType() != OrgType.getEnum((String)orgType)) continue;
                return rptOrg.getOrgUnit().getName();
            }
            return "";
        }
        return "";
    }

    public String getOrgEName(String number) throws BOSException, EASBizException {
        Object result = null;
        if (number == null || number.length() < 1) {
            number = this.ServerCtx == null ? SysContext.getSysContext().getCurrentFIUnit().getNumber() : ContextUtil.getCurrentFIUnit((Context)this.ServerCtx).getNumber();
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("Name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        CoreBaseCollection coll = this.getComp().getCollection(view);
        if (coll == null || coll.size() < 1) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{RptUtil.getResourceSince51("NoExistsCompany") + number});
        }
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)coll.get(0);
        result = info.get("name", LocaleUtils.getLocale((String)"L1"));
        if (result == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{RptUtil.getResourceSince51("Company") + "\"" + number + "\" " + RptUtil.getResourceSince51("SettingEnglishName")});
        }
        return result.toString();
    }

    public String basicCurrency(String number) throws BOSException, EASBizException {
        return this.stdCur(number);
    }

    public BigDecimal exchangeRate(String sourceCurrency, String targetCurrency, String date) throws BOSException, EASBizException {
        ReportBaseInfo report;
        Date exchangeDate = null;
        String companyid = null;
        if (StringUtils.isEmpty((String)sourceCurrency)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NeedSrcCurrency")});
        }
        if (StringUtils.isEmpty((String)targetCurrency)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NeedDisCurrency")});
        }
        if (StringUtils.isEmpty((String)date)) {
            report = this.rptData.getReportBaseInfo();
            if (report instanceof CslReportInfo) {
                CslReportInfo cslr = (CslReportInfo)report;
                exchangeDate = RPTDateUtil.getPeriodLastDate((int)cslr.getYear(), (int)cslr.getPeriod(), (RptPeriodTypeEnum)cslr.getPeriodType());
            } else {
                exchangeDate = report.getEndDate();
            }
        } else {
            try {
                exchangeDate = DateFormat.getDateInstance().parse(date);
            }
            catch (ParseException e) {
                throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR);
            }
        }
        report = this.rptData.getReportBaseInfo();
        companyid = report.getCompany().getId().toString();
        ICompanyOrgUnit icompany = null;
        icompany = this.ServerCtx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo company = icompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        ExchangeTableInfo xtbl = company.getBaseExchangeTable();
        if (xtbl == null) {
            String msg = null;
            msg = this.ServerCtx != null ? ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoExchangeTableInThisCompany", (Locale)this.ServerCtx.getOriginLocale()) : EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoExchangeTableInThisCompany");
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{msg});
        }
        String exTableId = xtbl.getId().toString();
        return this.getReportCacl().exchangeRate(sourceCurrency, targetCurrency, exchangeDate, exTableId);
    }

    public String stdCur(String orgNumber) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report == null) {
            return "";
        }
        if (orgNumber == null || orgNumber.length() <= 0) {
            orgNumber = report.getCompany().getNumber();
        }
        return this.getReportCacl().getStdCurrency(report.getId() == null ? "" : report.getId().toString(), orgNumber);
    }

    public String rptDate(String dateFormat) throws BOSException, EASBizException {
        return this.getDateImp(dateFormat, 1, false);
    }

    public String getCurrency() throws BOSException, EASBizException {
        if (this.calcTable != null || this.book != null) {
            ReportBaseInfo report = this.rptData.getReportBaseInfo();
            this.getRptSP();
            if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                return this.rptSP.getCurrency().getName().toString();
            }
            if (report != null && report.getCurrency() != null) {
                return report.getCurrency().getName();
            }
        }
        return "";
    }

    public String getOrgTree() throws BOSException, EASBizException {
        ReportBaseInfo report;
        if ((this.calcTable != null || this.book != null) && (report = this.rptData.getReportBaseInfo()) != null && report.getOrgTree() != null) {
            return report.getOrgTree().getName();
        }
        return "";
    }

    public BigDecimal Dholding(String shareHolderNumber, String investeeCompanyNumber, String date) throws BOSException, EASBizException {
        Date changeDate = null;
        if (StringUtils.isEmpty((String)shareHolderNumber)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NeedInvestCompany")});
        }
        if (StringUtils.isEmpty((String)investeeCompanyNumber)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NeedBeInvestedCompany")});
        }
        if (StringUtils.isEmpty((String)date)) {
            ReportBaseInfo report = this.rptData.getReportBaseInfo();
            if (report instanceof CslReportInfo) {
                CslReportInfo cslr = (CslReportInfo)report;
                changeDate = RPTDateUtil.getPeriodLastDate((int)cslr.getYear(), (int)cslr.getPeriod(), (RptPeriodTypeEnum)cslr.getPeriodType());
            } else {
                changeDate = report.getEndDate();
            }
        } else {
            try {
                changeDate = DateFormat.getDateInstance().parse(date);
            }
            catch (ParseException e) {
                throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR);
            }
        }
        return this.getReportCacl().Dholding(shareHolderNumber, investeeCompanyNumber, changeDate);
    }

    public BigDecimal AGE(String fiOrgUnit, String acctItem, String currency, String endData, String from, String to, String balType) throws BOSException, EASBizException {
        CTypeEnum type = null;
        if (balType.equalsIgnoreCase("E")) {
            type = CTypeEnum.E;
        }
        if (balType.equalsIgnoreCase("B")) {
            type = CTypeEnum.B;
        }
        if (type == null) {
            throw new ReportException(ReportException.TYPE_NULL);
        }
        if (!this.getUserPermissionOrgs().containsKey(fiOrgUnit.toUpperCase())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()));
        }
        boolean includeVoucher = false;
        this.getRptSP();
        if (this.rptSP != null) {
            includeVoucher = this.rptSP.isIsIncludingUnposted();
        }
        Date date = null;
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report != null) {
            if ((fiOrgUnit == null || fiOrgUnit.length() <= 0) && report.getCompany() != null) {
                fiOrgUnit = report.getCompany().getNumber();
            }
            if (currency == null || currency.length() <= 0) {
                if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                    currency = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currency = report.getCurrency().getNumber().toString();
                }
            }
            if (endData == null || endData.trim().length() <= 0) {
                date = report.getStartDate();
                if (date == null) {
                    date = new Date();
                    date.setHours(0);
                    date.setMinutes(0);
                    date.setSeconds(0);
                }
            } else {
                date = new Date();
                date.setHours(0);
                date.setMinutes(0);
                date.setSeconds(0);
                int year = 0;
                int mouth = 0;
                int day = 0;
                int i = 0;
                StringTokenizer tok = new StringTokenizer(endData, "-");
                while (tok.hasMoreElements()) {
                    String intv = (String)tok.nextElement();
                    switch (++i) {
                        case 1: {
                            year = Integer.parseInt(intv);
                            date.setYear(year);
                            break;
                        }
                        case 2: {
                            mouth = Integer.parseInt(intv);
                            date.setMonth(mouth);
                            break;
                        }
                        case 3: {
                            day = Integer.parseInt(intv);
                            date.setDate(day);
                        }
                    }
                }
            }
        }
        return this.getReportCacl().age(fiOrgUnit, acctItem, currency, date, from, to, balType, includeVoucher);
    }

    public BigDecimal acct(String fiOrgUnit, String acctItem, String balType, int startYear, int startPeriod, int endYear, int endPeriod, String currency) throws BOSException, EASBizException {
        BalanceTypeEnum balanceType = BalanceTypeEnum.getEnum(balType = balType.toUpperCase());
        if (balanceType == null) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
        }
        if (!this.getUserPermissionOrgs().containsKey(fiOrgUnit.toUpperCase())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()));
        }
        boolean includeVoucher = false;
        this.getRptSP();
        if (this.rptSP != null) {
            includeVoucher = this.rptSP.isIsIncludingUnposted();
        }
        boolean checkDataRight = false;
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report != null) {
            Calendar calendar;
            Date periodLastDate;
            if ((fiOrgUnit == null || fiOrgUnit.length() <= 0) && report.getCompany() != null) {
                fiOrgUnit = report.getCompany().getNumber();
            }
            if (startYear <= 0) {
                startYear = (this.rptSP == null || this.rptSP.getStartYear() == 0 ? report.getYear() : this.rptSP.getStartYear()) + startYear;
            }
            if (startPeriod <= 0) {
                startPeriod = (this.rptSP == null || this.rptSP.getStartPeriod() == 0 ? report.getPeriod() : this.rptSP.getStartPeriod()) + startPeriod;
                if (startPeriod <= 0) {
                    startPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)(--startYear), (String)report.getCompany().getId().toString());
                }
                if (report.getPeriodType() != null) {
                    periodLastDate = RPTDateUtil.getPeriodLastDate((int)startYear, (int)startPeriod, (RptPeriodTypeEnum)report.getPeriodType());
                    calendar = Calendar.getInstance();
                    calendar.setTime(periodLastDate);
                    startYear = calendar.get(1);
                    startPeriod = calendar.get(2) + 1;
                }
            }
            if (endYear <= 0) {
                endYear = (this.rptSP == null || this.rptSP.getEndYear() == 0 ? report.getYear() : this.rptSP.getEndYear()) + endYear;
            }
            if (endPeriod <= 0) {
                endPeriod = (this.rptSP == null || this.rptSP.getEndPeriod() == 0 ? report.getPeriod() : this.rptSP.getEndPeriod()) + endPeriod;
                if (endPeriod <= 0) {
                    --endYear;
                    endPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)startYear, (String)report.getCompany().getId().toString());
                }
                if (report.getPeriodType() != null) {
                    periodLastDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)report.getPeriodType());
                    calendar = Calendar.getInstance();
                    calendar.setTime(periodLastDate);
                    endYear = calendar.get(1);
                    endPeriod = calendar.get(2) + 1;
                }
            }
            if (currency == null || currency.length() <= 0) {
                if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                    currency = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currency = report.getCurrency().getNumber().toString();
                }
            }
        }
        if (((currency = currency.toUpperCase(Locale.ENGLISH)).equals("GLC") || currency.equals("GRC")) && balType.length() > 0 && (balType.charAt(0) == 'T' || balType.charAt(0) == 'R')) {
            throw new BOSException();
        }
        return this.getReportCacl().acct(fiOrgUnit, acctItem, balanceType, startYear, startPeriod, endYear, endPeriod, currency, false, includeVoucher, checkDataRight);
    }

    private void getRptSP() {
        if (this.calcTable == null && this.book == null) {
            return;
        }
        if (this.book == null) {
            KDTable ct;
            ScriptContext sc = (ScriptContext)this.calcTable.getScriptManager().getRelationsObject().getCurrentListener();
            KDTable kDTable = ct = sc == null ? null : sc.getTable();
            if (ct == null) {
                ct = this.calcTable;
            }
            this.rptSP = (RptSheetParamInfo)TablePorperts.getInstance(ct).get("SheetParam");
        } else {
            this.rptSP = this.rptData.getVirtualSheetParamInfo().getSheetParam().get(this.getCurrentCalcSheet().getSheetIndex());
        }
    }

    private Map getUserPermissionOrgs() throws BOSException {
        if (this.permissionOrgs != null) {
            return this.permissionOrgs;
        }
        Map fullOrgs = new HashMap();
        try {
            fullOrgs = this.getPermission().getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(this.userID), OrgType.Company, null, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.rpt.client", "RptReportProcessUI"), (IMetaDataPK)new MetaDataPK("rpt_report_calculate"));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.setFilter(new FilterInfo());
        Iterator iterator = ((HashMap)fullOrgs).keySet().iterator();
        StringBuffer mask = new StringBuffer();
        int index = 0;
        while (iterator.hasNext()) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)iterator.next().toString(), CompareType.EQUALS));
            if (index == 0) {
                mask.append("#" + index++);
                continue;
            }
            mask.append(" or #" + index++);
        }
        evi.getFilter().setMaskString(mask.toString());
        ICompanyOrgUnit company = null;
        company = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        CompanyOrgUnitCollection coms = company.getCompanyOrgUnitCollection(evi);
        this.permissionOrgs = new HashMap();
        this.permissionOrgs.put("", null);
        int n = coms.size();
        for (int i = 0; i < n; ++i) {
            this.permissionOrgs.put(coms.get(i).getNumber().toUpperCase(), new FunctionPermission(coms.get(i).getId()));
        }
        return this.permissionOrgs;
    }

    public BigDecimal acctExt(String fiOrgUnit, String account, String opposingAccount, String userDefineFiter, String voucherGetType, String currency, String startDate, String endDate) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (!this.getUserPermissionOrgs().containsKey(fiOrgUnit.toUpperCase())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()));
        }
        this.getRptSP();
        if (report != null) {
            if ((fiOrgUnit == null || fiOrgUnit.length() <= 0) && report.getCompany() != null) {
                fiOrgUnit = report.getCompany().getNumber();
            }
            if (startDate == null || startDate.length() <= 0) {
                String string = startDate = this.rptSP == null || this.rptSP.getStartDate() == null ? report.getStartDate().toString() : this.rptSP.getStartDate().toString();
            }
            if (endDate == null || endDate.length() <= 0) {
                String string = endDate = this.rptSP == null || this.rptSP.getEndDate() == null ? report.getEndDate().toString() : this.rptSP.getEndDate().toString();
            }
            if (currency == null || currency.length() <= 0) {
                if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                    currency = this.rptSP.getCurrency().getNumber();
                } else if (report.getCurrency() != null) {
                    currency = report.getCurrency().getNumber();
                }
            }
        }
        boolean includeVoucher = false;
        if (this.rptSP != null) {
            includeVoucher = this.rptSP.isIsIncludingUnposted();
        }
        if (voucherGetType == null || voucherGetType.trim().length() == 0) {
            throw new BOSException(RptUtil.getResourceSince51("NeedFetchType"));
        }
        VoucherGetTypeEnum en = VoucherGetTypeEnum.getEnum(voucherGetType.toUpperCase());
        if (en == null) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
        }
        if ((currency.toUpperCase().equalsIgnoreCase("GLC") || currency.toUpperCase().equalsIgnoreCase("GRC")) && (voucherGetType.substring(0, 1).toUpperCase().equalsIgnoreCase("T") || voucherGetType.substring(0, 1).toUpperCase().equalsIgnoreCase("Z"))) {
            throw new BOSException();
        }
        return this.getReportCacl().acctExt(fiOrgUnit, account, opposingAccount, userDefineFiter, en, currency, startDate, endDate, includeVoucher, false);
    }

    public KDTable getCalcTable() {
        return this.calcTable;
    }

    public IObjectValue getEditData() {
        return this.rptData.getIObjectValue();
    }

    public void setCalcTable(KDTable table) {
        this.calcTable = table;
    }

    public void setEditData(IObjectValue value) {
        this.rptData = new RptRefractor(value);
    }

    public BigDecimal BgAcct(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int beginYear, int beginPeriod, int endYear, int endPeriod) throws EASBizException, BOSException {
        BigDecimal result = null;
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        this.getRptSP();
        int currentYear = 0;
        short currentPeriod = 0;
        if (report != null) {
            currentYear = report.getYear();
            currentPeriod = report.getPeriod();
            if (orgNumber == null || orgNumber.length() <= 0) {
                orgNumber = report.getCompany().getNumber().toString();
            }
            if (beginYear <= 0) {
                int n = beginYear = this.rptSP.getStartYear() == 0 ? currentYear + beginYear : this.rptSP.getStartYear() + beginYear;
            }
            if (beginPeriod <= 0) {
                int n = beginPeriod = this.rptSP.getStartPeriod() == 0 ? currentPeriod + beginPeriod : this.rptSP.getStartPeriod() + beginPeriod;
            }
            if (endYear <= 0) {
                int n = endYear = this.rptSP.getEndYear() == 0 ? currentYear + endYear : this.rptSP.getEndYear() + endYear;
            }
            if (endPeriod <= 0) {
                int n = endPeriod = this.rptSP.getEndPeriod() == 0 ? currentPeriod + endPeriod : this.rptSP.getEndPeriod() + endPeriod;
            }
            if (currencyNumber == null || currencyNumber.length() <= 0) {
                if (this.rptSP.getCurrency() != null) {
                    currencyNumber = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currencyNumber = report.getCurrency().getNumber().toString();
                }
            }
        }
        String field = "FBgValue";
        result = this.getIBgProvider().getBgValue(orgNumber, bgTypeNumber, bgElementNumber, strDimAndItemNum, currencyNumber, beginYear, beginPeriod, endYear, endPeriod, field);
        return result;
    }

    public BigDecimal BgAct(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        String field = "fbgvalue";
        BigDecimal result = this.calculateBg(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, field);
        return result;
    }

    private BigDecimal calculateBg(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber, String field) throws BOSException, EASBizException {
        int state;
        IBgFormulaFacade iBgF = null;
        if (iBgF == null) {
            iBgF = this.ServerCtx == null ? BgFormulaFacadeFactory.getRemoteInstance() : BgFormulaFacadeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (beginPeriodNumber.equals("")) {
            beginPeriodNumber = "0";
        }
        if (endPeriodNumber.equals("")) {
            endPeriodNumber = "0";
        }
        int begin = 0;
        int end = 0;
        boolean isPass = true;
        try {
            begin = Integer.parseInt(beginPeriodNumber);
            end = Integer.parseInt(endPeriodNumber);
        }
        catch (NumberFormatException e) {
            isPass = false;
        }
        int currentYear = 0;
        int currentPeriod = 0;
        int n = state = report.get("myState") == null ? 1 : (Integer)report.get("myState");
        if (report.get("myBgPeriod") != null && isPass) {
            BgPeriodInfo period = (BgPeriodInfo)report.get("myBgPeriod");
            int bgPeriodType = period.getPeriodType().getValue();
            currentYear = period.getYear();
            if (bgPeriodType == 1) {
                currentPeriod = 0;
                if (begin > 0) {
                    beginPeriodNumber = begin + "Y";
                } else {
                    int beginYear = currentYear + begin;
                    beginPeriodNumber = beginYear + "Y";
                }
                if (end > 0) {
                    endPeriodNumber = end + "Y";
                } else {
                    int endYear = currentYear + end;
                    endPeriodNumber = endYear + "Y";
                }
            } else if (bgPeriodType == 4) {
                currentPeriod = period.getMonth();
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 12 ? begin : 12);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 12;
                        int j = beginPeriod % 12;
                        beginYear += i;
                        beginPeriod = 12 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 12 ? end : 12);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 12;
                        int j = endPeriod % 12;
                        endYear += i;
                        endPeriod = 12 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
            } else if (bgPeriodType == 3) {
                currentPeriod = period.getQuarter();
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 4 ? begin : 4);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 4;
                        int j = beginPeriod % 4;
                        beginYear += i;
                        beginPeriod = 4 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 4 ? end : 4);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 4;
                        int j = endPeriod % 4;
                        endYear += i;
                        endPeriod = 4 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
            } else if (bgPeriodType == 2) {
                currentPeriod = period.getQuarter();
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 2 ? begin : 2);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 2;
                        int j = beginPeriod % 2;
                        beginYear += i;
                        beginPeriod = 2 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 2 ? end : 2);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 2;
                        int j = endPeriod % 2;
                        endYear += i;
                        endPeriod = 2 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
            }
        } else {
            this.getRptSP();
            if (report != null && isPass) {
                int beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                int endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                RptPeriodTypeEnum type = report.getPeriodType();
                currentPeriod = report.getPeriod();
                if (type.getValue() == 6) {
                    currentPeriod = 0;
                    beginPeriodNumber = begin > 0 ? begin + "Y" : (beginYear += begin) + "Y";
                    endPeriodNumber = end > 0 ? end + "Y" : (endYear += end) + "Y";
                } else if (type.getValue() == 3) {
                    beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                    int beginPeriod = 0;
                    beginPeriod = begin < 0 ? (this.rptSP.getStartPeriod() == 0 ? currentPeriod + begin : this.rptSP.getStartPeriod() + begin) : (begin <= 12 ? begin : 12);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 12;
                            int j = beginPeriod % 12;
                            beginYear += i;
                            beginPeriod = 12 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? (this.rptSP.getEndPeriod() == 0 ? currentPeriod + end : this.rptSP.getEndPeriod() + end) : (end <= 12 ? end : 12);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 12;
                            int j = endPeriod % 12;
                            endYear += i;
                            endPeriod = 12 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
                } else if (type.getValue() == 4) {
                    beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                    int beginPeriod = 0;
                    beginPeriod = begin <= 0 ? (this.rptSP.getStartPeriod() == 0 ? currentPeriod + begin : this.rptSP.getStartPeriod() + begin) : (begin <= 4 ? begin : 4);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 4;
                            int j = beginPeriod % 4;
                            beginYear += i;
                            beginPeriod = 4 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? (this.rptSP.getEndPeriod() == 0 ? currentPeriod + end : this.rptSP.getEndPeriod() + end) : (end <= 4 ? end : 4);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 4;
                            int j = endPeriod % 4;
                            endYear += i;
                            endPeriod = 4 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
                } else if (type.getValue() == 5) {
                    beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                    int beginPeriod = 0;
                    beginPeriod = begin <= 0 ? (this.rptSP.getStartPeriod() == 0 ? currentPeriod + begin : this.rptSP.getStartPeriod() + begin) : (begin <= 2 ? begin : 2);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 2;
                            int j = beginPeriod % 2;
                            beginYear += i;
                            beginPeriod = 2 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? (this.rptSP.getEndPeriod() == 0 ? currentPeriod + end : this.rptSP.getEndPeriod() + end) : (end <= 2 ? end : 2);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 2;
                            int j = endPeriod % 2;
                            endYear += i;
                            endPeriod = 2 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
                }
            }
        }
        if (currencyNumber == null || currencyNumber.length() <= 0) {
            if (this.rptSP.getCurrency() != null) {
                currencyNumber = this.rptSP.getCurrency().getNumber().toString();
            } else if (report.getCurrency() != null) {
                currencyNumber = report.getCurrency().getNumber().toString();
            }
        }
        BigDecimal result = iBgF.getBgValue(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, field, state);
        return result;
    }

    public BigDecimal BgItem(String strItemCombinNum, String periodNumber, String bgElementNumber, String type, boolean isSum, String currencyNumber) {
        return new BigDecimal("0.00");
    }

    public BigDecimal BgItem(String strItemCombinNum, String periodNumber, String bgElementNumber, String currencyNumber) {
        return new BigDecimal("0.00");
    }

    public BigDecimal BgFormula(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        String field = "fbgvalue";
        BigDecimal result = this.calculateBg(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, field);
        return result;
    }

    private BigDecimal getBgValue(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int year, int period, ReportBaseInfo report, String field) throws BOSException, EASBizException {
        BigDecimal result = null;
        result = this.getIBgProvider().parseRptFormulaMul(field, bgTypeNumber, orgNumber, bgElementNumber, strDimAndItemNum, currencyNumber, String.valueOf(year), String.valueOf(period));
        return result;
    }

    private BigDecimal getBgValue(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int beginYear, int beginPeriod, int endYear, int endPeriod, ReportBaseInfo report, String field) throws BOSException, EASBizException {
        BigDecimal result = new BigDecimal("0");
        if (beginYear == endYear) {
            for (int i = beginPeriod; i <= endPeriod; ++i) {
                BigDecimal temp = this.getIBgProvider().parseRptFormulaMul(field, bgTypeNumber, orgNumber, bgElementNumber, strDimAndItemNum, currencyNumber, String.valueOf(beginYear), String.valueOf(i));
                result = result.add(temp);
            }
        } else if (beginYear > endYear) {
            result = new BigDecimal("0");
        } else {
            int i;
            for (i = beginPeriod; i <= 12; ++i) {
                result = result.add(this.getIBgProvider().parseRptFormulaMul(field, bgTypeNumber, orgNumber, bgElementNumber, strDimAndItemNum, currencyNumber, String.valueOf(beginYear), String.valueOf(i)));
            }
            for (int j = beginYear + 1; j < endYear; ++j) {
                for (int i2 = 1; i2 <= 12; ++i2) {
                    result = result.add(this.getIBgProvider().parseRptFormulaMul(field, bgTypeNumber, orgNumber, bgElementNumber, strDimAndItemNum, currencyNumber, String.valueOf(j), String.valueOf(i2)));
                }
            }
            for (i = 1; i <= endPeriod; ++i) {
                result = result.add(this.getIBgProvider().parseRptFormulaMul(field, bgTypeNumber, orgNumber, bgElementNumber, strDimAndItemNum, currencyNumber, String.valueOf(endYear), String.valueOf(i)));
            }
        }
        return result;
    }

    public BigDecimal BgBalance(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int beginYear, int beginPeriod) throws EASBizException, BOSException {
        return this.BgBalance(orgNumber, bgTypeNumber, bgElementNumber, strDimAndItemNum, currencyNumber, beginYear, beginPeriod, beginYear, beginPeriod);
    }

    public BigDecimal BgAcct(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int beginYear, int beginPeriod) throws EASBizException, BOSException {
        return this.BgAcct(orgNumber, bgTypeNumber, bgElementNumber, strDimAndItemNum, currencyNumber, beginYear, beginPeriod, beginYear, beginPeriod);
    }

    public BigDecimal BgBalance(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int beginYear, int beginPeriod, int endYear, int endPeriod) throws EASBizException, BOSException {
        BigDecimal result = null;
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        this.getRptSP();
        int currentYear = 0;
        short currentPeriod = 0;
        if (report != null) {
            currentYear = report.getYear();
            currentPeriod = report.getPeriod();
            if (orgNumber == null || orgNumber.length() <= 0) {
                orgNumber = report.getCompany().getNumber().toString();
            }
            if (beginYear <= 0) {
                int n = beginYear = this.rptSP.getStartYear() == 0 ? currentYear + beginYear : this.rptSP.getStartYear() + beginYear;
            }
            if (beginPeriod <= 0) {
                int n = beginPeriod = this.rptSP.getStartPeriod() == 0 ? currentPeriod + beginPeriod : this.rptSP.getStartPeriod() + beginPeriod;
            }
            if (endYear <= 0) {
                int n = endYear = this.rptSP.getEndYear() == 0 ? currentYear + endYear : this.rptSP.getEndYear() + endYear;
            }
            if (endPeriod <= 0) {
                int n = endPeriod = this.rptSP.getEndPeriod() == 0 ? currentPeriod + endPeriod : this.rptSP.getEndPeriod() + endPeriod;
            }
            if (currencyNumber == null || currencyNumber.length() <= 0) {
                if (this.rptSP.getCurrency() != null) {
                    currencyNumber = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currencyNumber = report.getCurrency().getNumber().toString();
                }
            }
        }
        String field = "FBgBalance";
        result = this.getIBgProvider().getBgValue(orgNumber, bgTypeNumber, bgElementNumber, strDimAndItemNum, currencyNumber, beginYear, beginPeriod, endYear, endPeriod, field);
        return result;
    }

    public BigDecimal BgBal(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        String field = "fbgbalance";
        BigDecimal result = this.calculateBg(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, field);
        return result;
    }

    public BigDecimal BgActual(String orgNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        IBgFormulaFacade iBgF = null;
        if (iBgF == null) {
            iBgF = this.ServerCtx == null ? BgFormulaFacadeFactory.getRemoteInstance() : BgFormulaFacadeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (beginPeriodNumber.equals("")) {
            beginPeriodNumber = "0";
        }
        if (endPeriodNumber.equals("")) {
            endPeriodNumber = "0";
        }
        int begin = 0;
        int end = 0;
        boolean isPass = true;
        try {
            begin = Integer.parseInt(beginPeriodNumber);
            end = Integer.parseInt(endPeriodNumber);
        }
        catch (NumberFormatException e) {
            isPass = false;
        }
        int currentYear = 0;
        int currentPeriod = 0;
        if (report.get("myBgPeriod") != null && isPass) {
            BgPeriodInfo period = (BgPeriodInfo)report.get("myBgPeriod");
            int bgPeriodType = period.getPeriodType().getValue();
            currentYear = period.getYear();
            if (bgPeriodType == 1) {
                currentPeriod = 0;
                int beginYear = 0;
                beginYear = begin <= 0 ? currentYear + begin : begin;
                int endYear = 0;
                endYear = end <= 0 ? currentYear + end : end;
                beginPeriodNumber = beginYear + "Y";
                endPeriodNumber = endYear + "Y";
            } else if (bgPeriodType == 4) {
                currentPeriod = period.getMonth();
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 12 ? begin : 12);
                if (beginPeriod < 0 || beginPeriod > 12) {
                    int i = beginPeriod / 12;
                    int j = beginPeriod % 12;
                    beginYear += i;
                    beginPeriod = 12 + j;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 12 ? end : 12);
                if (endPeriod < 0 || endPeriod > 12) {
                    int i = endPeriod / 12;
                    int j = endPeriod % 12;
                    endYear += i;
                    endPeriod = j;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
            } else if (bgPeriodType == 3) {
                currentPeriod = period.getQuarter();
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 4 ? begin : 4);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 4;
                        int j = beginPeriod % 4;
                        beginYear += i;
                        beginPeriod = 4 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 4 ? end : 4);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 4;
                        int j = endPeriod % 4;
                        endYear += i;
                        endPeriod = 4 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
            } else if (bgPeriodType == 2) {
                currentPeriod = period.getQuarter();
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 2 ? begin : 2);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 2;
                        int j = beginPeriod % 2;
                        beginYear += i;
                        beginPeriod = 2 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 2 ? end : 2);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 2;
                        int j = endPeriod % 2;
                        endYear += i;
                        endPeriod = 2 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
            }
        } else {
            this.getRptSP();
            if (report != null && isPass) {
                int beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                int endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                RptPeriodTypeEnum type = report.getPeriodType();
                currentPeriod = report.getPeriod();
                if (type.getValue() == 6) {
                    currentPeriod = 0;
                    beginPeriodNumber = begin > 0 ? begin + "Y" : (beginYear += begin) + "Y";
                    endPeriodNumber = end > 0 ? end + "Y" : (endYear += end) + "Y";
                } else if (type.getValue() == 3) {
                    beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                    int beginPeriod = 0;
                    beginPeriod = begin < 0 ? (this.rptSP.getStartPeriod() == 0 ? currentPeriod + begin : this.rptSP.getStartPeriod() + begin) : (begin <= 12 ? begin : 12);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 12;
                            int j = beginPeriod % 12;
                            beginYear += i;
                            beginPeriod = 12 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? (this.rptSP.getEndPeriod() == 0 ? currentPeriod + end : this.rptSP.getEndPeriod() + end) : (end <= 12 ? end : 12);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 12;
                            int j = endPeriod % 12;
                            endYear += i;
                            endPeriod = 12 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
                } else if (type.getValue() == 4) {
                    beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                    int beginPeriod = 0;
                    beginPeriod = begin <= 0 ? (this.rptSP.getStartPeriod() == 0 ? currentPeriod + begin : this.rptSP.getStartPeriod() + begin) : (begin <= 4 ? begin : 4);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 4;
                            int j = beginPeriod % 4;
                            beginYear += i;
                            beginPeriod = 4 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? (this.rptSP.getEndPeriod() == 0 ? currentPeriod + end : this.rptSP.getEndPeriod() + end) : (end <= 4 ? end : 4);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 4;
                            int j = endPeriod % 4;
                            endYear += i;
                            endPeriod = 4 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
                } else if (type.getValue() == 5) {
                    beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                    int beginPeriod = 0;
                    beginPeriod = begin <= 0 ? (this.rptSP.getStartPeriod() == 0 ? currentPeriod + begin : this.rptSP.getStartPeriod() + begin) : (begin <= 2 ? begin : 2);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 2;
                            int j = beginPeriod % 2;
                            beginYear += i;
                            beginPeriod = 2 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? (this.rptSP.getEndPeriod() == 0 ? currentPeriod + end : this.rptSP.getEndPeriod() + end) : (end <= 2 ? end : 2);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 2;
                            int j = endPeriod % 2;
                            endYear += i;
                            endPeriod = 2 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
                }
            }
        }
        if (currencyNumber == null || currencyNumber.length() <= 0) {
            if (this.rptSP.getCurrency() != null) {
                currencyNumber = this.rptSP.getCurrency().getNumber().toString();
            } else if (report.getCurrency() != null) {
                currencyNumber = report.getCurrency().getNumber().toString();
            }
        }
        BigDecimal result = iBgF.getBgValue(orgNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, "fbizactual");
        return result;
    }

    public BigDecimal FpAcct(String orgNumber, String itemNumber, String asstItemCombNumber, String beginPeriodNumber, String endPeriodNumber, String valueType, String dataType, String currencyNumber) throws BOSException, EASBizException {
        IFpFormulaFacade iFpFormula = null;
        if (iFpFormula == null) {
            iFpFormula = this.ServerCtx == null ? FpFormulaFacadeFactory.getRemoteInstance() : FpFormulaFacadeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        BigDecimal result = iFpFormula.getFpValue(orgNumber, itemNumber, asstItemCombNumber, beginPeriodNumber, endPeriodNumber, valueType, dataType, currencyNumber);
        return result;
    }

    public Object REFDM(String companyNumber, String templateNumber, String templateType, String currencyNumber, int year, int period, String itemNumber, String dyItemNumber, String fetchType, String valueType) throws BOSException, EASBizException {
        int[] start;
        CslReportInfo cslRpt = this.rptData.getCslReportInfo();
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        int rptYear = 0;
        int rptPeriod = 0;
        int int_periodType = 0;
        String dataCollectNumber = null;
        if (report != null) {
            if ((companyNumber == null || companyNumber.length() <= 0) && report.getCompany() != null) {
                companyNumber = report.getCompany().getNumber();
            }
            if (currencyNumber == null || currencyNumber.trim().equals("")) {
                if (cslRpt != null) {
                    currencyNumber = cslRpt.getSourceCurrency().getNumber();
                    rptYear = cslRpt.getYear();
                    rptPeriod = cslRpt.getPeriod();
                    int_periodType = cslRpt.getPeriodType().getValue();
                    dataCollectNumber = cslRpt.getDataCollectNumber();
                }
                if (report != null) {
                    currencyNumber = report.getCurrency().getNumber();
                    rptYear = report.getYear();
                    rptPeriod = report.getPeriod();
                    int_periodType = report.getPeriodType().getValue();
                    dataCollectNumber = "ACTUALDATA";
                }
            }
        }
        if ((start = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)year, (int)period)) != null) {
            year = start[0];
            period = start[1];
        }
        int int_dataElement = -1;
        int_dataElement = this.ServerCtx == null ? DataElementProvider.getDataElementInnerValue((String)fetchType) : DataElementProvider.getDataElementInnerValue((Context)this.ServerCtx, (String)fetchType);
        int int_valueType = FormulaAdapter.getValueType((String)valueType);
        try {
            return this.getDynaRptItemDataFacade().getDyItemDataByTemplate(companyNumber, templateNumber, templateType, currencyNumber, null, year, period, itemNumber, dyItemNumber, int_dataElement, int_valueType, null, dataCollectNumber);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public BigDecimal acctAC(String fiOrgUnit, String destOrgUnit, String acctItem, String balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currency) throws BOSException, EASBizException {
        int periodType;
        short rptPeriod;
        int rptYear;
        int[] start;
        ReportBaseInfo cslRpt = this.rptData.getReportBaseInfo();
        if (StringUtils.isEmpty((String)fiOrgUnit)) {
            fiOrgUnit = cslRpt.getCompany().getNumber();
        }
        if (StringUtils.isEmpty((String)currency) && cslRpt.getCurrency() != null && cslRpt.getCurrency().getNumber() != null) {
            currency = cslRpt.getCurrency().getNumber();
        }
        if ((start = RPTDateUtil.getRptYearAndPeriod((int)(rptYear = cslRpt.getYear()), (int)(rptPeriod = cslRpt.getPeriod()), (int)(periodType = cslRpt.getPeriodType().getValue()), (int)startYear, (int)startPeriod)) == null) {
            startYear = rptYear;
            startPeriod = rptPeriod;
        } else {
            startYear = start[0];
            startPeriod = start[1];
        }
        int[] end = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)periodType, (int)endYear, (int)endPeriod);
        if (end == null) {
            endYear = rptYear;
            endPeriod = rptPeriod;
        } else {
            endYear = end[0];
            endPeriod = end[1];
        }
        return this.getCslRptDataService().acctAC(fiOrgUnit, destOrgUnit, acctItem, balanceType, startYear, startPeriod, endYear, endPeriod, currency, false);
    }

    public BigDecimal AdjustData(String orgBoundNumber, String orgUnitNumber, String sourceCurrencyNumber, String currencyNumber, String startItemNumber, String endItemNumber, String rptPeriodType, int yearOffset, int startPeriodOffset, int endPeriodOffset, String dataSource, String dataElement, String valueType, String dc, boolean isIncldUnAudit) throws BOSException, EASBizException {
        ReportBaseInfo cslRpt = this.rptData.getReportBaseInfo();
        if (cslRpt != null) {
            int endPeriod;
            int endYear;
            int startPeriod;
            int startYear;
            if ((orgBoundNumber == null || orgBoundNumber.trim().equals("")) && cslRpt.getOrgTree() != null && cslRpt.getOrgTree().getNumber() != null) {
                orgBoundNumber = cslRpt.getOrgTree().getNumber();
            }
            if (orgUnitNumber == null || orgUnitNumber.trim().equals("")) {
                orgUnitNumber = this.rptData.getCslReportInfo() != null ? this.rptData.getCslReportInfo().getOrgUnit().getNumber() : this.rptData.getReportBaseInfo().getCompany().getNumber();
            }
            if (currencyNumber == null || currencyNumber.trim().equals("")) {
                currencyNumber = cslRpt.getCurrency().getNumber();
            }
            int int_periodType = rptPeriodType == null || rptPeriodType.trim().equals("") ? cslRpt.getPeriodType().getValue() : FormulaAdapter.getRptPeriodType((String)rptPeriodType);
            int rptYear = cslRpt.getYear();
            int rptPeriod = cslRpt.getPeriod();
            String itemRange = startItemNumber + STR_SEPRATOR + endItemNumber;
            int int_dataSource = FormulaAdapter.getDataSource((String)dataSource);
            int int_dataElement = -1;
            if (this.ServerCtx == null && !StringUtils.isEmpty((String)dataElement)) {
                int_dataElement = DataElementProvider.getDataElementInnerValue((String)dataElement);
            } else if (!StringUtils.isEmpty((String)dataElement)) {
                int_dataElement = DataElementProvider.getDataElementInnerValue((Context)this.ServerCtx, (String)dataElement);
            }
            int int_valueType = FormulaAdapter.getValueType((String)valueType);
            int int_dc = FormulaAdapter.getDebitOrCredit((String)dc);
            int[] start = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)startPeriodOffset);
            int[] end = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)endPeriodOffset);
            if (start == null) {
                startYear = rptYear;
                startPeriod = rptPeriod;
            } else {
                startYear = start[0];
                startPeriod = start[1];
            }
            if (end == null) {
                endYear = rptYear;
                endPeriod = rptPeriod;
            } else {
                endYear = end[0];
                endPeriod = end[1];
            }
            BigDecimal result = this.getCslRptDataService().adjustData(orgBoundNumber, orgUnitNumber, itemRange, sourceCurrencyNumber, currencyNumber, int_periodType, int_dataSource, int_dataElement, startYear, endYear, startPeriod, endPeriod, isIncldUnAudit, int_dc, int_valueType, null);
            return result;
        }
        return new BigDecimal("0");
    }

    public BigDecimal ElimData(String orgBoundNumber, String orgUnitNumber, String sourceCurrencyNumber, String currencyNumber, String startItemNumber, String endItemNumber, String rptPeriodType, int yearOffset, int startPeriodOffset, int endPeriodOffset, String dataElement, String valueType, String dc, boolean isIncldUnAudit) throws BOSException, EASBizException {
        ReportBaseInfo cslRpt = this.rptData.getReportBaseInfo();
        if (cslRpt != null) {
            int endPeriod;
            int endYear;
            int startPeriod;
            int startYear;
            int rptYear = cslRpt.getYear();
            int rptPeriod = cslRpt.getPeriod();
            if (endPeriodOffset + rptPeriod == 0 && dataElement.equals("YTDAMOUNT")) {
                return new BigDecimal("0");
            }
            if ((orgBoundNumber == null || orgBoundNumber.trim().equals("")) && cslRpt.getOrgTree() != null && cslRpt.getOrgTree().getNumber() != null) {
                orgBoundNumber = cslRpt.getOrgTree().getNumber();
            }
            if (orgUnitNumber == null || orgUnitNumber.trim().equals("")) {
                orgUnitNumber = this.rptData.getCslReportInfo() != null ? this.rptData.getCslReportInfo().getOrgUnit().getNumber() : this.rptData.getReportBaseInfo().getCompany().getNumber();
            }
            if (currencyNumber == null || currencyNumber.trim().equals("")) {
                currencyNumber = cslRpt.getCurrency().getNumber();
            }
            int int_periodType = rptPeriodType == null || rptPeriodType.trim().equals("") ? cslRpt.getPeriodType().getValue() : FormulaAdapter.getRptPeriodType((String)rptPeriodType);
            String itemRange = startItemNumber + STR_SEPRATOR + endItemNumber;
            int int_dataElement = -1;
            if (this.ServerCtx == null && !StringUtils.isEmpty((String)dataElement)) {
                int_dataElement = DataElementProvider.getDataElementInnerValue((String)dataElement);
            } else if (!StringUtils.isEmpty((String)dataElement)) {
                int_dataElement = DataElementProvider.getDataElementInnerValue((Context)this.ServerCtx, (String)dataElement);
            }
            int int_valueType = FormulaAdapter.getValueType((String)valueType);
            int int_dc = FormulaAdapter.getDebitOrCredit((String)dc);
            int[] start = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)startPeriodOffset);
            int[] end = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)endPeriodOffset);
            if (start == null) {
                startYear = rptYear;
                startPeriod = rptPeriod;
            } else {
                startYear = start[0];
                startPeriod = start[1];
            }
            if (end == null) {
                endYear = rptYear;
                endPeriod = rptPeriod;
            } else {
                endYear = end[0];
                endPeriod = end[1];
            }
            BigDecimal result = this.getCslRptDataService().elimData(orgBoundNumber, orgUnitNumber, itemRange, sourceCurrencyNumber, currencyNumber, int_periodType, int_dataElement, startYear, endYear, startPeriod, endPeriod, isIncldUnAudit, int_dc, int_valueType);
            return result;
        }
        return new BigDecimal("0");
    }

    public String getCurrentUser() {
        UserInfo uif;
        String res = null;
        VirtualSheetParamInfo info = this.rptData.getVirtualSheetParamInfo();
        if (info != null && (uif = info.getCreator()) != null) {
            res = this.ServerCtx == null ? uif.getName(SysContext.getSysContext().getLocale()) : uif.getName(this.ServerCtx.getLocale());
        }
        return res;
    }

    public String getStartDate(String pattern) throws BOSException, EASBizException {
        return this.getDateImp(pattern, 2, true);
    }

    public String getCurrentDate(String pattern) throws BOSException, EASBizException {
        return this.getDateImp(pattern, 1, false);
    }

    public String getEndDate(String pattern) throws BOSException, EASBizException {
        return this.getDateImp(pattern, 3, true);
    }

    private String getDateImp(String dateFormat, int type, boolean byPeriodType) throws BOSException, EASBizException {
        Date rptDate = null;
        ReportBaseInfo ri = this.rptData.getReportBaseInfo();
        TemplateInfo ti = this.rptData.getTemplateInfo();
        if (ri != null) {
            switch (type) {
                case 2: {
                    rptDate = ri.getStartDate();
                    break;
                }
                case 1: {
                    if (!(ri instanceof CslReportInfo)) {
                        rptDate = ri.getEndDate();
                        dateFormat = dateFormat.toLowerCase().replace('m', 'M');
                        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                        String result = sdf.format(rptDate);
                        return result;
                    }
                }
                default: {
                    if (ri instanceof CslReportInfo) {
                        CslReportInfo cslr = (CslReportInfo)ri;
                        rptDate = RPTDateUtil.getPeriodLastDate((int)cslr.getYear(), (int)cslr.getPeriod(), (RptPeriodTypeEnum)cslr.getPeriodType());
                        dateFormat = dateFormat.toLowerCase().replace('m', 'M');
                        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                        String result = sdf.format(rptDate);
                        return result;
                    }
                    rptDate = ri.getEndDate();
                    break;
                }
            }
        } else if (ti != null) {
            rptDate = ti.getStartDate();
        } else {
            return null;
        }
        if (byPeriodType) {
            dateFormat = dateFormat.toLowerCase().replace('m', 'M');
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            String result = sdf.format(rptDate);
            return result;
        }
        if (rptDate == null) {
            return "";
        }
        int year = 0;
        int month = 0;
        if (ri != null && this.rptSP != null) {
            year = this.rptSP.getEndYear();
            month = this.rptSP.getEndPeriod();
            if (year == 0) {
                year = ri.getYear();
            }
            if (month == 0) {
                month = ri.getPeriod();
            }
        }
        if (dateFormat.equalsIgnoreCase("YYYY")) {
            if (ri != null && this.rptSP != null) {
                return String.valueOf(year);
            }
            Timestamp time = new Timestamp(rptDate.getTime());
            String strdate = time.toString();
            return strdate.substring(0, 4);
        }
        if (dateFormat.equalsIgnoreCase("MM")) {
            if (ri != null && this.rptSP != null) {
                return String.valueOf(month);
            }
            Timestamp time = new Timestamp(rptDate.getTime());
            String strdate = time.toString();
            return strdate.substring(0, 2);
        }
        if (dateFormat.equalsIgnoreCase("YYYY-MM")) {
            if (ri != null && this.rptSP != null) {
                return String.valueOf(year) + "-" + String.valueOf(month);
            }
            Timestamp time = new Timestamp(rptDate.getTime());
            String strdate = time.toString();
            return strdate.substring(0, 7);
        }
        if (ri != null && this.rptSP != null && ri.getPeriodType() != RptPeriodTypeEnum.DAILY && ri.getPeriodType() != RptPeriodTypeEnum.WEEKLY) {
            if (ri.getSourceType() == RptSrcTypeEnum.SUM || ri.getSourceType() == RptSrcTypeEnum.CONSOLIDATION || ri.getSourceType() == RptSrcTypeEnum.MANUSCRIPT) {
                rptDate = ri.getEndDate();
            } else {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("AccountPeriodType"));
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getComp().getValue((IObjectPK)new ObjectUuidPK(ri.getCompany().getId()), selector);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("PeriodYear", (Object)new Integer(year)));
                filter.getFilterItems().add(new FilterItemInfo("PeriodNumber", (Object)new Integer(month)));
                filter.getFilterItems().add(new FilterItemInfo("PeriodType", (Object)company.getAccountPeriodType().getId().toString()));
                evi.setFilter(filter);
                PeriodCollection periods = this.getPeriod().getPeriodCollection(evi);
                if (periods.size() > 0) {
                    rptDate = periods.get(0).getEndDate();
                }
            }
        }
        Timestamp time = new Timestamp(rptDate.getTime());
        String strdate = time.toString();
        return strdate.substring(0, 10);
    }

    public BigDecimal cash(String companyNum, String sDataSource, String bankAcctNum, String currencyNum, String sBeginDate, String sEndDate, String sDataType) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (StringUtils.isEmpty((String)companyNum) && report.getCompany() != null) {
            companyNum = report.getCompany().getNumber();
        }
        if (StringUtils.isEmpty((String)currencyNum)) {
            if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                currencyNum = this.rptSP.getCurrency().getNumber();
            } else if (report.getCurrency() != null) {
                currencyNum = report.getCurrency().getNumber();
            }
        }
        Date beginDate = null;
        if (StringUtils.isEmpty((String)sBeginDate)) {
            beginDate = report.getStartDate();
        } else {
            try {
                beginDate = DateTimeUtils.parseDate((String)sBeginDate);
            }
            catch (ParseException ex) {
                log.debug((Object)ex.getMessage());
            }
        }
        Date endDate = null;
        if (StringUtils.isEmpty((String)sEndDate)) {
            endDate = report.getEndDate();
        } else {
            try {
                endDate = DateTimeUtils.parseDate((String)sEndDate);
            }
            catch (ParseException ex) {
                log.debug((Object)ex.getMessage());
            }
        }
        CashDataSourceEnum dataSource = CashDataSourceEnum.CB;
        if (sDataSource != null) {
            dataSource = CashDataSourceEnum.getEnum((String)sDataSource);
        }
        CashDataTypeEnum dataType = CashDataTypeEnum.C;
        if (sDataType != null) {
            dataType = CashDataTypeEnum.getEnum((String)sDataType);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("accountTable.number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNum));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = this.getComp().getCompanyOrgUnitCollection(view);
        CompanyOrgUnitInfo company = coll.get(0);
        String acctTableNum = null;
        if (!company.isIsOnlyUnion()) {
            acctTableNum = company.getAccountTable().getNumber();
        }
        return this.getICashMgt().cash(companyNum, dataSource, acctTableNum, null, bankAcctNum, currencyNum, beginDate, endDate, dataType, false);
    }

    public BigDecimal inAcct(String companyNumber, String sSubsidiaryType, String sInnerAcctType, String innerAcctNumber, String currencyNumber, String sCapitalType, String sBeginDay, String sEndDay, String sInAcctDataType) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (StringUtils.isEmpty((String)companyNumber) && report.getCompany() != null) {
            companyNumber = report.getCompany().getNumber();
        }
        if (!this.getUserPermissionOrgs().containsKey(companyNumber.toUpperCase())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()));
        }
        if (StringUtils.isEmpty((String)currencyNumber)) {
            if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                currencyNumber = this.rptSP.getCurrency().getNumber();
            } else if (report.getCurrency() != null) {
                currencyNumber = report.getCurrency().getNumber();
            }
        }
        Date beginDate = null;
        if (StringUtils.isEmpty((String)sBeginDay)) {
            beginDate = report.getStartDate();
        } else {
            try {
                beginDate = DateTimeUtils.parseDate((String)sBeginDay);
            }
            catch (ParseException ex) {
                log.debug((Object)ex.getMessage());
            }
        }
        Date endDate = null;
        if (StringUtils.isEmpty((String)sEndDay)) {
            endDate = report.getEndDate();
        } else {
            try {
                endDate = DateTimeUtils.parseDate((String)sEndDay);
            }
            catch (ParseException ex) {
                log.debug((Object)ex.getMessage());
            }
        }
        InAcctDataTypeEnum inAcctDataType = InAcctDataTypeEnum.C;
        if (sInAcctDataType != null) {
            inAcctDataType = InAcctDataTypeEnum.getEnum((String)sInAcctDataType);
        }
        return this.getIInAcct().inAcct(companyNumber, innerAcctNumber, currencyNumber, beginDate, endDate, inAcctDataType);
    }

    public String rptIndex(String fiOrgUnit, String indexNumber, int startYear, int startPeriod, int endYear, int endPeriod, String currency, int rptSrcType) throws BOSException, EASBizException {
        IndexItemInfo indexItemInfo;
        if (!this.getUserPermissionOrgs().containsKey(fiOrgUnit.toUpperCase())) {
            return "";
        }
        if (indexNumber == null || indexNumber.trim().length() == 0) {
            return "";
        }
        this.getRptSP();
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report == null) {
            return "";
        }
        if ((fiOrgUnit == null || fiOrgUnit.length() <= 0) && report.getCompany() != null) {
            fiOrgUnit = report.getCompany().getNumber();
        }
        if (startYear <= 0) {
            startYear = (this.rptSP == null || this.rptSP.getStartYear() == 0 ? report.getYear() : this.rptSP.getStartYear()) + startYear;
        }
        if (startPeriod <= 0 && (startPeriod = (this.rptSP == null || this.rptSP.getStartPeriod() == 0 ? report.getPeriod() : this.rptSP.getStartPeriod()) + startPeriod) <= 0) {
            startPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)(--startYear), (String)report.getCompany().getId().toString());
        }
        if (endYear <= 0) {
            endYear = (this.rptSP == null || this.rptSP.getEndYear() == 0 ? report.getYear() : this.rptSP.getEndYear()) + endYear;
        }
        if (endPeriod <= 0 && (endPeriod = (this.rptSP == null || this.rptSP.getEndPeriod() == 0 ? report.getPeriod() : this.rptSP.getEndPeriod()) + endPeriod) <= 0) {
            --endYear;
            endPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)startYear, (String)report.getCompany().getId().toString());
        }
        if (currency == null || currency.length() <= 0) {
            if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                currency = this.rptSP.getCurrency().getNumber().toString();
            } else if (report.getCurrency() != null) {
                currency = report.getCurrency().getNumber();
            }
        }
        if ((indexItemInfo = this.getIRptIndex().getLatestIndexItem(fiOrgUnit, indexNumber, rptSrcType)) != null) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filters = filterInfo.getFilterItems();
            filters.add(new FilterItemInfo("startYear", (Object)new Integer(startYear), CompareType.GREATER_EQUALS));
            filters.add(new FilterItemInfo("endYear", (Object)new Integer(endYear), CompareType.LESS_EQUALS));
            filters.add(new FilterItemInfo("startPeriod", (Object)new Integer(startPeriod), CompareType.GREATER_EQUALS));
            filters.add(new FilterItemInfo("endPeriod", (Object)new Integer(endPeriod), CompareType.LESS_EQUALS));
            filters.add(new FilterItemInfo("currency.number", (Object)currency));
            filters.add(new FilterItemInfo("company.number", (Object)fiOrgUnit));
            filters.add(new FilterItemInfo("sourceType", (Object)new Integer(rptSrcType)));
            filters.add(new FilterItemInfo("indexItem.id", (Object)indexItemInfo.getId().toString()));
            String indexValue = this.getIRptIndex().getLatestIndexData(filterInfo);
            if (indexValue != null) {
                return indexValue;
            }
        }
        return "";
    }

    public IObjectCollection rptIndexExt(String fiOrgUnit, String indexNumber, int startYear, int startPeriod, int endYear, int endPeriod, String currency, int rptSrcType) throws BOSException, EASBizException {
        IndexItemInfo indexItemInfo;
        if (!this.getUserPermissionOrgs().containsKey(fiOrgUnit.toUpperCase())) {
            return null;
        }
        if (indexNumber == null || indexNumber.trim().length() == 0) {
            return null;
        }
        this.getRptSP();
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report == null) {
            return null;
        }
        if ((fiOrgUnit == null || fiOrgUnit.length() <= 0) && report.getCompany() != null) {
            fiOrgUnit = report.getCompany().getNumber();
        }
        if (startYear <= 0) {
            startYear = (this.rptSP == null || this.rptSP.getStartYear() == 0 ? report.getYear() : this.rptSP.getStartYear()) + startYear;
        }
        if (startPeriod <= 0 && (startPeriod = (this.rptSP == null || this.rptSP.getStartPeriod() == 0 ? report.getPeriod() : this.rptSP.getStartPeriod()) + startPeriod) <= 0) {
            startPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)(--startYear), (String)report.getCompany().getId().toString());
        }
        if (endYear <= 0) {
            endYear = (this.rptSP == null || this.rptSP.getEndYear() == 0 ? report.getYear() : this.rptSP.getEndYear()) + endYear;
        }
        if (endPeriod <= 0 && (endPeriod = (this.rptSP == null || this.rptSP.getEndPeriod() == 0 ? report.getPeriod() : this.rptSP.getEndPeriod()) + endPeriod) <= 0) {
            --endYear;
            endPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)startYear, (String)report.getCompany().getId().toString());
        }
        if (currency == null || currency.length() <= 0) {
            if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                currency = this.rptSP.getCurrency().getNumber().toString();
            } else if (report.getCurrency() != null) {
                currency = report.getCurrency().getNumber();
            }
        }
        if ((indexItemInfo = this.getIRptIndex().getLatestIndexItem(fiOrgUnit, indexNumber, rptSrcType)) != null) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filters = filterInfo.getFilterItems();
            filters.add(new FilterItemInfo("startYear", (Object)new Integer(startYear), CompareType.GREATER_EQUALS));
            filters.add(new FilterItemInfo("endYear", (Object)new Integer(endYear), CompareType.LESS_EQUALS));
            filters.add(new FilterItemInfo("startPeriod", (Object)new Integer(startPeriod), CompareType.GREATER_EQUALS));
            filters.add(new FilterItemInfo("endPeriod", (Object)new Integer(endPeriod), CompareType.LESS_EQUALS));
            filters.add(new FilterItemInfo("currency.number", (Object)currency));
            filters.add(new FilterItemInfo("company.number", (Object)fiOrgUnit));
            filters.add(new FilterItemInfo("sourceType", (Object)new Integer(rptSrcType)));
            filters.add(new FilterItemInfo("indexItem.id", (Object)indexItemInfo.getId().toString()));
            IObjectCollection indexValue = this.getIRptIndex().getLatestIndexDataExt(filterInfo);
            if (indexValue != null) {
                return indexValue;
            }
        }
        return null;
    }

    private static String parseAcctFormula(String formula, String company, int startYear, int startPeriod, int endYear, int endPeriod, String currency) {
        try {
            ArrayList<String> formulas = new ArrayList<String>();
            String _formula = formula.trim().substring(1);
            StringTokenizer st = new StringTokenizer(_formula, "+");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (!s.startsWith("Acct(")) {
                    return formula;
                }
                FormulaHint formulaHint = TableToolkit.parseFormula(s);
                String[] params = formulaHint.getParams();
                String result = "Acct(\"" + company + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + startYear + "\",\"" + startPeriod + "\",\"" + endYear + "\",\"" + endPeriod + "\",\"" + currency + "\")";
                formulas.add(result);
            }
            if (formulas.size() > 0) {
                StringBuffer ret = new StringBuffer();
                int size = formulas.size();
                for (int i = 0; i < size - 1; ++i) {
                    ret.append(formulas.get(i) + "+");
                }
                return "=" + ret.toString() + formulas.get(formulas.size() - 1);
            }
        }
        catch (Exception e) {
            return formula;
        }
        return formula;
    }

    private void hasAccountPermission(String companyNumber) throws BOSException, EASBizException {
        if (!this.checkFunctionPermission(companyNumber, PERMISSION_ACCOUNTVIEW)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"ACCOUNT_CALCULATE_PERMISSION_ERROR", (Locale)this.ServerCtx.getOriginLocale()));
        }
    }

    private boolean checkFunctionPermission(String companyNumber, String permissionItem) throws BOSException, EASBizException {
        FunctionPermission p = (FunctionPermission)this.getUserPermissionOrgs().get(companyNumber.toUpperCase());
        if (p != null) {
            Boolean perm = (Boolean)p.permissionItems.get(permissionItem);
            if (perm != null) {
                return perm;
            }
            try {
                this.getPermission().checkFunctionPermission((IObjectPK)new ObjectUuidPK(this.userID), p.companyId, permissionItem);
                p.permissionItems.put(permissionItem, Boolean.TRUE);
                return true;
            }
            catch (EASBizException e) {
                p.permissionItems.put(permissionItem, Boolean.FALSE);
                return false;
            }
        }
        return false;
    }

    public RptRefractor getRptData() {
        return this.rptData;
    }

    public void setRptData(RptRefractor rptData) {
        this.rptData = rptData;
    }

    private ICompanyOrgUnit getComp() throws BOSException {
        if (this.comp == null) {
            this.comp = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.comp;
    }

    private IRPTItemDataService getCslRptDataService() throws BOSException {
        if (this.cslRptDataService == null) {
            this.cslRptDataService = this.ServerCtx == null ? RPTItemDataServiceFactory.getRemoteInstance() : RPTItemDataServiceFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.cslRptDataService;
    }

    private IBgProvider getIBgProvider() throws BOSException {
        if (this.iBgProvider == null) {
            this.iBgProvider = this.ServerCtx == null ? BgProviderFactory.getRemoteInstance() : BgProviderFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.iBgProvider;
    }

    private ICashManagement getICashMgt() throws BOSException {
        if (this.iCashMgt == null) {
            this.iCashMgt = this.ServerCtx == null ? CashManagementFactory.getRemoteInstance() : CashManagementFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.iCashMgt;
    }

    private IFaReportFacade getIFaProvider() throws BOSException {
        if (this.iFaProvider == null) {
            this.iFaProvider = this.ServerCtx == null ? FaReportFacadeFactory.getRemoteInstance() : FaReportFacadeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.iFaProvider;
    }

    private IInAcct getIInAcct() throws BOSException {
        if (this.iInAcct == null) {
            this.iInAcct = this.ServerCtx == null ? InAcctFactory.getRemoteInstance() : InAcctFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.iInAcct;
    }

    private IReport getIReport() throws BOSException {
        if (this.iReport == null) {
            this.iReport = this.ServerCtx == null ? ReportFactory.getRemoteInstance() : ReportFactory.getLocalInstance(this.ServerCtx);
        }
        return this.iReport;
    }

    private IRptIndexFacade getIRptIndex() throws BOSException {
        if (this.iRptIndex == null) {
            this.iRptIndex = this.ServerCtx == null ? RptIndexFacadeFactory.getRemoteInstance() : RptIndexFacadeFactory.getLocalInstance(this.ServerCtx);
        }
        return this.iRptIndex;
    }

    private IOrgRange getOrgRange() throws BOSException {
        if (this.orgRange == null) {
            this.orgRange = this.ServerCtx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.orgRange;
    }

    private IPeriod getPeriod() throws BOSException {
        if (this.period == null) {
            this.period = this.ServerCtx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.period;
    }

    private IPermission getPermission() throws BOSException {
        if (this.permission == null) {
            this.permission = this.ServerCtx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.permission;
    }

    private IReportCacl getReportCacl() throws BOSException {
        if (this.reportCacl == null) {
            this.reportCacl = this.ServerCtx == null ? ReportCaclFactory.getRemoteInstance() : ReportCaclFactory.getLocalInstance(this.ServerCtx);
        }
        return this.reportCacl;
    }

    private Locale getLocale() {
        Locale locale = null;
        locale = this.ServerCtx == null ? SysContext.getSysContext().getLocale() : this.ServerCtx.getLocale();
        return locale;
    }

    private IDynaRptItemDataFacade getDynaRptItemDataFacade() throws BOSException {
        if (this.dynaRptItemDataFacade == null) {
            this.dynaRptItemDataFacade = this.ServerCtx == null ? DynaRptItemDataFacadeFactory.getRemoteInstance() : DynaRptItemDataFacadeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.dynaRptItemDataFacade;
    }

    public Object bgRefBgForm(String orgCode, String bgFormCode, String sheetName, String cellName) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report.get("myBgOrgUnit") != null && orgCode.equals("")) {
            OrgUnitInfo org = (OrgUnitInfo)report.get("myBgOrgUnit");
            orgCode = org.getNumber();
        }
        Object result = null;
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.ma.budget.BgHelper");
            Method method = clazz.getMethod("bgRefBgForm", Context.class, String.class, String.class, String.class, String.class);
            result = method.invoke(clazz.newInstance(), this.ServerCtx, orgCode, bgFormCode, sheetName, cellName);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            return "BAD FUNCTION: " + e.getMessage();
        }
        return result;
    }

    public Object bgRefBgTem(String orgCode, String bgSchemeCode, String bgTemCode, String bgPeriodCode, String sheetName, String cellName) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report.get("myBgOrgUnit") != null && orgCode.equals("")) {
            OrgUnitInfo org = (OrgUnitInfo)report.get("myBgOrgUnit");
            orgCode = org.getNumber();
        }
        Object result = null;
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.ma.budget.BgHelper");
            Method method = clazz.getMethod("bgRefBgTem", Context.class, String.class, String.class, String.class, String.class, String.class, String.class);
            result = method.invoke(clazz.newInstance(), this.ServerCtx, orgCode, bgSchemeCode, bgTemCode, bgPeriodCode, sheetName, cellName);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            return "BAD FUNCTION: " + e.getMessage();
        }
        return result;
    }

    public Object BgActualFD(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (beginPeriodNumber.equals("")) {
            beginPeriodNumber = "0";
        }
        if (endPeriodNumber.equals("")) {
            endPeriodNumber = "0";
        }
        int begin = 0;
        int end = 0;
        boolean isPass = true;
        try {
            begin = Integer.parseInt(beginPeriodNumber);
            end = Integer.parseInt(endPeriodNumber);
        }
        catch (NumberFormatException e) {
            isPass = false;
        }
        int currentYear = 0;
        int currentPeriod = 0;
        if (report.get("myBgPeriod") != null && isPass) {
            int beginYear;
            BgPeriodInfo period = (BgPeriodInfo)report.get("myBgPeriod");
            int bgPeriodType = period.getPeriodType().getValue();
            currentYear = period.getYear();
            if (bgPeriodType == 1) {
                currentPeriod = 0;
                beginYear = currentYear + begin;
                int endYear = currentYear + end;
                beginPeriodNumber = beginYear + "Y";
                endPeriodNumber = endYear + "Y";
            } else if (bgPeriodType == 4) {
                currentPeriod = period.getMonth();
                beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 12 ? begin : 12);
                if (beginPeriod < 0 || beginPeriod > 12) {
                    int i = beginPeriod / 12;
                    int j = beginPeriod % 12;
                    beginYear += i;
                    beginPeriod = 12 + j;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 12 ? end : 12);
                if (endPeriod < 0 || endPeriod > 12) {
                    int i = endPeriod / 12;
                    int j = endPeriod % 12;
                    endYear += i;
                    endPeriod = j;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
            } else if (bgPeriodType == 3) {
                currentPeriod = period.getQuarter();
                beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 4 ? begin : 4);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 4;
                        int j = beginPeriod % 4;
                        beginYear += i;
                        beginPeriod = 4 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 4 ? end : 4);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 4;
                        int j = endPeriod % 4;
                        endYear += i;
                        endPeriod = 4 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
            } else if (bgPeriodType == 2) {
                currentPeriod = period.getQuarter();
                beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 2 ? begin : 2);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 2;
                        int j = beginPeriod % 2;
                        beginYear += i;
                        beginPeriod = 2 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 2 ? end : 2);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 2;
                        int j = endPeriod % 2;
                        endYear += i;
                        endPeriod = 2 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
            }
        } else {
            this.getRptSP();
            if (report != null && isPass) {
                currentYear = report.getYear();
                currentPeriod = report.getPeriod();
                int beginYear = this.rptSP.getStartYear() == 0 ? currentYear : this.rptSP.getStartYear();
                int beginPeriod = 0;
                beginPeriod = begin < 0 ? (this.rptSP.getStartPeriod() == 0 ? currentPeriod + begin : this.rptSP.getStartPeriod() + begin) : (begin <= 12 ? begin : 12);
                if (beginPeriod < 0 || beginPeriod > 12) {
                    int i = beginPeriod / 12;
                    int j = beginPeriod % 12;
                    beginYear += i;
                    beginPeriod = 12 + j;
                }
                int endYear = this.rptSP.getEndYear() == 0 ? currentYear : this.rptSP.getEndYear();
                int endPeriod = 0;
                endPeriod = end < 0 ? (this.rptSP.getEndPeriod() == 0 ? currentPeriod + end : this.rptSP.getEndPeriod() + end) : (end <= 12 ? end : 12);
                if (endPeriod < 0 || endPeriod > 12) {
                    int i = endPeriod / 12;
                    int j = endPeriod % 12;
                    endYear += i;
                    endPeriod = j;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
            }
        }
        if (currencyNumber == null || currencyNumber.length() <= 0) {
            if (this.rptSP.getCurrency() != null) {
                currencyNumber = this.rptSP.getCurrency().getNumber().toString();
            } else if (report.getCurrency() != null) {
                currencyNumber = report.getCurrency().getNumber().toString();
            }
        }
        Object result = null;
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.ma.budget.BgHelper");
            Method method = clazz.getMethod("BgActualFD", Context.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class);
            result = method.invoke(clazz.newInstance(), this.ServerCtx, orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            return "BAD FUNCTION: " + e.getMessage();
        }
        return result;
    }

    public Object BgActualS(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        return this.BgActualFD(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber);
    }

    public String GetCreator() throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        IBgForm iReport = null;
        iReport = this.ServerCtx == null ? BgFormFactory.getRemoteInstance() : BgFormFactory.getLocalInstance((Context)this.ServerCtx);
        ObjectBaseInfo base = null;
        try {
            base = iReport.getObjectBaseInfo("select lastUpdateUser.name where id='" + report.getId() + "'");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (base == null) {
            if (this.ServerCtx == null) {
                return SysContext.getSysContext().getCurrentUserInfo().getName();
            }
            return ContextUtil.getCurrentUserInfo((Context)this.ServerCtx).getName();
        }
        return base.getLastUpdateUser().getName();
    }

    public String bgRptDate(String dateFormat) throws BOSException, EASBizException {
        return this.getBgRptDate(dateFormat);
    }

    private String getBgRptDate(String dateFormat) throws BOSException, EASBizException {
        IBgPeriod ibp = null;
        ibp = this.ServerCtx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance((Context)this.ServerCtx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("endDate");
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        BgPeriodInfo period = (BgPeriodInfo)report.get("myBgPeriod");
        period = (BgPeriodInfo)ibp.getValue((IObjectPK)new ObjectUuidPK(period.getId()), sic);
        Date date = period.getEndDate();
        if (dateFormat.equalsIgnoreCase("yyyy")) {
            return new SimpleDateFormat("yyyy").format(date);
        }
        if (dateFormat.equalsIgnoreCase("mm")) {
            return new SimpleDateFormat("MM").format(date);
        }
        if (dateFormat.equalsIgnoreCase("dd")) {
            return new SimpleDateFormat("dd").format(date);
        }
        if (dateFormat.equalsIgnoreCase("yyyy-mm")) {
            return new SimpleDateFormat("yyyy-MM").format(date);
        }
        if (dateFormat.equalsIgnoreCase("yyyy-mm-dd")) {
            return new SimpleDateFormat("yyyy-MM-dd").format(date);
        }
        return "";
    }

    public String getCurrentOrg(String returnType) throws EASBizException, BOSException {
        FullOrgUnitInfo org;
        IFullOrgUnit ibf = this.ServerCtx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        String returnVal = "";
        if (report.get("myBgPeriod") != null && (org = (FullOrgUnitInfo)report.get("myBgOrgUnit")) != null && org.getId() != null) {
            String oql = "select name ,number where id = '" + org.getId() + "'";
            FullOrgUnitCollection col = ibf.getFullOrgUnitCollection(oql);
            FullOrgUnitInfo info = col.get(0);
            if (returnType.equals("Name")) {
                returnVal = info.getName();
            } else if (returnType.equals("Number")) {
                returnVal = info.getNumber();
            }
        }
        return returnVal;
    }

    private class FunctionPermission {
        IObjectPK companyId = null;
        Map permissionItems = new HashMap(2);

        FunctionPermission(BOSUuid id) {
            this.companyId = new ObjectUuidPK(id);
        }
    }
}

