/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.fi.rpt.ISheetEditObserver;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class RptCheckExpTank
implements Serializable,
ISheetEditObserver,
Cloneable {
    private static final long serialVersionUID = 20041129105311L;
    private ArrayList expressions = null;

    public RptCheckExpTank() {
    }

    public Collection getExpressions() {
        return this.expressions;
    }

    public RptCheckExpTank(RptCheckExpTank mirror) {
        this();
        if (mirror == null) {
            return;
        }
        if (mirror.expressions == null) {
            return;
        }
        int count = mirror.expressions.size();
        this.expressions = new ArrayList(count < 1 ? 1 : count);
        for (int i = 0; i < count; ++i) {
            RptCheckExpression exp = (RptCheckExpression)mirror.expressions.get(i);
            this.expressions.add(exp == null ? null : exp.clone());
        }
    }

    public Object clone() {
        return new RptCheckExpTank(this);
    }

    public RptCheckExpression add(RptCheckExpression exp) {
        if (exp != null) {
            if (this.expressions == null) {
                this.expressions = new ArrayList(1);
            }
            this.expressions.add(exp);
        }
        return exp;
    }

    public void remove(RptCheckExpression exp) {
        if (this.expressions != null) {
            this.expressions.remove(exp);
        }
    }

    public void getSheetExpression(String sheetName, String createOrgId, Collection output) {
        if (output == null || this.expressions == null) {
            return;
        }
        int count = this.expressions.size();
        for (int i = 0; i < count; ++i) {
            RptCheckExpression exp = (RptCheckExpression)this.expressions.get(i);
            if (sheetName != null && !sheetName.equalsIgnoreCase(exp.getSheetName())) continue;
            output.add(exp);
        }
    }

    public void mergeExpressions(RptCheckExpTank exps) {
        if (exps == null) {
            return;
        }
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        if (exps.getExpressions() != null) {
            this.expressions.addAll(exps.getExpressions());
        }
    }

    private void removeSheet(String name) {
        if (this.expressions == null || name == null) {
            return;
        }
        name = name.toLowerCase();
        Iterator it = this.expressions.iterator();
        while (it.hasNext()) {
            RptCheckExpression exp = (RptCheckExpression)it.next();
            if (name.equalsIgnoreCase(exp.getSheetName())) {
                it.remove();
                continue;
            }
            String expr = exp.getContent();
            if (expr == null || expr.toLowerCase().indexOf(name + '!') == -1) continue;
            it.remove();
        }
    }

    private void renameSheet(String oldName, String newName) {
        if (this.expressions == null || newName == null || oldName == null) {
            return;
        }
        for (int i = 0; i < this.expressions.size(); ++i) {
            String expr;
            RptCheckExpression exp = (RptCheckExpression)this.expressions.get(i);
            if (oldName.equalsIgnoreCase(exp.getSheetName())) {
                exp.setSheetName(newName);
            }
            if ((expr = exp.getContent()) != null) {
                expr = StringUtils.replaceIgnoreCase((String)expr, (String)(oldName + '!'), (String)(newName + '!'));
                exp.setContent(expr);
            }
            if (expr == null) continue;
            expr = StringUtils.replaceIgnoreCase((String)expr, (String)(oldName + "'!"), (String)(newName + "'!"));
            exp.setContent(expr);
        }
    }

    public void onDeleteSheet(String sheet) {
        this.removeSheet(sheet);
    }

    public void onRenameSheet(String oldName, String newName) {
        this.renameSheet(oldName, newName);
    }

    public void onAddNewSheet(String newSheet) {
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator it = UserObjectTrans.createObjectIterator((String)s);
        if (it.hasNext()) {
            this.expressions = (ArrayList)it.nextObject();
        }
    }

    public String toSerialString() throws Exception {
        return UserObjectTrans.getSerialString((Object)this.expressions);
    }

    public void setExpressions(ArrayList expressions) {
        this.expressions = expressions;
    }
}

