/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.AbstractRptDataInfo;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.rptdata.RptDataUtil;
import com.kingdee.eas.fi.rpt.rptdata.RptProperty2Info;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RptDataInfo
extends AbstractRptDataInfo
implements Serializable {
    private static final Logger log = Logger.getLogger(RptDataInfo.class);
    public static final String CSLPARAM_KEY_RECORD_RPTDATA = "IsRecordRptData";

    public RptDataInfo() {
    }

    protected RptDataInfo(String pkField) {
        super(pkField);
    }

    public RptDataInfo(Context serverCtx, IReportPropertyAdapter cslReportInfo, Map<String, SortedParameterArray> map) {
        this();
        ReportInfo rpt = this.getRptProperty2Info().convert(serverCtx, cslReportInfo);
        this.setRptInfo(rpt);
        this.setUserId(BOSUuid.read((String)serverCtx.getCaller().toString()));
        this.setUserIp(serverCtx.getClientHostIP());
        this.setFormulaDetail(map);
    }

    public RptDataInfo(Context serverCtx, CslReportInfo cslReportInfo, Map<String, Integer> methods) {
        this();
        this.setRptInfo(cslReportInfo);
        this.setUserId(BOSUuid.read((String)serverCtx.getCaller().toString()));
        this.setUserIp(serverCtx.getClientHostIP());
        this.setFormulaDetailForInt(methods);
    }

    public RptDataInfo(Context serverCtx, ReportBaseInfo cslReportInfo, Map<String, Integer> methods) {
        this();
        this.setRptInfo(cslReportInfo);
        this.setUserId(BOSUuid.read((String)serverCtx.getCaller().toString()));
        this.setUserIp(serverCtx.getClientHostIP());
        this.setFormulaDetailForInt(methods);
    }

    private void setFormulaDetailForInt(Map<String, Integer> methods) {
        Properties detail = new Properties();
        Map.Entry<String, Integer> entry2 = null;
        int totalFormulaNum = 0;
        for (Map.Entry<String, Integer> entry2 : methods.entrySet()) {
            detail.put(entry2.getKey(), entry2.getValue() + "");
            totalFormulaNum += entry2.getValue().intValue();
        }
        this.setTotalFormulaNum(totalFormulaNum);
        this.setFormulaDetail(RptDataUtil.convertProperies2String(detail));
    }

    private void setFormulaDetail(Map<String, SortedParameterArray> methods) {
        Properties detail = new Properties();
        Map.Entry<String, SortedParameterArray> entry2 = null;
        int totalFormulaNum = 0;
        for (Map.Entry<String, SortedParameterArray> entry2 : methods.entrySet()) {
            detail.put(entry2.getKey(), entry2.getValue().size() + "");
            totalFormulaNum += entry2.getValue().size();
        }
        this.setTotalFormulaNum(totalFormulaNum);
        this.setFormulaDetail(RptDataUtil.convertProperies2String(detail));
    }

    private void setRptInfo(CslReportInfo rpt) {
        this.setRptId(rpt.getId());
        this.setRptName(rpt.getName());
        this.setRptNumber(rpt.getNumber());
        this.setRptPeriod(rpt.getPeriod());
        this.setRptYear(rpt.getYear());
        this.setRptPeriodType(rpt.getPeriodType());
        this.setRptSourceType(rpt.getSourceType());
        this.setCompanyId(rpt.getCompany().getId());
        this.setCompanyNumber(rpt.getCompany().getNumber());
        this.setCompanyName(rpt.getCompany().getName());
        this.setRptCurrencyNumber(rpt.getCurrency().getNumber());
        Locale local = new Locale("L1");
        this.setRptCurrencyName(rpt.getCurrency().getName(local), local);
        local = new Locale("L2");
        this.setRptCurrencyName(rpt.getCurrency().getName(local), local);
        local = new Locale("L3");
        this.setRptCurrencyName(rpt.getCurrency().getName(local), local);
    }

    private void setRptInfo(ReportBaseInfo rpt) {
        this.setRptId(rpt.getId());
        this.setRptName(rpt.getName());
        this.setRptNumber(rpt.getNumber());
        this.setRptPeriod(rpt.getPeriod());
        this.setRptYear(rpt.getYear());
        this.setRptPeriodType(rpt.getPeriodType());
        this.setRptSourceType(rpt.getSourceType());
        this.setCompanyId(rpt.getCompany().getId());
        this.setCompanyNumber(rpt.getCompany().getNumber());
        this.setCompanyName(rpt.getCompany().getName());
        this.setRptCurrencyNumber(rpt.getCurrency().getNumber());
        Locale local = new Locale("L1");
        this.setRptCurrencyName(rpt.getCurrency().getName(local), local);
        local = new Locale("L2");
        this.setRptCurrencyName(rpt.getCurrency().getName(local), local);
        local = new Locale("L3");
        this.setRptCurrencyName(rpt.getCurrency().getName(local), local);
    }

    private RptProperty2Info getRptProperty2Info() {
        return new RptProperty2Info();
    }

    public int getRptCalcNum() {
        if (!this.containsKey("rptCalcNum")) {
            return 0;
        }
        return (Integer)this.get("rptCalcNum");
    }

    public void setRptCalcNum(int rptCalcNum) {
        this.put("rptCalcNum", rptCalcNum);
    }

    @Override
    public long getCalcFinishTime() {
        if (super.getCalcFinishTime() == 0L) {
            return Long.MAX_VALUE;
        }
        return super.getCalcFinishTime();
    }

    public long getNetFinishTime() {
        if (this.getCalcFinishTime() == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.getCalcFinishTime() - this.getServerCalcFinishTime();
    }

    public long getUpNetFinishTime() {
        if (this.getServerCalcStartTime() == null || this.getCalcStartTime() == null || this.getCalcFinishTime() == this.getServerCalcFinishTime()) {
            return 0L;
        }
        return this.getServerCalcStartTime().getTime() - this.getCalcStartTime().getTime();
    }

    public long getDownNetFinishTime() {
        if (this.getCalcFinishTime() == this.getServerCalcFinishTime()) {
            return 0L;
        }
        if (this.getCalcFinishTime() == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.getCalcFinishTime() - this.getServerCalcFinishTime() - this.getUpNetFinishTime();
    }
}

