/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.rpt.AbstractReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.util.PropertyContainer;

public class RptReportPropertyAdapter
extends AbstractReportPropertyAdapter {
    private static final long serialVersionUID = 3933978563818108716L;

    public RptReportPropertyAdapter() {
    }

    public RptReportPropertyAdapter(ReportInfo report) {
        this.setProperties(report);
    }

    private void setProperties(ReportInfo report) {
        if (this.propertyContainer == null) {
            this.propertyContainer = new PropertyContainer();
        }
        if (report.getCompany() != null) {
            this.propertyContainer.setString("Company.Name", report.getCompany().getName());
            this.propertyContainer.setString("Company.Number", report.getCompany().getNumber());
            this.propertyContainer.setString("Company.ID", report.getCompany().getId().toString());
        }
        if (report.getOrgTree() != null && report.getOrgTree().getNumber() != null) {
            this.propertyContainer.setString("CSLReport_OrgTree_Number", report.getOrgTree().getNumber());
        }
        if (report.getPeriodType() != null) {
            this.propertyContainer.setInt("PeriodType", report.getPeriodType().getValue());
        }
        this.propertyContainer.setInt("Report.Year", report.getYear());
        this.propertyContainer.setInt("Report.Period", (int)report.getPeriod());
        if (report.getCurrency() != null) {
            this.propertyContainer.setString("Currency.Number", report.getCurrency().getNumber());
        }
        if (report.getSourceCurrency() != null) {
            this.propertyContainer.setString("SourceCurrency.Number", report.getSourceCurrency().getNumber());
        }
        if (report.getLastUpdateUser() != null) {
            this.propertyContainer.setString("LastUpdater.Name", report.getLastUpdateUser().getName());
        }
        this.propertyContainer.setString("Report.Name", report.getName());
        if (report.getId() != null) {
            this.propertyContainer.setString("Report.ID", report.getId().toString());
        }
        this.propertyContainer.setString("Report.Number", report.getNumber());
        if (report.getSourceType() != null) {
            this.propertyContainer.setInt("Report.SourceType", report.getSourceType().getValue());
        }
        if (report.getCU() != null) {
            this.propertyContainer.setString("CU.Name", report.getCU().getId().toString());
        }
        if (report.getCreator() != null) {
            this.propertyContainer.setString("Creater.Name", report.getCreator().getName());
        }
        this.propertyContainer.setDate("Report_StartDate", report.getStartDate());
        this.propertyContainer.setDate("Report_EndDate", report.getEndDate());
        this.propertyContainer.setInt("SupportAdjustPeriodData", report.isIsSupportAdjust() ? 1 : 0);
        this.propertyContainer.setString("CSLReport_DataCollect_Number", report.getDataCollectNumber());
        CurrencyInfo info = report.getSourceCurrency();
        if (info != null && report.getConvertStatus() == ConvertStatusEnum.Converted) {
            this.propertyContainer.setString("SourceCurrency.Number", info.getNumber());
        }
        if (report.getK3Template() != null) {
            this.propertyContainer.setString("isReportFormK3Template", report.getK3Template().getId().toString());
        }
        this.propertyContainer.put("orgType", (Object)report.getOrgType());
        super.setCommonProperty((ReportBaseInfo)report, null);
    }

    public Object getReportProperty(String name) {
        return this.propertyContainer.get(name);
    }

    public void setExtraProperty(String key, Object val) {
        this.propertyContainer.put(key, val);
    }

    public void initReportProperties(IObjectValue vo, Context ctx) {
        this.setProperties((ReportInfo)vo);
    }
}

