/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgF7UI;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewUnionF7;
import com.kingdee.eas.basedata.org.client.tree.MutiRootTreeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.CslRptNewOrgF7UI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class UnionF7Helper {
    private static Logger logger = Logger.getLogger(UnionF7Helper.class);
    public static final int ONLY_UNIT = 1;
    public static final int ONLY_GROUP = 2;
    public static final int UNIT_AND_GROUP = 3;

    public static String getUnionSQLByUserPKAndTreePK(IObjectPK userPK, IObjectPK treePk) throws BOSException {
        return PermissionRangeHelper.getUnionSQLByUserPKAndTreePK((IObjectPK)userPK, (IObjectPK)treePk);
    }

    public static UnionF7 getUnionF7(IUIObject _uiObject, int model) {
        return new UnionF7(_uiObject, model);
    }

    public static UnionF7 getUnionF7(int model) {
        return new UnionF7(model);
    }

    public static IFilterInfoProducer getOrgUnitFilterInfoProducer(OrgType orgType) {
        return new NewOrgUnitFilterInfoProducer(orgType);
    }

    public static ArrayList getAuthenticUnits(Context ctx, String treeID, String rootUnitID, IMetaDataPK uiPK, IMetaDataPK actionPK, int selectMode) throws EASBizException, BOSException {
        String userId = ctx != null ? ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString() : SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        Set set = UnionF7Helper.getAuthorizedOrgs(ctx, null, (IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(treeID), selectMode, uiPK, actionPK);
        ArrayList<OrgUnitInfo> list = new ArrayList<OrgUnitInfo>();
        if (set != null && !set.isEmpty()) {
            OrgUnitInfo orgUnitInfo = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgUnitInfo = new OrgUnitInfo();
                orgUnitInfo.put("id", iterator.next());
                list.add(orgUnitInfo);
            }
        }
        return list;
    }

    private static Set getAuthorizedOrgs(Context ctx, IObjectPK ctrlUnitPK, IObjectPK userPK, IObjectPK treePk, int selectMode, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        IPermission iPermission = ctx != null ? PermissionFactory.getLocalInstance((Context)ctx) : PermissionFactory.getRemoteInstance();
        Map permOrgs = null;
        permOrgs = ctrlUnitPK != null ? iPermission.getAuthorizedOrgs(ctrlUnitPK, userPK, OrgType.UnionDebt, treePk, uiPK, actionPK) : iPermission.getAuthorizedOrgs(userPK, OrgType.UnionDebt, treePk, uiPK, actionPK);
        if (permOrgs == null) {
            permOrgs = new HashMap(2);
        }
        if (selectMode == 2) {
            return permOrgs.keySet();
        }
        HashSet orgIds = UnionF7Helper.getCompanyFromUnionGroup(ctx, treePk.toString(), permOrgs.keySet());
        if (orgIds == null) {
            orgIds = new HashSet(2);
        }
        if (selectMode == 1) {
            return orgIds;
        }
        if (permOrgs != null) {
            orgIds.addAll(permOrgs.keySet());
        }
        return orgIds;
    }

    private static Set getCompanyFromUnionGroup(Context ctx, String treeID, Set unionGroup) throws BOSException, EASBizException {
        HashSet<Object> ret = new HashSet<Object>();
        Iterator it = unionGroup.iterator();
        if (!it.hasNext()) {
            return ret;
        }
        String groupIDs = CslRptUtil.changeIdIter2String(it);
        StringBuffer sql = new StringBuffer("select id, unit.id where ");
        sql.append(" tree.id='").append(treeID).append("' ");
        sql.append(" and parent.unit.id in (").append(groupIDs).append(")");
        sql.append(" and unit.isunion = 0 and unit.partFI.ISSEALUP = 0 ");
        IOrgStructure iOrgStructure = ctx != null ? OrgStructureFactory.getLocalInstance((Context)ctx) : OrgStructureFactory.getRemoteInstance();
        OrgStructureCollection coll = iOrgStructure.getOrgStructureCollection(sql.toString());
        for (int i = 0; i < coll.size(); ++i) {
            ret.add(coll.get(i).getUnit().get("id"));
        }
        return ret;
    }

    public static String getQueryOrgUnitIDSql(String treeId, String userId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ORGRANGE.FORGID FROM T_PM_ORGRANGE ORGRANGE ");
        if (treeId != null) {
            sql.append(" INNER JOIN T_ORG_STRUCTURE  STRUCTURE ON ");
            sql.append(" STRUCTURE.FUNITID = ORGRANGE.FORGID ");
        }
        sql.append(" WHERE ORGRANGE.FUSERID = '").append(userId).append("'");
        sql.append("\tAND ORGRANGE.FTYPE=").append(10);
        if (treeId != null) {
            sql.append("  AND STRUCTURE.FTREEID ='").append(treeId).append("'");
        }
        return sql.toString();
    }

    public static String getQueryOrgUnitNumberSql(String treeId, String userId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT BaseUnit.FNUMBER FROM T_PM_ORGRANGE ORGRANGE ");
        sql.append(" INNER JOIN T_ORG_BaseUnit  BaseUnit ON ");
        sql.append(" ORGRANGE.FORGID = BaseUnit.FID ");
        if (treeId != null) {
            sql.append(" INNER JOIN T_ORG_STRUCTURE  STRUCTURE ON ");
            sql.append(" STRUCTURE.FUNITID = ORGRANGE.FORGID ");
        }
        sql.append(" WHERE ORGRANGE.FUSERID = '").append(userId).append("'");
        sql.append("\tAND ORGRANGE.FTYPE=").append(10);
        if (treeId != null) {
            sql.append("  AND STRUCTURE.FTREEID ='").append(treeId).append("'");
        }
        return sql.toString();
    }

    public static String getQueryCompanyIDSql(String userId, String treeId) {
        StringBuffer sql = new StringBuffer();
        sql.append("\tSELECT T0.FUNITID  \tUNITID\t\t\r\n");
        sql.append("\tFROM T_ORG_STRUCTURE T0\t\t\t\r\n");
        sql.append("\tINNER JOIN T_ORG_TREE T1\t\t\r\n");
        sql.append(" \t ON T0.FTREEID = T1.FID\t\t\t\r\n");
        sql.append("\tINNER JOIN T_ORG_BASEUNIT T2\t\r\n");
        sql.append("  \tON T0.FUNITID = T2.FID\t\t\t\r\n");
        sql.append("\tLEFT OUTER JOIN T_ORG_OUPARTFI T3\t\r\n");
        sql.append("  ON T2.FPARTFIID = T3.FID\t\t\t\t\r\n");
        sql.append("\tLEFT OUTER JOIN T_ORG_STRUCTURE T4\t\r\n");
        sql.append("  ON T0.FPARENTID = T4.FID\t\t\t\t\r\n");
        sql.append(" WHERE T1.FID = '").append(treeId).append("' AND T4.FUNITID IN \r\n");
        sql.append("  (").append(UnionF7Helper.getQueryOrgUnitIDSql(treeId, userId)).append(") \t\r\n");
        sql.append("   AND T2.FISUNION = 0 AND (T3.FISSEALUP = 0 OR T3.FID IS NULL\t)\t");
        return sql.toString();
    }

    public static String getMergeModeOrgUnitIDSql(String treeId, String unitId, MergeModeEnum mergeMode) {
        return UnionF7Helper.getMergeModeOrgUnitIDSql(treeId, unitId, mergeMode, false);
    }

    public static String getMergeModeOrgUnitIDSql(String treeId, String unitId, MergeModeEnum mergeMode, boolean isIncludeSelfUnit) {
        if (MergeModeEnum.ORDINAL.equals((Object)mergeMode)) {
            try {
                OrgStructureInfo unitInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo("select level where unit='" + unitId + "'");
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FUNITID FROM T_ORG_STRUCTURE ");
                if (isIncludeSelfUnit) {
                    sql.append(" WHERE (FUnitId = '").append(unitId).append("' or FLEVEL = ").append(unitInfo.getLevel() + 1).append(")");
                } else {
                    sql.append(" WHERE FLEVEL = ").append(unitInfo.getLevel() + 1);
                }
                sql.append("  AND FTREEID ='").append(treeId).append("'");
                return sql.toString();
            }
            catch (Exception e) {
                return "''";
            }
        }
        return "''";
    }

    public static String getMergeModeOrgUnitIDSqlForConvt(String treeId, String unitId, MergeModeEnum mergeMode) {
        if (MergeModeEnum.ORDINAL.equals((Object)mergeMode)) {
            try {
                OrgStructureInfo unitInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo("select level where unit='" + unitId + "'");
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FUNITID FROM T_ORG_STRUCTURE ");
                sql.append(" WHERE ( FLEVEL = ").append(unitInfo.getLevel() + 1);
                sql.append(" OR FLEVEL = " + unitInfo.getLevel() + ") ");
                sql.append("  AND FTREEID ='").append(treeId).append("'");
                return sql.toString();
            }
            catch (Exception e) {
                return "''";
            }
        }
        return "''";
    }

    public static void addTreeWillExpandListener(KDTree treeMain, final OrgTreeInfo treeInfo, final UnionF7 f7) {
        if (treeInfo == null || f7 == null || treeMain == null) {
            return;
        }
        treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                try {
                    UnionF7Helper.loadNode(tmp, treeInfo, f7);
                }
                catch (Exception e) {
                    throw new ExpandVetoException(event, e.getMessage());
                }
            }
        });
    }

    private static void loadNode(DefaultKingdeeTreeNode tmp, OrgTreeInfo treeInfo, UnionF7 f7) throws Exception {
        CoreBaseInfo orgInfo = (CoreBaseInfo)tmp.getUserObject();
        if (orgInfo == null) {
            return;
        }
        if (orgInfo.getBoolean("isChildLoaded")) {
            return;
        }
        f7.getDirectChildNodes(OrgViewType.UNIONDEBT, treeInfo, tmp);
        orgInfo.setBoolean("isChildLoaded", true);
    }

    public static class UnionF7
    extends NewUnionF7 {
        private OrgTreeCollection orgTrees;
        private OrgTreeInfo preOrgTreeInfo = null;
        private boolean isRptAnalysis = false;
        private boolean isSupportShowArchiveOrgTree = false;
        private boolean isQingAnalyze = false;
        private boolean isShowAllUnion = false;
        private boolean isRptAutoWeave = false;
        private boolean isForCslOrg = false;
        private boolean isTreeChangeRemoveSeletedOrgs = false;

        public boolean isShowAllUnion() {
            return this.isShowAllUnion;
        }

        public void setShowAllUnion(boolean isShowAllUnion) {
            this.isShowAllUnion = isShowAllUnion;
        }

        public OrgTreeInfo getPreOrgTreeInfo() {
            return this.preOrgTreeInfo;
        }

        public void setPreOrgTreeInfo(OrgTreeInfo preOrgTreeInfo) {
            this.preOrgTreeInfo = preOrgTreeInfo;
        }

        public boolean isSupportShowArchiveOrgTree() {
            return this.isSupportShowArchiveOrgTree;
        }

        public void setSupportShowArchiveOrgTree(boolean isSupportShowArchiveOrgTree) {
            this.isSupportShowArchiveOrgTree = isSupportShowArchiveOrgTree;
        }

        public boolean isRptAnalysis() {
            return this.isRptAnalysis;
        }

        public void setRptAnalysis(boolean isRptAnalysis) {
            this.isRptAnalysis = isRptAnalysis;
        }

        public boolean isQingAnalyze() {
            return this.isQingAnalyze;
        }

        public void setQingAnalyze(boolean isQingAnalyze) {
            this.isQingAnalyze = isQingAnalyze;
        }

        public boolean isRptAutoWeave() {
            return this.isRptAutoWeave;
        }

        public UnionF7() {
        }

        public UnionF7(int model) {
            super(model);
        }

        public UnionF7(boolean isForCslOrg, int model) {
            super(model);
            this.isForCslOrg = isForCslOrg;
        }

        public UnionF7(IUIObject _uiObject, int model) {
            super(_uiObject, model);
        }

        public UnionF7(IUIObject _uiObject, int model, boolean isRptAutoWeave) {
            super(_uiObject, model);
            this.isRptAutoWeave = isRptAutoWeave;
        }

        protected OrgUnitInfo[] getTypedInfos(Collection selectedOrgs) {
            if (this.isForCslOrg) {
                if (selectedOrgs == null || selectedOrgs.size() == 0) {
                    return null;
                }
                OrgUnitInfo[] unitInfos = new OrgUnitInfo[selectedOrgs.size()];
                Iterator it = selectedOrgs.iterator();
                int i = 0;
                while (it.hasNext()) {
                    unitInfos[i++] = (FullOrgUnitInfo)it.next();
                }
                return unitInfos;
            }
            return super.getTypedInfos(selectedOrgs);
        }

        public void setOrgViewType(OrgViewType[] orgViewTypeArrays) {
            this.orgViewTypes = orgViewTypeArrays;
            this.setTitle(this.orgViewTypes[0].toString());
            this.setNeedAddOrgRange(true);
            this.setNeedConsiderFaultTree(true);
        }

        public UnionF7(Frame _owner, int model) {
            super(_owner, model);
        }

        public UnionF7(Dialog _owner, int model) {
            super(_owner, model);
        }

        public void setTreeID(String treeID) {
            super.setTreeID(treeID);
        }

        public void setRootUnitID(String rootUnitID) {
            super.setRootUnitID(rootUnitID);
        }

        protected void init() {
            super.init();
        }

        protected boolean isTreeComboxVisible() {
            boolean isVisible = true;
            OrgViewType viewType = this.getComboTypeSelectedItem();
            if (viewType.equals((Object)OrgViewType.COMPANY) || viewType.equals((Object)OrgViewType.PROFITCENTER)) {
                isVisible = false;
            }
            return isVisible;
        }

        public void filterUnitSql(String sql) {
            this.setNeedAddOrgRange(false);
            this.setExtraTreeFilters("\"BASEUNIT\".fid in (" + sql + ")");
            try {
                this.setOuterFilterInfo(new FilterInfo("unit.id in (" + sql + ")"));
            }
            catch (ParserException e) {
                logger.info((Object)" append unit id Filter errer", (Throwable)e);
            }
        }

        public OrgType getOrgType() {
            if (this.orgViewTypes == null || this.orgViewTypes[0] == null) {
                return OrgType.UnionDebt;
            }
            return OrgTypeInfoMgr.getInstance().getOrgTypeInfo(this.orgViewTypes[0]).getOrgType();
        }

        public void setCtrlUnitPK(CtrlUnitInfo cu) {
            if (cu != null && cu.getId() != null) {
                this.setCtrlUnitPK(cu.getId().toString());
            }
        }

        public void setCtrlUnitPK(String ctrlUnitId) {
            this.setCurrentCUID(ctrlUnitId);
        }

        public IFilterInfoProducer getOrgUnitFilterInfoProducer() {
            return new NewOrgUnitFilterInfoProducer(this.getOrgType());
        }

        public TreeModel buildTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, DefaultKingdeeTreeNode selectedNode) throws Exception {
            return super.buildTreeModel(orgViewType, orgTreeInfo, selectedNode);
        }

        protected SelectorItemCollection getSelectorCollection() {
            SelectorItemCollection coll = super.getSelectorCollection();
            coll.add(new SelectorItemInfo("isGrouping"));
            coll.add(new SelectorItemInfo("isProfitOrgUnit"));
            return coll;
        }

        protected OrgTreeCollection fillTreeComboOnUnion() throws EASBizException, BOSException {
            if (this.orgTrees != null) {
                CslRptUtil.handleBudgetFilter(null, null, (OrgTreeCollection)this.orgTrees, null);
                return this.orgTrees;
            }
            OrgTreeCollection oldColl = super.fillTreeComboOnUnion();
            if (oldColl != null && !oldColl.isEmpty()) {
                CslRptUtil.handleBudgetFilter(null, null, (OrgTreeCollection)oldColl, null);
                return oldColl;
            }
            return new OrgTreeCollection();
        }

        public OrgTreeCollection getOrgTrees() {
            return this.orgTrees;
        }

        public void setOrgTrees(OrgTreeCollection orgTrees) {
            this.orgTrees = orgTrees;
        }

        protected EntityViewInfo getEntityViewExceptTreeFilter() throws BOSException {
            FilterInfo filter;
            EntityViewInfo viewInfo;
            OrgViewType viewType;
            if (this.isShowAllUnion && (viewType = this.getComboTypeSelectedItem()) != null && viewType.equals((Object)OrgViewType.UNIONDEBT)) {
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                FilterInfo outerFilterInfo = this.getOuterFilterInfo();
                if (outerFilterInfo != null) {
                    filter.mergeFilter(outerFilterInfo, "and");
                    viewInfo.setFilter(filter);
                    return viewInfo;
                }
            }
            if (!this.isRptAnalysis) {
                return super.getEntityViewExceptTreeFilter();
            }
            try {
                viewType = this.getComboTypeSelectedItem();
                if (viewType != null && viewType.equals((Object)OrgViewType.UNIONDEBT)) {
                    if (!this.isCUFilter() || this.isNeedAddOrgRange()) {
                        viewInfo = this.getTopSupperEntityViewExceptTreeFilter();
                        filter = viewInfo.getFilter();
                        OrgTreeInfo treeInfo = this.getComboTreeSelectedItem();
                        FilterInfo orgRangeFilter = this.getOrgFilter(treeInfo);
                        if (orgRangeFilter != null) {
                            filter.mergeFilter(orgRangeFilter, "and");
                        }
                        return viewInfo;
                    }
                } else if (viewType != null && (viewType.equals((Object)OrgViewType.COMPANY) || viewType.equals((Object)OrgViewType.PROFITCENTER))) {
                    viewInfo = super.getEntityViewExceptTreeFilter();
                    filter = viewInfo.getFilter();
                    FilterInfo filterOut = new FilterInfo();
                    filterOut.appendFilterItem("ORGSTRUCTURE.isLeaf", (Object)1);
                    filter.mergeFilter(filterOut, "and");
                    return viewInfo;
                }
            }
            catch (Exception e) {
                logger.error((Object)"getEntityViewExceptTreeFilter error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            return super.getEntityViewExceptTreeFilter();
        }

        protected FilterInfo getOrgFilter(OrgTreeInfo treeInfo) throws Exception {
            if (treeInfo == null) {
                return null;
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("tree.id", (Object)treeInfo.getId().toString());
            filter.appendFilterItem("unit.isunion", (Object)1);
            StringBuffer sql = new StringBuffer();
            sql.append("unit.id in(select forgid FROM t_pm_orgrange");
            sql.append(" where ftype = 10 and fuserid='");
            sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            sql.append("')");
            FilterInfo orgRangeFilter = new FilterInfo(sql.toString());
            filter.mergeFilter(orgRangeFilter, "and");
            viewInfo.setFilter(filter);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("longNumber");
            viewInfo.setSelector(selectors);
            SorterItemCollection sorts = new SorterItemCollection();
            SorterItemInfo sorterItem = new SorterItemInfo("longNumber");
            sorterItem.setSortType(SortType.ASCEND);
            sorts.add(sorterItem);
            viewInfo.setSorter(sorts);
            OrgStructureCollection coll = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                FilterInfo dataPermFilter;
                String preLongNumber = null;
                FilterInfo curFilter = new FilterInfo();
                for (int i = 0; i < coll.size(); ++i) {
                    String longNumber = coll.get(i).getLongNumber();
                    if (preLongNumber != null) {
                        if (longNumber.startsWith(preLongNumber + "!")) continue;
                        this.setLongNumberFilter(longNumber, curFilter);
                        preLongNumber = longNumber;
                        continue;
                    }
                    this.setLongNumberFilter(longNumber, curFilter);
                    preLongNumber = longNumber;
                }
                if (curFilter.getFilterItems().size() > 0) {
                    StringBuffer maskString = new StringBuffer("(");
                    for (int i = 0; i < curFilter.getFilterItems().size(); ++i) {
                        if (i > 0) {
                            maskString.append(" or ");
                        }
                        maskString.append("#").append(i);
                    }
                    maskString.append(")");
                    curFilter.appendFilterItem("tree.id", (Object)treeInfo.getId().toString());
                    maskString.append(" and #").append(curFilter.getFilterItems().size() - 1);
                    curFilter.setMaskString(maskString.toString());
                }
                sql.append(" and unit.isunion=0 and tree.id='").append(treeInfo.getId().toString()).append("' ");
                FilterInfo orgRangeFilter2 = new FilterInfo(sql.toString());
                if (this.dataPermParam != null && (dataPermFilter = this.getOrgIdsByDataPermFilter(treeInfo)) != null) {
                    curFilter.mergeFilter(dataPermFilter, "and");
                }
                if (curFilter.getFilterItems().size() <= 0) {
                    return orgRangeFilter2;
                }
                curFilter.mergeFilter(orgRangeFilter2, "or");
                return curFilter;
            }
            return null;
        }

        protected FilterInfo getOrgIdsByDataPermFilter(OrgTreeInfo treeInfo) {
            StringBuffer sql = new StringBuffer();
            try {
                if (treeInfo != null) {
                    sql.append(" select distinct FOrgID from (");
                    sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" inner join T_PM_PERMITEM item on item.fid=UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FOwner ='").append(this.dataPermParam.userId).append("'").append(" AND item.FNumber='").append(this.dataPermParam.permItem).append("'").append(" AND UserOrgPerm.FPermType <> ").append(30).append(" ").append(" UNION ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" inner join T_PM_PERMITEM item on item.fid=RolePerm.FPermItemID ").append(" WHERE UserRoleOrg.FUserID ='").append(this.dataPermParam.userId).append("'").append(" AND item.FNumber ='").append(this.dataPermParam.permItem).append("'");
                    sql.append(") orgTable ");
                    sql.append(" where FOrgID in (select funitid from t_org_structure where ftreeid='").append(treeInfo.getId().toString()).append("') ");
                }
            }
            catch (Exception e) {
                sql.setLength(0);
                logger.error((Object)"getQueryPermissionSQL error.", (Throwable)e);
            }
            if (sql.length() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)sql.toString(), CompareType.INNER));
                return filter;
            }
            return null;
        }

        private void setLongNumberFilter(String longNumber, FilterInfo filter) throws Exception {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        }

        protected EntityViewInfo getTopSupperEntityViewExceptTreeFilter() throws Exception {
            FilterInfo tmpOuterFilter;
            FilterInfo outerFilter;
            EntityViewInfo result = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            result.setFilter(filter);
            Method prefix = NewOrgF7UI.class.getDeclaredMethod("prefix", new Class[0]);
            NewRptUtil.makeAccessible((Method)prefix);
            if (this.isNeedAddAssistant()) {
                CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
                if (currentCompany != null && currentCompany.isIsAssistantOrg()) {
                    filter.getFilterItems().add(new FilterItemInfo(prefix.invoke((Object)this.f7ui, new Object[0]) + "isAssistantOrg", (Object)1, CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo(prefix.invoke((Object)this.f7ui, new Object[0]) + "isAssistantOrg", (Object)0, CompareType.EQUALS));
                }
            }
            if (this.isNeedAddVirtual()) {
                filter.getFilterItems().add(new FilterItemInfo(prefix.invoke((Object)this.f7ui, new Object[0]) + "partAdmin.isVirtual", (Object)0, CompareType.EQUALS));
            }
            if (this.isNeedAddSealUp()) {
                Method getSealUpOrgFilter = NewOrgF7UI.class.getDeclaredMethod("getSealUpOrgFilter", new Class[0]);
                NewRptUtil.makeAccessible((Method)getSealUpOrgFilter);
                FilterItemInfo itemInfo = (FilterItemInfo)getSealUpOrgFilter.invoke((Object)this.f7ui, new Object[0]);
                if (itemInfo != null) {
                    filter.getFilterItems().add(itemInfo);
                }
            }
            Method getQuickSearchFilter = NewOrgF7UI.class.getDeclaredMethod("getQuickSearchFilter", new Class[0]);
            NewRptUtil.makeAccessible((Method)getQuickSearchFilter);
            FilterInfo quickSearchfilter = (FilterInfo)getQuickSearchFilter.invoke((Object)this.f7ui, new Object[0]);
            if (quickSearchfilter != null) {
                filter.mergeFilter(quickSearchfilter, "and");
            }
            if ((outerFilter = this.getOuterFilterInfo()) != null) {
                filter.mergeFilter(outerFilter, "and");
            }
            if ((tmpOuterFilter = this.handleRuntimeOuterFilterInfo()) != null) {
                filter.mergeFilter(tmpOuterFilter, "and");
            }
            return result;
        }

        public DefaultKingdeeTreeNode getDirectChildNodes(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, DefaultKingdeeTreeNode selectedNode) throws EASBizException, BOSException {
            if (this.isShowAllUnion && orgViewType != null && OrgViewType.UNIONDEBT.equals((Object)orgViewType)) {
                try {
                    return this.getDirectChildNodes(orgViewType, orgTreeInfo, selectedNode, true);
                }
                catch (Exception e) {
                    logger.error((Object)"getDirectChildNodes error_isShowAllUnion", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            if (!this.isRptAnalysis) {
                return super.getDirectChildNodes(orgViewType, orgTreeInfo, selectedNode);
            }
            try {
                if (orgViewType != null && OrgViewType.UNIONDEBT.equals((Object)orgViewType)) {
                    return this.getDirectChildNodes(orgViewType, orgTreeInfo, selectedNode, false);
                }
                return super.getDirectChildNodes(orgViewType, orgTreeInfo, selectedNode);
            }
            catch (Exception e) {
                logger.error((Object)"getDirectChildNodes error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }

        private DefaultKingdeeTreeNode getDirectChildNodes(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, DefaultKingdeeTreeNode selectedNode, boolean isShowAllUnion) throws Exception {
            if (this.f7ui == null) {
                this.createF7UI();
            }
            CoreBaseInfo userObject = null;
            if (selectedNode == null) {
                if (this.getRootUnits() != null && this.getRootUnits().size() > 0) {
                    if (this.getRootUnits().size() > 1) {
                        return MutiRootTreeHelper.buildMutiRootTree((!this.isCbTypeTextEqualsALL() ? 1 : 0) != 0, (List)this.getRootUnits(), (OrgViewType)orgViewType, (OrgTreeInfo)orgTreeInfo);
                    }
                    userObject = this.handleSingleRoot(orgViewType, orgTreeInfo);
                    if (userObject == null) {
                        return new DefaultKingdeeTreeNode();
                    }
                    selectedNode = new DefaultKingdeeTreeNode((Object)userObject);
                } else {
                    userObject = this.prepareUserObject(orgViewType, orgTreeInfo);
                }
            } else {
                userObject = (CoreBaseInfo)selectedNode.getUserObject();
            }
            List childNodes = this.getChildNodes(orgTreeInfo, (OrgStructureInfo)userObject, isShowAllUnion);
            selectedNode = NewOrgViewHelper.buildTreeByList((DefaultKingdeeTreeNode)selectedNode, (List)childNodes);
            if (selectedNode != null && selectedNode.getUserObject() != null) {
                ((CoreBaseInfo)selectedNode.getUserObject()).setBoolean("isChildLoaded", true);
            }
            return selectedNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getChildNodes(OrgTreeInfo orgTreeInfo, OrgStructureInfo curNode, boolean isShowAllUnion) throws Exception {
            ArrayList<OrgStructureInfo> nodes = new ArrayList<OrgStructureInfo>();
            if (orgTreeInfo == null || orgTreeInfo.getId() == null) {
                return nodes;
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selectors = new SelectorItemCollection();
            if (isShowAllUnion) {
                selectors.add("isleaf");
                selectors.add("parent.id");
                selectors.add("id");
                selectors.add("unit.id");
                selectors.add("unit.number");
                selectors.add("unit.name");
                selectors.add("unit.isunion");
                selectors.add("level");
                selectors.add("longnumber");
                viewInfo.setSelector(selectors);
                FilterInfo filter = new FilterInfo();
                filter.appendFilterItem("tree.id", (Object)orgTreeInfo.getId().toString());
                filter.appendFilterItem("unit.isunion", (Object)1);
                if (curNode != null) {
                    filter.appendFilterItem("parent.id", (Object)curNode.getId().toString());
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("level", (Object)2, CompareType.LESS_EQUALS));
                }
                viewInfo.setFilter(filter);
                SorterItemCollection sorts = new SorterItemCollection();
                SorterItemInfo sorterItem = new SorterItemInfo("longNumber");
                sorterItem.setSortType(SortType.ASCEND);
                sorts.add(sorterItem);
                viewInfo.setSorter(sorts);
                OrgStructureInfo info = null;
                OrgStructureCollection coll = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(viewInfo);
                for (int i = 0; i < coll.size(); ++i) {
                    info = coll.get(i);
                    nodes.add(info);
                }
                return nodes;
            }
            FilterInfo orgFilter = this.getOrgFilter(orgTreeInfo);
            if (orgFilter == null) {
                return nodes;
            }
            viewInfo.setFilter(orgFilter);
            selectors.add("longNumber");
            selectors.add("unit.isunion");
            viewInfo.setSelector(selectors);
            OrgStructureCollection coll = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(viewInfo);
            HashMap longNumbers = new HashMap();
            try {
                OrgStructureInfo info = null;
                String curLongNumber = null;
                for (int i = 0; i < coll.size(); ++i) {
                    info = coll.get(i);
                    curLongNumber = info.getLongNumber();
                    longNumbers.put(curLongNumber, null);
                    if (!info.getUnit().isIsUnion()) continue;
                    while (curLongNumber.lastIndexOf("!") > 0) {
                        curLongNumber = curLongNumber.substring(0, curLongNumber.lastIndexOf("!"));
                        longNumbers.put(curLongNumber, null);
                    }
                }
                viewInfo = new EntityViewInfo();
                selectors = new SelectorItemCollection();
                selectors.add("isleaf");
                selectors.add("parent.id");
                selectors.add("id");
                selectors.add("unit.id");
                selectors.add("unit.number");
                selectors.add("unit.name");
                selectors.add("unit.isunion");
                selectors.add("level");
                selectors.add("longnumber");
                viewInfo.setSelector(selectors);
                FilterInfo filter = new FilterInfo();
                filter.appendFilterItem("tree.id", (Object)orgTreeInfo.getId().toString());
                if (curNode != null) {
                    filter.appendFilterItem("parent.id", (Object)curNode.getId().toString());
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("level", (Object)2, CompareType.LESS_EQUALS));
                }
                viewInfo.setFilter(filter);
                SorterItemCollection sorts = new SorterItemCollection();
                SorterItemInfo sorterItem = new SorterItemInfo("longNumber");
                sorterItem.setSortType(SortType.ASCEND);
                sorts.add(sorterItem);
                viewInfo.setSorter(sorts);
                coll = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(viewInfo);
                for (int i = 0; i < coll.size(); ++i) {
                    info = coll.get(i);
                    if (!longNumbers.containsKey(info.getLongNumber())) continue;
                    nodes.add(info);
                }
            }
            finally {
                longNumbers.clear();
            }
            return nodes;
        }

        public void setTreeChangeRemoveSeletedOrgs(boolean isTreeChangeRemoveSeletedOrgs) {
            this.isTreeChangeRemoveSeletedOrgs = isTreeChangeRemoveSeletedOrgs;
        }

        public OrgTreeInfo getSelectedOrgTree() {
            try {
                Field cbOrgTree = null;
                cbOrgTree = this.isTreeChangeRemoveSeletedOrgs ? this.f7ui.getClass().getSuperclass().getSuperclass().getDeclaredField("cbOrgTree") : this.f7ui.getClass().getSuperclass().getDeclaredField("cbOrgTree");
                NewRptUtil.makeAccessible((Field)cbOrgTree);
                KDComboBox cbOrgTreeCom = (KDComboBox)cbOrgTree.get(this.f7ui);
                if (cbOrgTreeCom != null) {
                    return (OrgTreeInfo)cbOrgTreeCom.getSelectedItem();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return null;
        }

        public void createF7UI() {
            if (this.isTreeChangeRemoveSeletedOrgs) {
                try {
                    if (this.uiOwner != null) {
                        this.owner = ComponentUtil.getOwnerWindow((Component)((Component)this.uiOwner));
                    }
                    if (this.owner == null) {
                        this.owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    }
                    UIContext uiContext = new UIContext((Object)this.owner);
                    uiContext.put((Object)"OrgF7Proxy", (Object)this);
                    uiContext.put((Object)"selectedOrgIds", (Object)this.getSelectedOrgIds());
                    uiContext.put((Object)"selectedOrgIdSQL", (Object)this.getSelectedOrgIdSQL());
                    uiContext.put((Object)"isSupportShowArchiveOrgTree", (Object)this.isSupportShowArchiveOrgTree);
                    uiContext.put((Object)"preOrgTreeInfo", (Object)this.preOrgTreeInfo);
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CslRptNewOrgF7UI.class.getName(), (Map)uiContext);
                    if (uiWindow instanceof KDDialog) {
                        ((KDDialog)uiWindow).setResizable(true);
                    }
                    this.f7ui = (NewOrgF7UI)uiWindow.getUIObject();
                    Field curTitleField = UnionF7.class.getSuperclass().getSuperclass().getSuperclass().getDeclaredField("title");
                    NewRptUtil.makeAccessible((Field)curTitleField);
                    String curTitle = (String)curTitleField.get((Object)this);
                    Field curInputStrField = UnionF7.class.getSuperclass().getSuperclass().getDeclaredField("inputStr");
                    NewRptUtil.makeAccessible((Field)curInputStrField);
                    String curInputStr = (String)curInputStrField.get((Object)this);
                    if (uiWindow instanceof Dialog) {
                        ((Dialog)uiWindow).setTitle(curTitle);
                    } else if (uiWindow instanceof Frame) {
                        ((Frame)uiWindow).setTitle(curTitle);
                    }
                    if (!StringUtils.isEmpty((String)curInputStr)) {
                        ((CslRptNewOrgF7UI)this.f7ui).getTxtFieldValue().setText(curInputStr);
                        ((CslRptNewOrgF7UI)this.f7ui).getChkContainSub().setSelected(true);
                        ((CslRptNewOrgF7UI)this.f7ui).btnQuickQuery_actionPerformed(null);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else if (this.preOrgTreeInfo == null || this.f7ui == null) {
                super.createF7UI();
            }
        }

        public Object getData() {
            Object data = super.getData();
            if (this.isQingAnalyze() && data != null && data instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] datas = (OrgUnitInfo[])data;
                ArrayList<OrgUnitInfo> list = new ArrayList<OrgUnitInfo>();
                int size = datas.length;
                for (int i = 0; i < size; ++i) {
                    list.add(datas[i]);
                }
                return list;
            }
            return data;
        }
    }
}

