/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.batch.INeedOrgTree;
import com.kingdee.eas.fi.rpt.batch.OrgTreeQueryWrapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractCalculator {
    protected Context serverContext;
    protected BatchHelper batchHelper;
    protected ICalculateContextProvider calCulateContext;
    protected List formulaCalculatorList;
    protected List errorList;

    public AbstractCalculator(ICalculateContextProvider context, Context serverCtx) {
        this.serverContext = serverCtx;
        this.batchHelper = new BatchHelper(context, serverCtx);
        this.calCulateContext = context;
        this.formulaCalculatorList = new LinkedList();
        this.errorList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SortedParameterArray params) {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            this.init(params);
            long time = System.currentTimeMillis() - currentTimeMillis;
            System.out.println("\ninit used time:" + time + "\n");
            this.preCalculate();
            this.calculate();
            this.handleAllException();
        }
        catch (Exception e) {
            this.handleException(this.formulaCalculatorList, e);
            e.printStackTrace();
            this.handleAllException();
        }
        finally {
            this.clear();
        }
    }

    protected abstract void clear();

    protected void preCalculate() throws BOSException, EASBizException {
        if (this.formulaCalculatorList.size() == 0) {
            return;
        }
        this.initOrgTree();
    }

    private void initOrgTree() throws BOSException {
        if (this.formulaCalculatorList.get(0) instanceof INeedOrgTree) {
            LinkedHashSet<OrgTreeQueryWrapper> querySet = new LinkedHashSet<OrgTreeQueryWrapper>();
            for (INeedOrgTree formula : this.formulaCalculatorList) {
                OrgTreeQueryWrapper wrapper = new OrgTreeQueryWrapper();
                wrapper.setOrgTreeNumber(formula.getOrgTreeNumber());
                wrapper.setQueryStartDate(formula.getStartDate());
                wrapper.setQueryEndDate(formula.getEndDate());
                querySet.add(wrapper);
            }
            Map number2OrgTreeCollection = this.batchHelper.getOrgTreeCollectionByNumberAndDate(querySet);
            LinkedHashSet<String> orgTreeIDSet = new LinkedHashSet<String>();
            for (INeedOrgTree formula : this.formulaCalculatorList) {
                OrgTreeCollection treeCollection = (OrgTreeCollection)number2OrgTreeCollection.get(formula.getOrgTreeNumber());
                formula.setOrgTreeIDSet(orgTreeIDSet);
                if (treeCollection == null) continue;
                for (OrgTreeInfo orgTreeInfo : treeCollection) {
                    if (orgTreeInfo.getStartDate().compareTo(new Timestamp(formula.getStartDate().getTime())) > 0 || orgTreeInfo.getEndDate().compareTo(new Timestamp(formula.getEndDate().getTime())) < 0) continue;
                    orgTreeIDSet.add(orgTreeInfo.getId().toString());
                }
            }
        }
    }

    protected abstract void calculate() throws BOSException, EASBizException;

    protected abstract void init(SortedParameterArray var1) throws BOSException, EASBizException;

    protected void handleException(List list, Exception e) {
        for (AbstractFormulaCalculatorParameter formula : list) {
            formula.setException(e);
        }
    }

    protected void handleAllException() {
        FormulaValueBackfill err;
        for (AbstractFormulaCalculatorParameter formula : this.formulaCalculatorList) {
            if (formula.isException()) {
                err = new FormulaValueBackfill(formula.getParameter());
                err.setException((Throwable)formula.getException());
                continue;
            }
            if (formula.getParameter().getValue() != null) continue;
            formula.getParameter().setValue((Object)CslConstant.BGZERO);
        }
        for (AbstractFormulaCalculatorParameter formula : this.errorList) {
            if (!formula.isException()) continue;
            err = new FormulaValueBackfill(formula.getParameter());
            err.setException((Throwable)formula.getException());
        }
    }

    public void addToErrorList(AbstractFormulaCalculatorParameter formula) {
        this.errorList.add(formula);
    }

    public void addToErrorList(AbstractFormulaCalculatorParameter formula, Exception e) {
        formula.setException(e);
        this.errorList.add(formula);
    }

    public Context getServerContext() {
        return this.serverContext;
    }

    public BatchHelper getBatchHelper() {
        return this.batchHelper;
    }

    public ICalculateContextProvider getCalCulateContext() {
        return this.calCulateContext;
    }

    public List getFormulaCalculatorParameterList() {
        return this.formulaCalculatorList;
    }
}

