/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import java.math.BigDecimal;
import java.util.Set;

public abstract class AbstractFormulaCalculatorParameter
implements IFormulaCalculator {
    private Parameter param;
    private Exception e;
    private boolean isException;
    private Set nullFields;

    public AbstractFormulaCalculatorParameter(Parameter param) {
        this.param = param;
        try {
            this.initParam();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    public AbstractFormulaCalculatorParameter() {
    }

    private void initParam() throws BOSException, EASBizException {
        this.initArgs();
        this.verifyArgs();
    }

    public void combineNumberValue(Object value) {
        this.combineValue(value, true);
    }

    public void combineValue(Object value, boolean isNumberValue) {
        if (value instanceof Exception) {
            this.setException((Exception)value);
            return;
        }
        Parameter parameter = this.getParameter();
        if (isNumberValue) {
            Object old = parameter.getValue();
            if (old == null || "".equals(old.toString().trim())) {
                try {
                    BigDecimal newValue = new BigDecimal(value.toString());
                    parameter.setValue((Object)newValue);
                }
                catch (Exception e) {
                    parameter.setValue(value);
                }
            } else if (value instanceof String || value instanceof BigDecimal) {
                BigDecimal oldValue = null;
                try {
                    oldValue = new BigDecimal(old.toString());
                }
                catch (RuntimeException e1) {
                    old = CslConstant.BGZERO;
                    oldValue = new BigDecimal(old.toString());
                }
                try {
                    BigDecimal newValue = new BigDecimal(value.toString());
                    parameter.setValue((Object)oldValue.add(newValue));
                }
                catch (RuntimeException e) {
                    parameter.setValue(value);
                }
            }
        } else {
            parameter.setValue(value);
        }
    }

    protected abstract void verifyArgs() throws BOSException, EASBizException;

    protected abstract void initArgs() throws BOSException, EASBizException;

    @Override
    public Parameter getParameter() {
        return this.param;
    }

    @Override
    public String getSheetName() {
        return this.param.getSheetName();
    }

    public void setException(Exception e) {
        if (!this.isException) {
            this.e = e;
            this.isException = true;
        }
    }

    @Override
    public boolean isException() {
        if (this.isException) {
            return this.isException;
        }
        if (this.param.getValue() != null && this.param.getValue() instanceof Exception) {
            this.isException = true;
            this.e = (Exception)this.param.getValue();
            return true;
        }
        return false;
    }

    @Override
    public Exception getException() {
        return this.e;
    }

    public Set getNullFields() {
        return this.nullFields;
    }

    public void addNullFields(String field) {
        if (this.nullFields != null) {
            this.nullFields.add(field);
        }
    }

    private int getObjectArrayhashCode(Object[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
        }
        return result;
    }

    private int getParamHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getObjectArrayhashCode(this.param.getArgs());
        result = 31 * result + (this.param.getSheetName() == null ? 0 : this.param.getSheetName().hashCode());
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.e == null ? 0 : this.e.hashCode());
        result = 31 * result + (this.nullFields == null ? 0 : this.nullFields.hashCode());
        result = 31 * result + (this.param == null ? 0 : this.getParamHashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFormulaCalculatorParameter other = (AbstractFormulaCalculatorParameter)obj;
        if (this.nullFields == null ? other.nullFields != null : !this.nullFields.equals(other.nullFields)) {
            return false;
        }
        return !(this.param == null ? other.param != null : this.param.compareTo((Object)other.param) != 0);
    }

    public void setParameter(Parameter param) {
        this.param = param;
    }

    public void setNullFields(Set nullFields) {
        this.nullFields = nullFields;
    }
}

