/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeCollection;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.AcctStruct;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.app.AcctBatchQueryServiceNew;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.AcctChangeAccountAsstActType;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.AcctExecuteAsstAccountChanged;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantityCalculator;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.CachingMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.ma.pca.IPcaPeriodEndFacade;
import com.kingdee.eas.ma.pca.PcaPeriodEndFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class AcctBatchCalculaterNew {
    private static final String RPT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fi.rpt.RPTAutoGenerateResource";
    private static final int PERFORMANCE_ACCTWHEREVARIABLESIZE = 100;
    private static final int PERFORMANCE_ACCTBATCHSIZE = 18000;
    private static final int EXPAND_WILDCAR_SIZE = 100;
    private static final String PERFORMANCE_ACCT_EXPAND_WILDCAR_SIZE = "KEY_CSLPARAM_PERFORMANCE_ACCT_EXPAND_WILDCAR_SIZE";
    private static final String SUPPORT_VIRORG_MULTIUNPOSTED = "SUPPORT_VIRORG_MULTIUNPOSTED";
    private static final String GROUP_BY_ACCOUNT = "GroupByAccount";
    private static final String USE_ACCT_OLD = "USE_ACCT_OLD";
    private static final String USE_TEMP_TABLE_SCHEME = "USE_TEMP_TABLE_SCHEME";
    private static final String USE_TEMP_TABLE_SCHEME_DEBUG = "USE_TEMP_TABLE_SCHEME_DEBUG";
    private static Logger logger = Logger.getLogger(AcctBatchCalculaterNew.class);
    private List formulas;
    private List formulasNeedChangedAct;
    private List expandWildcarList;
    private AcctBatchQueryServiceNew batchQueryService;
    private VouchQuantityCalculator vouchQuantityCalculator;
    private Context ctx;
    private boolean checkPermission = true;
    Map accountTableCache = new CachingMap();
    Map accountTableIdCache = new CachingMap();
    Map accountCache = new CachingMap();
    Map permissionOrgs = null;
    Map companyCache = new CachingMap();
    Map currencyCache = new CachingMap();
    Map itemCache = new CachingMap();
    private boolean isGroupByAccount;
    private int whereSize;
    private int expandWildcarSize;
    public boolean isUseNewBatchLogic;
    private boolean isSupportVirtualOrgMultiUnPosted;
    private boolean isUseTempTableScheme;
    private boolean isTempTableSchemeDebug;
    private boolean isExeWildcardExpand = true;
    private boolean isCalSaperateByAccountLevel = false;
    private OrgType currentOrgType;
    private ICalculateContextProvider calcCtx;
    private boolean isProfitCenter = false;
    Map<String, IObjectCollection> company_AccountRef = new HashMap<String, IObjectCollection>();
    private boolean isAccountRefNull = false;

    private static void initUserPermissionOrgs(Context ctx, Map UserPermissionOrgsCache, ICalculateContextProvider context) throws BOSException {
        FullOrgUnitCollection fullOrgs = null;
        FullOrgUnitCollection profitCenterOrgs = null;
        try {
            if (context != null) {
                boolean checkPermission = true;
                ReportVariables rvs = context.getReportVariables();
                if (rvs != null) {
                    VariableEntry v = rvs.get("Check_Permissioin", null);
                    if (v != null) {
                        try {
                            checkPermission = Boolean.valueOf(v.getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!checkPermission) {
                        return;
                    }
                }
            }
            String userId = ctx.getCaller().toString();
            IPermission permissionDao = PermissionFactory.getLocalInstance((Context)ctx);
            fullOrgs = permissionDao.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.Company, null, "rpt_report_calculate");
            profitCenterOrgs = permissionDao.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.ProfitCenter, null, "prof_rpt_update");
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (fullOrgs != null && !fullOrgs.isEmpty()) {
            int n = fullOrgs.size();
            for (int i = 0; i < n; ++i) {
                UserPermissionOrgsCache.put(AcctBatchCalculaterNew.buildPermssionKey(OrgType.Company, fullOrgs.get(i).getNumber().toUpperCase()), new FunctionPermission(fullOrgs.get(i).getId()));
            }
        }
        if (profitCenterOrgs != null && !profitCenterOrgs.isEmpty()) {
            int n = profitCenterOrgs.size();
            for (int i = 0; i < n; ++i) {
                UserPermissionOrgsCache.put(AcctBatchCalculaterNew.buildPermssionKey(OrgType.ProfitCenter, profitCenterOrgs.get(i).getNumber().toUpperCase()), new FunctionPermission(profitCenterOrgs.get(i).getId()));
            }
        }
    }

    protected static String buildPermssionKey(OrgType orgType, String companyNumber) {
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return OrgType.ProfitCenter + "|" + companyNumber;
        }
        return companyNumber;
    }

    private Map getUserPermissionOrgs(ICalculateContextProvider context) throws BOSException {
        if (this.permissionOrgs == null) {
            this.permissionOrgs = new HashMap();
            AcctBatchCalculaterNew.initUserPermissionOrgs(this.ctx, this.permissionOrgs, context);
        }
        return this.permissionOrgs;
    }

    private boolean expandWildcar(AcctCalculaterExt acctExt) {
        AcctStruct acctStruct = acctExt.getStruct();
        boolean groupWildcar = false;
        if (acctExt.getAccountItem() == null || acctExt.getAccountItem().getAccountAsstItem() == null) {
            return false;
        }
        AcctountAsstItemParser.AccountAsstItem accountAsstItem = acctExt.getAccountItem().getAccountAsstItem();
        if (accountAsstItem.asstItems != null) {
            for (int i = 0; i < accountAsstItem.asstItems.length; ++i) {
                AcctountAsstItemParser.AsstItem asstItem = accountAsstItem.asstItems[i];
                if (asstItem.group == null || asstItem.group.length == 0 || !asstItem.toString().matches(".*[^#]\\*.*")) continue;
                acctExt.setACCTValue((Object)new ReportException(ReportException.ACCT_ASST_GROUP_NO_SUPPORT_WILDCAR));
                groupWildcar = true;
                break;
            }
        }
        if (groupWildcar) {
            return true;
        }
        if (acctStruct.getAccountItem().matches(".*[^#]\\*.*")) {
            acctExt.setAcctBatchQueryService(this.batchQueryService);
            this.submitRequireCompanyInfoBatchQueryService(acctExt);
            this.submitRequireCurrencyInfoBatchQueryService(acctExt);
            this.submitAccountTableQuery(acctExt);
            this.expandWildcarList.add(acctExt);
            return true;
        }
        return false;
    }

    private AccountTableInfo getAccountTableFromCache(AcctCalculaterExt acctExt) throws EASBizException, BOSException {
        String accountTableNum = acctExt.getStruct().getAccountTable();
        if (StringUtils.isEmpty((String)accountTableNum)) {
            accountTableNum = acctExt.getCompany().getAccountTable().getNumber();
        }
        String companyNum = acctExt.getCompany().getNumber();
        String cacheKey = accountTableNum + "|" + companyNum + "|" + acctExt.getStruct().getEndYear() + "|" + acctExt.getStruct().getEndPeriod();
        AccountTableInfo accountTable = (AccountTableInfo)this.accountTableCache.get(cacheKey);
        if (accountTable == null) {
            accountTable = new AccountTableInfo();
            accountTable.setId(BOSUuid.read((String)acctExt.getCompany().getAccountTable().getId().toString()));
            accountTable.setSeparator(acctExt.getCompany().getAccountTable().getSeparator());
            this.accountTableCache.put(cacheKey, accountTable);
        }
        return accountTable;
    }

    private String getAccountTableIDFromCache(AcctCalculaterExt acctExt, int year, int period) throws EASBizException, BOSException {
        if (acctExt.getAccountTable() == null) {
            return null;
        }
        String cuid = acctExt.getCompany().getId().toString();
        String tableid = acctExt.getAccountTable().getId().toString();
        String key = cuid + "|" + tableid + "|" + year + "|" + period;
        String currentAcctTable = (String)this.accountTableIdCache.get(key);
        if (currentAcctTable == null) {
            currentAcctTable = this.getCurrentAcctTable(this.batchQueryService.getServerContext(), cuid, tableid, year, period);
            if (StringUtils.isEmpty((String)currentAcctTable)) {
                this.accountTableIdCache.put(key, "");
            } else {
                this.accountTableIdCache.put(key, currentAcctTable);
            }
        }
        return StringUtils.isEmpty((String)currentAcctTable) ? null : currentAcctTable;
    }

    public AcctBatchCalculaterNew(Context ctx) {
        this.formulas = new LinkedList();
        this.expandWildcarList = new LinkedList();
        this.batchQueryService = new AcctBatchQueryServiceNew(ctx, this);
        this.vouchQuantityCalculator = new VouchQuantityCalculator(ctx);
        this.ctx = ctx;
    }

    public List getFormulas() {
        return this.formulas;
    }

    public void init() throws SQLException {
        this.batchQueryService.initResource();
    }

    public void initPermission(ICalculateContextProvider context) {
        ReportVariables rvs = context.getReportVariables();
        if (rvs == null) {
            return;
        }
        VariableEntry v = rvs.get("Check_Permissioin", null);
        if (v == null) {
            return;
        }
        try {
            this.checkPermission = Boolean.valueOf(v.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Boolean isCalSaperateByAccountLevel(ICalculateContextProvider context) {
        ReportVariables rvs = context.getReportVariables();
        String sheetName = (String)context.getReportAdapter().getReportProperty("curCalcSheetName");
        if (rvs != null) {
            try {
                VariableEntry v = null;
                if (sheetName != null) {
                    v = rvs.get("isCalSaperateByAccountLevel", sheetName);
                }
                if (v == null) {
                    v = rvs.get("isCalSaperateByAccountLevel", null);
                }
                if (v != null) {
                    return Boolean.valueOf(v.getValue());
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    private static Boolean isUseTempTableScheme(ICalculateContextProvider context) {
        ReportVariables rvs = context.getReportVariables();
        String sheetName = (String)context.getReportAdapter().getReportProperty("curCalcSheetName");
        if (rvs != null) {
            try {
                VariableEntry v = null;
                if (sheetName != null) {
                    v = rvs.get(USE_TEMP_TABLE_SCHEME, sheetName);
                }
                if (v == null) {
                    v = rvs.get(USE_TEMP_TABLE_SCHEME, null);
                }
                if (v != null) {
                    return Boolean.valueOf(v.getValue());
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isWildcardExpand(ICalculateContextProvider context) {
        ReportVariables rvs = context.getReportVariables();
        if (rvs == null) {
            return true;
        }
        VariableEntry v = rvs.get("WILDCARD_EXPAND", null);
        if (v == null) {
            return true;
        }
        boolean wildcardExpand = true;
        try {
            wildcardExpand = Boolean.valueOf(v.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wildcardExpand;
    }

    public void clearUp() throws SQLException {
        this.batchQueryService.clearnupResource();
    }

    public void addFormula(AcctCalculaterExt acctformula) {
        this.vouchQuantityCalculator = new VouchQuantityCalculator(acctformula.getContext());
        acctformula.setAcctBatchQueryService(this.batchQueryService);
        this.submitRequireCompanyInfoBatchQueryService(acctformula);
        this.submitRequireCurrencyInfoBatchQueryService(acctformula);
        this.submitAccountTableQuery(acctformula);
        this.isProfitCenter = acctformula.isProfitCenter();
        this.formulas.add(acctformula);
    }

    public int addFormula(AcctStruct acct) throws Exception {
        int breakDownAcctSize = 0;
        acct.check();
        StringTokenizer stoken = new StringTokenizer(acct.getFiOrgUnitNum(), "\\||\\,|\\;");
        ArrayList<String> companyList = new ArrayList<String>();
        while (stoken.hasMoreElements()) {
            String trim = stoken.nextElement().toString().trim();
            companyList.add(trim);
        }
        if (acct.isInitRacct() && companyList.size() > 1) {
            throw new ReportException(ReportException.RACCT_NOT_SUPPORT_MUTI_ORG);
        }
        return breakDownAcctSize += this.expandDiscreteAccount(acct, companyList);
    }

    private int expandFormulaCompany(AcctStruct acct, String[] companyNumbers) {
        int expandFormulaSize = 0;
        if (companyNumbers.length > 1) {
            for (int k = 0; k < companyNumbers.length; ++k) {
                AcctStruct dummyAcct = acct.copy();
                dummyAcct.setFiOrgUnitNum(companyNumbers[k]);
                expandFormulaSize += this.addAcctCalculaterExtFormula(dummyAcct);
            }
        } else {
            expandFormulaSize += this.addAcctCalculaterExtFormula(acct);
        }
        return expandFormulaSize;
    }

    private int expandDiscreteAccount(AcctStruct acct, List companyList) throws Exception {
        int expandFormulaSize = 0;
        AcctountAsstItemParser.AccountAsstItem item = AcctountAsstItemParser.parse(acct.getAccountItem());
        AcctountAsstItemParser.Range[] accounts = item.accounts;
        String[] companyNumbers = companyList.toArray(new String[companyList.size()]);
        if (accounts.length > 1) {
            for (int x = 0; x < accounts.length; ++x) {
                item.startNumber = accounts[x].startNumber;
                item.endNumber = accounts[x].endNumber;
                AcctStruct dummyAcct = acct.copy();
                dummyAcct.setAccountItem(item.toOldString());
                expandFormulaSize += this.expandFormulaCompany(dummyAcct, companyNumbers);
            }
        } else {
            expandFormulaSize += this.expandFormulaCompany(acct, companyNumbers);
        }
        return expandFormulaSize;
    }

    private int addAcctCalculaterExtFormula(AcctStruct acctStruct) {
        int expandFormulaSize = 0;
        AcctCalculaterExt acctExt = new AcctCalculaterExt(acctStruct, acctStruct.getBackFiller());
        if (acctExt.isException()) {
            return expandFormulaSize;
        }
        acctExt.setGroupByAccount(this.isGroupByAccount());
        if (!this.expandWildcar(acctExt)) {
            this.addFormula(acctExt);
            ++expandFormulaSize;
        } else if (this.expandWildcarList.size() >= this.expandWildcarSize) {
            expandFormulaSize += this.executeAccountWildcarQuery();
        }
        return expandFormulaSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeAccountWildcarQuery() {
        int expandFormulaSize = 0;
        try {
            this.submitAccountWildcarQuery(this.expandWildcarList);
            expandFormulaSize += this.batchQueryService.executeAccountWildcarQuery();
        }
        catch (Exception ex) {
            for (AcctCalculaterExt acctEx1 : this.expandWildcarList) {
                acctEx1.setACCTValue((Object)ex);
            }
        }
        finally {
            this.expandWildcarList.clear();
        }
        return expandFormulaSize;
    }

    private void submitAccountTableQuery(AcctCalculaterExt acct) {
        if (!StringUtils.isEmpty((String)acct.getStruct().getAccountTable())) {
            String accountTableNum = acct.getStruct().getAccountTable();
            String companyNum = null;
            companyNum = acct.getCompany() != null ? acct.getCompany().getNumber() : acct.getStruct().getCompanyNumber();
            String cacheKey = accountTableNum + "|" + companyNum + "|" + acct.getStruct().getEndYear() + "|" + acct.getStruct().getEndPeriod();
            if (this.accountTableCache.containsKey(cacheKey)) {
                AccountTableInfo accountTableInfo = (AccountTableInfo)this.accountTableCache.get(cacheKey);
                acct.setAccountTable(accountTableInfo);
            } else {
                this.batchQueryService.submitAccountTableQuery(acct);
            }
        }
    }

    private void submitRequireCurrencyInfoBatchQueryService(AcctCalculaterExt acctExt) {
        String cacheKey = null;
        String currencyNumber = acctExt.getStruct().getCurrencyNumber();
        cacheKey = acctExt.getCompany() != null && (currencyNumber.equalsIgnoreCase("GLC") || currencyNumber.equalsIgnoreCase("GRC")) ? acctExt.getCompany().getNumber() + "|" + currencyNumber.toUpperCase() : currencyNumber.toUpperCase();
        CurrencyInfo currency = (CurrencyInfo)this.currencyCache.get(cacheKey);
        if (currency != null) {
            acctExt.setCurrency(currency);
        } else {
            acctExt.submitRequireCurrencyInfoBatchQueryService();
        }
    }

    private void submitRequireCompanyInfoBatchQueryService(AcctCalculaterExt acctExt) {
        if (acctExt.getCompany() == null) {
            String cacheKey = acctExt.getStruct().getFiOrgUnitNum() + "|" + acctExt.getStruct().getEndYear() + "|" + acctExt.getStruct().getEndPeriod();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.companyCache.get(cacheKey);
            if (company != null) {
                acctExt.setCompany(company);
            } else {
                acctExt.submitRequireCompanyInfoBatchQueryService();
            }
        }
    }

    private void execTailAccountQuery() throws Exception {
        for (AcctCalculaterExt tempAcct : this.formulas) {
            if (tempAcct.isException()) continue;
            if (tempAcct.getAccountItem().startAccount.account == null) {
                String startCacheKey = "tail" + tempAcct.getCompany().getId().toString() + tempAcct.getAccountTable().getId().toString() + tempAcct.getAccountItem().startAccount.getAccountNumber();
                if (this.accountCache.containsKey(startCacheKey)) {
                    tempAcct.getAccountItem().startAccount.account = (Account)this.accountCache.get(startCacheKey);
                } else {
                    this.batchQueryService.submitTailRequireBatchFitchAccountInfoService(tempAcct.getAccountItem().startAccount);
                }
            }
            if (tempAcct.getAccountItem().endAccount.account != null) continue;
            String endCacheKey = "tail" + tempAcct.getCompany().getId().toString() + tempAcct.getAccountTable().getId().toString() + tempAcct.getAccountItem().endAccount.getAccountNumber();
            if (this.accountCache.containsKey(endCacheKey)) {
                tempAcct.getAccountItem().endAccount.account = (Account)this.accountCache.get(endCacheKey);
                continue;
            }
            this.batchQueryService.submitTailRequireBatchFitchAccountInfoService(tempAcct.getAccountItem().endAccount);
        }
        this.batchQueryService.execTailAccountQuery();
    }

    private void submitRequireBatchFitchItemInfoService(AssistantItemExt item) {
        if (this.itemCache.containsKey(item.getItemTypeNumber())) {
            item.itemType = (AsstActType)this.itemCache.get(item.getItemTypeNumber());
        } else {
            this.batchQueryService.submitRequireBatchFitchItemInfoService(item);
        }
    }

    public static void execute(Context ServerCtx, ICalculateContextProvider context, SortedParameterArray params) {
        AcctBatchCalculaterNew.execute(ServerCtx, context, params, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Context ServerCtx, ICalculateContextProvider context, SortedParameterArray params, boolean isRacct) {
        Object companyId;
        long tmpStartTime = System.currentTimeMillis();
        CachingMap CompanyCache = new CachingMap(true);
        CachingMap CurrencyCache = new CachingMap(true);
        CachingMap accountTableCache = new CachingMap(true);
        CachingMap accountTableIdCache = new CachingMap(true);
        CachingMap accountCache = new CachingMap(true);
        CachingMap currentPeriodCache = new CachingMap();
        CachingMap prePeriodCache = new CachingMap();
        CachingMap nextPeriodCache = new CachingMap();
        CachingMap userPermissionOrgs = new CachingMap();
        CachingMap itemCache = new CachingMap();
        boolean isUseOldBatchLogic = false;
        boolean isSupportVirtualOrgMultiUnPosted = false;
        boolean isGroupByAccount = false;
        boolean isUseTempTableScheme = false;
        boolean isTempTableSchemeDebug = false;
        boolean isCalSaperateByAccountLevel = false;
        int batchSize = 18000;
        int expandWildcarSize = 100;
        int whereSize = 100;
        int calculatorSize = 0;
        try {
            Map paramsMap = RptUtil.getCslParams(ServerCtx, new String[]{"KEY_CSLPARAM_PERFORMANCE_ACCT_WHERE_VARIABLE_SIZE", "KEY_CSLPARAM_PERFORMANCE_ACCT_BATCH_SIZE", USE_ACCT_OLD, PERFORMANCE_ACCT_EXPAND_WILDCAR_SIZE, GROUP_BY_ACCOUNT, SUPPORT_VIRORG_MULTIUNPOSTED, USE_TEMP_TABLE_SCHEME, USE_TEMP_TABLE_SCHEME_DEBUG});
            isGroupByAccount = RptUtil.isTrue(paramsMap.get(GROUP_BY_ACCOUNT));
            isSupportVirtualOrgMultiUnPosted = RptUtil.isTrue(paramsMap.get(SUPPORT_VIRORG_MULTIUNPOSTED));
            isUseTempTableScheme = RptUtil.isTrue(paramsMap.get(USE_TEMP_TABLE_SCHEME));
            isTempTableSchemeDebug = RptUtil.isTrue(paramsMap.get(USE_TEMP_TABLE_SCHEME_DEBUG));
            if (paramsMap.get("KEY_CSLPARAM_PERFORMANCE_ACCT_BATCH_SIZE") != null) {
                batchSize = Integer.parseInt(paramsMap.get("KEY_CSLPARAM_PERFORMANCE_ACCT_BATCH_SIZE").toString());
            }
            if (paramsMap.get("KEY_CSLPARAM_PERFORMANCE_ACCT_WHERE_VARIABLE_SIZE") != null) {
                whereSize = Integer.parseInt(paramsMap.get("KEY_CSLPARAM_PERFORMANCE_ACCT_WHERE_VARIABLE_SIZE").toString());
            }
            if (paramsMap.get(PERFORMANCE_ACCT_EXPAND_WILDCAR_SIZE) != null) {
                expandWildcarSize = Integer.parseInt(paramsMap.get(PERFORMANCE_ACCT_EXPAND_WILDCAR_SIZE).toString());
            }
            AcctBatchCalculaterNew.initUserPermissionOrgs(ServerCtx, userPermissionOrgs, context);
        }
        catch (Exception ex) {
            AcctBatchCalculaterNew.setError(params, ex);
            logger.error((Object)"", (Throwable)ex);
            return;
        }
        boolean isMergeByFiscalPeriod = CSLParamUtil.isMergeByFiscalPeriod((Context)ServerCtx);
        PeriodCollection periods = null;
        Object orgType = context.getReportAdapter().getReportProperty("orgType");
        if (orgType == null) {
            isMergeByFiscalPeriod = false;
        } else if (context != null && (companyId = context.getReportAdapter().getReportProperty("Company.ID")) != null) {
            try {
                String fiOrgId = companyId.toString();
                if (OrgType.ProfitCenter.equals(context.getReportAdapter().getReportProperty("orgType"))) {
                    CompanyOrgUnitInfo fiOrg = MultOrgUnitHelper.getInstance().getDelegateCompany(OrgType.ProfitCenter, companyId.toString(), ServerCtx);
                    fiOrgId = fiOrg.getId().toString();
                }
                periods = FiscalPeriodHelper.getPeriodCollection((Context)ServerCtx, (String)fiOrgId.toString());
            }
            catch (Exception e) {
                periods = null;
            }
        }
        OrgType orgTypeInContext = null;
        try {
            orgTypeInContext = orgType instanceof OrgType ? (OrgType)orgType : OrgType.Company;
        }
        catch (Exception ex) {
            AcctBatchCalculaterNew.setError(params, ex);
            logger.error((Object)ex);
            orgTypeInContext = OrgType.Company;
        }
        BatchHelper batchHelper = new BatchHelper(context, ServerCtx);
        int count = 0;
        while (count < params.size()) {
            AcctBatchCalculaterNew batcher = new AcctBatchCalculaterNew(ServerCtx);
            batcher.setPermissionOrgs(userPermissionOrgs);
            batcher.setCompanyCache(CompanyCache);
            batcher.setCurrencyCache(CurrencyCache);
            batcher.setAccountTableIdCache(accountTableIdCache);
            batcher.setAccountTableCache(accountTableCache);
            batcher.setAccountCache(accountCache);
            batcher.setPeriodCache(currentPeriodCache);
            batcher.setPrePeriodCaChe(prePeriodCache);
            batcher.setNextPeriodCache(nextPeriodCache);
            batcher.setItemCache(itemCache);
            batcher.setUseNewBatchLogic(!isUseOldBatchLogic);
            batcher.setGroupByAccount(isGroupByAccount);
            batcher.setSupportVirtualOrgMultiUnPosted(isSupportVirtualOrgMultiUnPosted);
            Boolean sheetParamIsUseTempTableScheme = AcctBatchCalculaterNew.isUseTempTableScheme(context);
            batcher.setUseTempTableScheme(sheetParamIsUseTempTableScheme != null ? sheetParamIsUseTempTableScheme : isUseTempTableScheme);
            batcher.setTempTableSchemeDebug(isTempTableSchemeDebug);
            Boolean sheetParamIsCalSaperateByAccountLevel = AcctBatchCalculaterNew.isCalSaperateByAccountLevel(context);
            batcher.setCalSaperateByAccountLevel(sheetParamIsCalSaperateByAccountLevel != null ? sheetParamIsCalSaperateByAccountLevel : isCalSaperateByAccountLevel);
            batcher.setWhereSize(whereSize);
            batcher.setExpandWildcarSize(expandWildcarSize);
            try {
                batcher.init();
                batcher.initPermission(context);
                batcher.setCalcCtx(context);
            }
            catch (SQLException e1) {
                AcctBatchCalculaterNew.setError(params, e1);
                logger.error((Object)"", (Throwable)e1);
                try {
                    batcher.clearUp();
                }
                catch (SQLException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                return;
            }
            int batchEnd = count + batchSize;
            int real_batch_size = 0;
            logger.error((Object)("[acct profit]batch run param:real_batch_size is " + real_batch_size + ",batchSize is " + batchSize));
            while (count < batchEnd && real_batch_size < batchSize && count < params.size()) {
                block26: {
                    Parameter param = params.getParameter(count);
                    String sheetName = param.getSheetName();
                    AcctStruct acct = null;
                    try {
                        acct = AcctStruct.getInstance(param.getArgs(), isRacct);
                        if (acct.isUseRptOrgType()) {
                            acct.setOrgType(orgTypeInContext);
                        }
                        acct.setFiscalPeriods(periods);
                        acct.setMergeByFiscalPeriod(isMergeByFiscalPeriod);
                        acct.setServerCtx(ServerCtx);
                        acct.reviseParameters(sheetName, context.getReportVariables(), context.getReportAdapter());
                        acct.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                        if (!(batcher.expandWildcarList.isEmpty() || (real_batch_size += batcher.addFormula(acct)) < batchSize && count != params.size() - 1 && count != batchEnd - 1)) {
                            real_batch_size += batcher.executeAccountWildcarQuery();
                        }
                    }
                    catch (Exception e) {
                        IErrorProvider errorProvider = context.getErrorProvider();
                        if (errorProvider != null) {
                            param.setValue(errorProvider.getProperValue(e).getValue());
                            break block26;
                        }
                        param.setValue((Object)("#BAD FUNCTION " + e.getMessage()));
                    }
                }
                ++count;
            }
            logger.info((Object)("acct batch size:" + real_batch_size));
            calculatorSize += real_batch_size;
            batcher.execute();
        }
        logger.info((Object)("total calculator Size:" + calculatorSize));
        logger.info((Object)("total calculator Time:" + (System.currentTimeMillis() - tmpStartTime) + " ms"));
    }

    private void setCalcCtx(ICalculateContextProvider calcCtx) {
        this.calcCtx = calcCtx;
    }

    public ICalculateContextProvider getCalcCtx() {
        return this.calcCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.batchQueryService.setUseNewBatchLogic(this.isUseNewBatchLogic);
            this.batchQueryService.setSupportVirtualOrgMultiUnPosted(this.isSupportVirtualOrgMultiUnPosted);
            this.batchQueryService.excBatchCompanyInfoService();
            this.batchQueryService.executeAccountTableQuery();
            Set companyIdSet = this.checkFormulaCompanyInfo(this.formulas);
            this.batchQueryService.excBatchCurrencyInfoService();
            this.submitRequireAccountAndItemInfoBatchQueryService(this.formulas);
            this.batchQueryService.excBatchAccountAndItemInfoService();
            this.execTailAccountQuery();
            this.seperateFormulaByAccountLevel(this.formulas);
            this.submitRequireItemInfoByAccount(this.formulas);
            this.batchQueryService.executeItemQueryByAccount();
            this.batchQueryService.fixVirtualCompanyLeafAccount(this.formulas);
            this.executeAsstAccountChangeForSubAccount(this.formulas);
            this.submitRequireBatchFitchItemInfoService(this.formulas);
            this.batchQueryService.excBatchItemInfoService();
            this.submitDetailAsstActTypeAndAssistantStandard(this.formulas);
            this.batchQueryService.execAssistantStandard();
            this.submitRequireAssistantItem(this.formulas);
            this.batchQueryService.execAssistantItemQuery();
            this.checkAssistantGroup(this.formulas);
            this.batchQueryService.excBatchPeriodIDService();
            this.batchQueryService.executeDetailAsstActTypeQuery();
            Iterator itn = this.formulas.iterator();
            while (itn.hasNext()) {
                this.batchQueryService.submitRequireBatchFitchReportDataService((AcctCalculaterExt)itn.next());
            }
            if (companyIdSet.size() > 0) {
                DebugLogger.info(logger, "submitVoucherBatch");
                DebugLogger.info(logger, "companyId", companyIdSet.toArray());
                if (this.isProfitCenter || this.getCalcCtx() != null && OrgType.ProfitCenter.equals(this.getCalcCtx().getReportAdapter().getReportProperty("orgType"))) {
                    this.submitProfitVoucherBatch(companyIdSet.toArray(new String[companyIdSet.size()]));
                } else {
                    this.submitVoucherBatch(companyIdSet.toArray(new String[companyIdSet.size()]));
                }
            }
            this.batchQueryService.excBatchReportDataService();
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            for (int i = 0; i < this.formulas.size(); ++i) {
                AcctCalculaterExt acct = (AcctCalculaterExt)this.formulas.get(i);
                acct.setACCTValue((Object)ex);
            }
        }
        finally {
            try {
                this.setNullToZero();
                this.clearUp();
            }
            catch (Exception e) {
                logger.error((Object)"clearUp: ", (Throwable)e);
            }
        }
    }

    private void setNullToZero() throws Exception {
        Exception e = new Exception();
        IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(e.getClass());
        boolean isReplaceNull = false;
        if (errorProvider != null) {
            boolean bl = isReplaceNull = errorProvider.getProperValue(e).getValue() == null || StringUtils.isEmpty((String)errorProvider.getProperValue(e).getValue().toString());
        }
        if (!isReplaceNull || DebugLogger.isDebug) {
            for (int i = 0; i < this.formulas.size(); ++i) {
                AcctCalculaterExt acct = (AcctCalculaterExt)this.formulas.get(i);
                Object value = acct.getBackfillHandler().getValue();
                if (DebugLogger.isDebug) {
                    logger.error((Object)("ACCT" + Arrays.toString(acct.getParameter().getArgs()) + " value:" + value + "   "));
                }
                if (isReplaceNull || value != null && !StringUtils.isEmpty((String)value.toString())) continue;
                acct.setDefaultACCTValue((Object)BigDecimal.ZERO);
            }
        }
    }

    private void submitAccountWildcarQuery(List formulas) throws Exception {
        this.batchQueryService.excBatchCompanyInfoService();
        this.batchQueryService.excBatchCurrencyInfoService();
        this.batchQueryService.executeAccountTableQuery();
        Iterator it = formulas.iterator();
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = (AcctCalculaterExt)it.next();
            if (!tempAcct.getStruct().getAccountItem().matches(".*[^#]\\*.*")) continue;
            AccountItemExt accountItem = tempAcct.getAccountItem();
            boolean accountHasWildcar = false;
            boolean itemHasWildcar = false;
            if (!(accountItem.startAccount.getAccountNumber().equals(accountItem.endAccount.getAccountNumber()) || accountItem.startAccount.getAccountNumber().indexOf(42) < 0 && accountItem.endAccount.getAccountNumber().indexOf(42) < 0)) {
                AcctCalculaterExt acctExt = new AcctCalculaterExt(tempAcct.getStruct(), tempAcct.getStruct().getBackFiller());
                acctExt.setACCTValue((Object)new Exception(ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"26_AcctBatchCalculaterNew", (Locale)this.ctx.getOriginLocale())));
                return;
            }
            if (accountItem.startAccount.getAccountNumber().indexOf(42) >= 0) {
                accountHasWildcar = true;
            }
            if (accountItem.itemValues() != null) {
                for (AssistantItemExt item : accountItem.itemValues()) {
                    if (item.startItem == null) continue;
                    if (item.startItem.number.indexOf(42) >= 0) {
                        itemHasWildcar = true;
                    }
                    if (!item.startItem.number.equals(item.endItem.number) && (item.startItem.number.indexOf(42) >= 0 || item.endItem.number != null && item.endItem.number.indexOf(42) >= 0)) {
                        AcctCalculaterExt acctExt = new AcctCalculaterExt(tempAcct.getStruct(), tempAcct.getStruct().getBackFiller());
                        acctExt.setACCTValue((Object)new Exception(ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"26_AcctBatchCalculaterNew", (Locale)this.ctx.getOriginLocale())));
                        return;
                    }
                    this.submitRequireBatchFitchItemInfoService(item);
                }
            }
            tempAcct.setAccountHasWildcar(accountHasWildcar);
            tempAcct.setItemHasWildcar(itemHasWildcar);
            if (tempAcct.getCompany().getAccountTable() == null) {
                it.remove();
                tempAcct.setACCTValue((Object)new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE));
                continue;
            }
            this.correctAccountTable(tempAcct);
            this.batchQueryService.submitAccountWildcarQuery(tempAcct);
        }
        this.batchQueryService.excBatchItemInfoService();
    }

    private void submitDetailAsstActTypeAndAssistantStandard(List formulas) throws Exception {
        Iterator it = formulas.iterator();
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = (AcctCalculaterExt)it.next();
            if (!tempAcct.check()) {
                it.remove();
                continue;
            }
            this.submitDetailAsstActTypeQuery(tempAcct);
            tempAcct.submitRequireStandard();
        }
    }

    private void executeAsstAccountChangeForSubAccount(List<AcctCalculaterExt> formulas) throws Exception {
        AcctExecuteAsstAccountChanged change = new AcctExecuteAsstAccountChanged(this.ctx);
        this.formulas = change.executeAsstAccountChangeForParentAccount(formulas);
    }

    private void submitRequireBatchFitchItemInfoService(List formulas) throws Exception {
        AsstAccountChangeCollection accountByAsstAccountChanges = this.getAsstAccountChangeCollection(formulas);
        if (accountByAsstAccountChanges != null && accountByAsstAccountChanges.size() > 0) {
            if (this.formulasNeedChangedAct != null && this.formulasNeedChangedAct.size() > 0) {
                for (AcctCalculaterExt acct : this.formulasNeedChangedAct) {
                    formulas.remove(acct);
                }
            }
            AcctChangeAccountAsstActType acctChg = new AcctChangeAccountAsstActType(this.ctx, this.batchQueryService, this.isGroupByAccount);
            this.formulasNeedChangedAct = acctChg.acctsInAsstAccountChange(this.formulasNeedChangedAct, accountByAsstAccountChanges);
            formulas.addAll(this.formulasNeedChangedAct);
            this.formulasNeedChangedAct.clear();
            this.formulas = formulas;
        }
        Iterator it = formulas.iterator();
        ArrayList newItemTypes = new ArrayList();
        while (it.hasNext()) {
            Collection items;
            AcctCalculaterExt tempAcct = (AcctCalculaterExt)it.next();
            this.synAccountItems(tempAcct);
            boolean IncludeDetailAccountAsstItem = tempAcct.isIncludeDetailAccountAsstItem();
            if (!IncludeDetailAccountAsstItem || (items = tempAcct.getAccountItem().itemValues()) == null) continue;
            for (AssistantItemExt item : items) {
                if (!StringUtils.isEmpty((String)item.itemType.realtionDataObject)) continue;
                this.submitRequireBatchFitchItemInfoService(item);
            }
        }
    }

    private AsstAccountChangeCollection getAsstAccountChangeCollection(List<AcctCalculaterExt> formulas) throws BOSException, SQLException {
        Iterator<AcctCalculaterExt> it = formulas.iterator();
        ArrayList<String> accountidList = new ArrayList<String>();
        AsstAccountChangeCollection colls = null;
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = it.next();
            if (tempAcct.getOrgType().equals((Object)OrgType.ProfitCenter) || tempAcct.isException() || (tempAcct.isSelectSheetParam() || this.isGroupByAccount() || !AcctUtils.isJDType(tempAcct.getBalanceType().getName())) && (!tempAcct.getIsIncludeLeafAsstItem() && !tempAcct.getIsIncludeSubAsstItem() || !tempAcct.getAccountItem().isDetailAccount()) || tempAcct.getAccountItem().hasItem() || !tempAcct.getAccountItem().isSingleAccount()) continue;
            if (this.formulasNeedChangedAct == null) {
                this.formulasNeedChangedAct = new ArrayList();
            }
            accountidList.add(tempAcct.getAccountItem().startAccount.account.id);
            this.formulasNeedChangedAct.add(tempAcct);
        }
        if (accountidList.size() > 0) {
            String accountids = CslRptUtil.changeIdList2String(accountidList);
            colls = AsstAccountChangeFactory.getLocalInstance((Context)this.ctx).getAsstAccountChangeCollection("select account,before,after,period.periodYear,period.periodNumber where account in (" + accountids + ") order by period.periodYear,period.periodNumber");
        }
        return colls;
    }

    private void submitDetailAsstActTypeQuery(AcctCalculaterExt tempAcct) {
        if ((tempAcct.getIsIncludeLeafAsstItem() || tempAcct.getIsIncludeSubAsstItem()) && !tempAcct.getAccountItem().hasItem() && tempAcct.getAccountItem().isSingleAccount() && !tempAcct.getAccountItem().isDetailAccount() && AcctUtils.isJDType(tempAcct.getBalanceType().getName())) {
            this.batchQueryService.submitDetailAsstActTypeQuery(tempAcct);
        }
    }

    private void synAccountItems(AcctCalculaterExt tempAcct) {
        if (this.isUseNewBatchLogic) {
            if ((!tempAcct.isSelectSheetParam() && !this.isGroupByAccount() && AcctUtils.isJDType(tempAcct.getBalanceType().getName()) || (tempAcct.getIsIncludeLeafAsstItem() || tempAcct.getIsIncludeSubAsstItem()) && tempAcct.getAccountItem().isDetailAccount()) && !tempAcct.getAccountItem().hasItem() && tempAcct.getAccountItem().isSingleAccount()) {
                tempAcct.getAccountItem().synItems(true);
            } else {
                tempAcct.getAccountItem().synItems(false);
            }
        } else if ((tempAcct.getIsIncludeLeafAsstItem() || tempAcct.getIsIncludeSubAsstItem()) && !tempAcct.getAccountItem().hasItem() && tempAcct.getAccountItem().isSingleAccount()) {
            tempAcct.getAccountItem().synItems(true);
        } else {
            tempAcct.getAccountItem().synItems(false);
        }
    }

    private void submitRequireAssistantItem(List formulas) {
        Iterator it = formulas.iterator();
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = (AcctCalculaterExt)it.next();
            try {
                tempAcct.submitRequireAssistantItem();
            }
            catch (Exception e) {
                tempAcct.setACCTValue((Object)e);
                it.remove();
            }
        }
    }

    private void checkAssistantGroup(List formulas) {
        Iterator it = formulas.iterator();
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = (AcctCalculaterExt)it.next();
            for (AssistantItem itm : tempAcct.getAccountItem().itemValues()) {
                if (itm.getGroups() == null) continue;
                for (int j = 0; j < itm.getGroups().length; ++j) {
                    AssistantGroup assistantGroup = itm.getGroups()[j];
                    if (assistantGroup.getStartGroup().longNumber != null) continue;
                    tempAcct.setACCTValue((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("GroupNoExists") + "\"" + assistantGroup.getStartGroup().number + "\""}));
                    it.remove();
                }
            }
        }
    }

    private void submitRequireItemInfoByAccount(List formulas) {
        for (AcctCalculaterExt tempAcct : formulas) {
            this.batchQueryService.submitRequireItemInfoByAccount(tempAcct.getAccountItem());
        }
    }

    private void submitRequireAccountAndItemInfoBatchQueryService(List formulas) {
        Iterator it = formulas.iterator();
        while (it.hasNext()) {
            AcctCalculaterExt acctc = (AcctCalculaterExt)it.next();
            if (acctc.isException()) continue;
            if (acctc.getCompany() == null) {
                it.remove();
                acctc.setACCTValue((Object)new ReportException(ReportException.FIND_COMPANY_ERROR));
                continue;
            }
            try {
                String company = null;
                company = acctc.getCompany().isIsProfitOrgUnit() && acctc.getCompany().get("DELEGATED_COMPANY_ID") instanceof String ? (String)acctc.getCompany().get("DELEGATED_COMPANY_ID") : acctc.getCompany().getId().toString();
                String startCacheKey = company + acctc.getAccountTable().getId().toString() + acctc.getAccountItem().startAccount.getAccountNumber();
                if (this.accountCache.containsKey(startCacheKey)) {
                    acctc.getAccountItem().startAccount.account = (Account)this.accountCache.get(startCacheKey);
                } else {
                    this.batchQueryService.submitRequireBatchFitchAccountInfoService(acctc.getAccountItem().startAccount);
                }
                String endCacheKey = company + acctc.getAccountTable().getId().toString() + acctc.getAccountItem().endAccount.getAccountNumber();
                if (this.accountCache.containsKey(endCacheKey)) {
                    acctc.getAccountItem().endAccount.account = (Account)this.accountCache.get(endCacheKey);
                    continue;
                }
                this.batchQueryService.submitRequireBatchFitchAccountInfoService(acctc.getAccountItem().endAccount);
            }
            catch (Exception ex) {
                it.remove();
                acctc.setACCTValue((Object)ex);
            }
        }
    }

    private Set checkFormulaCompanyInfo(List formulas) throws BOSException, EASBizException {
        HashSet<String> companyIdSet = new HashSet<String>();
        Iterator it = formulas.iterator();
        while (it.hasNext()) {
            AcctCalculaterExt acctc = (AcctCalculaterExt)it.next();
            if (acctc.isException()) continue;
            CompanyOrgUnitInfo company = acctc.getCompany();
            if (company == null) {
                it.remove();
                acctc.setACCTValue((Object)new ReportException(ReportException.FIND_COMPANY_ERROR));
                continue;
            }
            OrgType orgType = acctc.getOrgType();
            if (this.checkPermission && this.checkPermission((OrgUnitInfo)company, this.calcCtx, orgType)) {
                it.remove();
                acctc.setACCTValue((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"35_Acctext", (Locale)this.ctx.getOriginLocale()) + company.getNumber() + ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"36_Acctext", (Locale)this.ctx.getOriginLocale())}));
                continue;
            }
            if (acctc.getCompany().getAccountTable() == null) {
                it.remove();
                acctc.setACCTValue((Object)new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE));
                continue;
            }
            this.correctAccountTable(acctc);
            if (AcctUtils.getPeriodType(acctc.getBalanceType().getName()) == 1) {
                String accountTableIdStart = null;
                try {
                    accountTableIdStart = this.getAccountTableIDFromCache(acctc, acctc.getStruct().getStartYear(), acctc.getStruct().getEndPeriod());
                }
                catch (Exception e) {
                    it.remove();
                    acctc.setACCTValue((Object)e);
                    continue;
                }
                if (accountTableIdStart != null && !accountTableIdStart.equals(acctc.getAccountTable().getId().toString())) {
                    it.remove();
                    acctc.setACCTValue((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"29_AcctBatchCalculaterNew", (Locale)this.ctx.getOriginLocale())}));
                    continue;
                }
            }
            if (company.getId() == null) continue;
            companyIdSet.add(company.getId().toString());
        }
        return companyIdSet;
    }

    protected boolean checkPermission(OrgUnitInfo company, ICalculateContextProvider context, OrgType orgType) throws BOSException {
        if (orgType.equals((Object)OrgType.Company)) {
            return !this.getUserPermissionOrgs(context).containsKey(company.getNumber().toUpperCase());
        }
        if (orgType.equals((Object)OrgType.ProfitCenter)) {
            return !this.getUserPermissionOrgs(context).containsKey(OrgType.ProfitCenter + "|" + company.getNumber().toUpperCase());
        }
        return false;
    }

    private void correctAccountTable(AcctCalculaterExt acctc) throws EASBizException, BOSException {
        if (acctc.isCorrectAccountTable()) {
            return;
        }
        if (!StringUtils.isEmpty((String)acctc.getStruct().getAccountTable()) && acctc.getAccountTable() == null) {
            acctc.setACCTValue((Object)new ReportException(ReportException.NOT_FIND_RACCT_ACCOUNTTABLE));
        }
        if (acctc.getAccountTable() == null) {
            AccountTableInfo accountTable = this.getAccountTableFromCache(acctc);
            acctc.setAccountTable(accountTable);
        }
        String accountTableId = null;
        try {
            accountTableId = this.getAccountTableIDFromCache(acctc, acctc.getStruct().getEndYear(), acctc.getStruct().getEndPeriod());
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            acctc.setACCTValue((Object)new ReportException(ReportException.GET_CURRENT_ACCOUNTTABLE_ERROR));
        }
        if (accountTableId == null) {
            acctc.setACCTValue((Object)new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE));
        }
        acctc.getAccountTable().setId(BOSUuid.read((String)accountTableId));
        acctc.setCorrectAccountTable(true);
    }

    protected void submitVoucherBatch(String[] companyIds) {
        try {
            IGLPeriodEndFacade facade = GLPeriodEndFacadeFactory.getLocalInstance((Context)this.ctx);
            facade.submitVoucherBatch(companyIds);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void submitProfitVoucherBatch(String[] profitCenterIds) {
        try {
            IPcaPeriodEndFacade facade = PcaPeriodEndFacadeFactory.getLocalInstance((Context)this.ctx);
            facade.submitVoucherBatch(profitCenterIds);
        }
        catch (Exception e) {
            logger.error((Object)"submitProfitVoucherBatch", (Throwable)e);
        }
    }

    private static void setError(SortedParameterArray params, Exception e) {
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            param.setValue((Object)e);
        }
    }

    public boolean isGroupByAccount() {
        return this.isGroupByAccount;
    }

    public void setGroupByAccount(boolean isGroupByAccount) {
        this.isGroupByAccount = isGroupByAccount;
        this.batchQueryService.setGroupByAccount(isGroupByAccount);
    }

    public Map getAccountTableIdCache() {
        return this.accountTableIdCache;
    }

    public void setAccountTableIdCache(Map accountTableIdCache) {
        this.accountTableIdCache = accountTableIdCache;
    }

    public void setCompanyCache(Map companyCache) {
        this.companyCache = companyCache;
    }

    public Map getCompanyCache() {
        return this.companyCache;
    }

    public void setAccountCache(Map accountCache) {
        this.accountCache = accountCache;
    }

    public Map getAccountCache() {
        return this.accountCache;
    }

    public void setCurrencyCache(Map currencyCache) {
        this.currencyCache = currencyCache;
    }

    public Map getCurrencyCache() {
        return this.currencyCache;
    }

    public void setPeriodCache(Map periodCache) {
        this.batchQueryService.setCurrentPeriodCache(periodCache);
    }

    public void setPrePeriodCaChe(Map prePeriodCaChe) {
        this.batchQueryService.setPrePeriodCache(prePeriodCaChe);
    }

    public void setNextPeriodCache(Map nextPeriodCache) {
        this.batchQueryService.setNextPeriodCache(nextPeriodCache);
    }

    public void setPermissionOrgs(Map permissionOrgs) {
        this.permissionOrgs = permissionOrgs;
    }

    public void setItemCache(Map itemCache) {
        this.itemCache = itemCache;
    }

    public Map getItemCache() {
        return this.itemCache;
    }

    public int getWhereSize() {
        return this.whereSize;
    }

    public void setWhereSize(int whereSize) {
        this.whereSize = whereSize;
        this.batchQueryService.setWhereSize(whereSize);
    }

    public int getExpandWildcarSize() {
        return this.expandWildcarSize;
    }

    public void setExpandWildcarSize(int expandWildcarSize) {
        this.expandWildcarSize = expandWildcarSize;
    }

    public boolean isUseNewBatchLogic() {
        return this.isUseNewBatchLogic;
    }

    public void setUseNewBatchLogic(boolean isUseNewBatchLogic) {
        this.isUseNewBatchLogic = isUseNewBatchLogic;
    }

    public boolean isSupportVirtualOrgMultiUnPosted() {
        return this.isSupportVirtualOrgMultiUnPosted;
    }

    public void setSupportVirtualOrgMultiUnPosted(boolean isSupportVirtualOrgMultiUnPosted) {
        this.isSupportVirtualOrgMultiUnPosted = isSupportVirtualOrgMultiUnPosted;
    }

    public boolean isUseTempTableScheme() {
        return this.isUseTempTableScheme;
    }

    public void setUseTempTableScheme(boolean isUseTempTableScheme) {
        this.isUseTempTableScheme = isUseTempTableScheme;
    }

    public void setTempTableSchemeDebug(boolean isTempTableSchemeDebug) {
        this.isTempTableSchemeDebug = isTempTableSchemeDebug;
    }

    public boolean isTempTableSchemeDebug() {
        return this.isTempTableSchemeDebug;
    }

    public Map getAccountTableCache() {
        return this.accountTableCache;
    }

    public void setAccountTableCache(Map accountTableCache) {
        this.accountTableCache = accountTableCache;
    }

    public VouchQuantityCalculator getVouchQuantityCalculator() {
        return this.vouchQuantityCalculator;
    }

    public boolean isProfitCenter() {
        return this.isProfitCenter;
    }

    private String getCurrentAcctTable(Context ctx, String companyID, String curAcctTableID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        try {
            IObjectCollection lastRefCol;
            if (this.isAccountRefNull) {
                return curAcctTableID;
            }
            if (this.company_AccountRef.isEmpty()) {
                String rowcount;
                StringBuffer sql = new StringBuffer();
                sql.append(" select count(*) curRowCount from T_BD_ACCTREFCONTRAST");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet != null && rowSet.next() && (rowcount = rowSet.getString("curRowCount")).trim().equals("0")) {
                    this.isAccountRefNull = true;
                    return curAcctTableID;
                }
            }
            if ((lastRefCol = this.company_AccountRef.get(companyID)) == null && !this.company_AccountRef.containsKey(companyID)) {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT distinct acctRef.FENABLEDACCTTABLEID refEnabledAcctTableId, acctRef.FDISABLEDACCTTABLEID refDisabledAcctTableId ");
                sql.append(" ,T3.FPERIODYEAR periodYear, T3.FPERIODNUMBER periodNumber ");
                sql.append(" FROM T_BD_ACCTREFCONTRAST acctRef ");
                sql.append(" LEFT JOIN T_BD_ACCOUNTTABLE T1 ON acctRef.FENABLEDACCTTABLEID = T1.FID  ");
                sql.append(" LEFT JOIN T_BD_ACCOUNTTABLE T2 ON acctRef.FDISABLEDACCTTABLEID = T2.FID ");
                sql.append(" LEFT JOIN T_BD_PERIOD T3 ON acctRef.FENABLEDPERIODID = T3.FID ");
                sql.append(" WHERE acctRef.FREFTYPE = ? AND acctRef.FCOMPANYID = ? AND acctRef.FISENABLED = ? ");
                sql.append(" AND (acctRef.FENABLEDPERIODID IS NOT NULL) ORDER BY T3.FPERIODYEAR DESC, T3.FPERIODNUMBER DESC ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{1, companyID, 1});
                if (rowSet != null) {
                    lastRefCol = new AccountRefContrastCollection();
                    AccountRefContrastInfo info = null;
                    AccountTableInfo tableInfo = null;
                    PeriodInfo periodInfo = null;
                    AccountTableInfo disTableInfo = null;
                    while (rowSet.next()) {
                        info = new AccountRefContrastInfo();
                        lastRefCol.addObject((IObjectValue)info);
                        tableInfo = new AccountTableInfo();
                        tableInfo.setId(BOSUuid.read((String)rowSet.getString("refEnabledAcctTableId")));
                        info.setEnabledAcctTable(tableInfo);
                        periodInfo = new PeriodInfo();
                        periodInfo.setPeriodYear(rowSet.getInt("periodYear"));
                        periodInfo.setPeriodNumber(rowSet.getInt("periodNumber"));
                        info.setEnabledPeriod(periodInfo);
                        disTableInfo = new AccountTableInfo();
                        disTableInfo.setId(BOSUuid.read((String)rowSet.getString("refDisabledAcctTableId")));
                        info.setDisabledAcctTable(disTableInfo);
                    }
                }
                if (lastRefCol == null) {
                    this.company_AccountRef.put(companyID, null);
                } else {
                    this.company_AccountRef.put(companyID, lastRefCol);
                }
            }
            if (lastRefCol != null && lastRefCol.size() > 0) {
                AccountRefContrastInfo info = null;
                String enabledAcctTableID = curAcctTableID;
                for (int i = 0; i < lastRefCol.size(); ++i) {
                    info = (AccountRefContrastInfo)lastRefCol.getObject(i);
                    if (enabledAcctTableID.equals(info.getEnabledAcctTable().getId().toString()) && (periodYear > info.getEnabledPeriod().getPeriodYear() || periodYear == info.getEnabledPeriod().getPeriodYear() && periodNumber >= info.getEnabledPeriod().getPeriodNumber())) {
                        return info.getEnabledAcctTable().getId().toString();
                    }
                    if (enabledAcctTableID.equals(info.getEnabledAcctTable().getId().toString())) {
                        enabledAcctTableID = info.getDisabledAcctTable().getId().toString();
                    }
                    if (i != lastRefCol.size() - 1) continue;
                    return enabledAcctTableID;
                }
            }
            return curAcctTableID;
        }
        catch (Exception e) {
            logger.error((Object)"getCurrentAcctTable error.", (Throwable)e);
            throw new BOSException("getCurrentAcctTable error.", (Throwable)e);
        }
    }

    private void seperateFormulaByAccountLevel(List<AcctCalculaterExt> formulas) throws Exception {
        if (!this.isCalSaperateByAccountLevel()) {
            return;
        }
        Iterator<AcctCalculaterExt> it = formulas.iterator();
        ArrayList<AcctCalculaterExt> accountList = null;
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = it.next();
            if (tempAcct.isException() || tempAcct.getAccountItem().isSingleAccount() || tempAcct.getAccountItem().isDetailAccount() && (!tempAcct.getAccountItem().isDetailAccount() || tempAcct.getAccountItem().hasItem())) continue;
            if (accountList == null) {
                accountList = new ArrayList<AcctCalculaterExt>();
            }
            accountList.add(tempAcct);
        }
        if (accountList != null) {
            List<AcctCalculaterExt> newAcctList = this.getNewAcctList(accountList);
            formulas.removeAll(accountList);
            formulas.addAll(newAcctList);
        }
    }

    private List<AcctCalculaterExt> getNewAcctList(List<AcctCalculaterExt> accountList) throws Exception {
        Iterator<AcctCalculaterExt> it = accountList.iterator();
        Account startAccount = null;
        Account endAccount = null;
        AcctStruct acctStruct = null;
        AccountExt accountext = null;
        ArrayList<AcctCalculaterExt> newAcctExtList = new ArrayList<AcctCalculaterExt>();
        while (it.hasNext()) {
            AcctCalculaterExt oldAcct = it.next();
            Map<Integer, Account[]> accountsMap = this.queryAccount(oldAcct);
            if (accountsMap == null || accountsMap.isEmpty()) continue;
            Iterator<Account[]> accountIt = accountsMap.values().iterator();
            acctStruct = oldAcct.getStruct().copy();
            acctStruct.setAccountItem(oldAcct.getAccountItem().getAccountAsstItem().toOldString());
            while (accountIt.hasNext()) {
                Account[] accounts = accountIt.next();
                if (accounts.length == 2) {
                    startAccount = accounts[0];
                    endAccount = accounts[1] == null ? accounts[0] : accounts[1];
                }
                if (startAccount == null || endAccount == null) continue;
                AcctCalculaterExt newAcctExt = new AcctCalculaterExt(acctStruct, oldAcct.getStruct().getBackFiller());
                newAcctExt.getAccountItem().parseAcctItem(acctStruct.getAccountItem());
                accountext = new AccountExt(startAccount.number);
                accountext.account = startAccount;
                newAcctExt.getAccountItem().startAccount = accountext;
                accountext = new AccountExt(endAccount.number);
                accountext.account = endAccount;
                newAcctExt.getAccountItem().endAccount = accountext;
                newAcctExt.setItemHasWildcar(oldAcct.isItemHasWildcar());
                newAcctExt.setCurrency(oldAcct.getCurrency());
                newAcctExt.setCompany(oldAcct.getCompany());
                newAcctExt.setAcctBatchQueryService(oldAcct.getAcctBatchQueryService());
                newAcctExt.setContext(oldAcct.getContext());
                newAcctExt.setAccountTable(oldAcct.getAccountTable());
                newAcctExt.setCorrectAccountTable(oldAcct.isCorrectAccountTable());
                newAcctExtList.add(newAcctExt);
            }
        }
        return newAcctExtList;
    }

    private Map<Integer, Account[]> queryAccount(AcctCalculaterExt oldAcct) throws Exception {
        String oldStartAccountNumber = oldAcct.getAccountItem().getAccountAsstItem().startNumber;
        String oldEndAccountNumber = oldAcct.getAccountItem().getAccountAsstItem().endNumber;
        String companyId = oldAcct.getCompany().getId().toString();
        String accountTableId = oldAcct.getAccountTable().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select Fid, FNumber, FDC, FIsLeaf, FLevel \n");
        sql.append(" From T_BD_AccountView \n");
        sql.append(" Where fcompanyid = ? and FAccountTableID = ? and FNumber >= ? and FNumber <= ? \n");
        sql.append(" Order by FNumber");
        ArrayList<String> params = new ArrayList<String>();
        params.add(companyId);
        params.add(accountTableId);
        params.add(oldStartAccountNumber);
        params.add(oldEndAccountNumber);
        IRowSet rowSet = DbUtil.executeQuery((Context)this.batchQueryService.getServerContext(), (String)sql.toString(), (Object[])params.toArray());
        HashMap<Integer, Account[]> accountMap = new HashMap<Integer, Account[]>();
        Account[] accounts = null;
        Account account = null;
        while (rowSet.next()) {
            String id = rowSet.getString("Fid");
            String number = rowSet.getString("FNumber");
            int dc = rowSet.getInt("FDC");
            boolean isLeaf = rowSet.getBoolean("FIsLeaf");
            int level = rowSet.getInt("FLevel");
            if (!isLeaf) continue;
            if (accountMap.containsKey(level)) {
                account = new Account();
                account.id = id;
                account.number = number;
                account.dc = dc;
                account.isLeaf = isLeaf;
                account.level = level;
                ((Account[])accountMap.get((Object)Integer.valueOf((int)level)))[1] = account;
                continue;
            }
            account = new Account();
            account.id = id;
            account.number = number;
            account.dc = dc;
            account.isLeaf = isLeaf;
            account.level = level;
            accounts = new Account[2];
            accounts[0] = account;
            accountMap.put(level, accounts);
        }
        return accountMap;
    }

    public boolean isCalSaperateByAccountLevel() {
        return this.isCalSaperateByAccountLevel;
    }

    public void setCalSaperateByAccountLevel(boolean isCalSaperateByAccountLevel) {
        this.isCalSaperateByAccountLevel = isCalSaperateByAccountLevel;
    }

    private static class FunctionPermission {
        IObjectPK companyId = null;
        Map permissionItems = new HashMap(2);

        FunctionPermission(BOSUuid id) {
            this.companyId = new ObjectUuidPK(id);
        }
    }
}

