/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AcctExecuteAsstAccountChanged {
    private Context _ctx;

    public AcctExecuteAsstAccountChanged(Context ctx) {
        this._ctx = ctx;
    }

    public List<AcctCalculaterExt> executeAsstAccountChangeForParentAccount(List<AcctCalculaterExt> formulas) throws BOSException, SQLException, ParseException, EASBizException {
        Iterator<AcctCalculaterExt> it = formulas.iterator();
        ArrayList<String> parentSubidsList = new ArrayList<String>();
        ArrayList<String> parentDetailidsList = new ArrayList<String>();
        ArrayList<AcctCalculaterExt> formulasNeedChangedAct = new ArrayList<AcctCalculaterExt>();
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = it.next();
            if (tempAcct.getOrgType().equals((Object)OrgType.ProfitCenter) || tempAcct.isException() || !tempAcct.checkBaseInfo() || !tempAcct.getIsIncludeLeafAsstItem() && !tempAcct.getIsIncludeSubAsstItem() || tempAcct.getAccountItem().hasItem() || !tempAcct.getAccountItem().isSingleAccount() || tempAcct.getAccountItem().isDetailAccount() || !AcctUtils.isJDType(tempAcct.getBalanceType().getName())) continue;
            String accountid = tempAcct.getAccountItem().startAccount.account.id;
            formulasNeedChangedAct.add(tempAcct);
            if (tempAcct.getIsIncludeLeafAsstItem()) {
                if (parentDetailidsList.contains(accountid)) continue;
                parentDetailidsList.add(accountid);
                continue;
            }
            if (!tempAcct.getIsIncludeSubAsstItem() || parentSubidsList.contains(accountid)) continue;
            parentSubidsList.add(accountid);
        }
        if (parentDetailidsList.size() > 0 || parentSubidsList.size() > 0) {
            if (formulasNeedChangedAct != null && formulasNeedChangedAct.size() > 0) {
                for (AcctCalculaterExt acct : formulasNeedChangedAct) {
                    formulas.remove(acct);
                }
            }
            this.addAcctextByAsstChangeAccount(formulasNeedChangedAct, parentDetailidsList, parentSubidsList);
            formulas.addAll(formulasNeedChangedAct);
            formulasNeedChangedAct.clear();
        }
        return formulas;
    }

    private void getDetailAccountAcctextExceptAsstChanged(List<AcctCalculaterExt> formulas, List<String> parentids, boolean isDetailQuery) throws BOSException, SQLException, ReportException, ParseException {
        StringBuffer sql = new StringBuffer();
        String accountids = CslRptUtil.changeIdList2String(parentids);
        sql.append(" Select A_Acct.FID parentid,A_AcctLeaf.fid accountid,A_AcctLeaf.FNumber accountNumber, ");
        sql.append(" A_AcctLeaf.FLevel FLevel,A_AcctLeaf.FIsleaf FIsleaf,item.Fnumber FNumber, ");
        sql.append(" item.frealtiondataobject FTableName,item.fmappingfieldname  FFieldName, ");
        sql.append(" item.FGLAsstActTypeGrpID FGlAsstActTypeGrpID,item.FGroupTableName FGroupTableName, ");
        sql.append(" item.FGroupMappingFieldName FGroupMappingFieldName \n");
        sql.append(" From T_BD_AccountView A_Acct \n");
        sql.append(" Inner Join T_BD_AccountView A_AcctLeaf On (A_Acct.FCompanyID = A_AcctLeaf.FCompanyID ");
        sql.append(" and A_Acct.FAccountTableID = A_AcctLeaf.FAccountTableID and charindex(A_Acct.FLongNumber || '!',A_AcctLeaf.FLongNumber) = 1) \n");
        sql.append(" LEFT JOIN T_BD_AsstAccount book ON A_AcctLeaf.FCaa = book.FID \n");
        sql.append(" LEFT JOIN T_BD_AsstActGroupDetail rel ON book.FID = rel.FasstAccountID \n");
        sql.append(" LEFT JOIN T_BD_AsstActType item ON item.FID = rel.FasstActTypeID \n");
        sql.append(" Where A_Acct.FID in (" + accountids + ") ");
        if (isDetailQuery) {
            sql.append(" And  A_AcctLeaf.fisleaf = 1 ");
        } else {
            sql.append(" And  A_AcctLeaf.fisleaf = 1 ");
            sql.append(" And A_AcctLeaf.FLevel = A_Acct.FLevel + 1 ");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)this._ctx, (String)sql.toString());
        Map<String, List<AsstActType>> asstActTypeMap = this.getActTypes(rowSet);
        rowSet.beforeFirst();
        this.extendAcctext(formulas, rowSet, asstActTypeMap);
    }

    private void extendAcctext(List<AcctCalculaterExt> formulas, IRowSet rowSet, Map<String, List<AsstActType>> asstActTypeMap) throws SQLException, ReportException, ParseException {
        ArrayList<AcctCalculaterExt> newFormulas = new ArrayList<AcctCalculaterExt>();
        ArrayList<String> remRepeat = new ArrayList<String>();
        while (rowSet.next()) {
            String accountid = rowSet.getString("accountid");
            String parentid = rowSet.getString("parentid");
            String key = parentid + accountid;
            if (remRepeat.contains(key)) continue;
            remRepeat.add(key);
            Account account = new Account();
            account.id = accountid;
            account.number = rowSet.getString("accountNumber");
            account.level = rowSet.getInt("FLevel");
            account.isLeaf = rowSet.getBoolean("FIsleaf");
            List<AsstActType> asstActTypes = asstActTypeMap.get(accountid);
            for (AcctCalculaterExt acctext : formulas) {
                String id;
                if (acctext.getOrgType().equals((Object)OrgType.ProfitCenter) || acctext.isException() || !(id = acctext.getAccountItem().startAccount.account.id).equals(parentid) || !AcctUtils.isJDType(acctext.getBalanceType().getName())) continue;
                this.addAcctext(account, acctext, asstActTypes, newFormulas);
            }
        }
        formulas.addAll(newFormulas);
    }

    private void addAcctext(Account account, AcctCalculaterExt acctext, List<AsstActType> asstActTypes, List<AcctCalculaterExt> newFormulas) throws ReportException, ParseException {
        AcctCalculaterExt newAcct = new AcctCalculaterExt(acctext.getStruct().copy(), acctext.getStruct().getBackFiller());
        newAcct.getStruct().setAccountItem(account.number);
        newAcct.setAccountItem(new AccountItemExt(newAcct.getStruct().getAccountItem(), acctext.getCompany()));
        newAcct.getAccountItem().endAccount.account = newAcct.getAccountItem().startAccount.account = account;
        newAcct.setCompany(acctext.getCompany());
        newAcct.setStrPeriodID(acctext.getStrPeriodID());
        newAcct.setCurrency(acctext.getCurrency());
        newAcct.setAccountTable(acctext.getAccountTable());
        newAcct.setCorrectAccountTable(acctext.isCorrectAccountTable());
        newAcct.setBalanceType(acctext.getBalanceType());
        int startYear = acctext.getStruct().getStartYear();
        int startPeriod = acctext.getStruct().getStartPeriod();
        int endYear = acctext.getStruct().getEndYear();
        int endPeriod = acctext.getStruct().getEndPeriod();
        BalanceTypeEnum balType = acctext.getBalanceType();
        newAcct.setBalanceType(balType);
        newAcct.setContext(acctext.getContext());
        newAcct.setiStartYear(startYear);
        newAcct.setiStartPeriod(startPeriod);
        newAcct.setIEndYear(endYear);
        newAcct.setIEndPeriod(endPeriod);
        newAcct.setAcctBatchQueryService(acctext.getAcctBatchQueryService());
        newAcct.getStruct().setOrgType(acctext.getOrgType());
        this.changeAsstForAcctExt(newAcct, asstActTypes);
        newFormulas.add(newAcct);
    }

    private void changeAsstForAcctExt(AcctCalculaterExt tempAcct, List<AsstActType> asstActTypeList) {
        if (asstActTypeList != null) {
            HashMap items = new HashMap();
            boolean isclear = true;
            for (AsstActType asstActType : asstActTypeList) {
                AccountExt account = tempAcct.getAccountItem().startAccount;
                ArrayList<AsstActType> itemTypes = account.getItemTypes();
                if (itemTypes == null) {
                    itemTypes = new ArrayList<AsstActType>();
                    account.setItemTypes(itemTypes);
                }
                if (isclear) {
                    itemTypes.clear();
                    isclear = false;
                }
                if (asstActType.number == null) continue;
                itemTypes.add(asstActType);
            }
        } else {
            AccountExt account = tempAcct.getAccountItem().startAccount;
            ArrayList itemTypes = account.getItemTypes();
            if (itemTypes == null) {
                itemTypes = new ArrayList();
                account.setItemTypes(itemTypes);
            }
            itemTypes.clear();
        }
    }

    private void addAcctextByAsstChangeAccount(List<AcctCalculaterExt> formulas, List<String> parentDetailidsList, List<String> parentSubidsList) throws BOSException, SQLException, ParseException, EASBizException {
        IRowSet rowSet;
        String parentsids;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select A_Acct.FID parentid \n");
        sql.append(" From T_BD_AccountView A_Acct \n");
        sql.append(" Inner Join T_BD_AccountView A_AcctLeaf On (A_Acct.FCompanyID = A_AcctLeaf.FCompanyID ");
        sql.append(" and A_Acct.FAccountTableID = A_AcctLeaf.FAccountTableID and charindex(A_Acct.FLongNumber || '!',A_AcctLeaf.FLongNumber) = 1) \n");
        sql.append(" Inner Join T_BD_AsstAccountChange asstchg on asstchg.FAccountID = A_AcctLeaf.FID \n");
        if (parentDetailidsList.size() > 0) {
            StringBuffer sql1 = new StringBuffer();
            parentsids = CslRptUtil.changeIdList2String(parentDetailidsList);
            sql1.append(" Where A_Acct.FID in(" + parentsids + ") \n");
            sql1.append(" And  A_AcctLeaf.fisleaf = 1 ");
            rowSet = DbUtil.executeQuery((Context)this._ctx, (String)(sql.toString() + sql1.toString()));
            if (rowSet.size() > 0) {
                this.excuteResult(rowSet, formulas, true);
            }
        }
        if (parentSubidsList.size() > 0) {
            StringBuffer sql2 = new StringBuffer();
            parentsids = CslRptUtil.changeIdList2String(parentSubidsList);
            sql2.append(" Where A_Acct.FID in(" + parentsids + ") \n");
            sql2.append(" And  A_AcctLeaf.fisleaf = 1 ");
            sql2.append(" And A_AcctLeaf.FLevel = A_Acct.FLevel + 1");
            rowSet = DbUtil.executeQuery((Context)this._ctx, (String)(sql.toString() + sql2.toString()));
            if (rowSet.size() > 0) {
                this.excuteResult(rowSet, formulas, false);
            }
        }
    }

    private Map<String, List<AsstActType>> getActTypes(IRowSet rowSet) throws SQLException {
        HashMap<String, List<AsstActType>> asstActTypeMap = new HashMap<String, List<AsstActType>>();
        while (rowSet.next()) {
            List<AsstActType> asstActTypes;
            String accountid = rowSet.getString("accountid");
            AsstActType asstActType = new AsstActType();
            asstActType.mappingFieldName = rowSet.getString("FFieldName");
            asstActType.number = rowSet.getString("FNumber");
            asstActType.realtionDataObject = rowSet.getString("FTableName");
            asstActType.glAsstActTypeGrpID = rowSet.getString("FGlAsstActTypeGrpID");
            asstActType.groupTableName = rowSet.getString("FGroupTableName");
            asstActType.groupMappingFieldName = rowSet.getString("FGroupMappingFieldName");
            if (asstActTypeMap.containsKey(accountid)) {
                asstActTypes = (List)asstActTypeMap.get(accountid);
                asstActTypes.add(asstActType);
                asstActTypeMap.put(accountid, asstActTypes);
                continue;
            }
            asstActTypes = new ArrayList();
            asstActTypes.add(asstActType);
            asstActTypeMap.put(accountid, asstActTypes);
        }
        return asstActTypeMap;
    }

    private void excuteResult(IRowSet rowSet, List<AcctCalculaterExt> formulas, boolean isDetailQuery) throws SQLException, ParseException, BOSException, EASBizException {
        ArrayList<String> parentids = new ArrayList<String>();
        while (rowSet.next()) {
            String parentid = rowSet.getString("parentid");
            if (parentids.contains(parentid)) continue;
            parentids.add(parentid);
        }
        if (parentids.size() > 0) {
            this.getDetailAccountAcctextExceptAsstChanged(formulas, parentids, isDetailQuery);
            this.removeParentAcctext(formulas, parentids);
        }
    }

    private void removeParentAcctext(List<AcctCalculaterExt> formulas, List<String> parentids) {
        ArrayList<AcctCalculaterExt> removeAcctexts = new ArrayList<AcctCalculaterExt>();
        for (String parentid : parentids) {
            for (AcctCalculaterExt acctext : formulas) {
                String id;
                if (acctext.isException() || !(id = acctext.getAccountItem().startAccount.account.id).equals(parentid) || !AcctUtils.isJDType(acctext.getBalanceType().getName())) continue;
                removeAcctexts.add(acctext);
            }
        }
        if (removeAcctexts.size() > 0) {
            for (AcctCalculaterExt acctext : removeAcctexts) {
                formulas.remove(acctext);
            }
        }
    }
}

