/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.batchquery.IObjectBulider;
import com.kingdee.eas.fi.rpt.batchquery.IQueryObject;
import com.kingdee.eas.fi.rpt.batchquery.Solution;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectField;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectFieldCollection;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import java.sql.Connection;
import java.util.Map;

public class AccountSubQuerySolution
extends Solution {
    private Map accountCache;
    private String FCompanyID;
    private String FAccountTableID;
    private boolean flag = true;

    public AccountSubQuerySolution(Connection _conn) {
        super(_conn);
    }

    @Override
    public WhereItems configStaticWherePart() {
        WhereItems ws = new WhereItems();
        ws.addItem("FCompanyID", this.FCompanyID);
        ws.addItem("FAccountTableID", this.FAccountTableID);
        return ws;
    }

    @Override
    public String configFromPart() {
        return "T_Bd_AccountView";
    }

    @Override
    public IObjectBulider configDefaultObjectBuilder() {
        return new ObjectBulider();
    }

    @Override
    public boolean configAutoItemIsNeedGroupBy() {
        return false;
    }

    public void add(AccountExt account) throws Exception {
        if (this.flag) {
            this.flag = false;
            this.FCompanyID = account.getCompany().isIsProfitOrgUnit() && account.getCompany().get("DELEGATED_COMPANY_ID") instanceof String ? (String)account.getCompany().get("DELEGATED_COMPANY_ID") : account.getCompany().getId().toString();
            this.FAccountTableID = account.getAccountTable().getId().toString();
        }
        this.configQueryObjectToSolution(new AccountQueryObject(account));
    }

    public void setAccountCache(Map accountCache) {
        this.accountCache = accountCache;
    }

    class AccountQueryObject
    extends IQueryObject {
        private AccountExt accountEx;

        public AccountQueryObject(AccountExt account) {
            this.accountEx = account;
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems w = new WhereItems();
            w.addItem(new WhereItem("FNumber", this.accountEx.getAccountNumber()));
            return w;
        }

        @Override
        public SelectFieldCollection configSelectFields() {
            SelectFieldCollection sc = new SelectFieldCollection();
            sc.addSelectField(new SelectField("FID", "FID"));
            sc.addSelectField(new SelectField("FDc", "FDc"));
            sc.addSelectField(new SelectField("FIsLeaf", "FIsLeaf"));
            sc.addSelectField(new SelectField("FLevel", "FLevel"));
            sc.addSelectField(new SelectField("FNumber", "FNumber"));
            sc.addSelectField(new SelectField("FCONTROLUNITID", "FCONTROLUNITID"));
            return sc;
        }

        @Override
        public void fillValueObject(Object value) {
            this.accountEx.account = (Account)value;
            String cacheKey = this.accountEx.getCompany().getId().toString() + this.accountEx.getAccountTable().getId().toString() + this.accountEx.getAccountNumber();
            if (AccountSubQuerySolution.this.accountCache != null && !AccountSubQuerySolution.this.accountCache.containsKey(cacheKey)) {
                AccountSubQuerySolution.this.accountCache.put(cacheKey, this.accountEx.account);
            }
        }

        @Override
        public void fillValueList(Object[] objList) {
        }
    }

    class ObjectBulider
    implements IObjectBulider {
        ObjectBulider() {
        }

        @Override
        public Object bulider(Object[] value) throws Exception {
            Account account = new Account();
            account.id = value[0].toString();
            account.dc = Integer.parseInt(value[1].toString());
            account.isLeaf = value[2].toString().equals("1");
            account.level = Integer.parseInt(value[3].toString());
            account.number = value[4].toString();
            return account;
        }

        @Override
        public String[] getOrderedSelectedFields() {
            return new String[]{"FID", "FDc", "FIsLeaf", "FLevel", "FNumber", "FCONTROLUNITID"};
        }
    }
}

