/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.batch.AbstractSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.ICombineRowSetHandler;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.RowSetCombineHandler;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValueItem;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountTableQuery {
    private static Logger logger = Logger.getLogger(AccountTableQuery.class);
    private BatchHelper batchHelper;
    private IBatchSQLProcessor sqlProcessor;
    private Map accountTableCache = null;

    public AccountTableQuery(Context context) {
        this.batchHelper = new BatchHelper(context);
        this.sqlProcessor = new AccountTableQuerySQLProcessor();
    }

    public void registerFormula(AcctCalculaterExt acct) {
        this.sqlProcessor.getFormulaCalculators().add(acct);
    }

    public void executeAccountTableQuery() {
        RowSetCombineHandler combineHandler = new RowSetCombineHandler(new ICombineRowSetHandler(){

            @Override
            public void processRowSet(IRowSet rs, IFormulaCalculator formula, IBatchSQLProcessor sqlBuilder) throws SQLException {
                AcctCalculaterExt acctExt = (AcctCalculaterExt)formula;
                String accountTableNum = acctExt.getStruct().getAccountTable();
                if (StringUtils.isEmpty((String)accountTableNum)) {
                    accountTableNum = acctExt.getCompany().getAccountTable().getNumber();
                }
                String companyNum = acctExt.getCompany().getNumber();
                String cacheKey = accountTableNum + "|" + companyNum + "|" + acctExt.getStruct().getEndYear() + "|" + acctExt.getStruct().getEndPeriod();
                AccountTableInfo accountTableInfo = null;
                if (AccountTableQuery.this.accountTableCache != null && AccountTableQuery.this.accountTableCache.containsKey(cacheKey)) {
                    accountTableInfo = (AccountTableInfo)AccountTableQuery.this.accountTableCache.get(cacheKey);
                } else {
                    accountTableInfo = new AccountTableInfo();
                    accountTableInfo.setId(BOSUuid.read((String)rs.getString("Id")));
                    accountTableInfo.setSeparator(rs.getString("separator"));
                    if (AccountTableQuery.this.accountTableCache != null) {
                        AccountTableQuery.this.accountTableCache.put(cacheKey, accountTableInfo);
                    }
                }
                acctExt.setAccountTable(accountTableInfo);
            }
        });
        try {
            this.batchHelper.batchCalculateBigDecimal(this.sqlProcessor, combineHandler);
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            for (AcctCalculaterExt acctExt : this.sqlProcessor.getFormulaCalculators()) {
                acctExt.setACCTValue((Object)ex);
            }
        }
    }

    public Map getAccountTableCache() {
        return this.accountTableCache;
    }

    public void setAccountTableCache(Map accountTableCache) {
        this.accountTableCache = accountTableCache;
    }

    class AccountTableQuerySQLProcessor
    extends AbstractSQLProcessor {
        private List formulaList = new ArrayList();

        AccountTableQuerySQLProcessor() {
        }

        @Override
        public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
            AcctCalculaterExt acctExt = (AcctCalculaterExt)formula;
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(acctExt.getStruct().getAccountTable());
            Object[][] result = new Object[1][fields.size()];
            result[0] = fields.toArray();
            return result;
        }

        @Override
        public String[] getIndexResultSetFields() {
            ArrayList<String> indexedFields = new ArrayList<String>();
            indexedFields.add("number");
            String[] result = new String[indexedFields.size()];
            indexedFields.toArray(result);
            return result;
        }

        @Override
        public void buildSelectPart(Set nullSet, StringBuffer sql) {
            sql.append("SELECT FID Id, FNumber number, FSeparator separator");
        }

        @Override
        public void buildFromPart(Set nullSet, StringBuffer sql) {
            sql.append(" FROM T_Bd_AccountTable accountTable ");
        }

        @Override
        public void buildInnerJoinTempTable(StringBuffer sql, String tempTableName, ITempTableField tempTableField) {
            sql.append("\n inner join ");
            sql.append(tempTableName).append(" tempTable");
            sql.append(" on ");
            Iterator it = tempTableField.getTempTableFieldItems().iterator();
            while (it.hasNext()) {
                TempTableFieldItem tempTableFieldItem = (TempTableFieldItem)it.next();
                String fieldName = tempTableFieldItem.getField();
                String tempTableFieldName = tempTableFieldItem.getTempTableField();
                tempTableFieldName = "tempTable." + tempTableFieldName;
                sql.append(fieldName).append(" = ").append(tempTableFieldName);
                if (!it.hasNext()) continue;
                sql.append(" and ");
            }
        }

        @Override
        public ITempTableField getTempTableField() {
            TempTableField tempTableField = new TempTableField();
            tempTableField.addTempTableItem(new TempTableFieldItem("accountTable.FNumber"));
            return tempTableField;
        }

        @Override
        public ITempTableValue insertTempTableValues(IFormulaCalculator formula) {
            AcctCalculaterExt acctExt = (AcctCalculaterExt)formula;
            TempTableValue tempTableValue = new TempTableValue();
            tempTableValue.addTempTableItem(new TempTableValueItem("accountTable.FNumber", acctExt.getStruct().getAccountTable()));
            return tempTableValue;
        }

        @Override
        public boolean isUseTempTableScheme() {
            return true;
        }

        @Override
        public List getFormulaCalculators() {
            return this.formulaList;
        }
    }
}

