/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.CompanyTableCountSubQuerySolution;
import com.kingdee.eas.fi.rpt.batchquery.IObjectBulider;
import com.kingdee.eas.fi.rpt.batchquery.IQueryObject;
import com.kingdee.eas.fi.rpt.batchquery.Solution;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectField;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectFieldCollection;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class CompanyQuerySolution
extends Solution {
    private static final Logger logger = Logger.getLogger(CompanyQuerySolution.class);
    private static final String TRUE = "1";
    private CompanyTableCountSubQuerySolution ct = null;
    private Connection conn = null;
    private Map companyCache = null;

    public CompanyQuerySolution(Connection _conn) {
        super(_conn);
        this.conn = _conn;
    }

    @Override
    public WhereItems configStaticWherePart() {
        return null;
    }

    @Override
    public String configFromPart() {
        return "T_ORG_Company company left outer join t_bd_currency baseCurrency on company.FBaseCurrencyID=baseCurrency.fid  left outer join t_bd_currency reportCurrency on company.FReportCurrencyID=reportCurrency.fid left join T_BD_AccountTable accountTable on accountTable.FID = company.FAccountTableID ";
    }

    @Override
    public boolean configAutoItemIsNeedGroupBy() {
        return false;
    }

    @Override
    public IObjectBulider configDefaultObjectBuilder() {
        return new ObjectBulider();
    }

    public void add(String compNumber, AcctCalculaterExt acct) throws Exception {
        this.configQueryObjectToSolution(new Company(acct, compNumber));
    }

    @Override
    public void afterExec() throws SQLException, Exception {
        if (this.ct != null) {
            this.ct.exec();
        }
        this.rm.clearResultHouders();
        this.getQueryManager().getExportResultManager().clearFilterMap();
        this.sql.getWherePart().getAutoPartList().clear();
    }

    public void setCompanyCache(Map companyCache) {
        this.companyCache = companyCache;
    }

    public static SelectFieldCollection defineCompanyFields() {
        SelectFieldCollection sc = new SelectFieldCollection();
        sc.addSelectField(new SelectField("company.FID", "FID"));
        sc.addSelectField(new SelectField("company.FNumber", "FNumber"));
        sc.addSelectField(new SelectField("company.FIsBizUnit", "FIsBizUnit"));
        sc.addSelectField(new SelectField("company.FIsOnlyUnion", "FIsOnlyUnion"));
        sc.addSelectField(new SelectField("company.FAccountTableID", "FAccountTableID"));
        sc.addSelectField(new SelectField("company.FControlUnitID", "FControlUnitID"));
        sc.addSelectField(new SelectField("company.FAccountPeriodID", "FAccountPeriodID"));
        sc.addSelectField(new SelectField("company.FLongNumber", "FLongNumber"));
        sc.addSelectField(new SelectField("accountTable.FNumber", "tableNumber"));
        sc.addSelectField(new SelectField("accountTable.FSeparator", "tableSeparator"));
        sc.addSelectField(new SelectField("baseCurrency.FPrecision", "basePrecision"));
        sc.addSelectField(new SelectField("reportCurrency.FPrecision", "rptPrecision"));
        return sc;
    }

    class CompanyWhitIDCondition
    extends Company {
        private String id;

        public CompanyWhitIDCondition(AcctCalculaterExt _acct, String _compId) {
            super(_acct);
            this.id = _compId;
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems w = new WhereItems();
            w.addItem(new WhereItem("company.FId", this.id));
            return w;
        }

        @Override
        public void fillValueObject(Object value) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)value;
            this.acctExt.setCompany(company);
            company.setIsCompanyOrgUnit(true);
            String cacheKey = this.acctExt.getStruct().getFiOrgUnitNum();
            if (CompanyQuerySolution.this.companyCache != null && !CompanyQuerySolution.this.companyCache.containsKey(cacheKey)) {
                CompanyQuerySolution.this.companyCache.put(cacheKey, company);
            }
        }
    }

    class Company
    extends IQueryObject {
        protected AcctCalculaterExt acctExt;
        private String Number;

        protected Company(AcctCalculaterExt _acct) {
            this.acctExt = _acct;
        }

        public Company(AcctCalculaterExt _acct, String _compNumber) {
            this.acctExt = _acct;
            this.Number = _compNumber;
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems w = new WhereItems();
            w.addItem(new WhereItem("company.FNumber", this.Number));
            return w;
        }

        @Override
        public SelectFieldCollection configSelectFields() {
            return CompanyQuerySolution.defineCompanyFields();
        }

        @Override
        public void fillValueObject(Object value) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)value;
            this.acctExt.setCompany(company);
            String cacheKey = this.acctExt.getCompany().getNumber();
            if (CompanyQuerySolution.this.companyCache != null && !CompanyQuerySolution.this.companyCache.containsKey(cacheKey)) {
                CompanyQuerySolution.this.companyCache.put(cacheKey, company);
            }
        }

        @Override
        public void fillValueList(Object[] value) {
        }
    }

    class ObjectBulider
    implements IObjectBulider {
        ObjectBulider() {
        }

        @Override
        public Object bulider(Object[] value) throws Exception {
            Integer p1;
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)value[0].toString()));
            company.setNumber(value[1].toString());
            if (CompanyQuerySolution.TRUE.equals(value[2].toString())) {
                company.setIsBizUnit(true);
            } else {
                company.setIsBizUnit(false);
            }
            if (CompanyQuerySolution.TRUE.equals(value[3].toString())) {
                company.setIsOnlyUnion(true);
            } else {
                company.setIsOnlyUnion(false);
            }
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)value[4].toString()));
            company.setCU(cu);
            if (value[5] != null) {
                AccountTableInfo acTable = new AccountTableInfo();
                acTable.setId(BOSUuid.read((String)value[5].toString()));
                if (value[8] != null) {
                    acTable.setNumber(value[8].toString());
                }
                if (value[11] != null) {
                    acTable.setSeparator(value[11].toString());
                }
                company.setAccountTable(acTable);
            }
            PeriodTypeInfo pti = new PeriodTypeInfo();
            pti.setId(BOSUuid.read((String)value[6].toString()));
            company.setAccountPeriodType(pti);
            company.setLongNumber(value[7].toString());
            Object obj = value[9];
            if (obj != null && obj.toString().trim().length() > 0) {
                p1 = new Integer(obj.toString());
                company.put("GLC", (Object)p1);
            }
            if ((obj = value[10]) != null && obj.toString().trim().length() > 0) {
                p1 = new Integer(obj.toString());
                company.put("GRC", (Object)p1);
            }
            return company;
        }

        @Override
        public String[] getOrderedSelectedFields() {
            return new String[]{"FID", "FNumber", "FIsBizUnit", "FIsOnlyUnion", "FControlUnitID", "FAccountTableID", "FAccountPeriodID", "FLongNumber", "tableNumber", "basePrecision", "rptPrecision", "tableSeparator"};
        }
    }
}

