/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AcctStruct;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.IContainCompany;
import com.kingdee.eas.fi.rpt.batchquery.IObjectBulider;
import com.kingdee.eas.fi.rpt.batchquery.IQueryObject;
import com.kingdee.eas.fi.rpt.batchquery.Solution;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectField;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectFieldCollection;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProfitCenterQuerySolution
extends Solution {
    private static final Logger logger = Logger.getLogger(ProfitCenterQuerySolution.class);
    private static final String TRUE = "1";
    private Connection conn = null;
    private Map companyCache = null;
    private Set<AcctCalculaterExt> acctFormulas;

    public ProfitCenterQuerySolution(Connection _conn) {
        super(_conn);
        this.conn = _conn;
        this.acctFormulas = new HashSet<AcctCalculaterExt>(3);
    }

    @Override
    public WhereItems configStaticWherePart() {
        return null;
    }

    @Override
    public String configFromPart() {
        return "T_Org_ProfitCenter company  join t_org_UnitRelation ur on ur.FFromUnitId = company.fid join T_Org_TypeRelation tr on tr.fid = ur.FTypeRelationID and tr.FFromType = 6 and tr.FToType = 1 join T_ORG_Company delegatedCompany on delegatedCompany.fid = ur.FToUnitID  left outer join t_bd_currency baseCurrency on delegatedCompany.FBaseCurrencyID=baseCurrency.fid   left outer join t_bd_currency reportCurrency on delegatedCompany.FReportCurrencyID=reportCurrency.fid  left outer join T_BD_AccountTable accountTable on accountTable.FID = delegatedCompany.FAccountTableID ";
    }

    @Override
    public boolean configAutoItemIsNeedGroupBy() {
        return false;
    }

    @Override
    public IObjectBulider configDefaultObjectBuilder() {
        return new ObjectBulider();
    }

    public void add(String compNumber, AcctCalculaterExt acct) throws Exception {
        this.acctFormulas.add(acct);
        this.configQueryObjectToSolution(new Company((IContainCompany)acct, compNumber));
    }

    public void add(String compNum, QueryedCompany queryedCompany) throws Exception {
        IContainCompany acct = queryedCompany.createCellCompany();
        this.configQueryObjectToSolution(new Company(acct, compNum));
    }

    @Override
    public void afterExec() throws SQLException, Exception {
        this.rm.clearResultHouders();
        this.getQueryManager().getExportResultManager().clearFilterMap();
        this.sql.getWherePart().getAutoPartList().clear();
    }

    public void setCompanyCache(Map companyCache) {
        this.companyCache = companyCache;
    }

    public static SelectFieldCollection defineCompanyFields() {
        SelectFieldCollection sc = new SelectFieldCollection();
        sc.addSelectField(new SelectField("company.FID", "FID"));
        sc.addSelectField(new SelectField("company.FNumber", "FNumber"));
        sc.addSelectField(new SelectField("company.FIsBizUnit", "FIsBizUnit"));
        sc.addSelectField(new SelectField("delegatedCompany.FId", "FCompanyID"));
        sc.addSelectField(new SelectField("delegatedCompany.FLongNumber", "FCompanyLongNumber"));
        sc.addSelectField(new SelectField("delegatedCompany.FIsOnlyUnion", "FIsOnlyUnion"));
        sc.addSelectField(new SelectField("delegatedCompany.FAccountTableID", "FAccountTableID"));
        sc.addSelectField(new SelectField("company.FControlUnitID", "FControlUnitID"));
        sc.addSelectField(new SelectField("delegatedCompany.FAccountPeriodID", "FAccountPeriodID"));
        sc.addSelectField(new SelectField("company.FLongNumber", "FLongNumber"));
        sc.addSelectField(new SelectField("accountTable.FNumber", "tableNumber"));
        sc.addSelectField(new SelectField("accountTable.FSeparator", "tableSeparator"));
        sc.addSelectField(new SelectField("baseCurrency.FPrecision", "basePrecision"));
        sc.addSelectField(new SelectField("reportCurrency.FPrecision", "rptPrecision"));
        return sc;
    }

    public void handleVirutalProfitCenter(Context ctx) throws BOSException {
        logger.error((Object)"start handle_virutal_profitCenter");
        HashMap<String, CompanyOrgUnitInfo> virtualProfitCenters = new HashMap<String, CompanyOrgUnitInfo>(5);
        String companyLongNumber = null;
        this.setVirutalProfitCenterInfoToAcct(ctx);
        for (AcctCalculaterExt formula : this.acctFormulas) {
            if (formula.getCompany() == null || formula.getCompany().isIsBizUnit()) continue;
            companyLongNumber = formula.getCompany().getLongNumber();
            logger.error((Object)("find one virutal profitCenter:" + companyLongNumber));
            if (virtualProfitCenters.containsKey(companyLongNumber)) {
                logger.error((Object)("find a same company for different formula " + formula + ",update formula's company!"));
                formula.setCompany((CompanyOrgUnitInfo)virtualProfitCenters.get(companyLongNumber));
                continue;
            }
            virtualProfitCenters.put(companyLongNumber, formula.getCompany());
        }
        logger.error((Object)("find " + virtualProfitCenters.size() + " virtual profitCenter."));
        logger.error((Object)"start handle virutal profitCenter");
        Map<String, String> longNumber2FILongNumbers = this.queryCommonFICompany(ctx, virtualProfitCenters.keySet());
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add("id");
        selectors.add("isOnlyUnion");
        selectors.add("accountPeriod.id");
        selectors.add("accountTable.id");
        selectors.add("accountTable.number");
        selectors.add("accountTable.separator");
        selectors.add("accountPeriodType.id");
        selectors.add("baseCurrency.precision");
        selectors.add("reportCurrency.precision");
        for (CompanyOrgUnitInfo company : virtualProfitCenters.values()) {
            String fiCompanyLongNumber = longNumber2FILongNumbers.get(company.getLongNumber());
            if (fiCompanyLongNumber == null) {
                logger.error((Object)("profitcenter " + company + " no_find_common_fi_company[key]"));
                continue;
            }
            view.setFilter(new FilterInfo());
            view.getFilter().appendFilterItem("longNumber", (Object)fiCompanyLongNumber);
            logger.error((Object)("update ficompany filter:" + view));
            CompanyOrgUnitCollection fiCompanys = icompany.getCompanyOrgUnitCollection(view);
            if (fiCompanys.isEmpty()) {
                logger.error((Object)(" ficompany_not_exist[key],long number is " + fiCompanyLongNumber));
                continue;
            }
            CompanyOrgUnitInfo fiCompany = fiCompanys.get(0);
            logger.error((Object)("update_profitcenter_ficompany[key](" + fiCompany + ")"));
            company.setIsOnlyUnion(!company.isIsBizUnit());
            company.setAccountTable(fiCompany.getAccountTable());
            company.setAccountPeriodType(fiCompany.getAccountPeriodType());
            company.put("GLC", (Object)fiCompany.getBaseCurrency().getPrecision());
            if (fiCompany.getReportCurrency() != null) {
                company.put("GRC", (Object)fiCompany.getReportCurrency().getPrecision());
            } else {
                company.put("GRC", (Object)fiCompany.getBaseCurrency().getPrecision());
            }
            company.put("DELEGATED_COMPANY_ID", (Object)fiCompany.getId().toString());
            company.put("DELEGATED_COMPANY_LONG_NUMBER", (Object)fiCompanyLongNumber);
        }
        logger.error((Object)"end handle_virutal_profitCenter[key]");
    }

    private Map<String, String> queryCommonFICompany(Context ctx, Collection<String> profitCenterLongNumbers) throws BOSException {
        logger.error((Object)"start queryCommonFICompany");
        HashMap<String, String> longNumber2FILongNumbers = new HashMap<String, String>(profitCenterLongNumbers.size());
        if (profitCenterLongNumbers.isEmpty()) {
            logger.error((Object)"profitCenterLongNumbers is empty.");
            return longNumber2FILongNumbers;
        }
        HashMap longNumber2FICompany = new HashMap(profitCenterLongNumbers.size());
        StringBuffer sql = new StringBuffer();
        sql.append("\tSELECT \tdelegatedCompany.fLongNumber company_longNumber,company.FLongNumber profit_longNumber    \n");
        sql.append("\tFROM T_Org_ProfitCenter company    \n");
        sql.append("    INNER JOIN t_org_UnitRelation ur    \n");
        sql.append("        ON ur.FFromUnitId = company.fid    \n");
        sql.append("    INNER JOIN T_Org_TypeRelation tr    \n");
        sql.append("        ON ((tr.fid = ur.FTypeRelationID AND tr.FFromType = 6) AND    \n");
        sql.append("           tr.FToType = 1)    \n");
        sql.append("    INNER JOIN T_ORG_Company delegatedCompany    \n");
        sql.append("        ON delegatedCompany.fid = ur.FToUnitID    \n");
        sql.append("\tWHERE\t\n");
        for (String longNumber : profitCenterLongNumbers) {
            sql.append(" company.FLongNumber like concat('").append(longNumber).append("', '!%') \n");
            sql.append(" OR ");
        }
        sql.delete(sql.length() - 4, sql.length());
        logger.error((Object)("sql is " + sql));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String companyLongNumber = rs.getString("company_longNumber");
                String profitLongNumber = rs.getString("profit_longNumber");
                logger.error((Object)(" find one record:(" + companyLongNumber + "," + profitLongNumber + ")"));
                if (profitLongNumber == null || companyLongNumber == null) {
                    logger.error((Object)"omit empty record");
                    continue;
                }
                for (String longNumber : profitCenterLongNumbers) {
                    if (!profitLongNumber.startsWith(longNumber)) continue;
                    logger.error((Object)("this_longnumber_match[key] " + longNumber));
                    if (longNumber2FICompany.containsKey(longNumber)) {
                        ((Collection)longNumber2FICompany.get(longNumber)).add(companyLongNumber);
                        continue;
                    }
                    HashSet<String> fiCompanys = new HashSet<String>(5);
                    fiCompanys.add(companyLongNumber);
                    longNumber2FICompany.put(longNumber, fiCompanys);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        logger.error((Object)("match collection is " + longNumber2FICompany));
        for (Map.Entry entry : longNumber2FICompany.entrySet()) {
            String commonNumber = this.findCommonLongNumber((Collection)entry.getValue());
            if (commonNumber == null) {
                logger.error((Object)("fail_find_commonFICompanyNumber[key] for " + entry));
                continue;
            }
            logger.error((Object)("set_commonFICompanyNumber[key] for " + (String)entry.getKey()));
            longNumber2FILongNumbers.put((String)entry.getKey(), commonNumber);
        }
        logger.error((Object)"end queryCommonFICompany");
        return longNumber2FILongNumbers;
    }

    private String findCommonLongNumber(Collection<String> numbers) {
        String commonNumber = null;
        int commonNumberLevel = 0;
        logger.error((Object)(" ready to find common number in " + numbers));
        for (String number : numbers) {
            if (commonNumber == null) {
                commonNumber = number;
                commonNumberLevel = commonNumber.replaceAll("[^!]", "").length();
                logger.error((Object)(" set_common_number[key] as  " + number + ",level is " + commonNumberLevel));
                continue;
            }
            if (number.replaceAll("[^!]", "").length() > commonNumberLevel) {
                logger.error((Object)(" omit_longer_number[key] " + number));
                continue;
            }
            if (number.replaceAll("[^!]", "").length() < commonNumberLevel) {
                commonNumber = number;
                commonNumberLevel = commonNumber.replaceAll("[^!]", "").length();
                logger.error((Object)(" set_common_number[key] as  " + number + ",level is " + commonNumberLevel));
                continue;
            }
            if (number.equals(commonNumber)) {
                logger.error((Object)" this number_same[key] as common number ");
                continue;
            }
            int lastCharPos = number.lastIndexOf("!");
            if (lastCharPos == -1) {
                logger.error((Object)(" no_common_number[key] for (" + number + "," + commonNumber + ")"));
                return null;
            }
            commonNumber = number.substring(0, lastCharPos);
            commonNumberLevel = commonNumber.replaceAll("[^!]", "").length();
            logger.error((Object)(" set_common_number[key] as  " + number + ",level is " + commonNumberLevel));
        }
        logger.error((Object)(" find_common_number[key] as  " + commonNumber));
        return commonNumber;
    }

    private void setVirutalProfitCenterInfoToAcct(Context ctx) throws BOSException {
        HashSet<String> companyNumberSet = new HashSet<String>();
        for (AcctCalculaterExt formula : this.acctFormulas) {
            if (formula.getCompany() != null) continue;
            String number = formula.getStruct().getCompanyNumber();
            companyNumberSet.add(number);
        }
        if (companyNumberSet.size() > 0) {
            ParamTempTblService service = this.getParamTempTblService(ctx, companyNumberSet);
            String tblName = service.getTmpTableName();
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT profit.FID FID,profit.FNumber FNumber,profit.FIsBizUnit FIsBizUnit,profit.FLongNumber FLongNumber, \n").append(" profit.FControlUnitID FControlUnitID \n").append(" FROM T_ORG_ProfitCenter profit \n").append(" INNER JOIN ").append(tblName).append(" temp ON temp.FNumber = profit.FNumber \n").append(" WHERE profit.FIsBizUnit = 0 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    String profitNumber = rs.getString("FNumber");
                    String longNumber = rs.getString("FLongNumber");
                    String id = rs.getString("FID");
                    boolean isbizunit = Boolean.valueOf(rs.getString("FIsBizUnit"));
                    String cuID = rs.getString("FControlUnitID");
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)cuID));
                    for (AcctCalculaterExt formula : this.acctFormulas) {
                        String number = formula.getStruct().getCompanyNumber();
                        if (formula.getCompany() != null || !profitNumber.equals(number)) continue;
                        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                        company.setId(BOSUuid.read((String)id));
                        company.setNumber(number);
                        company.setIsBizUnit(isbizunit);
                        company.setLongNumber(longNumber);
                        company.setIsProfitOrgUnit(true);
                        company.setIsCompanyOrgUnit(false);
                        company.setCU(cu);
                        formula.setCompany(company);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                service.release();
            }
        }
    }

    private ParamTempTblService getParamTempTblService(Context ctx, Collection ids) {
        TableInfo table = new TableInfo("t_temp_comNumber");
        table.addColumn(new ColumnInfo("fnumber", "nvarchar(80)"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)ids, null);
        return service;
    }

    private static class ContainCompanyCell
    implements IContainCompany {
        CompanyOrgUnitInfo company;

        private ContainCompanyCell() {
        }

        public void setCompany(CompanyOrgUnitInfo company) {
            this.company = company;
        }

        public CompanyOrgUnitInfo getCompany() {
            return this.company;
        }

        public Object getExtendProps(String key) {
            return null;
        }
    }

    public static class QueryedCompany {
        Collection<IContainCompany> cellCompanys = new HashSet<IContainCompany>(5);

        public IContainCompany createCellCompany() {
            ContainCompanyCell cell = new ContainCompanyCell();
            this.cellCompanys.add(cell);
            return cell;
        }

        public CompanyOrgUnitCollection all() {
            CompanyOrgUnitCollection companys = new CompanyOrgUnitCollection();
            for (IContainCompany cell : this.cellCompanys) {
                if (cell.getCompany() == null) continue;
                companys.add(cell.getCompany());
            }
            return companys;
        }
    }

    class CompanyWhitIDCondition
    extends Company {
        private String id;

        public CompanyWhitIDCondition(AcctCalculaterExt _acct, String _compId) {
            super(_acct);
            this.id = _compId;
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems w = new WhereItems();
            w.addItem(new WhereItem("company.FId", this.id));
            return w;
        }

        @Override
        public void fillValueObject(Object value) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)value;
            this.acctExt.setCompany(company);
            company.setIsProfitOrgUnit(true);
            String cacheKey = ((AcctStruct)this.acctExt.getExtendProps("STRUCT")).getFiOrgUnitNum();
            if (ProfitCenterQuerySolution.this.companyCache != null && !ProfitCenterQuerySolution.this.companyCache.containsKey(cacheKey)) {
                ProfitCenterQuerySolution.this.companyCache.put(cacheKey, company);
            }
        }
    }

    class Company
    extends IQueryObject {
        protected IContainCompany acctExt;
        private String Number;

        protected Company(AcctCalculaterExt _acct) {
            this.acctExt = _acct;
        }

        public Company(IContainCompany _acct, String _compNumber) {
            this.acctExt = _acct;
            this.Number = _compNumber;
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems w = new WhereItems();
            w.addItem(new WhereItem("company.FNumber", this.Number));
            return w;
        }

        @Override
        public SelectFieldCollection configSelectFields() {
            return ProfitCenterQuerySolution.defineCompanyFields();
        }

        @Override
        public void fillValueObject(Object value) {
            CompanyOrgUnitInfo company = null;
            if (!(value instanceof CompanyOrgUnitInfo)) {
                logger.error((Object)" when finding profit center org,finded object is not company.");
                return;
            }
            company = (CompanyOrgUnitInfo)value;
            this.acctExt.setCompany(company);
            String cacheKey = this.acctExt.getCompany().getNumber();
            if (ProfitCenterQuerySolution.this.companyCache != null && !ProfitCenterQuerySolution.this.companyCache.containsKey(cacheKey)) {
                ProfitCenterQuerySolution.this.companyCache.put(cacheKey, company);
            }
        }

        @Override
        public void fillValueList(Object[] value) {
        }
    }

    class ObjectBulider
    implements IObjectBulider {
        ObjectBulider() {
        }

        @Override
        public Object bulider(Object[] value) throws Exception {
            Integer p1;
            Object obj;
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setIsProfitOrgUnit(true);
            company.setIsCompanyOrgUnit(false);
            company.setId(BOSUuid.read((String)value[0].toString()));
            company.setNumber(value[1].toString());
            company.setIsBizUnit(ProfitCenterQuerySolution.TRUE.equals(value[2].toString()));
            if (value[3] != null) {
                company.setIsOnlyUnion(ProfitCenterQuerySolution.TRUE.equals(value[3].toString()));
            }
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)value[4].toString()));
            company.setCU(cu);
            if (value[5] != null) {
                AccountTableInfo acTable = new AccountTableInfo();
                acTable.setId(BOSUuid.read((String)value[5].toString()));
                acTable.setNumber(value[8].toString());
                acTable.setSeparator(value[11].toString());
                company.setAccountTable(acTable);
            }
            if (value[6] != null) {
                PeriodTypeInfo pti = new PeriodTypeInfo();
                pti.setId(BOSUuid.read((String)value[6].toString()));
                company.setAccountPeriodType(pti);
            }
            if (value[7] != null) {
                company.setLongNumber(value[7].toString());
            }
            if ((obj = value[9]) != null && obj.toString().trim().length() > 0) {
                p1 = new Integer(obj.toString());
                company.put("GLC", (Object)p1);
            }
            if ((obj = value[10]) != null && obj.toString().trim().length() > 0) {
                p1 = new Integer(obj.toString());
                company.put("GRC", (Object)p1);
            }
            if ((obj = value[12]) != null && obj.toString().trim().length() > 0) {
                company.put("DELEGATED_COMPANY_ID", obj);
            }
            if ((obj = value[13]) != null && obj.toString().trim().length() > 0) {
                company.put("DELEGATED_COMPANY_LONG_NUMBER", obj);
            }
            return company;
        }

        @Override
        public String[] getOrderedSelectedFields() {
            return new String[]{"FID", "FNumber", "FIsBizUnit", "FIsOnlyUnion", "FControlUnitID", "FAccountTableID", "FAccountPeriodID", "FLongNumber", "tableNumber", "basePrecision", "rptPrecision", "tableSeparator", "FCompanyID", "FCompanyLongNumber"};
        }
    }
}

