/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.CalculatorCombiner;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.SQLStringWrapper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdjustDataCalculator
extends AbstractCalculator {
    private static Logger logger = Logger.getLogger(AdjustDataCalculator.class);
    private Set orgTreeNumberSet;
    private boolean isSupportOtherDS = false;
    private PeriodCollection fiscalPeriods = null;
    private boolean isMergeByFiscalPeriod = false;
    private boolean isSupport13Period = false;
    private String autoParentItem = null;
    private String autoParentItem2 = null;

    public AdjustDataCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
        String autoParentItemStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"98_AdjustDynamicItemControllerBean", (Locale)serverCtx.getOriginLocale());
        this.autoParentItem = "'" + autoParentItemStr + "'";
        this.autoParentItem2 = "'" + autoParentItemStr + " *'";
        this.isSupportOtherDS = CslRptUtil.isSupportOtherDSServer((Context)this.serverContext);
        this.isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod((Context)serverCtx);
        this.fiscalPeriods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)serverCtx, (ICalculateContextProvider)context);
        this.isSupport13Period = CslRptUtil.isSupport13Period((Context)serverCtx);
    }

    private void calculateNew() throws Exception {
        List formulas = this.getFormulaCalculatorParameterList();
        HashMap<String, List<AdjustData>> itemSame_Map = new HashMap<String, List<AdjustData>>();
        ArrayList<AdjustData> itemNotSame_List = new ArrayList<AdjustData>();
        List<AdjustData> formulaList = null;
        AdjustData adjustData = null;
        String key = null;
        for (Object obj : formulas) {
            adjustData = (AdjustData)obj;
            if (adjustData.startItemNumber.equals(adjustData.endItemNumber)) {
                key = this.getKey(adjustData);
                formulaList = (List)itemSame_Map.get(key);
                if (formulaList == null) {
                    formulaList = new ArrayList<AdjustData>();
                    itemSame_Map.put(key, formulaList);
                }
                formulaList.add(adjustData);
                continue;
            }
            itemNotSame_List.add(adjustData);
        }
        Iterator iterator = itemSame_Map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            formulaList = (ArrayList<AdjustData>)next.getValue();
            if (formulaList.size() >= 10) continue;
            itemNotSame_List.addAll((Collection<AdjustData>)formulaList);
            iterator.remove();
        }
        if (!itemNotSame_List.isEmpty()) {
            this.calculate(itemNotSame_List);
            itemNotSame_List.clear();
        }
        if (!itemSame_Map.isEmpty()) {
            this.calculateByGroup(itemSame_Map);
            itemSame_Map.clear();
        }
    }

    private String getKey(AdjustData adjustData) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (adjustData.orgBoundIDSet != null && !adjustData.orgBoundIDSet.isEmpty()) {
            sb.append(adjustData.orgBoundIDSet.toString());
        }
        sb.append(adjustData.orgUnitNumber);
        sb.append(adjustData.currencyNumber);
        sb.append(adjustData.sourceCurrencyNumber);
        sb.append(adjustData.int_periodType);
        sb.append(adjustData.year);
        sb.append(adjustData.startPeriod);
        sb.append(adjustData.endPeriod);
        sb.append(adjustData.int_dataSource);
        sb.append(adjustData.int_dataElement);
        sb.append(adjustData.int_valueType);
        sb.append(adjustData.isIncldUnAudit);
        sb.append(adjustData.dataCollectNumber);
        return sb.toString();
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        try {
            this.calculateNew();
        }
        catch (Exception e) {
            logger.error((Object)"adjustData calcu error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void calculateByGroup(Map<String, List<AdjustData>> itemSame_Map) throws Exception {
        List<AdjustData> calList = null;
        for (String key : itemSame_Map.keySet()) {
            SQLStringWrapper sql;
            TempTablePool pool;
            String tableName;
            block15: {
                calList = itemSame_Map.get(key);
                tableName = null;
                pool = null;
                if (calList.size() > 50) {
                    pool = TempTablePool.getInstance((Context)this.serverContext);
                    tableName = pool.createTempTable("create table itemTable(fid nvarchar(100))");
                    ArrayList<Object[]> tmpParams = new ArrayList<Object[]>();
                    for (AdjustData adjustData : calList) {
                        if (adjustData.isException()) continue;
                        tmpParams.add(new Object[]{adjustData.startItemNumber});
                    }
                    CslRptUtil.executeBatch((Context)this.serverContext, (String)("insert into " + tableName + "(fid) values(?)"), tmpParams);
                    tmpParams.clear();
                }
                if ((sql = this.createCalculateSQL_sameItemByGroup(calList, tableName)) != null) break block15;
                this.handleAllException();
                if (!StringUtils.isEmpty((String)tableName)) {
                    pool.releaseTable(tableName);
                }
                return;
            }
            try {
                CalculatorCombiner combiner = new CalculatorCombiner();
                this.preparePropertyMap(calList, combiner);
                CombineState state = new CombineState();
                combiner.setPrepareState(state);
                IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.getSQLString(), (Object[])sql.getArrayParams());
                PropertyContainer property = new PropertyContainer(8);
                while (rs.next()) {
                    BigDecimal debit;
                    int dataSource = rs.getInt("DataSource");
                    property.put("DataElement", (Object)new Integer(rs.getInt("DataElement")));
                    property.put("DataSource", (Object)new Integer(dataSource));
                    property.put("PeriodType", (Object)new Integer(rs.getInt("PeriodType")));
                    property.put("EntryYear", (Object)new Integer(rs.getInt("EntryYear")));
                    property.put("ValueType", (Object)new Integer(rs.getInt("ValueType")));
                    property.put("DataCollectNumber", (Object)rs.getString("DataCollectNumber"));
                    property.put("CompanyNumber", (Object)rs.getString("CompanyNumber"));
                    property.put("SourceCurrencyNumber", (Object)rs.getString("SourceCurrencyNumber"));
                    property.put("CurrencyNumber", (Object)rs.getString("CurrencyNumber"));
                    property.put("DataCollectNumber", (Object)rs.getString("DataCollectNumber"));
                    BigDecimal credit = rs.getBigDecimal("Credit");
                    if (credit == null) {
                        credit = CslConstant.BGZERO;
                    }
                    if ((debit = rs.getBigDecimal("Debit")) == null) {
                        debit = CslConstant.BGZERO;
                    }
                    state.setCheckStatus(rs.getInt("CheckedStatus"));
                    state.setCredit(credit);
                    state.setDebit(debit);
                    state.setItemNumber(rs.getString("ItemNumber"));
                    state.setOrgBoundID(rs.getString("OrgBoundID"));
                    state.setPeriod(rs.getInt("EntryPeriod"));
                    if (!(dataSource != 1 && dataSource != 7 || combiner.getPropertyToCalculatorMap().containsKey(property))) {
                        int realDataSource = 1;
                        if (dataSource == 1) {
                            realDataSource = 7;
                        }
                        property.put("DataSource", (Object)new Integer(realDataSource));
                        combiner.combineValue(property);
                        continue;
                    }
                    combiner.combineValue(property);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"adjust sql error", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!StringUtils.isEmpty(tableName)) {
                        pool.releaseTable(tableName);
                    }
                    throw throwable;
                }
            }
            if (StringUtils.isEmpty((String)tableName)) continue;
            pool.releaseTable(tableName);
        }
    }

    protected void calculate(List<AdjustData> formulas) throws Exception {
        int batch_size = 130;
        int i = 0;
        while (i < formulas.size()) {
            ArrayList<AdjustData> calList = new ArrayList<AdjustData>();
            for (int j = 0; j < batch_size && i < formulas.size(); ++j) {
                calList.add(formulas.get(i++));
            }
            SQLStringWrapper sql = this.createCalculateSQL(calList);
            if (sql == null) {
                this.handleAllException();
                return;
            }
            CalculatorCombiner combiner = new CalculatorCombiner();
            this.preparePropertyMap(calList, combiner);
            CombineState state = new CombineState();
            combiner.setPrepareState(state);
            IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.getSQLString(), (Object[])sql.getArrayParams());
            PropertyContainer property = new PropertyContainer(8);
            try {
                while (rs.next()) {
                    BigDecimal debit;
                    int dataSource = rs.getInt("DataSource");
                    property.put("DataElement", (Object)new Integer(rs.getInt("DataElement")));
                    property.put("DataSource", (Object)new Integer(dataSource));
                    property.put("PeriodType", (Object)new Integer(rs.getInt("PeriodType")));
                    property.put("EntryYear", (Object)new Integer(rs.getInt("EntryYear")));
                    property.put("ValueType", (Object)new Integer(rs.getInt("ValueType")));
                    property.put("DataCollectNumber", (Object)rs.getString("DataCollectNumber"));
                    property.put("CompanyNumber", (Object)rs.getString("CompanyNumber"));
                    property.put("SourceCurrencyNumber", (Object)rs.getString("SourceCurrencyNumber"));
                    property.put("CurrencyNumber", (Object)rs.getString("CurrencyNumber"));
                    property.put("DataCollectNumber", (Object)rs.getString("DataCollectNumber"));
                    BigDecimal credit = rs.getBigDecimal("Credit");
                    if (credit == null) {
                        credit = CslConstant.BGZERO;
                    }
                    if ((debit = rs.getBigDecimal("Debit")) == null) {
                        debit = CslConstant.BGZERO;
                    }
                    state.setCheckStatus(rs.getInt("CheckedStatus"));
                    state.setCredit(credit);
                    state.setDebit(debit);
                    state.setItemNumber(rs.getString("ItemNumber"));
                    state.setOrgBoundID(rs.getString("OrgBoundID"));
                    state.setPeriod(rs.getInt("EntryPeriod"));
                    if (!(dataSource != 1 && dataSource != 7 || combiner.getPropertyToCalculatorMap().containsKey(property))) {
                        int realDataSource = 1;
                        if (dataSource == 1) {
                            realDataSource = 7;
                        }
                        property.put("DataSource", (Object)new Integer(realDataSource));
                        combiner.combineValue(property);
                        continue;
                    }
                    combiner.combineValue(property);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void preparePropertyMap(List formulaCalculatorParameterList, CalculatorCombiner combiner) {
        for (AdjustData adjustData : formulaCalculatorParameterList) {
            PropertyContainer property = new PropertyContainer(8);
            property.put("DataElement", (Object)new Integer(adjustData.int_dataElement));
            property.put("DataSource", (Object)new Integer(adjustData.int_dataSource));
            property.put("PeriodType", (Object)new Integer(adjustData.int_periodType));
            property.put("EntryYear", (Object)new Integer(adjustData.year));
            property.put("ValueType", (Object)new Integer(adjustData.int_valueType));
            property.put("DataCollectNumber", (Object)adjustData.dataCollectNumber);
            property.put("CompanyNumber", (Object)adjustData.orgUnitNumber);
            property.put("SourceCurrencyNumber", (Object)adjustData.sourceCurrencyNumber);
            property.put("CurrencyNumber", (Object)adjustData.currencyNumber);
            property.put("DataCollectNumber", (Object)adjustData.dataCollectNumber);
            combiner.addFormulaParameter(property, (IFormulaCalculator)adjustData);
        }
    }

    private void buildSqlHead(StringBuffer sql, boolean isByGroup) throws Exception {
        sql.append("Select ISNULL(sum(Entry.FDebit),0) as Debit,ISNULL(sum(Entry.FCredit),0) as Credit\t\n");
        sql.append(",Item.FNumber as ItemNumber\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Entry.FdataElement as DataElement\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Adjust.FDataSource as DataSource\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Adjust.FPeriodType as PeriodType\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Adjust.FYear as EntryYear\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Adjust.FPeriod as EntryPeriod\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Adjust.FCheckedStatus as CheckedStatus\t\t\t\t\t\t\t\t\n");
        sql.append(",Adjust.FvalueType as ValueType\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Adjust.FDataCollectNumber as DataCollectNumber\t\t\t\t\t\t\n");
        sql.append(",Adjust.FOrgBoundID as OrgBoundID\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Company.Fnumber as CompanyNumber\t\t\t\t\t\t\t\t\t\n");
        sql.append(",SourceCurrency.Fnumber as SourceCurrencyNumber\t\t\t\t\t\t\n");
        sql.append(",Currency.Fnumber as CurrencyNumber\t\t\t\t\t\t\t\t\t\n");
        sql.append(",Adjust.FDataCollectNumber as DataCollectNumber\t\t\t\t\t\t\n");
        sql.append("from T_CSL_ADJUSTENTRY Entry\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("inner join T_CSL_RPTITEM Item on Entry.FitemID = item.FID\t\t\t\n");
        sql.append("inner join T_CSL_ADJUST Adjust on Entry.FAdjustID = Adjust.FID\t\t\n");
        sql.append("inner join T_ORG_BASEUNIT Company on Adjust.FOrgUnit = Company.FID\t\n");
        sql.append("inner join T_BD_CURRENCY SourceCurrency on Adjust.FSourceCurrencyID = SourceCurrency.FID \t\n");
        sql.append("inner join T_BD_CURRENCY Currency on Adjust.FCurrencyID = Currency.FID \t\n");
        sql.append("where \t\t\n");
    }

    private void buildSqlCommWhere(AdjustData adjustData, StringBuffer sql, List params) throws Exception {
        sql.append(" Entry.FdataElement= ? \t\n");
        params.add(new Integer(adjustData.int_dataElement));
        if (adjustData.int_dataSource == 7 || adjustData.int_dataSource == 1) {
            sql.append(" and ( Adjust.FDataSource = ? or Adjust.FDataSource = ? ) ");
            params.add(new Integer(7));
            params.add(new Integer(1));
        } else {
            sql.append(" and Adjust.FDataSource = ? ");
            params.add(new Integer(adjustData.int_dataSource));
        }
        sql.append(" and Adjust.FPeriodType = ? ");
        params.add(new Integer(adjustData.int_periodType));
        sql.append(" and Adjust.FYear = ? ");
        params.add(new Integer(adjustData.year));
        sql.append(" and Adjust.FPeriod >= ? ");
        params.add(new Integer(adjustData.startPeriod));
        sql.append(" and Adjust.FPeriod <= ? ");
        params.add(new Integer(adjustData.endPeriod));
        if (!adjustData.isIncldUnAudit) {
            sql.append(" and Adjust.FCheckedStatus = ? ");
            params.add(new Integer(2));
        }
        sql.append(" and Adjust.FvalueType= ? ");
        params.add(new Integer(adjustData.int_valueType));
        sql.append(" and Adjust.FOrgBoundID in ");
        sql.append(this.batchHelper.createInSql(adjustData.orgBoundIDSet.iterator()));
        sql.append(" \n");
        sql.append(" and Company.FNumber = ?\t\t\n");
        params.add(adjustData.orgUnitNumber);
        sql.append(" and Currency.FNumber = ? \t\t\n");
        params.add(adjustData.currencyNumber);
        sql.append(" and SourceCurrency.FNumber = ? \n");
        params.add(adjustData.sourceCurrencyNumber);
        sql.append(" and Adjust.FDataCollectNumber= ?   \n");
        params.add(adjustData.dataCollectNumber);
    }

    private void buildSqlGroup(StringBuffer sql, boolean isByGroup) throws Exception {
        sql.append("group by Item.FNumber ");
        sql.append(",Entry.FdataElement,Adjust.FDataSource,Adjust.FPeriodType,Adjust.FYear\t\n");
        sql.append(",Adjust.FPeriod,Adjust.FCheckedStatus,Adjust.FvalueType,Adjust.FdataCollectNumber,Adjust.FOrgBoundID\t\t\n");
        sql.append(",Company.Fnumber,SourceCurrency.Fnumber,Currency.Fnumber");
    }

    private SQLStringWrapper createCalculateSQL_sameItemByGroup(List<AdjustData> formulas, String tableName) throws Exception {
        StringBuffer sql = new StringBuffer();
        this.buildSqlHead(sql, true);
        ArrayList params = new ArrayList();
        this.buildSqlCommWhere(formulas.get(0), sql, params);
        if (StringUtils.isEmpty((String)tableName)) {
            StringBuffer inStr = new StringBuffer();
            for (AdjustData adjustData : formulas) {
                if (adjustData.isException()) continue;
                if (inStr.length() > 0) {
                    inStr.append(",");
                }
                inStr.append("'").append(adjustData.startItemNumber).append("'");
            }
            sql.append(" and Item.FNumber in\t(").append(inStr).append(")");
        } else {
            sql.append(" and Item.FNumber in (select fid from ").append(tableName).append(" itemTable )");
        }
        this.buildSqlGroup(sql, true);
        SQLStringWrapper result = new SQLStringWrapper(sql.toString(), params);
        return result;
    }

    private SQLStringWrapper createCalculateSQL(List<AdjustData> formulas) throws Exception {
        StringBuffer sql = new StringBuffer();
        this.buildSqlHead(sql, false);
        ArrayList<String> params = new ArrayList<String>();
        boolean addOr = false;
        for (AdjustData adjustData : formulas) {
            if (adjustData.isException()) continue;
            if (addOr) {
                sql.append("OR    \n");
            } else {
                addOr = true;
            }
            sql.append("(((Item.FNumber >= ?\t\t\n");
            params.add(adjustData.startItemNumber);
            sql.append("and Item.FNumber <= ?\t\n");
            params.add(adjustData.endItemNumber);
            sql.append("and (Entry.FSUMMARY is null or (Entry.FSUMMARY <>" + this.autoParentItem + " and Entry.FSUMMARY <>" + this.autoParentItem2 + " ))) \t\t\n");
            sql.append("or Item.FNumber = ?) \t\t\n");
            params.add(adjustData.endItemNumber);
            sql.append(" and ");
            this.buildSqlCommWhere(adjustData, sql, params);
            sql.append(")");
        }
        if (!addOr) {
            return null;
        }
        this.buildSqlGroup(sql, false);
        SQLStringWrapper result = new SQLStringWrapper(sql.toString(), params);
        return result;
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initAdjustDatas(params);
        this.initOrgBoundId();
    }

    private void initAdjustDatas(SortedParameterArray params) {
        this.orgTreeNumberSet = new LinkedHashSet();
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            AdjustData adjustData = new AdjustData(params.getParameter(i));
            if (adjustData.isException()) {
                this.addToErrorList(adjustData);
                continue;
            }
            this.getFormulaCalculatorParameterList().add(adjustData);
            this.orgTreeNumberSet.add(adjustData.orgBoundNumber);
        }
    }

    private void initOrgBoundId() throws BOSException {
        HashMap<String, OrgTreeCollection> orgBoundNumber2OrgTreeCollectionMap = new HashMap<String, OrgTreeCollection>();
        if (this.orgTreeNumberSet.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,FNumber,FStartDate,FEndDate from T_ORG_Tree where FNumber in \n");
        sql.append(this.batchHelper.createInSql(this.orgTreeNumberSet.iterator()));
        sql.append(" and (FStatus in (1,2))  \n");
        sql.append(" order by FstartDate desc,FendDate desc");
        IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            while (row.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                info.setId(BOSUuid.read((String)row.getString("Fid")));
                String number = row.getString("FNumber");
                info.setNumber(number);
                info.setStartDate(row.getTimestamp("FStartDate"));
                info.setEndDate(row.getTimestamp("FEndDate"));
                OrgTreeCollection collection = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(number);
                if (collection == null) {
                    collection = new OrgTreeCollection();
                }
                collection.add(info);
                orgBoundNumber2OrgTreeCollectionMap.put(number, collection);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.initOrgTreeByPeriods(orgBoundNumber2OrgTreeCollectionMap);
    }

    public void initOrgTreeByPeriods(Map orgBoundNumber2OrgTreeCollectionMap) {
        for (AdjustData adjustData : this.getFormulaCalculatorParameterList()) {
            if (adjustData.int_periodType == 0) {
                adjustData.int_periodType = 3;
            }
            RptPeriodTypeEnum curPeriodType = RptPeriodTypeEnum.getEnum((int)adjustData.int_periodType);
            OrgTreeCollection orgTreeCL = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(adjustData.orgBoundNumber);
            if (orgTreeCL != null && orgTreeCL.size() > 0) {
                Date curDate;
                block1: for (int period = adjustData.endPeriod; period >= adjustData.startPeriod && (curDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.fiscalPeriods, (int)adjustData.year, (int)period, (RptPeriodTypeEnum)curPeriodType, (boolean)this.isMergeByFiscalPeriod)) != null; --period) {
                    for (int i = 0; i < orgTreeCL.size(); ++i) {
                        String strOrgTreeID = orgTreeCL.get(i).getId().toString();
                        Timestamp sDate = orgTreeCL.get(i).getStartDate();
                        if (sDate.compareTo(new Timestamp(curDate.getTime())) > 0) continue;
                        adjustData.orgBoundIDSet.add(strOrgTreeID);
                        continue block1;
                    }
                }
                if (adjustData.orgBoundIDSet.size() != 0) continue;
                this.addToErrorList(adjustData, (Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"46_AdjustDataCalculator", (Locale)this.serverContext.getLocale()))));
                continue;
            }
            this.addToErrorList(adjustData, (Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"47_AdjustDataCalculator", (Locale)this.serverContext.getLocale()))));
        }
    }

    @Override
    protected void clear() {
    }

    private class AdjustData
    extends AbstractFormulaCalculatorParameter {
        String orgBoundNumber;
        String orgUnitNumber;
        String sourceCurrencyNumber;
        String currencyNumber;
        String startItemNumber;
        String endItemNumber;
        String dataCollectNumber;
        private String rptPeriodType;
        private int year;
        private int startPeriodOffset;
        private int endPeriodOffset;
        private String dataSource;
        private String dataElement;
        private String valueType;
        private String dc;
        boolean isIncldUnAudit;
        int int_periodType;
        int int_dataSource;
        int int_dataElement;
        int startPeriod;
        int endPeriod;
        int int_dc;
        int int_valueType;
        Set orgBoundIDSet;

        public AdjustData(Parameter param) {
            super(param);
            this.orgBoundIDSet = new HashSet();
        }

        @Override
        protected void initArgs() throws BOSException, EASBizException {
            int i;
            Object[] args = this.getParameter().getArgs();
            if (args[0] instanceof Object[]) {
                args = (Object[])args[0];
            }
            this.orgBoundNumber = ((Variant)args[i = 0]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            this.orgUnitNumber = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            ++i;
            if (args.length >= 15) {
                this.sourceCurrencyNumber = ((Variant)args[i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
                ++i;
            }
            this.currencyNumber = ((Variant)args[i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            this.startItemNumber = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            this.endItemNumber = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            this.rptPeriodType = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            this.year = Integer.parseInt(((Variant)args[++i]).getValue().toString());
            this.startPeriodOffset = Integer.parseInt(((Variant)args[++i]).getValue().toString());
            this.endPeriodOffset = Integer.parseInt(((Variant)args[++i]).getValue().toString());
            this.dataSource = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            this.dataElement = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            this.valueType = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            String string = this.dc = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            if (((Variant)args[++i]).getValue() != null) {
                this.isIncldUnAudit = (Boolean)((Variant)args[i]).getValue();
            }
            if (args.length == 16) {
                this.dataCollectNumber = ((Variant)args[++i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            }
        }

        @Override
        protected void verifyArgs() throws BOSException, EASBizException {
            if (this.orgBoundNumber == null || this.orgBoundNumber.trim().equals("")) {
                this.orgBoundNumber = AdjustDataCalculator.this.getBatchHelper().getOrgTreeNumber();
                if (this.orgBoundNumber == null) {
                    throw new EASBizException(new NumericExceptionSubItem("12484", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"48_AdjustDataCalculator", (Locale)AdjustDataCalculator.this.serverContext.getLocale())));
                }
            }
            AdjustDataCalculator.this.getBatchHelper().checkOrgTreePremision(this.orgBoundNumber);
            if (this.orgUnitNumber == null || this.orgUnitNumber.trim().equals("")) {
                this.orgUnitNumber = AdjustDataCalculator.this.batchHelper.getOrgUnit_Number();
                if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                    this.orgUnitNumber = AdjustDataCalculator.this.batchHelper.getCompany_Number();
                }
            }
            AdjustDataCalculator.this.getBatchHelper().checkUnitCompPermision(this.orgUnitNumber);
            if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                this.dataCollectNumber = AdjustDataCalculator.this.batchHelper.getDataCollectNumber();
            }
            if (AdjustDataCalculator.this.isSupportOtherDS) {
                CSLPermissionUtil.checkDataCollectPermissionForFormula((Context)AdjustDataCalculator.this.serverContext, (String)AdjustDataCalculator.this.serverContext.getCaller().toString(), (String)this.dataCollectNumber);
            }
            if (this.currencyNumber == null || this.currencyNumber.trim().equals("")) {
                this.currencyNumber = AdjustDataCalculator.this.getBatchHelper().getCorrect_Currency_Number(this.getSheetName());
            }
            if (StringUtils.isEmpty((String)this.sourceCurrencyNumber)) {
                this.sourceCurrencyNumber = this.currencyNumber;
            }
            this.int_periodType = this.rptPeriodType == null || this.rptPeriodType.trim().equals("") ? AdjustDataCalculator.this.batchHelper.getReport_PeriodType() : FormulaAdapter.getRptPeriodType((String)this.rptPeriodType);
            if (-1 == this.int_periodType) {
                throw new EASBizException(new NumericExceptionSubItem("01423", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"49_AdjustDataCalculator", (Locale)AdjustDataCalculator.this.serverContext.getLocale())));
            }
            int rptYear = AdjustDataCalculator.this.batchHelper.getReport_Year();
            int rptPeriod = AdjustDataCalculator.this.batchHelper.getReport_Period();
            this.int_dataSource = FormulaAdapter.getDataSource((String)this.dataSource);
            if (-1 == this.int_dataSource) {
                throw new EASBizException(new NumericExceptionSubItem("02433", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"50_AdjustDataCalculator", (Locale)AdjustDataCalculator.this.serverContext.getLocale())));
            }
            this.int_dataElement = -1;
            if (AdjustDataCalculator.this.serverContext == null && !StringUtils.isEmpty((String)this.dataElement)) {
                this.int_dataElement = DataElementProvider.getDataElementInnerValue((String)this.dataElement);
            } else if (!StringUtils.isEmpty((String)this.dataElement)) {
                this.int_dataElement = DataElementProvider.getDataElementInnerValue((Context)AdjustDataCalculator.this.serverContext, (String)this.dataElement);
            }
            this.int_valueType = FormulaAdapter.getValueType((String)this.valueType);
            if (-1 == this.int_valueType) {
                throw new EASBizException(new NumericExceptionSubItem("345533", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"51_AdjustDataCalculator", (Locale)AdjustDataCalculator.this.serverContext.getLocale())));
            }
            this.int_dc = FormulaAdapter.getDebitOrCredit((String)this.dc);
            if (-1 == this.int_dc) {
                throw new EASBizException(new NumericExceptionSubItem("01457", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"52_AdjustDataCalculator", (Locale)AdjustDataCalculator.this.serverContext.getLocale())));
            }
            int[] start = null;
            int[] end = null;
            if (AdjustDataCalculator.this.isSupport13Period) {
                start = RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.year, (int)this.startPeriodOffset, (boolean)AdjustDataCalculator.this.isSupport13Period);
                end = RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.year, (int)this.endPeriodOffset, (boolean)AdjustDataCalculator.this.isSupport13Period);
            } else {
                start = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)AdjustDataCalculator.this.fiscalPeriods, (int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.year, (int)this.startPeriodOffset, (boolean)AdjustDataCalculator.this.isMergeByFiscalPeriod);
                end = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)AdjustDataCalculator.this.fiscalPeriods, (int)rptYear, (int)rptPeriod, (int)this.int_periodType, (int)this.year, (int)this.endPeriodOffset, (boolean)AdjustDataCalculator.this.isMergeByFiscalPeriod);
            }
            if (start != null) {
                this.year = start[0];
            } else if (end != null) {
                this.year = end[0];
            }
            this.startPeriod = start == null ? rptPeriod : start[1];
            this.endPeriod = end == null ? rptPeriod : end[1];
        }

        public Object[] getFields() {
            return null;
        }
    }

    private class CombineState
    implements IFormulaCombinationPreparedState {
        private BigDecimal debit;
        private BigDecimal credit;
        private String itemNumber;
        private int period;
        private int checkStatus;
        private String orgBoundID;

        private CombineState() {
        }

        @Override
        public Object getFormulaResultValue(IFormulaCalculator formula) {
            AdjustData adjustData = (AdjustData)formula;
            if (adjustData.int_dc == 1) {
                return this.debit;
            }
            if (adjustData.int_dc == 0) {
                return this.credit;
            }
            return this.debit.subtract(this.credit);
        }

        @Override
        public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
            return true;
        }

        @Override
        public boolean isPrepared(IFormulaCalculator formula) {
            AdjustData adjustData = (AdjustData)formula;
            if (adjustData.startItemNumber == null) {
                return false;
            }
            if (adjustData.startItemNumber.compareTo(this.itemNumber) > 0) {
                return false;
            }
            if (adjustData.endItemNumber == null) {
                return false;
            }
            if (adjustData.endItemNumber.compareTo(this.itemNumber) < 0) {
                return false;
            }
            if (adjustData.startPeriod > this.period) {
                return false;
            }
            if (adjustData.endPeriod < this.period) {
                return false;
            }
            if (!adjustData.isIncldUnAudit && this.checkStatus != 2) {
                return false;
            }
            return adjustData.orgBoundIDSet.contains(this.orgBoundID);
        }

        public void setItemNumber(String itemNumber) {
            this.itemNumber = itemNumber;
        }

        public void setPeriod(int period) {
            this.period = period;
        }

        public void setCheckStatus(int checkStatus) {
            this.checkStatus = checkStatus;
        }

        public void setOrgBoundID(String orgBoundID) {
            this.orgBoundID = orgBoundID;
        }

        public void setDebit(BigDecimal debit) {
            this.debit = debit;
        }

        public void setCredit(BigDecimal credit) {
            this.credit = credit;
        }
    }
}

