/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class ElimRpt
extends AbstractFormulaCalculatorParameter {
    private BatchHelper batchHelper;
    private Set orgBoundIdSet;
    private String orgBoundNumber;
    private String company;
    private String companyInverse;
    private String currency;
    private String currencyConveted;
    private String reportItem;
    private String dataElement;
    private int rptDataElement = -1;
    private String periodType;
    private int rptPeriodType = -1;
    private int year;
    private int endYear;
    private int yearOffset;
    private int period;
    private int periodOffset;
    private int endPeriod;
    private int endPeriodOffset;
    private boolean isEndBalance;
    private String adjustStatus = "1";
    protected static final String BeforeAdjust = "-1";
    protected static final String Adjust = "0";
    protected static final String AfterAdjust = "1";
    private static PeriodCollection fiscalPeriods = null;
    private static boolean isMergeByFiscalPeriod = false;

    public ElimRpt(Parameter param, BatchHelper helper) {
        this.batchHelper = helper;
        this.orgBoundIdSet = new HashSet();
        this.setParameter(param);
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected void initArgs() throws BOSException, EASBizException {
        int count;
        Object var;
        Object[] args = this.getParameter().getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        this.orgBoundNumber = (var = ((Variant)args[count = 0]).getValue()) == null ? "" : var.toString();
        var = ((Variant)args[++count]).getValue();
        this.company = var == null ? "" : var.toString();
        var = ((Variant)args[++count]).getValue();
        this.companyInverse = var == null ? "" : var.toString();
        var = ((Variant)args[++count]).getValue();
        this.currency = var == null ? "" : var.toString();
        var = ((Variant)args[++count]).getValue();
        this.currencyConveted = var == null ? "" : var.toString();
        var = ((Variant)args[++count]).getValue();
        this.reportItem = var == null ? "" : var.toString();
        var = ((Variant)args[++count]).getValue();
        String string = this.dataElement = var == null ? null : var.toString();
        if (this.dataElement != null) {
            this.isEndBalance = this.dataElement.equals("ENDBALANCE");
        }
        this.rptDataElement = this.batchHelper.getServerContext() == null ? DataElementProvider.getDataElementInnerValue((String)this.dataElement) : DataElementProvider.getDataElementInnerValue((Context)this.batchHelper.getServerContext(), (String)this.dataElement);
        var = ((Variant)args[++count]).getValue();
        this.periodType = var == null ? null : var.toString();
        this.rptPeriodType = FormulaAdapter.getRptPeriodType((String)this.periodType);
        var = ((Variant)args[++count]).getValue();
        this.yearOffset = var == null ? 0 : Integer.valueOf(var.toString());
        var = ((Variant)args[++count]).getValue();
        this.periodOffset = var == null ? 0 : Integer.valueOf(var.toString());
        var = ((Variant)args[++count]).getValue();
        this.endPeriodOffset = var == null ? 0 : Integer.valueOf(var.toString());
        this.adjustStatus = args.length == 11 ? AfterAdjust : ((var = ((Variant)args[++count]).getValue()) == null || StringUtils.isEmpty((String)var.toString()) ? AfterAdjust : var.toString());
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.companyInverse)) {
            throw new ReportException(ReportException.COMPANYINVERSE_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)this.reportItem)) {
            throw new ReportException(ReportException.RPTITEM_NOT_NULL);
        }
        if (this.rptDataElement < 0) {
            throw new ReportException(ReportException.DATAELEMENT_NOT_NULL);
        }
        if (this.rptPeriodType < 0) {
            throw new ReportException(ReportException.RPTPERIODTYPE_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)this.orgBoundNumber)) {
            this.orgBoundNumber = this.batchHelper.getOrgTreeNumber();
        }
        if (StringUtils.isEmpty((String)this.company)) {
            this.company = this.batchHelper.getCompany_Number();
        }
        if (StringUtils.isEmpty((String)this.currency)) {
            this.currency = this.batchHelper.getSource_Currency_Number();
            if (StringUtils.isEmpty((String)this.currency)) {
                this.currency = this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
            }
        }
        if (StringUtils.isEmpty((String)this.currencyConveted)) {
            this.currencyConveted = this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
        }
        int rptYear = this.batchHelper.getReport_Year();
        int rptPeriod = this.batchHelper.getReport_Period();
        int[] start = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)fiscalPeriods, (int)rptYear, (int)rptPeriod, (int)this.rptPeriodType, (int)this.yearOffset, (int)this.periodOffset, (boolean)isMergeByFiscalPeriod);
        int[] end = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)fiscalPeriods, (int)rptYear, (int)rptPeriod, (int)this.rptPeriodType, (int)this.yearOffset, (int)this.endPeriodOffset, (boolean)isMergeByFiscalPeriod);
        this.year = start == null ? rptYear : start[0];
        this.period = start == null ? rptPeriod : start[1];
        this.endYear = end == null ? rptYear : end[0];
        int n = this.endPeriod = end == null ? rptPeriod : end[1];
        if (this.year >= this.endYear && this.period > this.endPeriod) {
            throw new ReportException(ReportException.ENDPERIOD_NOT_LESS_STARTPERIOD);
        }
    }

    public Set getOrgBoundIdSet() {
        return this.orgBoundIdSet;
    }

    public BatchHelper getBatchHelper() {
        return this.batchHelper;
    }

    public void setBatchHelper(BatchHelper batchHelper) {
        this.batchHelper = batchHelper;
    }

    public String getOrgBoundNumber() {
        return this.orgBoundNumber;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCompanyInverse() {
        return this.companyInverse;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCurrencyConveted() {
        return this.currencyConveted;
    }

    public String getReportItem() {
        return this.reportItem;
    }

    public int getRptDataElement() {
        return this.rptDataElement;
    }

    public int getRptPeriodType() {
        return this.rptPeriodType;
    }

    public int getYear() {
        return this.year;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getEndPeriod() {
        return this.endPeriod;
    }

    public boolean isEndBalance() {
        return this.isEndBalance;
    }

    @Override
    public String getSheetName() {
        return this.getParameter().getSheetName();
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setEndPeriod(int endPeriod) {
        this.endPeriod = endPeriod;
    }

    public boolean isMuliFormula() {
        return this.year != this.endYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public PeriodCollection getFiscalPeriods() {
        return fiscalPeriods;
    }

    public static void setFiscalPeriods(PeriodCollection Periods) {
        fiscalPeriods = Periods;
    }

    public boolean isMergeByFiscalPeriod() {
        return isMergeByFiscalPeriod;
    }

    public static void setMergeByFiscalPeriod(boolean isIsMergeByFiscalPeriod) {
        isMergeByFiscalPeriod = isIsMergeByFiscalPeriod;
    }

    public String getAdjustStatus() {
        return this.adjustStatus;
    }
}

