/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.CalculatorCombiner;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HisRateDataCalculator {
    private static final Logger logger = Logger.getLogger(HisRateDataCalculator.class);
    private Context serverContext;
    private BatchHelper batchHelper;
    private ICalculateContextProvider calContext;
    private List hisList = new ArrayList();
    private List companyValueList = new ArrayList();
    private List orgGrpValueList = new ArrayList();
    private Set orgTreeNumberSet = new HashSet();
    private Set orgTreeIdSet = new HashSet();
    private int sqlVariablsCount = 200;
    private int hisDataCount = 10000;
    private static final String BATCH_SIZE_KEY = "KEY_CSLPARAM_PERFORMANCE_HISRATEDATA_WHERE_VARIABLE_SIZE";
    private static final String BATCH_SIZE_COUNT = "KEY_CSLPARAM_PERFORMANCE_HISRATEDATA_BATCH_SIZE";
    private static final String RESCLASSNAME = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";

    public HisRateDataCalculator(ICalculateContextProvider context, Context serverCtx) {
        this.serverContext = serverCtx;
        this.calContext = context;
        this.batchHelper = new BatchHelper(context, serverCtx);
    }

    private void cleanup() {
        this.hisList.clear();
        this.companyValueList.clear();
        this.orgGrpValueList.clear();
        this.orgTreeNumberSet.clear();
        this.orgTreeIdSet.clear();
    }

    private void initBatchSize() {
        this.batchHelper.initBatchSize(BATCH_SIZE_KEY);
        this.sqlVariablsCount = this.batchHelper.getBatchSize();
    }

    private void initBatchHisDateSize() {
        this.batchHelper.initBatchSize(BATCH_SIZE_COUNT);
        this.hisDataCount = this.batchHelper.getBatchSize();
    }

    private void initOrgBoundIdNew() throws BOSException {
        if (this.hisList == null || this.hisList.isEmpty()) {
            return;
        }
        int size = this.hisList.size();
        ArrayList<HisData> moreOneOrgBound = new ArrayList<HisData>();
        for (int i = 0; i < size; ++i) {
            HisData data;
            block6: {
                data = (HisData)this.hisList.get(i);
                String orgBoundNumber = data.getOrgBoundNumber();
                if (StringUtils.isEmpty((String)orgBoundNumber)) continue;
                int[] startPeriod = RPTDateUtil.getPeriod((Date)data.dateStartDate, (RptPeriodTypeEnum)RptPeriodTypeEnum.DAILY);
                int[] endPeriod = RPTDateUtil.getPeriod((Date)data.dateEndDate, (RptPeriodTypeEnum)RptPeriodTypeEnum.DAILY);
                try {
                    Map orgTreeMap = UnionVersionUtil.getOrgTreeByPeriods((Context)this.serverContext, (String)orgBoundNumber, (int)startPeriod[0], (int)endPeriod[0], (int)startPeriod[1], (int)endPeriod[1], (int)1);
                    if (orgTreeMap == null || orgTreeMap.isEmpty() || orgTreeMap.size() < 1) break block6;
                    Iterator orgIter = orgTreeMap.keySet().iterator();
                    data.orgBoundIdSet.add(orgIter.next().toString());
                    data.groupId = data.orgBoundIdSet.toArray()[0].toString() + ":" + data.orgUnitNumber + ":" + data.sourceCurrencyNumber + ":" + data.reportItem + ":" + data.startDate + ":" + data.endDate + ":" + data.dataCollectNumber;
                    while (orgIter.hasNext()) {
                        HisData tmpData = new HisData(data.getParameter());
                        tmpData.orgBoundIdSet.clear();
                        tmpData.orgBoundIdSet.add(orgIter.next().toString());
                        tmpData.groupId = data.groupId;
                        moreOneOrgBound.add(tmpData);
                    }
                }
                catch (EASBizException e) {
                    data.setException((Exception)((Object)e));
                    data.exceptionType = 2;
                    logger.error((Object)e);
                    continue;
                }
                catch (BOSException e) {
                    data.setException((Exception)((Object)e));
                    data.exceptionType = 2;
                    logger.error((Object)e);
                    continue;
                }
            }
            if (!data.orgBoundIdSet.isEmpty()) continue;
            data.setException((Exception)((Object)new ReportException(ReportException.ORGBOUND_IS_NULL_IN_SELECT_PERIOD)));
        }
        this.initBoundGrp();
    }

    private void initOrgBoundId() throws BOSException {
        if (this.orgTreeNumberSet == null || this.orgTreeNumberSet.isEmpty()) {
            return;
        }
        HashMap<String, OrgTreeCollection> orgBoundNumber2OrgTreeCollectionMap = new HashMap<String, OrgTreeCollection>();
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,FNumber,FStartDate,FEndDate from T_ORG_Tree where FNumber in \n");
        sql.append(this.batchHelper.createInSql(this.orgTreeNumberSet.iterator()));
        sql.append(" and (FStatus = 1 or FStatus = 2)  \n");
        sql.append(" order by FstartDate desc,FendDate desc");
        IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString());
        try {
            while (row.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                info.setId(BOSUuid.read((String)row.getString("Fid")));
                String number = row.getString("FNumber");
                info.setNumber(number);
                info.setStartDate(row.getTimestamp("FStartDate"));
                info.setEndDate(row.getTimestamp("FEndDate"));
                OrgTreeCollection collection = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(number);
                if (collection == null) {
                    collection = new OrgTreeCollection();
                }
                collection.add(info);
                orgBoundNumber2OrgTreeCollectionMap.put(number, collection);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.initOrgTreeByDate(orgBoundNumber2OrgTreeCollectionMap);
    }

    private void initOrgTreeByDate(Map orgBoundNumber2OrgTreeCollectionMap) throws BOSException {
        for (int i = 0; i < this.hisList.size(); ++i) {
            int j;
            OrgTreeCollection orgTreeColl;
            HisData data = (HisData)this.hisList.get(i);
            if (data.hasException || !data.hasOrgTree || (orgTreeColl = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(data.orgBoundNumber)) == null || orgTreeColl.isEmpty() || (j = 0) >= orgTreeColl.size()) continue;
            OrgTreeInfo orgTree = orgTreeColl.get(j);
            if (orgTree.getEndDate() == null) {
                orgTree.setEndDate(new Timestamp(new GregorianCalendar(2099, 12, 31).getTimeInMillis()));
            }
            this.orgTreeIdSet.add(orgTree.getId());
            data.orgBoundIdSet.add(orgTree.getId());
        }
        this.initBoundGrp();
    }

    private void initBoundGrp() throws BOSException {
        StringBuffer sql = new StringBuffer();
        HashMap<String, Integer> mapBoundGrp = new HashMap<String, Integer>();
        int index = 0;
        while (index < this.hisList.size()) {
            boolean addOr = false;
            boolean flag = false;
            sql.append("SELECT distinct baseUnit.FNumber AS fnumber                                            \n");
            sql.append("   ,baseUnit.FIsGrouping AS isGrp                                             \n");
            sql.append("   ,struct.ftreeid AS treeid                                                  \n");
            sql.append("      FROM T_ORG_BaseUnit baseUnit                                            \n");
            sql.append("         INNER JOIN t_org_structure struct on baseUnit.fid = struct.FUnitId   \n");
            sql.append("            WHERE                                                             \n");
            ArrayList<String> params = new ArrayList<String>();
            int varCount = 0;
            while (varCount < this.sqlVariablsCount && index < this.hisList.size()) {
                HisData data = (HisData)this.hisList.get(index);
                if (!data.hasException && data.hasOrgTree && !data.orgBoundIdSet.isEmpty()) {
                    if (addOr) {
                        sql.append(" OR \n");
                    } else {
                        addOr = true;
                    }
                    sql.append(" (struct.FTreeId = ? AND baseUnit.FNumber = ?) \n");
                    params.add(data.orgBoundIdSet.toArray()[0].toString());
                    params.add(data.orgUnitNumber);
                    varCount += 2;
                    flag = true;
                }
                ++index;
            }
            if (flag) {
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])params.toArray());
                    while (rs.next()) {
                        mapBoundGrp.put(rs.getString("fnumber") + rs.getString("treeid"), new Integer(rs.getInt("isGrp")));
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            sql.setLength(0);
        }
        this.initOrgGrp(mapBoundGrp);
    }

    private void initOrgGrp(Map mapBoundGrp) {
        if (mapBoundGrp.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.hisList.size(); ++i) {
            String key;
            Integer grpFlag;
            HisData data = (HisData)this.hisList.get(i);
            if (data.hasException || !data.hasOrgTree || data.orgBoundIdSet.isEmpty() || (grpFlag = (Integer)mapBoundGrp.get(key = data.orgUnitNumber + data.orgBoundIdSet.toArray()[0].toString())) == null) continue;
            if (grpFlag != 1) {
                data.isOrgBoundGrp = false;
                data.boundType = 2;
                if (data.exceptionType != 2) continue;
                data.exceptionType = 0;
                data.removeException();
                continue;
            }
            if (data.exceptionType != 2) continue;
            data.setException(new Exception(ResourceBase.getString((String)RESCLASSNAME, (String)"Select_Time_Not_In_CombBound", (Locale)this.serverContext.getLocale())));
        }
    }

    private void groupHisData() {
        ArrayList<String> tmpGroupId = new ArrayList<String>();
        for (int i = 0; i < this.hisList.size(); ++i) {
            HisData data = (HisData)this.hisList.get(i);
            if (data.hasException) continue;
            if (data.hasOrgTree && data.isOrgBoundGrp) {
                this.orgGrpValueList.add(data);
                continue;
            }
            if (data.groupId != null) {
                if (tmpGroupId.contains(data.groupId)) continue;
                this.companyValueList.add(data);
                tmpGroupId.add(data.groupId);
                continue;
            }
            this.companyValueList.add(data);
        }
    }

    private void preparePropertyMapForCompany(List companyList, Map result) {
        StringBuffer property = new StringBuffer();
        for (HisData data : companyList) {
            this.batchHelper.buildFormulaCalculatorKey(data.boundType, property);
            this.batchHelper.buildFormulaCalculatorKey(data.orgUnitNumber, property);
            this.batchHelper.buildFormulaCalculatorKey(data.sourceCurrencyNumber, property);
            this.batchHelper.buildFormulaCalculatorKey(data.reportItem, property);
            this.batchHelper.buildFormulaCalculatorKey(data.dataCollectNumber, property);
            this.batchHelper.fillKey2FormulaCalculatorMap(result, property.toString(), data);
            property.setLength(0);
        }
    }

    private void preparePropertyMapForOrgGrp(List orgUnitList, Map result) {
        StringBuffer property = new StringBuffer();
        for (HisData data : orgUnitList) {
            this.batchHelper.buildFormulaCalculatorKey(data.orgBoundNumber, property);
            this.batchHelper.buildFormulaCalculatorKey(data.boundType, property);
            this.batchHelper.buildFormulaCalculatorKey(data.orgUnitNumber, property);
            this.batchHelper.buildFormulaCalculatorKey(data.reportItem, property);
            this.batchHelper.buildFormulaCalculatorKey(data.sourceCurrencyNumber, property);
            this.batchHelper.buildFormulaCalculatorKey(data.dataCollectNumber, property);
            this.batchHelper.fillKey2FormulaCalculatorMap(result, property.toString(), data);
            property.setLength(0);
        }
    }

    private void calculateCompany() throws BOSException {
        if (this.companyValueList.isEmpty()) {
            return;
        }
        ArrayList<HisData> usedDataList = new ArrayList<HisData>();
        HashMap property2HisDataMap = new HashMap();
        CalculatorCombiner combiner = new CalculatorCombiner();
        DateCombineState state = new DateCombineState();
        combiner.setPrepareState(state);
        StringBuffer sql = new StringBuffer();
        StringBuffer property = new StringBuffer();
        int listSize = this.companyValueList.size();
        int index = 0;
        while (index < this.companyValueList.size()) {
            boolean addOr = false;
            sql.append("SELECT sum(rate.FCHANGEAMOUNT) AS amount                                               \n");
            sql.append("  ,rate.FBoundType AS BoundType                                                        \n");
            sql.append("  ,company.FNumber AS CompanyNumber                                                    \n");
            sql.append("  ,currency.FNumber AS CurrencyNumber                                                  \n");
            sql.append("  ,item.FNumber AS ItemNumber                                                          \n");
            sql.append("  ,rate.FChangeDate AS ChangeDate                                                      \n");
            sql.append("  ,rate.FDataCollectNumber AS DataCollect                                              \n");
            sql.append("  FROM T_CSL_ItemHisExchgRate rate                                                     \n");
            sql.append("   INNER JOIN T_CSL_RptItem item ON item.FID = rate.FItemID                            \n");
            sql.append("   INNER JOIN T_BD_Currency currency ON currency.FID = rate.FCurrencyID                \n");
            sql.append("   INNER JOIN T_ORG_BaseUnit company ON company.FID = rate.FCompanyID                   \n");
            sql.append("      WHERE rate.FBoundType = 2 AND (                                                  \n");
            ArrayList<Object> paramsList = new ArrayList<Object>();
            int varCount = 0;
            while (varCount < this.sqlVariablsCount && index < listSize) {
                HisData data = (HisData)this.companyValueList.get(index);
                if (!data.hasException) {
                    if (addOr) {
                        sql.append(" OR \n");
                    } else {
                        addOr = true;
                    }
                    sql.append(" (company.FNumber = ? \n");
                    paramsList.add(data.orgUnitNumber);
                    ++varCount;
                    sql.append(" AND currency.FNumber = ? \n");
                    paramsList.add(data.sourceCurrencyNumber);
                    ++varCount;
                    sql.append(" AND item.FNumber = ?  \n");
                    paramsList.add(data.reportItem);
                    ++varCount;
                    sql.append(" AND (rate.FChangeDate >= ? AND rate.FChangeDate <= ? ) \n");
                    paramsList.add(new Timestamp(data.dateStartDate.getTime()));
                    paramsList.add(new Timestamp(data.dateEndDate.getTime()));
                    varCount += 2;
                    sql.append(" AND rate.FDataCollectNumber = ?) \n");
                    paramsList.add(data.dataCollectNumber);
                    ++varCount;
                    usedDataList.add(data);
                }
                ++index;
            }
            if (paramsList.isEmpty()) continue;
            sql.append(") \n");
            sql.append(" GROUP BY rate.FBoundType ");
            sql.append(", company.FNumber ");
            sql.append(", currency.FNumber ");
            sql.append(", item.FNumber ");
            sql.append(", rate.FChangeDate ");
            sql.append(", rate.FDataCollectNumber ");
            this.preparePropertyMapForCompany(usedDataList, property2HisDataMap);
            combiner.setPropertyToCalculatorMap(property2HisDataMap);
            IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])paramsList.toArray());
            try {
                while (rs.next()) {
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("BoundType"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("CompanyNumber"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("CurrencyNumber"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("ItemNumber"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("DataCollect"), property);
                    BigDecimal value = rs.getBigDecimal("amount");
                    if (value == null) {
                        value = CslConstant.BGZERO;
                    }
                    state.setDate(rs.getDate("ChangeDate"));
                    combiner.combineValue(property.toString(), (Object)value, true);
                    property.setLength(0);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            sql.setLength(0);
            usedDataList.clear();
            property2HisDataMap.clear();
        }
    }

    private void calculateOrgGrp() throws BOSException {
        if (this.orgGrpValueList.isEmpty()) {
            return;
        }
        ArrayList<HisData> usedDataList = new ArrayList<HisData>();
        HashMap property2HisDataMap = new HashMap();
        CalculatorCombiner combiner = new CalculatorCombiner();
        DateCombineState state = new DateCombineState();
        combiner.setPrepareState(state);
        StringBuffer sql = new StringBuffer();
        StringBuffer property = new StringBuffer();
        int listSize = this.orgGrpValueList.size();
        int index = 0;
        while (index < listSize) {
            boolean addOr = false;
            sql.append("SELECT sum(rate.FCHANGEAMOUNT) AS amount                                               \n");
            sql.append("  ,tree.fnumber AS treeNumber                                                                  \n");
            sql.append("  ,rate.FBoundType AS BoundType                                                        \n");
            sql.append("  ,baseUnit.FNumber AS UnitNumber                                                      \n");
            sql.append("  ,currency.FNumber AS CurrencyNumber                                                  \n");
            sql.append("  ,item.FNumber AS ItemNumber                                                          \n");
            sql.append("  ,rate.FChangeDate AS ChangeDate                                                      \n");
            sql.append("  ,rate.FDataCollectNumber AS DataCollect                                              \n");
            sql.append("  FROM T_CSL_ItemHisExchgRate rate                                                     \n");
            sql.append("   INNER JOIN T_CSL_RptItem item ON item.FID = rate.FItemID                            \n");
            sql.append("   INNER JOIN T_BD_Currency currency ON currency.FID = rate.FCurrencyID                \n");
            sql.append("   INNER JOIN T_ORG_Tree tree ON tree.FID = rate.FOrgBoundID                           \n");
            sql.append("   INNER JOIN T_ORG_BaseUnit baseUnit ON baseUnit.FID = rate.FOrgBoundGrpID            \n");
            sql.append("      WHERE rate.FBoundType = 1 AND (                                                  \n");
            ArrayList<Object> paramsList = new ArrayList<Object>();
            int varCount = 0;
            while (varCount < this.sqlVariablsCount && index < listSize) {
                HisData data = (HisData)this.orgGrpValueList.get(index);
                if (!data.hasException) {
                    if (addOr) {
                        sql.append(" OR \n");
                    } else {
                        addOr = true;
                    }
                    sql.append(" (tree.fnumber = ? \n");
                    paramsList.add(data.orgBoundNumber);
                    ++varCount;
                    sql.append(" AND baseUnit.FNumber = ? \n");
                    paramsList.add(data.orgUnitNumber);
                    ++varCount;
                    sql.append(" AND currency.FNumber = ? \n");
                    paramsList.add(data.sourceCurrencyNumber);
                    ++varCount;
                    sql.append(" AND item.FNumber = ?  \n");
                    paramsList.add(data.reportItem);
                    ++varCount;
                    sql.append(" AND (rate.FChangeDate >= ? AND rate.FChangeDate <= ? ) \n");
                    paramsList.add(new Timestamp(data.dateStartDate.getTime()));
                    paramsList.add(new Timestamp(data.dateEndDate.getTime()));
                    varCount += 2;
                    sql.append(" AND rate.FDataCollectNumber = ?) \n");
                    paramsList.add(data.dataCollectNumber);
                    ++varCount;
                    usedDataList.add(data);
                }
                ++index;
            }
            if (paramsList.isEmpty()) continue;
            sql.append(") \n");
            sql.append(" GROUP BY tree.fnumber ");
            sql.append(", rate.FBoundType ");
            sql.append(", baseUnit.FNumber ");
            sql.append(", currency.FNumber ");
            sql.append(", item.FNumber ");
            sql.append(", rate.FChangeDate ");
            sql.append(", rate.FDataCollectNumber ");
            this.preparePropertyMapForOrgGrp(usedDataList, property2HisDataMap);
            combiner.setPropertyToCalculatorMap(property2HisDataMap);
            IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])paramsList.toArray());
            try {
                while (rs.next()) {
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("treeNumber"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("BoundType"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("UnitNumber"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("ItemNumber"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("CurrencyNumber"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("DataCollect"), property);
                    BigDecimal value = rs.getBigDecimal("amount");
                    if (value == null) {
                        value = CslConstant.BGZERO;
                    }
                    state.setDate(rs.getDate("ChangeDate"));
                    combiner.combineValue(property.toString(), (Object)value, true);
                    property.setLength(0);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            sql.setLength(0);
            usedDataList.clear();
            property2HisDataMap.clear();
        }
    }

    public void execute(SortedParameterArray params) {
        this.initBatchHisDateSize();
        this.initBatchSize();
        try {
            int count = 0;
            int size = this.hisDataCount;
            while (true) {
                if (count < params.size() && count < size) {
                    Parameter param = (Parameter)params.getAt(count);
                    HisData data = new HisData(param);
                    this.hisList.add(data);
                    if (!data.hasException && data.hasOrgTree) {
                        this.orgTreeNumberSet.add(data.orgBoundNumber);
                    }
                    ++count;
                    continue;
                }
                this.excute();
                if (count < params.size()) {
                    size += this.hisDataCount;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.handleAllException();
        }
    }

    private void excute() throws BOSException {
        this.initOrgBoundIdNew();
        this.groupHisData();
        this.calculate();
        this.handleAllException();
        this.cleanup();
    }

    private void calculate() throws BOSException {
        this.calculateCompany();
        this.calculateOrgGrp();
    }

    private void handleAllException() {
        for (HisData data : this.hisList) {
            if (data.hasException) {
                FormulaValueBackfill err = new FormulaValueBackfill(data.param);
                err.setException((Throwable)data.ex);
                continue;
            }
            if (data.param.getValue() != null) continue;
            data.param.setValue((Object)CslConstant.BGZERO);
        }
    }

    private class DateCombineState
    implements IFormulaCombinationPreparedState {
        private Date date;

        private DateCombineState() {
        }

        @Override
        public boolean isPrepared(IFormulaCalculator formula) {
            if (this.date == null) {
                return false;
            }
            if (formula instanceof HisData) {
                HisData data = (HisData)formula;
                if (this.date.after(data.dateStartDate) && this.date.before(data.dateEndDate) || this.date.equals(data.dateStartDate) || this.date.equals(data.dateEndDate)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object getFormulaResultValue(IFormulaCalculator formula) {
            return null;
        }

        @Override
        public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
            return false;
        }

        public void setDate(Date _date) {
            this.date = _date;
        }
    }

    private class HisData
    implements IFormulaCalculator {
        int boundType = 1;
        int exceptionType = 0;
        static final int COMBBOUNDEXCEPTION = 2;
        String orgBoundNumber;
        String orgUnitNumber;
        String sourceCurrencyNumber;
        String reportItem;
        String startDate;
        String endDate;
        Date dateStartDate;
        Date dateEndDate;
        String dataCollectNumber;
        boolean hasException;
        boolean hasOrgTree = true;
        boolean isOrgBoundGrp = true;
        Exception ex;
        Parameter param;
        String groupId = null;
        Set orgBoundIdSet;

        HisData(Parameter param) {
            this.param = param;
            this.orgBoundIdSet = new HashSet();
            try {
                this.initParamt();
            }
            catch (Exception e) {
                this.setException(new Exception(e.getMessage()));
            }
        }

        void initParamt() throws Exception {
            this.initArgs();
            this.validate();
        }

        private void initArgs() {
            Object[] args = this.param.getArgs();
            if (args[0].getClass().isArray()) {
                args = (Object[])args[0];
            }
            if (args.length == 7) {
                this.orgBoundNumber = ((Variant)args[0]).getValue() == null ? null : ((Variant)args[0]).getValue().toString();
                this.orgUnitNumber = ((Variant)args[1]).getValue() == null ? null : ((Variant)args[1]).getValue().toString();
                this.sourceCurrencyNumber = ((Variant)args[2]).getValue() == null ? null : ((Variant)args[2]).getValue().toString();
                this.reportItem = ((Variant)args[3]).getValue() == null ? null : ((Variant)args[3]).getValue().toString();
                this.startDate = ((Variant)args[4]).getValue() == null ? null : ((Variant)args[4]).getValue().toString();
                this.endDate = ((Variant)args[5]).getValue() == null ? null : ((Variant)args[5]).getValue().toString();
                this.dataCollectNumber = ((Variant)args[6]).getValue() == null ? null : ((Variant)args[6]).getValue().toString();
            } else if (args.length == 6) {
                this.orgBoundNumber = ((Variant)args[0]).getValue() == null ? null : ((Variant)args[0]).getValue().toString();
                this.orgUnitNumber = ((Variant)args[1]).getValue() == null ? null : ((Variant)args[1]).getValue().toString();
                this.sourceCurrencyNumber = ((Variant)args[2]).getValue() == null ? null : ((Variant)args[2]).getValue().toString();
                this.reportItem = ((Variant)args[3]).getValue() == null ? null : ((Variant)args[3]).getValue().toString();
                this.startDate = ((Variant)args[4]).getValue() == null ? null : ((Variant)args[4]).getValue().toString();
                this.endDate = ((Variant)args[5]).getValue() == null ? null : ((Variant)args[5]).getValue().toString();
                this.dataCollectNumber = "ACTUALDATA";
            }
        }

        private void validate() throws Exception {
            SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFmt.setLenient(false);
            if (StringUtils.isEmpty((String)this.orgBoundNumber)) {
                this.hasOrgTree = false;
                this.isOrgBoundGrp = false;
                this.boundType = 2;
                if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                    this.orgUnitNumber = HisRateDataCalculator.this.batchHelper.getCompany_Number();
                }
            } else if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                this.orgUnitNumber = HisRateDataCalculator.this.batchHelper.getOrgGroup_Number();
                if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                    this.orgUnitNumber = HisRateDataCalculator.this.batchHelper.getCompany_Number();
                }
            }
            if (StringUtils.isEmpty((String)this.reportItem)) {
                throw new Exception(ResourceBase.getString((String)HisRateDataCalculator.RESCLASSNAME, (String)"RPTItems_Can't_Null", (Locale)HisRateDataCalculator.this.serverContext.getLocale()));
            }
            if (StringUtils.isEmpty((String)this.sourceCurrencyNumber)) {
                this.sourceCurrencyNumber = HisRateDataCalculator.this.batchHelper.getSource_Currency_Number();
            }
            if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                this.dataCollectNumber = HisRateDataCalculator.this.batchHelper.getDataCollectNumber();
            }
            DateFormat format = CslRptUtil.getNationalDateFormat((Context)HisRateDataCalculator.this.batchHelper.getServerContext());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (StringUtils.isEmpty((String)this.startDate)) {
                this.dateStartDate = HisRateDataCalculator.this.batchHelper.getReport_StartDate();
            } else {
                try {
                    this.dateStartDate = format != null ? dateFmt.parse(dateFormat.format(format.parse(this.startDate)) + " 00:00:00") : dateFmt.parse(this.startDate + " 00:00:00");
                }
                catch (ParseException e) {
                    throw new Exception(ResourceBase.getString((String)HisRateDataCalculator.RESCLASSNAME, (String)"DateTime_Error", (Locale)HisRateDataCalculator.this.serverContext.getLocale()));
                }
            }
            if (StringUtils.isEmpty((String)this.endDate)) {
                this.dateEndDate = this.getReportEndDate();
            } else {
                try {
                    this.dateEndDate = format != null ? dateFmt.parse(dateFormat.format(format.parse(this.endDate)) + " 23:59:59") : dateFmt.parse(this.endDate + " 23:59:59");
                }
                catch (ParseException e) {
                    throw new Exception(ResourceBase.getString((String)HisRateDataCalculator.RESCLASSNAME, (String)"DateTime_Error", (Locale)HisRateDataCalculator.this.serverContext.getLocale()));
                }
            }
            if (this.dateStartDate.after(this.dateEndDate)) {
                throw new Exception(ResourceBase.getString((String)HisRateDataCalculator.RESCLASSNAME, (String)"Start_Cant'_After_End", (Locale)HisRateDataCalculator.this.serverContext.getLocale()));
            }
        }

        private Date getReportEndDate() {
            return (Date)HisRateDataCalculator.this.calContext.getReportAdapter().getReportProperty("Report_EndDate");
        }

        void setException(Exception e) {
            this.ex = e;
            this.hasException = true;
        }

        void removeException() {
            this.ex = null;
            this.hasException = false;
        }

        @Override
        public Parameter getParameter() {
            return this.param;
        }

        @Override
        public String getSheetName() {
            return this.param.getSheetName();
        }

        @Override
        public boolean isException() {
            return this.hasException;
        }

        @Override
        public Exception getException() {
            return this.ex == null ? null : this.ex;
        }

        public String getOrgBoundNumber() {
            return this.orgBoundNumber;
        }
    }
}

