/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.app.RptContainer;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RefMBatchCalculater {
    private static Logger logger = Logger.getLogger(RefMBatchCalculater.class);
    private ICalculateContextProvider context;
    private HashMap companyCache = new HashMap();
    private Set companyNumberSet;
    private List refmList;
    private Map refmTmpType;
    private BatchHelper batchHelper;
    public PeriodCollection periods = null;
    public boolean isMergeByFiscalPeriod = false;
    HashMap map1 = new HashMap();
    HashMap map2 = new HashMap();
    HashMap map3 = new HashMap();
    HashMap mapRefm = new HashMap();
    HashMap refmTemplateMap = new HashMap();
    public static final String REFM_GROUPREPORT_CODE = "99";
    public static final int DT_CURRENT = 1;
    public static final int DT_START = 2;
    public static final int DT_END = 3;
    Context ServerCtx = null;
    private IPeriod iperiod = null;
    private ICompanyOrgUnit comp;

    public RefMBatchCalculater(ICalculateContextProvider calContext, Context serverCtx) {
        Object companyId;
        this.context = calContext;
        this.ServerCtx = serverCtx;
        this.companyNumberSet = new HashSet();
        this.refmList = new ArrayList();
        this.refmTmpType = new HashMap();
        this.batchHelper = new BatchHelper(this.context, serverCtx);
        this.isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod((Context)serverCtx);
        if (this.context != null && (companyId = this.context.getReportAdapter().getReportProperty("Company.ID")) != null) {
            try {
                OrgType orgType = this.batchHelper.getRptOrgType();
                if (!OrgType.Company.equals((Object)orgType)) {
                    CompanyOrgUnitInfo fiOrg = RptNewUIUtil.getDelegateCompany((OrgType)orgType, (String)companyId.toString());
                    if (fiOrg != null && fiOrg.getId() != null) {
                        companyId = fiOrg.getId().toString();
                    } else {
                        logger.error((Object)"", (Throwable)new Exception("error for query delegate company of " + companyId));
                    }
                }
                this.periods = FiscalPeriodHelper.getPeriodCollection((Context)serverCtx, (String)companyId.toString());
            }
            catch (Exception e) {
                this.periods = null;
            }
        }
    }

    public void execute(SortedParameterArray params, String type) {
        try {
            boolean isSupport13Period = CslRptUtil.isSupport13Period((Context)this.ServerCtx);
            HashMap checkPermission = new HashMap();
            boolean isSupportOtherDS = CslRptUtil.isSupportOtherDSServer((Context)this.ServerCtx);
            HashMap<String, String> tmpNumberTypeCatch = new HashMap<String, String>();
            for (int i = 0; i < params.size(); ++i) {
                FormulaValueBackfill backFill = new FormulaValueBackfill(params.getParameter(i));
                try {
                    ArrayList<Ref> list;
                    CharSequence key;
                    Ref ref = new Ref(params.getParameter(i), type, isSupport13Period);
                    ref.checkDataCollectPermission(isSupportOtherDS, checkPermission);
                    this.companyNumberSet.add(ref.fiOrgUnit);
                    if (ref.exp != null) {
                        backFill.setException((Throwable)ref.exp);
                        continue;
                    }
                    if (ref.tempType.trim().equals(String.valueOf(2)) && !StringUtils.isEmpty((String)ref.tempCode)) {
                        String tmpType = (String)tmpNumberTypeCatch.get(ref.tempCode);
                        if (StringUtils.isEmpty((String)tmpType)) {
                            TemplateCollection coll = TemplateFactory.getLocalInstance(this.ServerCtx).getTemplateCollection("select templateType where number = '" + ref.tempCode + "' and versionStatus = " + 1 + " and isFreezed = 0 and isK3Tpl = 0");
                            if (coll.size() == 1) {
                                TemplateInfo info = coll.get(0);
                                ref.tempType = info.getTemplateType().getValue() == 10 ? String.valueOf(12) : String.valueOf(info.getTemplateType().getValue());
                            } else if (coll.size() > 1) {
                                ref.tempType = String.valueOf(6);
                            }
                            tmpNumberTypeCatch.put(ref.tempCode, ref.tempType);
                        } else {
                            ref.tempType = tmpType;
                        }
                    }
                    if (ref.tempType.trim().equals("1")) {
                        key = ref.tempCode + "|" + ref.tempType + "|" + ref.fiOrgUnit + "|" + ref.currency + "|" + ref.year + "|" + ref.period + "|" + ref.dataCollectNumber + "|" + ref.srcCurrency + "|" + ref.isAdjusted;
                        list = (ArrayList<Ref>)this.map1.get(key);
                        if (list == null) {
                            list = new ArrayList<Ref>();
                            this.map1.put(key, list);
                        }
                        list.add(ref);
                        this.refmList.add(ref);
                        continue;
                    }
                    if (ref.tempType.trim().equals(String.valueOf(6)) || ref.tempType.trim().equals(String.valueOf(12)) || ref.tempType.trim().equals(String.valueOf(15))) {
                        key = ref.fiOrgUnit + "|" + ref.year + "|" + ref.period + "|" + ref.currency + "|" + ref.tempCode + "|" + ref.tempType + "|" + ref.dataCollectNumber + "|" + ref.srcCurrency + "|" + ref.isAdjusted;
                        list = (ArrayList<Ref>)this.map2.get(key);
                        if (list == null) {
                            list = new ArrayList<Ref>();
                            this.map2.put(key, list);
                        }
                        list.add(ref);
                        this.refmList.add(ref);
                        continue;
                    }
                    if (ref.tempType.trim().equals(String.valueOf(14))) {
                        key = new StringBuffer();
                        ((StringBuffer)key).append(ref.year).append("|");
                        ((StringBuffer)key).append(ref.period).append("|");
                        ((StringBuffer)key).append(ref.fiOrgUnit).append("|");
                        ((StringBuffer)key).append(ref.currency).append("|");
                        ((StringBuffer)key).append(ref.tempCode).append("|");
                        ((StringBuffer)key).append(ref.tempType);
                        ((StringBuffer)key).append(ref.dataCollectNumber);
                        ((StringBuffer)key).append("|").append(ref.srcCurrency);
                        ((StringBuffer)key).append("|").append(ref.isAdjusted);
                        list = (ArrayList<Ref>)this.mapRefm.get(((StringBuffer)key).toString());
                        if (list == null) {
                            list = new ArrayList<Ref>();
                            this.mapRefm.put(((StringBuffer)key).toString(), list);
                        }
                        list.add(ref);
                        this.refmList.add(ref);
                        continue;
                    }
                    key = ref.year + "|" + ref.period + "|" + ref.fiOrgUnit + "|" + ref.currency + "|" + ref.tempCode + "|" + RptTmpTypeEnum.getEnum(ref.groupTempType).getValue() + "|" + ref.dataCollectNumber;
                    list = (ArrayList<Ref>)this.map3.get(key);
                    if (list == null) {
                        list = new ArrayList<Ref>();
                        this.map3.put(key, list);
                    }
                    list.add(ref);
                    continue;
                }
                catch (RuntimeException e) {
                    backFill.setException((Throwable)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED));
                    continue;
                }
                catch (Exception e2) {
                    backFill.setException((Throwable)new Exception("#BAD FUNCTION " + e2.getMessage()));
                }
            }
            tmpNumberTypeCatch.clear();
            this.execute();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            for (int i = 0; i < params.size(); ++i) {
                new FormulaValueBackfill(params.getParameter(i)).setException((Throwable)new Exception("#BAD FUNCTION " + e.getMessage()));
            }
        }
    }

    private int getTemplatePeriodType(String tempType, String tempCode, String fiOrgUnit) {
        String key = tempType + "|" + tempCode;
        int typeTypeValue = RptTmpTypeEnum.getEnum(tempType).getValue();
        if (typeTypeValue == 1 || typeTypeValue == 14) {
            key = key + "|" + fiOrgUnit;
        }
        int periodType = -1;
        if (!this.refmTemplateMap.containsKey(key)) {
            periodType = this.findRefmTemplatePeriodType(this.ServerCtx, tempType, tempCode, fiOrgUnit);
            if (periodType >= 0) {
                this.refmTemplateMap.put(key, periodType);
            }
        } else {
            periodType = (Integer)this.refmTemplateMap.get(key);
        }
        return periodType;
    }

    private int findRefmTemplatePeriodType(Context ctx, String tempType, String tempCode, String fiOrgUnit) {
        logger.info((Object)"_tempType=[{1}],_tempCode=[{2}],_fiOrgUnit=[{3}]".replace("{1}", tempType).replace("{2}", tempCode));
        if (StringUtils.isEmpty((String)tempType) || StringUtils.isEmpty((String)tempCode)) {
            return -1;
        }
        int typeTypeValue = RptTmpTypeEnum.getEnum(tempType).getValue();
        boolean isCommonReport = typeTypeValue == 1 || typeTypeValue == 14;
        SQLBuilder sql = new SQLBuilder();
        sql.append("select top 1 template.FPeriodType from T_RPT_Template template ");
        if (isCommonReport) {
            sql.append(" inner join t_org_baseunit unit on unit.fid=template.fcompanyid ");
        }
        sql.append("where template.FVersionStatus = 1 ");
        sql.append("and template.FTemplateType = ? ", (Object)typeTypeValue);
        sql.append("and template.FPublishedStatus = 1 ");
        sql.append("and template.fnumber = ?", (Object)tempCode);
        if (isCommonReport) {
            sql.append("and unit.fnumber = ?", (Object)fiOrgUnit);
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            if (rs.next()) {
                return rs.getInt("FPeriodType");
            }
        }
        catch (Exception e) {
            logger.error((Object)"findRefmTemplatePeriodType_DbUtil", (Throwable)e);
        }
        return -1;
    }

    private void initRefmYearAndPeriod() throws BOSException, EASBizException {
        Map maxPeriodNumberMap = this.getMaxPeriodNumberMap(this.companyCache);
        for (Ref ref : this.refmList) {
            this.initSingleRefmYearAndPeriod(ref, maxPeriodNumberMap);
        }
    }

    private void initSingleRefmYearAndPeriod(Ref ref, Map maxPeriodNumberMap) throws BOSException, EASBizException {
        if (ref.period <= 0) {
            --ref.year;
            CompanyOrgUnitInfo company = this.getCacheCompany(ref.fiOrgUnit);
            String key = ref.year + company.getAccountPeriodType().getId().toString();
            Integer max = (Integer)maxPeriodNumberMap.get(key);
            if (max != null) {
                ref.period += max.intValue();
            } else {
                ref.period = 999;
                ref.formulaValue.setException(new ReportException(ReportException.ACCTEXT_NULL_PERIOD));
            }
            this.initSingleRefmYearAndPeriod(ref, maxPeriodNumberMap);
        }
    }

    private Map getMaxPeriodNumberMap(Map companyCache2) throws BOSException {
        HashSet<String> periodTypeSet = new HashSet<String>();
        for (CompanyOrgUnitInfo companyInfo : companyCache2.values()) {
            periodTypeSet.add(companyInfo.getAccountPeriodType().getId().toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(FPeriodNumber) MaxNumber,FPeriodYear,FTypeID from T_BD_Period\t\n");
        sql.append(" where FTypeID in \n").append(new BatchHelper(this.context, this.ServerCtx).createInSql(periodTypeSet.iterator())).append("\n");
        sql.append(" and FIsAdjustPeriod = 0    \n");
        sql.append(" group by FPeriodYear,FTypeID\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ServerCtx, (String)sql.toString());
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try {
            while (rowSet.next()) {
                Integer maxNumber = new Integer(rowSet.getInt("MaxNumber"));
                String key = rowSet.getInt("FPeriodYear") + rowSet.getString("FTypeID");
                result.put(key, maxNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private void initCompanyCache() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)this.companyNumberSet, CompareType.INCLUDE));
        ICompanyOrgUnit company = null;
        company = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        CompanyOrgUnitCollection coms = company.getCompanyOrgUnitCollection(evi);
        for (int i = 0; i < coms.size(); ++i) {
            this.companyCache.put(coms.get(i).getNumber(), coms.get(i));
        }
    }

    private CompanyOrgUnitInfo getCacheCompany(String fiOrgUnit) throws BOSException, EASBizException {
        if (this.companyCache.get(fiOrgUnit) == null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)fiOrgUnit, CompareType.EQUALS));
            CompanyOrgUnitCollection coms = null;
            OrgType rptOrgType = this.batchHelper.getRptOrgType();
            if (OrgType.Company.equals((Object)rptOrgType)) {
                ICompanyOrgUnit company = null;
                company = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
                coms = company.getCompanyOrgUnitCollection(evi);
                if (coms != null && coms.size() > 0) {
                    this.companyCache.put(fiOrgUnit, coms.get(0));
                }
            } else {
                CompanyOrgUnitInfo fiOrgInfo = RptNewUIUtil.getDelegateCompanyByNumber((Context)this.batchHelper.getServerContext(), (OrgType)rptOrgType, (String)fiOrgUnit, (SelectorItemCollection)evi.getSelector());
                if (fiOrgInfo != null) {
                    this.companyCache.put(fiOrgUnit, fiOrgInfo);
                }
            }
        }
        return (CompanyOrgUnitInfo)this.companyCache.get(fiOrgUnit);
    }

    private void execute() throws EASBizException, BOSException {
        this.doType1();
        this.doType2();
        this.doType3();
        this.doTypeForRefm();
    }

    private void doTypeForRefm() throws EASBizException, BOSException {
        if (this.mapRefm.values().size() > 0) {
            for (ArrayList list : this.mapRefm.values()) {
                Ref ref = (Ref)list.get(0);
                try {
                    CoreBaseCollection coll = RptContainer.getReportCollectionForPublicTemplate((Context)this.ServerCtx, (String)ref.fiOrgUnit, (String)String.valueOf(ref.year), (String)String.valueOf(ref.period), (String)String.valueOf(ref.currency), (String)String.valueOf(ref.tempType), (String)String.valueOf(ref.tempCode), (String)ref.dataCollectNumber, (String)ref.srcCurrency, (boolean)ref.isAdjusted);
                    if (coll == null || coll.isEmpty()) continue;
                    ReportInfo report = (ReportInfo)coll.get(0);
                    this.loadData(list, report.getData());
                }
                catch (Exception e) {
                    for (int i = 0; i < list.size(); ++i) {
                        ref = (Ref)list.get(i);
                        ref.formulaValue.setException(new Exception("#BAD FUNCTION " + e.getMessage()));
                    }
                }
            }
            this.submit(this.mapRefm);
        }
    }

    private void doType2() throws EASBizException, BOSException {
        if (this.map2.values().size() > 0) {
            for (ArrayList list : this.map2.values()) {
                int i;
                Ref ref = (Ref)list.get(0);
                try {
                    CoreBaseCollection c = RptContainer.getGroupReportCollection((Context)this.ServerCtx, (String)ref.fiOrgUnit, (String)Integer.toString(ref.year), (String)Integer.toString(ref.period), (String)ref.currency, (String)ref.tempType, (String)ref.tempCode, (String)ref.dataCollectNumber, (String)ref.srcCurrency, (boolean)ref.isAdjusted);
                    if (c == null || c.size() <= 0) continue;
                    for (i = 0; i < 1; ++i) {
                        ReportBaseInfo report = (ReportBaseInfo)c.get(i);
                        this.loadData(list, report.getData());
                    }
                }
                catch (Exception e) {
                    for (i = 0; i < list.size(); ++i) {
                        ref = (Ref)list.get(i);
                        ref.formulaValue.setException(new Exception("#BAD FUNCTION " + e.getMessage()));
                    }
                }
            }
            this.submit(this.map2);
        }
    }

    private void doType3() throws EASBizException, BOSException {
        if (this.map3.values().size() > 0) {
            for (ArrayList list : this.map3.values()) {
                int i;
                Ref ref = (Ref)list.get(0);
                try {
                    IObjectCollection c = CslRptUtil.getReportCollection((Context)this.ServerCtx, (String)ref.fiOrgUnit, (int)ref.year, (int)ref.period, (String)ref.currency, (String)ref.srcCurrency, (String)ref.tempCode, (String)ref.groupTempType, (Boolean)ref.isAdjusted);
                    if (c == null || c.size() <= 0) continue;
                    for (i = 0; i < 1; ++i) {
                        ReportBaseInfo report = (ReportBaseInfo)c.iterator().next();
                        this.loadData(list, report.getData());
                    }
                }
                catch (Exception e) {
                    for (i = 0; i < list.size(); ++i) {
                        ref = (Ref)list.get(i);
                        ref.formulaValue.setException(new Exception("#BAD FUNCTION " + e.getMessage()));
                    }
                }
            }
            this.submit(this.map3);
        }
    }

    private void doType1() throws EASBizException, BOSException {
        if (this.map1.values().size() > 0) {
            for (ArrayList list : this.map1.values()) {
                int i;
                Ref ref = (Ref)list.get(0);
                try {
                    CoreBaseCollection c = RptContainer.getReportCollection((Context)this.ServerCtx, (String)ref.fiOrgUnit, (int)ref.year, (int)ref.period, (String)ref.currency, (String)ref.tempType, (String)ref.tempCode, (int)ref.periodType, (String)ref.srcCurrency, (boolean)ref.isAdjusted);
                    if (c == null || c.size() <= 0) continue;
                    for (i = 0; i < 1; ++i) {
                        ReportInfo report = (ReportInfo)c.get(i);
                        this.loadData(list, report.getData());
                    }
                }
                catch (Exception e) {
                    for (i = 0; i < list.size(); ++i) {
                        ref = (Ref)list.get(i);
                        ref.formulaValue.setException(new Exception("#BAD FUNCTION " + e.getMessage()));
                    }
                }
            }
            this.submit(this.map1);
        }
    }

    private String makeValidOrgcode(String orgCode) {
        if (this.context != null && (orgCode == null || orgCode.length() < 1)) {
            String ci = null;
            if (this.context != null && (ci = (String)this.context.getReportAdapter().getReportProperty("Company.Number")) == null) {
                ci = (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Number");
            }
            return ci;
        }
        return orgCode;
    }

    private HashMap createMap(ArrayList list) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(((Ref)list.get(i)).getCellRefAddr(), null);
        }
        return map;
    }

    private void submit(HashMap map) {
        for (ArrayList list : map.values()) {
            for (int i = 0; i < list.size(); ++i) {
                ((Ref)list.get((int)i)).formulaValue.submit();
            }
        }
    }

    private void loadData(ArrayList list, byte[] data) {
        if (list == null) {
            return;
        }
        HashMap map = this.createMap(list);
        try {
            BookIOUtil.loadSomeCellValues((byte[])data, (HashMap)map);
        }
        catch (Exception e) {
            for (int i = 0; i < list.size(); ++i) {
                Ref ref = (Ref)list.get(i);
                ref.formulaValue.setException(e);
            }
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Ref ref = (Ref)list.get(i);
            Object object = map.get(ref.getCellRefAddr());
            if (!(object instanceof Variant)) {
                object = new Variant(object);
            }
            ref.formulaValue.setValue(object);
        }
    }

    class CalculateBackFiller {
        private Throwable _exception = null;
        private ArrayList vlist = new ArrayList();
        Parameter param;

        public CalculateBackFiller(Parameter _param) {
            this.param = _param;
        }

        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            this.vlist.add(value);
        }

        public void setException(Throwable exception) {
            this._exception = exception;
            IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(exception.getClass());
            if (errorProvider == null || exception instanceof Exception) {
                // empty if block
            }
        }

        void submit() {
            if (this._exception != null) {
                IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(this._exception.getClass());
                if (errorProvider != null && this._exception instanceof Exception) {
                    Object value = errorProvider.getProperValue((Exception)this._exception).getValue();
                    try {
                        value = new BigDecimal(value.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.param.setValue(value);
                } else {
                    this.param.setValue((Object)this._exception);
                }
            } else if (this.vlist.size() == 0) {
                this.param.setValue((Object)Variant.nullVariant);
            } else if (this.vlist.size() == 1) {
                this.param.setValue(this.vlist.get(0));
            } else {
                ArrayList<BigDecimal> bList = new ArrayList<BigDecimal>();
                boolean isAllNumber = true;
                for (int i = 0; i < this.vlist.size(); ++i) {
                    try {
                        bList.add(new BigDecimal(this.vlist.get(i).toString()));
                        continue;
                    }
                    catch (Exception e) {
                        isAllNumber = false;
                        break;
                    }
                }
                if (isAllNumber) {
                    BigDecimal r = new BigDecimal("0");
                    for (int i = 0; i < bList.size(); ++i) {
                        r = r.add((BigDecimal)bList.get(i));
                    }
                    this.param.setValue((Object)r);
                } else {
                    StringBuffer buf = new StringBuffer();
                    for (int j = 0; j < this.vlist.size(); ++j) {
                        Object temp = this.vlist.get(j);
                        if (temp == null) continue;
                        if (temp instanceof Calendar) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            buf.append(format.format(((Calendar)temp).getTime()));
                            continue;
                        }
                        buf.append(temp.toString());
                    }
                    this.param.setValue((Object)buf.toString());
                }
            }
        }
    }

    private class Ref {
        String fiOrgUnit;
        int year;
        int period;
        String currency;
        String srcCurrency;
        boolean hasSrcCurrencyParam = false;
        boolean hasAdjustedParam = false;
        String tempType;
        String tempCode;
        String groupTempType;
        String sheetName;
        String cellName;
        int periodType;
        Exception exp = null;
        String dataCollectNumber = "";
        boolean isAdjusted = false;
        String formulaType;
        CalculateBackFiller formulaValue;

        String getCellRefAddr() {
            return (this.sheetName + "!" + this.cellName).toUpperCase();
        }

        public Ref(Parameter param, String type, boolean isSupport13Period) throws EASBizException, BOSException {
            this.formulaType = type;
            Object[] params = param.getArgs();
            params = param.getArgs()[0] instanceof Object[] ? (Object[])param.getArgs()[0] : param.getArgs();
            String dataCollect = null;
            if (params.length == 9) {
                dataCollect = ((Variant)params[8]).getValue() == null ? null : ((Variant)params[8]).getValue().toString();
            } else if (params.length == 8) {
                dataCollect = this.getDataCollectNumber();
            }
            if (type.equalsIgnoreCase("csref")) {
                try {
                    this.hasSrcCurrencyParam = params.length >= 10;
                    this.hasAdjustedParam = params.length > 10;
                    this.initRef(((Variant)params[0]).getValue() == null ? null : ((Variant)params[0]).getValue().toString(), Integer.parseInt(((Variant)params[3]).getValue().toString()), Integer.parseInt(((Variant)params[4]).getValue().toString()), ((Variant)params[7]).getValue() == null ? null : ((Variant)params[7]).getValue().toString(), String.valueOf(2), ((Variant)params[1]).getValue() == null ? null : ((Variant)params[1]).getValue().toString(), ((Variant)params[2]).getValue() == null ? null : ((Variant)params[2]).getValue().toString(), ((Variant)params[5]).getValue() == null ? null : ((Variant)params[5]).getValue().toString(), ((Variant)params[6]).getValue() == null ? null : ((Variant)params[6]).getValue().toString(), -1, dataCollect, isSupport13Period, (String)(params.length >= 10 ? (((Variant)params[9]).getValue() == null ? null : ((Variant)params[9]).getValue().toString()) : ""), params.length > 10 ? ((Variant)params[10]).toBoolean() : true);
                }
                catch (Exception e) {
                    this.exp = e;
                    return;
                }
            }
            if (type.equalsIgnoreCase("refm")) {
                try {
                    this.hasSrcCurrencyParam = params.length >= 10;
                    this.hasAdjustedParam = params.length > 10;
                    this.initRef(((Variant)params[0]).getValue() == null ? null : ((Variant)params[0]).getValue().toString(), Integer.parseInt(((Variant)params[3]).getValue().toString()), Integer.parseInt(((Variant)params[4]).getValue().toString()), ((Variant)params[7]).getValue() == null ? null : ((Variant)params[7]).getValue().toString(), ((Variant)params[1]).getValue() == null ? null : ((Variant)params[1]).getValue().toString(), ((Variant)params[2]).getValue() == null ? null : ((Variant)params[2]).getValue().toString(), null, ((Variant)params[5]).getValue() == null ? null : ((Variant)params[5]).getValue().toString(), ((Variant)params[6]).getValue() == null ? null : ((Variant)params[6]).getValue().toString(), -1, dataCollect, isSupport13Period, params.length >= 10 ? ((Variant)params[9]).getValue().toString() : "", params.length > 10 ? ((Variant)params[10]).toBoolean() : false);
                }
                catch (Exception e) {
                    this.exp = e;
                    return;
                }
            }
            this.formulaValue = new CalculateBackFiller(param);
        }

        private void initRef(String _fiOrgUnit, int _year, int _period, String _currency, String _tempType, String _tempCode, String _groupTempType, String _sheetName, String _cellName, int _periodType, String _dataCollectNumber, boolean isSupport13Period, String _srcCurrency, boolean isAdjusted) throws EASBizException, BOSException {
            this.fiOrgUnit = _fiOrgUnit;
            this.year = _year;
            this.period = _period;
            this.currency = _currency;
            this.srcCurrency = _srcCurrency;
            this.tempType = _tempType;
            this.tempCode = _tempCode;
            this.groupTempType = _groupTempType;
            this.sheetName = _sheetName;
            this.cellName = _cellName;
            this.periodType = _periodType;
            this.dataCollectNumber = _dataCollectNumber;
            this.isAdjusted = isAdjusted;
            this.fiOrgUnit = RefMBatchCalculater.this.makeValidOrgcode(this.fiOrgUnit);
            try {
                RefMBatchCalculater.this.batchHelper.checkCompanyPermision(this.fiOrgUnit);
            }
            catch (Exception e) {
                this.exp = e;
                return;
            }
            if (this.formulaType.equalsIgnoreCase("refm")) {
                this.periodType = this.getReport_PeriodType();
                if (RefMBatchCalculater.this.context.getReportAdapter() instanceof com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter || RefMBatchCalculater.this.context.getReportAdapter() instanceof BgRptReportPropertyAdapter) {
                    if (this.year <= 0) {
                        this.year += this.getReport_Year();
                    }
                    if (this.period <= 0) {
                        this.period += this.getReport_Period();
                    }
                } else {
                    int[] arrYearAndPeriod;
                    if (this.year <= 0) {
                        this.year += RefMBatchCalculater.this.context.getReportVariables().getIntValue("StartYear", this.sheetName, 0);
                    }
                    if (this.period <= 0) {
                        this.period += RefMBatchCalculater.this.context.getReportVariables().getIntValue("StartPeriod", this.sheetName, 0);
                    }
                    Date reportDate = (Date)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Report_EndDate");
                    int reportDate_year = this.getReport_Year();
                    int reportDate_period = this.getReport_Period();
                    Integer type = RefMBatchCalculater.this.getTemplatePeriodType(this.tempType, this.tempCode, this.fiOrgUnit);
                    if (type != null && type >= 0 && this.periodType != type) {
                        this.periodType = type;
                        int[] periodArry = RPTDateUtil.getPeriod((Date)reportDate, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.periodType));
                        if (periodArry != null) {
                            reportDate_year = periodArry[0];
                            reportDate_period = periodArry[1];
                        }
                    }
                    if ((arrYearAndPeriod = RPTDate13Util.getRptYearAndPeriod((int)reportDate_year, (int)reportDate_period, (int)this.periodType, (int)this.year, (int)this.period, (boolean)isSupport13Period)) == null) {
                        this.year = reportDate_year;
                        this.period = reportDate_period;
                    } else {
                        this.year = arrYearAndPeriod[0];
                        this.period = arrYearAndPeriod[1];
                    }
                }
                if (this.currency == null || this.currency.trim().length() == 0) {
                    this.currency = RefMBatchCalculater.this.batchHelper.getCorrect_Currency_Number();
                }
                if (this.hasSrcCurrencyParam && StringUtils.isEmpty((String)this.srcCurrency)) {
                    this.srcCurrency = RefMBatchCalculater.this.batchHelper.getSource_Currency_Number();
                    if (StringUtils.isEmpty((String)this.srcCurrency)) {
                        this.srcCurrency = RefMBatchCalculater.this.batchHelper.getCorrect_Currency_Number();
                    }
                }
                this.tempType = String.valueOf(RptTmpTypeEnum.getEnum(this.tempType).getValue());
                if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                    this.dataCollectNumber = this.getDataCollectNumber();
                }
            }
            if (this.formulaType.equalsIgnoreCase("csref")) {
                if (RefMBatchCalculater.this.context.getReportAdapter() instanceof com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter || RefMBatchCalculater.this.context.getReportAdapter() instanceof BgRptReportPropertyAdapter) {
                    if (this.year <= 0) {
                        this.year = this.getReport_Year();
                    }
                    if (this.period <= 0) {
                        this.period = this.getReport_Period();
                    }
                } else {
                    int[] arrYearAndPeriod;
                    int curYear = (Integer)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.Year");
                    int curPeriod = (Integer)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.Period");
                    int int_periodType = this.getReport_PeriodType();
                    if (this.year == 0) {
                        this.year = curYear;
                    }
                    if (curPeriod == 0) {
                        this.period = curPeriod;
                    }
                    if ((arrYearAndPeriod = RPTDate13Util.getRptYearAndPeriod((int)curYear, (int)curPeriod, (int)int_periodType, (int)this.year, (int)this.period, (boolean)isSupport13Period)) == null) {
                        this.year = curYear;
                        this.period = curPeriod;
                    } else {
                        this.year = arrYearAndPeriod[0];
                        this.period = arrYearAndPeriod[1];
                    }
                }
                if (this.currency == null || this.currency.trim().length() == 0) {
                    this.currency = (String)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Currency.Number");
                }
                this.tempType = String.valueOf(2);
                if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                    this.dataCollectNumber = this.getDataCollectNumber();
                }
            }
        }

        public String getDataCollectNumber() {
            String dataCollectNumber;
            String string = dataCollectNumber = RefMBatchCalculater.this.context == null ? "" : (String)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("CSLReport_DataCollect_Number");
            if (StringUtils.isEmpty((String)dataCollectNumber)) {
                dataCollectNumber = (String)RefMBatchCalculater.this.ServerCtx.get((Object)"KEY_DATACOLLECT_NUMBER");
            }
            if (StringUtils.isEmpty((String)dataCollectNumber)) {
                dataCollectNumber = "ACTUALDATA";
            }
            return dataCollectNumber;
        }

        public void checkDataCollectPermission(boolean isSupportOtherDS, Map checkPermission) {
            if (isSupportOtherDS) {
                try {
                    CSLPermissionUtil.checkDataCollectPermissionForFormula((Context)RefMBatchCalculater.this.ServerCtx, (String)RefMBatchCalculater.this.ServerCtx.getCaller().toString(), (String)this.dataCollectNumber, (Map)checkPermission);
                }
                catch (EASBizException e) {
                    this.exp = e;
                }
                catch (BOSException e) {
                    this.exp = e;
                }
            }
        }

        private String getCompany_ID() {
            return (String)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Company.ID");
        }

        private IPeriod getPeriod() throws BOSException {
            if (RefMBatchCalculater.this.iperiod == null) {
                if (RefMBatchCalculater.this.ServerCtx == null) {
                    RefMBatchCalculater.this.iperiod = PeriodFactory.getRemoteInstance();
                } else {
                    RefMBatchCalculater.this.iperiod = PeriodFactory.getLocalInstance((Context)RefMBatchCalculater.this.ServerCtx);
                }
            }
            return RefMBatchCalculater.this.iperiod;
        }

        private ICompanyOrgUnit getComp() throws BOSException {
            if (RefMBatchCalculater.this.comp == null) {
                if (RefMBatchCalculater.this.ServerCtx == null) {
                    RefMBatchCalculater.this.comp = CompanyOrgUnitFactory.getRemoteInstance();
                } else {
                    RefMBatchCalculater.this.comp = CompanyOrgUnitFactory.getLocalInstance((Context)RefMBatchCalculater.this.ServerCtx);
                }
            }
            return RefMBatchCalculater.this.comp;
        }

        private int getReport_Year() {
            return (Integer)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.Year");
        }

        private int getReport_Period() {
            return (Integer)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.Period");
        }

        private int getReport_PeriodType() {
            Integer period = (Integer)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("PeriodType");
            if (period == null) {
                return -1;
            }
            return period;
        }

        private String getCorrect_Currency_Number() {
            String currency = RefMBatchCalculater.this.context.getReportVariables().getStringValue("Currency", this.getCalculateSheetName());
            if (StringUtils.isEmpty((String)currency)) {
                currency = (String)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Currency.Number");
            }
            if ("GLC".equalsIgnoreCase(currency)) {
                currency = CslRptUtil.getCUNaturalCurrency((Context)RefMBatchCalculater.this.ServerCtx).getNumber();
            }
            return currency;
        }

        private String getCalculateSheetName() {
            return this.sheetName;
        }

        private int getSheet_StartPeriod() {
            return RefMBatchCalculater.this.context.getReportVariables().getIntValue("StartPeriod", this.getCalculateSheetName(), 0);
        }

        public String rptDate(String dateFormat) throws BOSException, EASBizException {
            return this.getDateImp(dateFormat, 1, false);
        }

        private int getSheet_StartYear() {
            ReportVariables vs = RefMBatchCalculater.this.context.getReportVariables();
            if (vs == null) {
                return 0;
            }
            return vs.getIntValue("StartYear", this.getCalculateSheetName(), 0);
        }

        private int getSheet_EndYear() {
            ReportVariables vs = RefMBatchCalculater.this.context.getReportVariables();
            if (vs == null) {
                return 0;
            }
            return vs.getIntValue("EndYear", this.getCalculateSheetName(), 0);
        }

        private Date getReport_StartDate() {
            return (Date)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Report_StartDate");
        }

        private Date getReport_EndDate() {
            return (Date)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Report_EndDate");
        }

        private int getSheet_EndPeriod() {
            ReportVariables vs = RefMBatchCalculater.this.context.getReportVariables();
            if (vs == null) {
                return 0;
            }
            return vs.getIntValue("EndPeriod", this.getCalculateSheetName(), 0);
        }

        private int getReport_SourceType() {
            Integer i = (Integer)RefMBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.SourceType");
            return i != null ? i : -1;
        }

        private String getDateImp(String dateFormat, int type, boolean byPeriodType) throws BOSException, EASBizException {
            Date rptDate = null;
            switch (type) {
                case 2: {
                    rptDate = this.getReport_StartDate();
                    if (rptDate != null) break;
                    rptDate = FiscalPeriodHelper.getPeriodFirstDate((int)this.getReport_Year(), (int)this.getReport_Period(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()), (PeriodCollection)RefMBatchCalculater.this.periods, (boolean)RefMBatchCalculater.this.isMergeByFiscalPeriod);
                    break;
                }
                case 1: {
                    rptDate = this.getReport_EndDate();
                    if (rptDate == null) {
                        rptDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)RefMBatchCalculater.this.periods, (int)this.getReport_Year(), (int)this.getReport_Period(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()), (boolean)RefMBatchCalculater.this.isMergeByFiscalPeriod);
                    }
                    dateFormat = dateFormat.toLowerCase().replace('m', 'M');
                    SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                    String result = sdf.format(rptDate);
                    return result;
                }
                default: {
                    rptDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)RefMBatchCalculater.this.periods, (int)this.getReport_Year(), (int)this.getReport_Period(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()), (boolean)RefMBatchCalculater.this.isMergeByFiscalPeriod);
                    dateFormat = dateFormat.toLowerCase().replace('m', 'M');
                    SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                    String result = sdf.format(rptDate);
                    return result;
                }
            }
            if (byPeriodType) {
                dateFormat = dateFormat.toLowerCase().replace('m', 'M');
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                String result = sdf.format(rptDate);
                return result;
            }
            if (rptDate == null) {
                return "";
            }
            int year = 0;
            int month = 0;
            year = this.getSheet_EndYear();
            month = this.getSheet_EndPeriod();
            if (year == 0) {
                year = this.getReport_Year();
            }
            if (month == 0) {
                month = this.getReport_Period();
            }
            if (dateFormat.equalsIgnoreCase("YYYY")) {
                return String.valueOf(year);
            }
            if (dateFormat.equalsIgnoreCase("MM")) {
                return String.valueOf(month);
            }
            if (dateFormat.equalsIgnoreCase("YYYY-MM")) {
                return String.valueOf(year) + "-" + String.valueOf(month);
            }
            if (this.getReport_Period() > 0 && this.getReport_Period() != 1 && this.getReport_Period() != 2) {
                if (this.getReport_SourceType() == 2 || this.getReport_SourceType() == 3 || this.getReport_SourceType() == 4) {
                    rptDate = this.getReport_EndDate();
                } else {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("AccountPeriodType"));
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getComp().getValue((IObjectPK)new ObjectUuidPK(this.getCompany_ID()), selector);
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("PeriodYear", (Object)new Integer(year)));
                    filter.getFilterItems().add(new FilterItemInfo("PeriodNumber", (Object)new Integer(month)));
                    filter.getFilterItems().add(new FilterItemInfo("PeriodType", (Object)company.getAccountPeriodType().getId().toString()));
                    evi.setFilter(filter);
                    PeriodCollection periods = this.getPeriod().getPeriodCollection(evi);
                    if (periods.size() > 0) {
                        rptDate = periods.get(0).getEndDate();
                    }
                }
            }
            Timestamp time = new Timestamp(rptDate.getTime());
            String strdate = time.toString();
            return strdate.substring(0, 10);
        }
    }
}

