/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct;

import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acct.AcctBalanceState;
import com.kingdee.eas.fi.rpt.batch.acct.IAcctSortState;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class AcctCombineState
implements IFormulaCombinationPreparedState {
    private Map valueMap = new HashMap();
    private String leafAccountNumber;
    private Map notLeafAsstNumberMap = new HashMap();
    private Map assistItemSelectFieldMap = new HashMap();
    private IAcctSortState sortState;

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formula) {
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        if (this.sortState != null && this.sortState instanceof AcctBalanceState && BalanceTypeEnum.Y.getName().equals(((AcctBalanceState)this.sortState).getBalType()) && acct.getBalanceType().equals((Object)BalanceTypeEnum.B) && this.valueMap.containsKey("Y")) {
            Object object = this.valueMap.get(BalanceTypeEnum.Y.getName());
            return this.sortState.processReturnValue(formula, object);
        }
        if (acct.getBalanceType().equals((Object)BalanceTypeEnum.B) && this.valueMap.containsKey("Y") || acct.getBalanceType().equals((Object)BalanceTypeEnum.TB) && this.valueMap.containsKey("TY") || acct.getBalanceType().equals((Object)BalanceTypeEnum.RB) && this.valueMap.containsKey("RY") || acct.getBalanceType().equals((Object)BalanceTypeEnum.QB) && this.valueMap.containsKey("QY")) {
            BigDecimal value;
            BigDecimal dc = new BigDecimal(this.valueMap.get("DC").toString());
            if (acct.getBalanceType().equals((Object)BalanceTypeEnum.B) && this.valueMap.containsKey("Y")) {
                value = new BigDecimal(this.valueMap.get("Y").toString());
                this.valueMap.put(BalanceTypeEnum.B.getName(), value.multiply(dc));
            } else if (acct.getBalanceType().equals((Object)BalanceTypeEnum.TB) && this.valueMap.containsKey("TY")) {
                value = new BigDecimal(this.valueMap.get("TY").toString());
                this.valueMap.put(BalanceTypeEnum.TB.getName(), value.multiply(dc));
            } else if (acct.getBalanceType().equals((Object)BalanceTypeEnum.RB) && this.valueMap.containsKey("RY")) {
                value = new BigDecimal(this.valueMap.get("RY").toString());
                this.valueMap.put(BalanceTypeEnum.RB.getName(), value.multiply(dc));
            } else {
                value = new BigDecimal(this.valueMap.get("QY").toString());
                this.valueMap.put(BalanceTypeEnum.QB.getName(), value.multiply(dc));
            }
            Object object = this.valueMap.get(acct.getBalanceType().getName());
            return this.sortState.processReturnValue(formula, object, dc);
        }
        Object object = this.valueMap.get(acct.getBalanceType().getName());
        return this.sortState.processReturnValue(formula, object);
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    @Override
    public boolean isPrepared(IFormulaCalculator formula) {
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        if (this.leafAccountNumber != null && !this.leafAccountNumber.startsWith(acct.getAccountItem().startAccount.getAccountNumber() + acct.getAccountTable().getSeparator())) {
            return false;
        }
        if (this.notLeafAsstNumberMap.size() > 0) {
            for (Map.Entry entry : this.notLeafAsstNumberMap.entrySet()) {
                String asstActType = (String)entry.getKey();
                AssistantItem item = acct.getAccountItem().getItem(asstActType);
                String resultItem = (String)entry.getValue();
                String selectField = (String)this.assistItemSelectFieldMap.get(asstActType);
                String formulaItem = null;
                formulaItem = "FLongNumber".equalsIgnoreCase(selectField) ? item.startItem.longNumber : item.startItem.number;
                if (!(item.startItem.isHasWildcar || resultItem.equals(formulaItem) || resultItem.startsWith(formulaItem + "!"))) {
                    return false;
                }
                if (!item.startItem.isHasWildcar || resultItem.matches(formulaItem.replace('*', '.')) || resultItem.matches(formulaItem.replace('*', '.') + "!.*")) continue;
                return false;
            }
        }
        return true;
    }

    public void putValue(String balType, Object value) {
        this.valueMap.put(balType, value);
    }

    public void refresh() {
        this.valueMap.clear();
        this.notLeafAsstNumberMap.clear();
        this.leafAccountNumber = null;
        this.assistItemSelectFieldMap.clear();
    }

    public void putAsstNumber(String asstTypenumber, String asstNumber) {
        this.notLeafAsstNumberMap.put(asstTypenumber, asstNumber);
    }

    public void setLeafAccountNumber(String leafAccountNumber) {
        this.leafAccountNumber = leafAccountNumber;
    }

    public void setAsstSelectField(String asstTypenumber, String field) {
        this.assistItemSelectFieldMap.put(asstTypenumber, field);
    }

    public IAcctSortState getSortState() {
        return this.sortState;
    }

    public void setSortState(IAcctSortState sortState) {
        this.sortState = sortState;
    }
}

