/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct.quantity;

import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.AsstField;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.FormulaMatcher;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.SimpleStringUtil;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantityCombine;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantityFormula;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantitySort;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class VouchQuantityProcessor
implements IBatchSQLSorterProcessor {
    private VouchQuantitySort sort;
    private VouchQuantityCombine combine = new VouchQuantityCombine();

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combine;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return 100;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formulaPara) {
        ArrayList<String> formulaFields = new ArrayList<String>();
        VouchQuantityFormula formula = (VouchQuantityFormula)formulaPara;
        formulaFields.add(formula.getCurrency().getId().toString());
        return new Object[0][];
    }

    @Override
    public String[] getIndexResultSetFields() {
        return new String[0];
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        VouchQuantityCombine state = (VouchQuantityCombine)combineState;
        state.reset();
        FormulaMatcher matcher = new FormulaMatcher();
        matcher.setCompany(rs.getString("comp_longnumber"));
        matcher.addAccount(rs.getString("account_LongNumber"), rs.getString("account_LongNumber"));
        matcher.addPeriod(rs.getString("period_number"), rs.getString("period_number"));
        for (AsstField type : this.sort.getAssistantFieldNames()) {
            matcher.addAssistant(type.getType(), rs.getString(type.getFieldAlia()), rs.getString(type.getFieldAlia()));
        }
        matcher.setCurrency(rs.getString("currency_id"));
        state.put(matcher, rs.getBigDecimal("Quantity"));
    }

    @Override
    public List getFormulaCalculators() {
        return this.sort.getFormulaList();
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(" SELECT \t\tCASE");
        String debitCondition = "";
        String crebitCondition = "";
        if (this.sort.isDebit()) {
            debitCondition = "ve.FEntryDC = 1";
            crebitCondition = "ve.FEntryDC = 0";
        } else {
            debitCondition = "ve.FEntryDC = 0";
            crebitCondition = "ve.FEntryDC = 1";
        }
        sql.append("             WHEN  " + debitCondition + " THEN");
        sql.append("              ve.FStandardQuantity");
        sql.append("             WHEN  " + crebitCondition + " THEN");
        sql.append("              0-ve.FStandardQuantity");
        sql.append("             ELSE");
        sql.append("              0");
        sql.append("\t\t\tEND Quantity,");
        sql.append("\t\t\tcomp.flongnumber comp_longnumber,");
        sql.append("\t\t\tav.fNumber account_LongNumber,");
        sql.append("\t\t\tpd.fnumber period_number,");
        sql.append("\t\t\tve.fcurrencyid currency_id");
        for (AsstField type : this.sort.getAssistantFieldNames()) {
            sql.append("\t\t\t," + type.getTableAlia() + "." + (type.isLongNumber() ? "FLongNumber" : "FNumber") + " " + type.getFieldAlia() + " ");
        }
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append("  FROM t_gl_voucher v");
        sql.append(" INNER JOIN t_gl_voucherentry ve ON ve.fbillid = v.fid");
        sql.append(" INNER JOIN t_bd_accountview av ON (av.fid = ve.faccountid AND");
        sql.append("                                   av.fcompanyid = v.fcompanyid)");
        sql.append(" INNER JOIN t_bd_period pd ON pd.fid = v.fperiodid");
        sql.append(" INNER JOIN t_org_company comp ON comp.fid = v.fcompanyid");
        if (!this.sort.getAssistantFieldNames().isEmpty()) {
            sql.append(" inner join t_gl_voucherAssistRecord VA on va.FEntryId = Ve.fid");
            sql.append(" inner join t_bd_AssistantHG hg on hg.fid = va.FAssGrpId");
        }
        for (AsstField type : this.sort.getAssistantFieldNames()) {
            sql.append(" inner join " + type.getTableName() + " " + type.getTableAlia() + " on " + type.getTableAlia() + ".fid = hg." + type.getMapFieldName() + "");
        }
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" WHERE v.fbizstatus IN (1, 3, 5) ");
        sql.append(" AND v.fsourcetype = 1 ");
        sql.append(" and   ve.FStandardQuantity != 0 ");
        sql.append(" and ( ");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formulaParam) {
        sql.append(" ( ");
        VouchQuantityFormula formula = (VouchQuantityFormula)formulaParam;
        sql.append("\tcomp.flongnumber like ? AND av.faccounttableid = ? ");
        params.add(formula.getCompany().getLongNumber() + "%");
        params.add(formula.getCompany().getAccountTable().getId().toString());
        sql.append("\t\tAND pd.ftypeid = ?");
        params.add(formula.getCompany().getAccountPeriodType().getId().toString());
        sql.append("\t\tand pd.fnumber >= ? AND pd.fnumber <= ? ");
        params.add(formula.getStartYear() + SimpleStringUtil.prefix(formula.getStartPeriod()));
        params.add(formula.getEndYear() + SimpleStringUtil.prefix(formula.getEndPeriod()));
        sql.append("\t\tAND ve.fcurrencyid = ? ");
        params.add(formula.getCurrency().getId().toString());
        sql.append(" \tand( av.fnumber like ?   \t\n");
        params.add(formula.getAccount().startAccount.getAccountNumber() + "%");
        sql.append(" \tor (av.fnumber >=  ? \t\t\n");
        params.add(formula.getAccount().startAccount.getAccountNumber());
        sql.append(" \tand av.fnumber <= ?   \t))\t\n");
        params.add(formula.getAccount().endAccount.getAccountNumber() + "%");
        for (AsstField type : this.sort.getAssistantFieldNames()) {
            AssistantItem asstItem = formula.getAccount().getItem(type.getType());
            if (asstItem.startItem == null || asstItem.endItem == null) continue;
            if (type.isLongNumber()) {
                sql.append("\t\tand (" + type.getTableAlia() + ".flongnumber like ?  or ");
                params.add(asstItem.startItem.longNumber + "%");
                sql.append("\t\t(" + type.getTableAlia() + ".flongnumber >= ?");
                params.add(asstItem.startItem.longNumber);
                sql.append("\t\tand " + type.getTableAlia() + ".flongnumber <= ?)");
                params.add(asstItem.endItem.longNumber);
                sql.append("\t\t)");
                continue;
            }
            sql.append("\t\tand " + type.getTableAlia() + ".fnumber >= ?");
            params.add(asstItem.startItem.number);
            sql.append("\t\tand " + type.getTableAlia() + ".fnumber <= ?");
            params.add(asstItem.endItem.number);
        }
        sql.append(" ) ");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(" ) ");
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        if (!(sortState instanceof VouchQuantitySort)) {
            return;
        }
        this.sort = (VouchQuantitySort)sortState;
    }
}

