/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashExtTimeCondition;
import com.kingdee.eas.fi.rpt.batch.acctcash.CashFlowItem;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AcctCash
extends AbstractFormulaCalculatorParameter {
    public static final String CURRENCY_GLC = "GLC";
    public static final String CURRENCY_GRC = "GRC";
    private static final Logger logger = Logger.getLogger(AcctCash.class);
    BatchHelper batchHelper;
    String fiOrgUnit;
    String orgUnit;
    String cashGetType;
    String currencyNumber;
    String cashFlowItemString;
    String oppAccountString;
    CashTypeEnum cashTypeEnum;
    CashFlowItem cashFlowItem;
    AccountItemExt oppAccountItem;
    boolean isIncludingUnPosted;
    CompanyOrgUnitInfo company;
    CashFlowItemInfo cashFlowItemInfo;
    List companyList;
    List initCompanyList;
    List cashFlowItemList;
    List sorttedOppAsstActTypeList;
    List sorttedCashFlowAsstActTypeList;
    boolean needCombineInitValue;
    ITimeCondition timeCondition;
    List assistantItemExtList;
    PeriodCollection periods;
    boolean isMergeByFiscalPeriod;

    private AcctCash() {
    }

    protected AcctCash(Parameter param, BatchHelper batchHelper, ITimeCondition timeCondition) {
        this.batchHelper = batchHelper;
        this.timeCondition = timeCondition;
        this.setParameter(param);
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected void initArgs() throws BOSException, EASBizException {
        int i;
        Object[] args = this.getParameter().getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        this.orgUnit = ((Variant)args[i = 0]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        ++i;
        if (this.timeCondition.getType() == 1) {
            this.cashGetType = ((Variant)args[i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            ++i;
        }
        this.currencyNumber = ((Variant)args[i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        ++i;
        if (this.timeCondition.getType() == 1) {
            HashMap<String, Variant> timeVals = new HashMap<String, Variant>();
            timeVals.put("name.year", (Variant)args[i]);
            timeVals.put("name.startPeriod", (Variant)args[++i]);
            timeVals.put("name.endPeriod", (Variant)args[++i]);
            ++i;
            this.timeCondition.init(timeVals);
        } else if (this.timeCondition.getType() == 2) {
            if (this.currencyNumber != null && this.currencyNumber.equals(CURRENCY_GLC)) {
                this.cashTypeEnum = CashTypeEnum.AZ;
            } else if (this.currencyNumber != null && this.currencyNumber.equals(CURRENCY_GRC)) {
                this.cashTypeEnum = CashTypeEnum.AS;
            }
            HashMap<String, Object> timeVals = new HashMap<String, Object>();
            timeVals.put("name.startTime", (Variant)args[i]);
            timeVals.put("name.endTime", (Variant)args[++i]);
            ++i;
            timeVals.put("Context", this.batchHelper.getServerContext());
            this.timeCondition.init(timeVals);
        } else {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"0_AcctStruct", (Locale)this.batchHelper.getServerContext().getLocale())});
        }
        String string = this.cashFlowItemString = ((Variant)args[i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
        if (args.length > ++i) {
            this.oppAccountString = ((Variant)args[i]).getValue() == null ? null : ((Variant)args[i]).getValue().toString();
            ++i;
        }
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.orgUnit)) {
            this.orgUnit = this.batchHelper.getOrgUnit_Number();
            if (StringUtils.isEmpty((String)this.orgUnit)) {
                this.orgUnit = this.batchHelper.getCompany_Number();
            }
            this.fiOrgUnit = this.batchHelper.convertFIOrgUnit(this.orgUnit);
        } else {
            this.fiOrgUnit = this.orgUnit;
        }
        if (StringUtils.isEmpty((String)this.currencyNumber)) {
            this.currencyNumber = this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
        }
        if (StringUtils.isEmpty((String)this.fiOrgUnit)) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        int timeCondType = this.timeCondition.getType();
        if (timeCondType == 1) {
            this.cashTypeEnum = CashTypeEnum.getEnum(this.cashGetType.toUpperCase());
            if (this.cashTypeEnum == null) {
                throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
            }
            if ((this.currencyNumber.equalsIgnoreCase(CURRENCY_GLC) || this.currencyNumber.equalsIgnoreCase(CURRENCY_GRC)) && (this.cashTypeEnum.equals((Object)CashTypeEnum.S) || this.cashTypeEnum.equals((Object)CashTypeEnum.Y) || this.cashTypeEnum.equals((Object)CashTypeEnum.Z))) {
                throw new ReportException(ReportException.CANNOT_CURRENCY);
            }
            if (this.cashTypeEnum.equals((Object)CashTypeEnum.AS) && !this.currencyNumber.equalsIgnoreCase(CURRENCY_GRC)) {
                throw new ReportException(ReportException.ONLY_GRC);
            }
            if (this.cashTypeEnum.equals((Object)CashTypeEnum.AZ) && !this.currencyNumber.equalsIgnoreCase(CURRENCY_GLC)) {
                throw new ReportException(ReportException.ONLY_GLC);
            }
        }
        if (timeCondType == 2) {
            AcctCashExtTimeCondition acctCashExtTC = (AcctCashExtTimeCondition)this.timeCondition;
            if (acctCashExtTC.getStartTime() == null) {
                this.setDefaultStartDate(acctCashExtTC);
            }
            if (acctCashExtTC.getEndTime() == null) {
                this.setDefaultEndDate(acctCashExtTC);
            }
        }
        if (StringUtils.isEmpty((String)this.cashFlowItemString)) {
            Locale locale = ContextUtils.getOriginalLocaleFromEnv();
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NeedCashFlowItem", (Locale)locale)});
        }
        try {
            if (!StringUtils.isEmpty((String)this.oppAccountString)) {
                this.oppAccountItem = new AccountItemExt(this.oppAccountString);
            }
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        this.verifyOther();
        this.isIncludingUnPosted = this.batchHelper.isSheet_IncludePosted(this.getSheetName());
    }

    private void setDefaultEndDate(AcctCashExtTimeCondition acctCashExtTC) throws ReportException {
        Date sheet_EndDate = this.batchHelper.getSheet_EndDate(this.getSheetName());
        if (sheet_EndDate == null && this.batchHelper.getReport_PeriodType() != 1 && (sheet_EndDate = this.getDateByYearPeriod(this.batchHelper.getServerContext(), this.fiOrgUnit, false, this.batchHelper.getSheet_EndYear(this.getSheetName()), this.batchHelper.getSheet_EndPeriod(this.getSheetName()), this.batchHelper.getReport_Year(), this.batchHelper.getReport_Period(), RptPeriodTypeEnum.getEnum((int)this.batchHelper.getReport_PeriodType()))) == RPTDateUtil.NON_PERIOD_BE_FOUND) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"58_CsRefBatchCalculater", (Locale)this.batchHelper.getServerContext().getLocale())});
        }
        if (sheet_EndDate != null) {
            try {
                acctCashExtTC.setEndTime(sheet_EndDate);
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        } else {
            sheet_EndDate = this.batchHelper.getReport_EndDate();
            acctCashExtTC.setEndTime(sheet_EndDate);
        }
    }

    private void setDefaultStartDate(AcctCashExtTimeCondition acctCashExtTC) throws ReportException {
        Date sheet_StartDate = this.batchHelper.getSheet_StartDate(this.getSheetName());
        if (sheet_StartDate == null && this.batchHelper.getReport_PeriodType() != 1 && (sheet_StartDate = this.getDateByYearPeriod(this.batchHelper.getServerContext(), this.fiOrgUnit, true, this.batchHelper.getSheet_StartYear(this.getSheetName()), this.batchHelper.getSheet_StartPeriod(this.getSheetName()), this.batchHelper.getReport_Year(), this.batchHelper.getReport_Period(), RptPeriodTypeEnum.getEnum((int)this.batchHelper.getReport_PeriodType()))) == RPTDateUtil.NON_PERIOD_BE_FOUND) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"58_CsRefBatchCalculater", (Locale)this.batchHelper.getServerContext().getLocale())});
        }
        if (sheet_StartDate != null) {
            try {
                acctCashExtTC.setStartTime(sheet_StartDate);
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        } else {
            sheet_StartDate = this.batchHelper.getReport_StartDate();
            acctCashExtTC.setStartTime(sheet_StartDate);
        }
    }

    public Date getDateByYearPeriod(Context ctx, String companyNum, boolean isStartDate, int year, int period, int defaultYear, int defaultPeriod, RptPeriodTypeEnum periodType) {
        if (year == 0 && period == 0) {
            return null;
        }
        if (periodType == null) {
            return RPTDateUtil.NON_PERIOD_BE_FOUND;
        }
        if (year <= 0 && (year = defaultYear + year) <= 0) {
            return RPTDateUtil.NON_PERIOD_BE_FOUND;
        }
        if (period <= 0) {
            period = defaultPeriod + period > 0 ? defaultPeriod + period : defaultPeriod + period - 1;
        }
        try {
            return RPTDateUtil.getDateByYearOrPreYear((Context)ctx, null, (String)companyNum, (int)year, (int)period, (boolean)isStartDate);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return RPTDateUtil.NON_PERIOD_BE_FOUND;
    }

    public boolean isNeedCurrency() {
        return true;
    }

    public ITimeCondition getTimeCondition() {
        return this.timeCondition;
    }

    protected void verifyOther() throws BOSException, EASBizException {
        if (this.timeCondition.isExistAnyNull()) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"0_AcctStruct", (Locale)this.batchHelper.getServerContext().getLocale())});
        }
    }

    public AcctCash copy() {
        AcctCash acctCash = new AcctCash();
        acctCash.setParameter(this.getParameter());
        acctCash.batchHelper = this.batchHelper;
        acctCash.assistantItemExtList = this.assistantItemExtList;
        acctCash.cashFlowItem = this.cashFlowItem;
        acctCash.cashFlowItemInfo = this.cashFlowItemInfo;
        acctCash.cashFlowItemList = this.assistantItemExtList;
        acctCash.cashFlowItemString = this.cashFlowItemString;
        acctCash.cashGetType = this.cashGetType;
        acctCash.cashTypeEnum = this.cashTypeEnum;
        acctCash.company = this.company;
        acctCash.companyList = this.companyList;
        acctCash.currencyNumber = this.currencyNumber;
        acctCash.fiOrgUnit = this.fiOrgUnit;
        acctCash.initCompanyList = this.initCompanyList;
        acctCash.isIncludingUnPosted = this.isIncludingUnPosted;
        acctCash.isMergeByFiscalPeriod = this.isMergeByFiscalPeriod;
        acctCash.needCombineInitValue = this.needCombineInitValue;
        acctCash.oppAccountItem = this.oppAccountItem;
        acctCash.oppAccountString = this.oppAccountString;
        acctCash.orgUnit = this.orgUnit;
        acctCash.periods = this.periods;
        acctCash.sorttedCashFlowAsstActTypeList = this.sorttedCashFlowAsstActTypeList;
        acctCash.sorttedOppAsstActTypeList = this.sorttedOppAsstActTypeList;
        acctCash.timeCondition = this.timeCondition;
        return acctCash;
    }
}

