/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashProfitCombineState;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashProfitsSortState;
import com.kingdee.eas.fi.rpt.batch.acctcash.IBaseAcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AcctCashProfitsProcessor
implements IBatchSQLSorterProcessor {
    private int batchSize;
    protected static String[] IndexResultSetFields = new String[]{"CompanyID", "CurrencyNumber"};
    private AcctCashProfitCombineState combineState;
    private AcctCashProfitsSortState sortState;
    private List formulas;

    public AcctCashProfitsProcessor(int batchSize) {
        this.batchSize = batchSize;
        this.combineState = new AcctCashProfitCombineState();
        this.formulas = new LinkedList();
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append("Select sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) LocalAmount  ");
        sql.append(" , sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) ReportingAmount  ");
        sql.append(" , sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) OriginalAmount  ");
        sql.append(" ,voucher.FCompanyID CompanyID ");
        if (!nullSet.contains("CurrencyNumber")) {
            sql.append(" ,Currency.FNumber CurrencyNumber ");
        }
        sql.append(" ,period.FPeriodYear PeriodYear ");
        sql.append(" ,period.FPeriodNumber PeriodNumber ");
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" from T_GL_Voucher voucher ");
        sql.append(" inner join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID ");
        sql.append(" inner join T_BD_AccountView account on ve.FAccountID = account.FID ");
        sql.append(" left join t_bd_cashflowaccountdiff cashflowaccountdiff on cashflowaccountdiff.fdiffaccountid=account.FID ");
        sql.append(" inner join T_BD_Currency Currency on Currency.FID = ve.FCurrencyID ");
        sql.append(" inner join T_BD_Period period on voucher.FPeriodID = period.FID ");
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" where cashflowaccountdiff.fdiffaccountid is null ");
        sql.append(" and account.FPLType <> ?");
        params.add(new Integer(0));
        sql.append(" and voucher.FSourceType<>1 ");
        sql.append(" and voucher.FBizStatus in( ? ");
        params.add(new Integer(5));
        if (nullSet.contains("isIncludingUnPosted")) {
            sql.append(" ,?,? ");
            params.add(new Integer(1));
            params.add(new Integer(3));
        }
        sql.append(" )  ");
        if (this.sortState.getCompanyList() != null && this.sortState.getCompanyList().size() > 0) {
            this.addAndCompanyCondition(sql, params);
        }
        sql.append(" and (");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        sql.append(" ( ");
        if (this.sortState.getCompanyList() == null || this.sortState.getCompanyList().size() <= 1) {
            sql.append("  voucher.FCompanyID = ? ");
            params.add(acctCash.company.getId().toString());
        } else {
            sql.append(" 1 = 1 ");
        }
        if (!acctCash.getNullFields().contains("CurrencyNumber")) {
            sql.append(" and Currency.FNumber = ? ");
            params.add(acctCash.currencyNumber);
        }
        ITimeCondition timeCondition = acctCash.getTimeCondition();
        IBaseAcctCashHandler conditionHandler = timeCondition.getConditionHandler();
        Map tcFields = this.getPeriodFields();
        StringBuffer tcSql = conditionHandler.getTimeConditionSQL(timeCondition, tcFields, params);
        sql.append(" and ");
        sql.append(tcSql);
        sql.append(" ) ");
    }

    private Map getPeriodFields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("FPERIODYEAR", "period.FPeriodYear");
        fields.put("FPERIODNUMBER", "period.FPeriodNumber");
        fields.put("FBOOKEDDATE", "VOUCHER.FBookedDate");
        return fields;
    }

    private void addAndCompanyCondition(StringBuffer sql, List params) {
        sql.append(" and ( ");
        sql.append(" voucher.FCompanyID in ( ");
        for (int i = 0; i < this.sortState.getCompanyList().size(); ++i) {
            if (i != 0) {
                sql.append(',');
            }
            sql.append(" ? ");
            params.add(this.sortState.getCompanyList().get(i));
        }
        sql.append(" ) ");
        sql.append(" ) ");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(" ) group by voucher.FCompanyID  ");
        if (!nullSet.contains("CurrencyNumber")) {
            sql.append(" ,Currency.FNumber ");
        }
        sql.append(" ,period.FPeriodYear  ");
        sql.append(" ,period.FPeriodNumber  ");
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        List companyList = acctCash.companyList;
        ArrayList<String> condition = new ArrayList<String>();
        int index = 0;
        boolean isUseCompany = companyList.size() > 1;
        int count = isUseCompany ? companyList.size() : 1;
        Object[][] result = new Object[count][];
        String companyID = null;
        for (int i = 0; i < count; ++i) {
            companyID = (String)companyList.get(i);
            condition.add(companyID);
            if (!acctCash.getNullFields().contains("CurrencyNumber")) {
                condition.add(acctCash.currencyNumber);
            }
            result[index++] = condition.toArray();
            condition.clear();
        }
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        ArrayList<String> indexResultList = new ArrayList<String>();
        indexResultList.add("CompanyID");
        indexResultList.add("CurrencyNumber");
        String[] indexResult = new String[indexResultList.size()];
        indexResultList.toArray(indexResult);
        return indexResult;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        AcctCashProfitCombineState acctCashState = (AcctCashProfitCombineState)combineState;
        acctCashState.setLocal(rs.getBigDecimal("LocalAmount"));
        acctCashState.setReporting(rs.getBigDecimal("ReportingAmount"));
        acctCashState.setOriginal(rs.getBigDecimal("OriginalAmount"));
        acctCashState.setPeriodYear(rs.getInt("PeriodYear"));
        acctCashState.setPeriodNumber(rs.getInt("PeriodNumber"));
    }

    @Override
    public Set getAllowedNullFields() {
        HashSet<String> nullSet = new HashSet<String>();
        nullSet.add("isIncludingUnPosted");
        nullSet.add("CurrencyNumber");
        nullSet.add("sameperiod");
        nullSet.add("sameyear");
        return nullSet;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    public void setFormulas(List formulas) {
        this.formulas = formulas;
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (AcctCashProfitsSortState)sortState;
    }
}

